/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.interProcedural;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.PrimType;
import soot.ShortType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.dava.DavaBody;
import soot.dava.DecompilationException;
import soot.dava.internal.AST.ASTNode;
import soot.dava.toolkits.base.AST.traversals.AllDefinitionsFinder;
import soot.jimple.DefinitionStmt;
import soot.jimple.DoubleConstant;
import soot.jimple.FieldRef;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.NumericConstant;
import soot.tagkit.ConstantValueTag;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.util.Chain;

public class ConstantFieldValueFinder {
    public final boolean DEBUG = false;
    public static String combiner = "_$p$g_";
    private final HashMap<String, SootField> classNameFieldNameToSootFieldMapping = new HashMap();
    private final HashMap<String, ArrayList<Value>> fieldToValues = new HashMap();
    private final HashMap<String, Object> primTypeFieldValueToUse = new HashMap();
    private final Chain<SootClass> appClasses;

    public ConstantFieldValueFinder(Chain<SootClass> classes) {
        this.appClasses = classes;
        this.debug("ConstantFieldValueFinder -- applyAnalyses", "computing Method Summaries");
        this.computeFieldToValuesAssignedList();
        this.valuesForPrimTypeFields();
    }

    public HashMap<String, Object> getFieldsWithConstantValues() {
        return this.primTypeFieldValueToUse;
    }

    public HashMap<String, SootField> getClassNameFieldNameToSootFieldMapping() {
        return this.classNameFieldNameToSootFieldMapping;
    }

    private void valuesForPrimTypeFields() {
        for (SootClass s : this.appClasses) {
            this.debug("\nvaluesforPrimTypeFields", "Processing class " + s.getName());
            String declaringClass = s.getName();
            for (SootField f : s.getFields()) {
                ConstantValueTag t;
                Type fieldType = f.getType();
                if (!(fieldType instanceof PrimType)) continue;
                String combined = declaringClass + combiner + f.getName();
                this.classNameFieldNameToSootFieldMapping.put(combined, f);
                Constable value = null;
                if (fieldType instanceof DoubleType) {
                    t = (DoubleConstantValueTag)f.getTag("DoubleConstantValueTag");
                    if (t != null) {
                        value = ((DoubleConstantValueTag)t).getDoubleValue();
                    }
                } else if (fieldType instanceof FloatType) {
                    t = (FloatConstantValueTag)f.getTag("FloatConstantValueTag");
                    if (t != null) {
                        value = Float.valueOf(((FloatConstantValueTag)t).getFloatValue());
                    }
                } else if (fieldType instanceof LongType) {
                    t = (LongConstantValueTag)f.getTag("LongConstantValueTag");
                    if (t != null) {
                        value = ((LongConstantValueTag)t).getLongValue();
                    }
                } else if (fieldType instanceof CharType) {
                    t = (IntegerConstantValueTag)f.getTag("IntegerConstantValueTag");
                    if (t != null) {
                        value = ((IntegerConstantValueTag)t).getIntValue();
                    }
                } else if (fieldType instanceof BooleanType) {
                    t = (IntegerConstantValueTag)f.getTag("IntegerConstantValueTag");
                    if (t != null) {
                        value = Boolean.valueOf(((IntegerConstantValueTag)t).getIntValue() != 0);
                    }
                } else if ((fieldType instanceof IntType || fieldType instanceof ByteType || fieldType instanceof ShortType) && (t = (IntegerConstantValueTag)f.getTag("IntegerConstantValueTag")) != null) {
                    value = ((IntegerConstantValueTag)t).getIntValue();
                }
                if (value != null) {
                    this.debug("TAGGED value found for field: " + combined);
                    this.primTypeFieldValueToUse.put(combined, value);
                    continue;
                }
                ArrayList<Value> values = this.fieldToValues.get(combined);
                if (values == null) {
                    if (fieldType instanceof DoubleType) {
                        value = 0.0;
                    } else if (fieldType instanceof FloatType) {
                        value = Float.valueOf(0.0f);
                    } else if (fieldType instanceof LongType) {
                        value = 0L;
                    } else if (fieldType instanceof BooleanType) {
                        value = Boolean.valueOf(false);
                    } else if (fieldType instanceof IntType || fieldType instanceof ByteType || fieldType instanceof ShortType || fieldType instanceof CharType) {
                        value = 0;
                    } else {
                        throw new DecompilationException("Unknown primitive type...please report to developer");
                    }
                    this.primTypeFieldValueToUse.put(combined, value);
                    this.debug("DEFAULT value for field: " + combined);
                    continue;
                }
                this.debug("CHECKING USER ASSIGNED VALUES FOR: " + combined);
                NumericConstant tempConstant = null;
                for (Value val : values) {
                    if (!(val instanceof NumericConstant)) {
                        tempConstant = null;
                        this.debug("Not numeric constant hence giving up");
                        break;
                    }
                    if (tempConstant == null) {
                        tempConstant = (NumericConstant)val;
                        continue;
                    }
                    if (tempConstant.equals(val)) continue;
                    tempConstant = null;
                    break;
                }
                if (tempConstant == null) continue;
                if (tempConstant instanceof LongConstant) {
                    long tempVal = ((LongConstant)tempConstant).value;
                    if (Long.compare(tempVal, 0L) == 0) {
                        this.primTypeFieldValueToUse.put(combined, tempVal);
                        continue;
                    }
                    this.debug("Not assigning the agreed value since that is not the default value for " + combined);
                    continue;
                }
                if (tempConstant instanceof DoubleConstant) {
                    double tempVal = ((DoubleConstant)tempConstant).value;
                    if (Double.compare(tempVal, 0.0) == 0) {
                        this.primTypeFieldValueToUse.put(combined, tempVal);
                        continue;
                    }
                    this.debug("Not assigning the agreed value since that is not the default value for " + combined);
                    continue;
                }
                if (tempConstant instanceof FloatConstant) {
                    float tempVal = ((FloatConstant)tempConstant).value;
                    if (Float.compare(tempVal, 0.0f) == 0) {
                        this.primTypeFieldValueToUse.put(combined, Float.valueOf(tempVal));
                        continue;
                    }
                    this.debug("Not assigning the agreed value since that is not the default value for " + combined);
                    continue;
                }
                if (tempConstant instanceof IntConstant) {
                    int tempVal = ((IntConstant)tempConstant).value;
                    if (Integer.compare(tempVal, 0) == 0) {
                        SootField tempField = this.classNameFieldNameToSootFieldMapping.get(combined);
                        if (tempField.getType() instanceof BooleanType) {
                            this.primTypeFieldValueToUse.put(combined, false);
                            continue;
                        }
                        this.primTypeFieldValueToUse.put(combined, tempVal);
                        continue;
                    }
                    this.debug("Not assigning the agreed value since that is not the default value for " + combined);
                    continue;
                }
                throw new DecompilationException("Un handled Numberic Constant....report to programmer");
            }
        }
    }

    private void computeFieldToValuesAssignedList() {
        for (SootClass s : this.appClasses) {
            this.debug("\ncomputeMethodSummaries", "Processing class " + s.getName());
            Iterator<SootMethod> methodIt = s.methodIterator();
            while (methodIt.hasNext()) {
                SootMethod m = methodIt.next();
                if (!m.hasActiveBody()) continue;
                DavaBody body = (DavaBody)m.getActiveBody();
                ASTNode AST = (ASTNode)body.getUnits().getFirst();
                AllDefinitionsFinder defFinder = new AllDefinitionsFinder();
                AST.apply(defFinder);
                for (DefinitionStmt stmt : defFinder.getAllDefs()) {
                    Value left = stmt.getLeftOp();
                    if (!(left instanceof FieldRef)) continue;
                    this.debug("computeMethodSummaries method: " + m.getName(), "Field ref is: " + left);
                    FieldRef ref = (FieldRef)left;
                    SootField field = ref.getField();
                    if (!(field.getType() instanceof PrimType)) continue;
                    String fieldName = field.getName();
                    String declaringClass = field.getDeclaringClass().getName();
                    this.debug("\tField Name: " + fieldName);
                    this.debug("\tField DeclaringClass: " + declaringClass);
                    String combined = declaringClass + combiner + fieldName;
                    ArrayList<Value> valueList = this.fieldToValues.get(combined);
                    if (valueList == null) {
                        valueList = new ArrayList();
                        this.fieldToValues.put(combined, valueList);
                    }
                    valueList.add(stmt.getRightOp());
                }
            }
        }
    }

    public void printConstantValueFields() {
        System.out.println("\n\n Printing Constant Value Fields (method: printConstantValueFields)");
        for (String combined : this.primTypeFieldValueToUse.keySet()) {
            int temp = combined.indexOf(combiner, 0);
            if (temp <= 0) continue;
            System.out.println("Class: " + combined.substring(0, temp) + " Field: " + combined.substring(temp + combiner.length()) + " Value: " + this.primTypeFieldValueToUse.get(combined));
        }
    }

    public void debug(String methodName, String debug) {
    }

    public void debug(String debug) {
    }
}

