/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.finders;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootClass;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.asg.AugmentedStmtGraph;
import soot.dava.toolkits.base.finders.ExceptionFinder;
import soot.util.IterableSet;

public class ExceptionNode {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionNode.class);
    private final IterableSet<AugmentedStmt> body;
    private IterableSet<AugmentedStmt> tryBody;
    private IterableSet<AugmentedStmt> catchBody;
    private boolean dirty;
    private List<AugmentedStmt> exitList;
    private LinkedList<IterableSet<AugmentedStmt>> catchList;
    private SootClass exception;
    private HashMap<IterableSet<AugmentedStmt>, SootClass> catch2except;
    private AugmentedStmt handlerAugmentedStmt;

    public ExceptionNode(IterableSet<AugmentedStmt> tryBody, SootClass exception, AugmentedStmt handlerAugmentedStmt) {
        this.tryBody = tryBody;
        this.catchBody = null;
        this.exception = exception;
        this.handlerAugmentedStmt = handlerAugmentedStmt;
        this.body = new IterableSet<AugmentedStmt>((Collection<AugmentedStmt>)tryBody);
        this.dirty = true;
        this.exitList = null;
        this.catchList = null;
        this.catch2except = null;
    }

    public boolean add_TryStmts(Collection<AugmentedStmt> c) {
        for (AugmentedStmt as : c) {
            if (this.add_TryStmt(as)) continue;
            return false;
        }
        return true;
    }

    public boolean add_TryStmt(AugmentedStmt as) {
        if (this.body.contains(as) || this.tryBody.contains(as)) {
            return false;
        }
        this.body.add(as);
        this.tryBody.add(as);
        return true;
    }

    public void refresh_CatchBody(ExceptionFinder ef) {
        if (this.catchBody != null) {
            this.body.removeAll(this.catchBody);
        }
        this.catchBody = ef.get_CatchBody(this.handlerAugmentedStmt);
        this.body.addAll(this.catchBody);
    }

    public IterableSet<AugmentedStmt> get_Body() {
        return this.body;
    }

    public IterableSet<AugmentedStmt> get_TryBody() {
        return this.tryBody;
    }

    public IterableSet<AugmentedStmt> get_CatchBody() {
        return this.catchBody;
    }

    public boolean remove(AugmentedStmt as) {
        if (!this.body.contains(as)) {
            return false;
        }
        if (this.tryBody.contains(as)) {
            this.tryBody.remove(as);
        } else if (this.catchBody != null && this.catchBody.contains(as)) {
            this.catchBody.remove(as);
            this.dirty = true;
        } else {
            return false;
        }
        this.body.remove(as);
        return true;
    }

    public List<AugmentedStmt> get_CatchExits() {
        if (this.catchBody == null) {
            return null;
        }
        if (this.dirty) {
            this.exitList = new LinkedList<AugmentedStmt>();
            this.dirty = false;
            block0: for (AugmentedStmt as : this.catchBody) {
                for (AugmentedStmt succ : as.bsuccs) {
                    if (this.catchBody.contains(succ)) continue;
                    this.exitList.add(as);
                    continue block0;
                }
            }
        }
        return this.exitList;
    }

    public void splitOff_ExceptionNode(IterableSet<AugmentedStmt> newTryBody, AugmentedStmtGraph asg, IterableSet<ExceptionNode> enlist) {
        IterableSet oldTryBody = new IterableSet();
        oldTryBody.addAll(this.tryBody);
        IterableSet oldBody = new IterableSet();
        oldBody.addAll(this.body);
        for (AugmentedStmt as : newTryBody) {
            if (this.remove(as)) continue;
            StringBuffer b = new StringBuffer();
            for (AugmentedStmt auBody : newTryBody) {
                b.append("\n" + auBody.toString());
            }
            b.append("\n-");
            for (AugmentedStmt auBody : oldTryBody) {
                b.append("\n" + auBody.toString());
            }
            b.append("\n-");
            for (AugmentedStmt auBody : oldBody) {
                b.append("\n" + auBody.toString());
            }
            b.append("\n-");
            throw new RuntimeException("Tried to split off a new try body that isn't in the old one.\n" + as + "\n - " + b.toString());
        }
        asg.clone_Body(this.catchBody);
        AugmentedStmt oldCatchTarget = this.handlerAugmentedStmt;
        AugmentedStmt newCatchTarget = asg.get_CloneOf(this.handlerAugmentedStmt);
        for (AugmentedStmt as : newTryBody) {
            as.remove_CSucc(oldCatchTarget);
            oldCatchTarget.remove_CPred(as);
        }
        for (AugmentedStmt as : this.tryBody) {
            as.remove_CSucc(newCatchTarget);
            newCatchTarget.remove_CPred(as);
        }
        for (ExceptionNode en : enlist) {
            if (this == en || !this.catchBody.isSupersetOf(en.get_Body())) continue;
            IterableSet<AugmentedStmt> clonedTryBody = new IterableSet<AugmentedStmt>();
            for (AugmentedStmt au : en.get_TryBody()) {
                clonedTryBody.add(asg.get_CloneOf(au));
            }
            enlist.addLast(new ExceptionNode(clonedTryBody, en.exception, asg.get_CloneOf(en.handlerAugmentedStmt)));
        }
        enlist.addLast(new ExceptionNode(newTryBody, this.exception, asg.get_CloneOf(this.handlerAugmentedStmt)));
        for (ExceptionNode en : enlist) {
            en.refresh_CatchBody(ExceptionFinder.v());
        }
        asg.find_Dominators();
    }

    public void add_CatchBody(ExceptionNode other) {
        if (other.get_CatchList() == null) {
            this.add_CatchBody(other.get_CatchBody(), other.get_Exception());
            return;
        }
        for (IterableSet<AugmentedStmt> c : other.get_CatchList()) {
            this.add_CatchBody(c, other.get_Exception(c));
        }
    }

    public void add_CatchBody(IterableSet<AugmentedStmt> newCatchBody, SootClass except) {
        if (this.catchList == null) {
            this.catchList = new LinkedList();
            this.catchList.addLast(this.catchBody);
            this.catch2except = new HashMap();
            this.catch2except.put(this.catchBody, this.exception);
        }
        this.body.addAll(newCatchBody);
        this.catchList.addLast(newCatchBody);
        this.catch2except.put(newCatchBody, except);
    }

    public List<IterableSet<AugmentedStmt>> get_CatchList() {
        LinkedList<IterableSet<AugmentedStmt>> l = this.catchList;
        if (l == null) {
            l = new LinkedList();
            l.add(this.catchBody);
        }
        return l;
    }

    public Map<IterableSet<AugmentedStmt>, SootClass> get_ExceptionMap() {
        HashMap<IterableSet<AugmentedStmt>, SootClass> m = this.catch2except;
        if (m == null) {
            m = new HashMap();
            m.put(this.catchBody, this.exception);
        }
        return m;
    }

    public SootClass get_Exception() {
        return this.exception;
    }

    public SootClass get_Exception(IterableSet<AugmentedStmt> catchBody) {
        if (this.catch2except == null) {
            return this.exception;
        }
        return this.catch2except.get(catchBody);
    }

    public void dump() {
        logger.debug("try {");
        for (AugmentedStmt augmentedStmt : this.get_TryBody()) {
            logger.debug("\t" + augmentedStmt);
        }
        logger.debug("}");
        for (IterableSet iterableSet : this.get_CatchList()) {
            logger.debug("catch " + this.get_ExceptionMap().get(iterableSet) + " {");
            for (AugmentedStmt au : iterableSet) {
                logger.debug("\t" + au);
            }
            logger.debug("}");
        }
    }
}

