/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jf.dexlib2.iface.instruction.FiveRegisterInstruction;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.RegisterRangeInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction35c;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rc;
import org.jf.dexlib2.iface.instruction.formats.Instruction45cc;
import org.jf.dexlib2.iface.instruction.formats.Instruction4rcc;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootMethodRef;
import soot.SootResolver;
import soot.Type;
import soot.dexpler.DexBody;
import soot.dexpler.DexType;
import soot.dexpler.Util;
import soot.dexpler.instructions.DanglingInstruction;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.dexpler.instructions.MoveResultInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.MethodHandle;

public abstract class MethodInvocationInstruction
extends DexlibAbstractInstruction
implements DanglingInstruction {
    protected InvokeExpr invocation;
    protected AssignStmt assign = null;

    public MethodInvocationInstruction(Instruction instruction, int codeAddress) {
        super(instruction, codeAddress);
    }

    @Override
    public void finalize(DexBody body, DexlibAbstractInstruction successor) {
        if (successor instanceof MoveResultInstruction) {
            this.assign = Jimple.v().newAssignStmt(body.getStoreResultLocal(), this.invocation);
            this.setUnit(this.assign);
            this.addTags(this.assign);
            body.add(this.assign);
            this.unit = this.assign;
        } else {
            InvokeStmt invoke = Jimple.v().newInvokeStmt(this.invocation);
            this.setUnit(invoke);
            this.addTags(invoke);
            body.add(invoke);
            this.unit = invoke;
        }
    }

    @Override
    public Set<Type> introducedTypes() {
        HashSet<Type> types = new HashSet<Type>();
        MethodReference method = (MethodReference)((ReferenceInstruction)this.instruction).getReference();
        types.add(DexType.toSoot(method.getDefiningClass()));
        types.add(DexType.toSoot(method.getReturnType()));
        List paramTypes = method.getParameterTypes();
        if (paramTypes != null) {
            for (CharSequence type : paramTypes) {
                types.add(DexType.toSoot(type.toString()));
            }
        }
        return types;
    }

    @Override
    boolean isUsedAsFloatingPoint(DexBody body, int register) {
        return this.isUsedAsFloatingPoint(body, register, false);
    }

    protected boolean isUsedAsFloatingPoint(DexBody body, int register, boolean isStatic) {
        MethodReference item = (MethodReference)((ReferenceInstruction)this.instruction).getReference();
        List paramTypes = item.getParameterTypes();
        List<Integer> regs = this.getUsedRegistersNums();
        if (paramTypes == null) {
            return false;
        }
        int i = 0;
        int j = 0;
        while (i < regs.size()) {
            if (!isStatic && i == 0) {
                --j;
            } else {
                if (regs.get(i) == register && Util.isFloatLike(DexType.toSoot(((CharSequence)paramTypes.get(j)).toString()))) {
                    return true;
                }
                if (DexType.isWide(((CharSequence)paramTypes.get(j)).toString())) {
                    ++i;
                }
            }
            ++i;
            ++j;
        }
        return false;
    }

    protected boolean isUsedAsObject(DexBody body, int register, boolean isStatic) {
        MethodReference item = (MethodReference)((ReferenceInstruction)this.instruction).getReference();
        List paramTypes = item.getParameterTypes();
        List<Integer> regs = this.getUsedRegistersNums();
        if (paramTypes == null) {
            return false;
        }
        if (!isStatic && regs.get(0) == register) {
            return true;
        }
        int i = 0;
        int j = 0;
        while (i < regs.size()) {
            if (!isStatic && i == 0) {
                --j;
            } else {
                if (regs.get(i) == register && DexType.toSoot(((CharSequence)paramTypes.get(j)).toString()) instanceof RefType) {
                    return true;
                }
                if (DexType.isWide(((CharSequence)paramTypes.get(j)).toString())) {
                    ++i;
                }
            }
            ++i;
            ++j;
        }
        return false;
    }

    protected SootMethodRef getVirtualSootMethodRef() {
        return this.getNormalSootMethodRef(MethodHandle.Kind.REF_INVOKE_VIRTUAL);
    }

    protected SootMethodRef getStaticSootMethodRef() {
        return this.getNormalSootMethodRef(MethodHandle.Kind.REF_INVOKE_STATIC);
    }

    protected SootMethodRef getInterfaceSootMethodRef() {
        return this.getNormalSootMethodRef(MethodHandle.Kind.REF_INVOKE_INTERFACE);
    }

    protected SootMethodRef getNormalSootMethodRef(MethodHandle.Kind kind) {
        return this.getSootMethodRef((MethodReference)((ReferenceInstruction)this.instruction).getReference(), kind);
    }

    protected SootMethodRef getSootMethodRef(MethodReference mItem, MethodHandle.Kind kind) {
        return this.getSootMethodRef(this.convertClassName(mItem.getDefiningClass(), kind), mItem.getName(), mItem.getReturnType(), mItem.getParameterTypes(), kind);
    }

    protected SootMethodRef getSootMethodRef(SootClass sc, String name, String returnType, List<? extends CharSequence> paramTypes, MethodHandle.Kind kind) {
        return Scene.v().makeMethodRef(sc, name, this.convertParameterTypes(paramTypes), DexType.toSoot(returnType), kind == MethodHandle.Kind.REF_INVOKE_STATIC);
    }

    protected SootFieldRef getSootFieldRef(FieldReference mItem, MethodHandle.Kind kind) {
        return this.getSootFieldRef(this.convertClassName(mItem.getDefiningClass(), kind), mItem.getName(), mItem.getType(), kind);
    }

    protected SootFieldRef getSootFieldRef(SootClass sc, String name, String type, MethodHandle.Kind kind) {
        return Scene.v().makeFieldRef(sc, name, DexType.toSoot(type), kind == MethodHandle.Kind.REF_GET_FIELD_STATIC || kind == MethodHandle.Kind.REF_PUT_FIELD_STATIC);
    }

    protected List<Type> convertParameterTypes(List<? extends CharSequence> paramTypes) {
        ArrayList<Type> parameterTypes = new ArrayList<Type>();
        if (paramTypes != null) {
            for (CharSequence charSequence : paramTypes) {
                parameterTypes.add(DexType.toSoot(charSequence.toString()));
            }
        }
        return parameterTypes;
    }

    protected SootClass convertClassName(String name, MethodHandle.Kind kind) {
        name = name.startsWith("[") ? "java.lang.Object" : Util.dottedClassName(name);
        SootClass sc = SootResolver.v().makeClassRef(name);
        if (kind == MethodHandle.Kind.REF_INVOKE_INTERFACE && sc.isPhantom()) {
            sc.setModifiers(sc.getModifiers() | 0x200);
        }
        return sc;
    }

    protected List<Local> buildParameters(DexBody body, List<? extends CharSequence> paramTypes, boolean isStatic) {
        ArrayList<Local> parameters = new ArrayList<Local>();
        List<Integer> regs = this.getUsedRegistersNums();
        int i = 0;
        int j = 0;
        while (i < regs.size()) {
            parameters.add(body.getRegisterLocal(regs.get(i)));
            if (!isStatic && i == 0) {
                --j;
            } else if (paramTypes != null && DexType.isWide(paramTypes.get(j).toString())) {
                ++i;
            }
            ++i;
            ++j;
        }
        return parameters;
    }

    protected List<Integer> getUsedRegistersNums() {
        if (this.instruction instanceof Instruction35c) {
            return this.getUsedRegistersNums((FiveRegisterInstruction)((Instruction35c)this.instruction));
        }
        if (this.instruction instanceof Instruction3rc) {
            return this.getUsedRegistersNums((RegisterRangeInstruction)((Instruction3rc)this.instruction));
        }
        if (this.instruction instanceof Instruction45cc) {
            return this.getUsedRegistersNums((FiveRegisterInstruction)((Instruction45cc)this.instruction));
        }
        if (this.instruction instanceof Instruction4rcc) {
            return this.getUsedRegistersNums((RegisterRangeInstruction)((Instruction4rcc)this.instruction));
        }
        throw new RuntimeException("Instruction is neither a InvokeInstruction nor a InvokeRangeInstruction");
    }

    protected void jimplifyVirtual(DexBody body) {
        SootMethodRef ref = this.getVirtualSootMethodRef();
        if (ref.getDeclaringClass().isInterface()) {
            this.jimplifyInterface(body);
            return;
        }
        MethodReference item = (MethodReference)((ReferenceInstruction)this.instruction).getReference();
        List<Local> parameters = this.buildParameters(body, item.getParameterTypes(), false);
        this.invocation = Jimple.v().newVirtualInvokeExpr(parameters.get(0), ref, parameters.subList(1, parameters.size()));
        body.setDanglingInstruction(this);
    }

    protected void jimplifyInterface(DexBody body) {
        SootMethodRef ref = this.getInterfaceSootMethodRef();
        if (!ref.getDeclaringClass().isInterface()) {
            this.jimplifyVirtual(body);
            return;
        }
        MethodReference item = (MethodReference)((ReferenceInstruction)this.instruction).getReference();
        List<Local> parameters = this.buildParameters(body, item.getParameterTypes(), false);
        this.invocation = Jimple.v().newInterfaceInvokeExpr(parameters.get(0), ref, parameters.subList(1, parameters.size()));
        body.setDanglingInstruction(this);
    }

    protected void jimplifySpecial(DexBody body) {
        MethodReference item = (MethodReference)((ReferenceInstruction)this.instruction).getReference();
        List<Local> parameters = this.buildParameters(body, item.getParameterTypes(), false);
        this.invocation = Jimple.v().newSpecialInvokeExpr(parameters.get(0), this.getVirtualSootMethodRef(), parameters.subList(1, parameters.size()));
        body.setDanglingInstruction(this);
    }

    protected void jimplifyStatic(DexBody body) {
        MethodReference item = (MethodReference)((ReferenceInstruction)this.instruction).getReference();
        this.invocation = Jimple.v().newStaticInvokeExpr(this.getStaticSootMethodRef(), this.buildParameters(body, item.getParameterTypes(), true));
        body.setDanglingInstruction(this);
    }
}

