/*
 * Decompiled with CFR 0.152.
 */
package soot.grimp.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.grimp.Grimp;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.ExprSwitch;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.util.Switch;

public class GDynamicInvokeExpr
extends AbstractInvokeExpr
implements DynamicInvokeExpr {
    protected final SootMethodRef bsmRef;
    protected final ValueBox[] bsmArgBoxes;
    protected final int tag;

    public GDynamicInvokeExpr(SootMethodRef bootStrapMethodRef, List<? extends Value> bootstrapArgs, SootMethodRef methodRef, int tag, List<? extends Value> methodArgs) {
        super(methodRef, new ValueBox[methodArgs.size()]);
        Value v;
        this.bsmRef = bootStrapMethodRef;
        this.bsmArgBoxes = new ValueBox[bootstrapArgs.size()];
        this.tag = tag;
        Grimp grmp = Grimp.v();
        ListIterator<? extends Value> it = bootstrapArgs.listIterator();
        while (it.hasNext()) {
            v = it.next();
            this.bsmArgBoxes[it.previousIndex()] = grmp.newExprBox(v);
        }
        it = methodArgs.listIterator();
        while (it.hasNext()) {
            v = it.next();
            this.argBoxes[it.previousIndex()] = grmp.newExprBox(v);
        }
    }

    @Override
    public Object clone() {
        ArrayList<Value> clonedBsmArgs = new ArrayList<Value>(this.bsmArgBoxes.length);
        for (ValueBox box : this.bsmArgBoxes) {
            clonedBsmArgs.add(box.getValue());
        }
        int count = this.getArgCount();
        ArrayList<Value> clonedArgs = new ArrayList<Value>(count);
        for (int i = 0; i < count; ++i) {
            clonedArgs.add(Grimp.cloneIfNecessary(this.getArg(i)));
        }
        return new GDynamicInvokeExpr(this.bsmRef, clonedBsmArgs, this.methodRef, this.tag, clonedArgs);
    }

    @Override
    public int getBootstrapArgCount() {
        return this.bsmArgBoxes.length;
    }

    @Override
    public Value getBootstrapArg(int i) {
        return this.bsmArgBoxes[i].getValue();
    }

    @Override
    public List<Value> getBootstrapArgs() {
        ArrayList<Value> l = new ArrayList<Value>();
        for (ValueBox element : this.bsmArgBoxes) {
            l.add(element.getValue());
        }
        return l;
    }

    @Override
    public SootMethodRef getBootstrapMethodRef() {
        return this.bsmRef;
    }

    public SootMethod getBootstrapMethod() {
        return this.bsmRef.resolve();
    }

    @Override
    public int getHandleTag() {
        return this.tag;
    }

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseDynamicInvokeExpr(this);
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof GDynamicInvokeExpr) {
            GDynamicInvokeExpr ie = (GDynamicInvokeExpr)o;
            if (!((this.argBoxes == null ? 0 : this.argBoxes.length) == (ie.argBoxes == null ? 0 : ie.argBoxes.length) && this.bsmArgBoxes.length == ie.bsmArgBoxes.length && this.getMethod().equals(ie.getMethod()) && this.methodRef.equals(ie.methodRef) && this.bsmRef.equals(ie.bsmRef))) {
                return false;
            }
            int i = 0;
            for (ValueBox element : this.bsmArgBoxes) {
                if (!element.getValue().equivTo(ie.getBootstrapArg(i))) {
                    return false;
                }
                ++i;
            }
            if (this.argBoxes != null) {
                i = 0;
                for (ValueBox element : this.argBoxes) {
                    if (!element.getValue().equivTo(ie.getArg(i))) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.getBootstrapMethod().equivHashCode() * this.getMethod().equivHashCode() * 17;
    }

    public String toString() {
        int i;
        int e;
        StringBuilder buf = new StringBuilder("dynamicinvoke \"");
        buf.append(this.methodRef.name());
        buf.append("\" <");
        buf.append(SootMethod.getSubSignature("", this.methodRef.parameterTypes(), this.methodRef.returnType()));
        buf.append(">(");
        if (this.argBoxes != null) {
            e = this.argBoxes.length;
            for (i = 0; i < e; ++i) {
                if (i != 0) {
                    buf.append(", ");
                }
                buf.append(this.argBoxes[i].getValue().toString());
            }
        }
        buf.append(") ");
        buf.append(this.bsmRef.getSignature());
        buf.append('(');
        e = this.bsmArgBoxes.length;
        for (i = 0; i < e; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.bsmArgBoxes[i].getValue().toString());
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        int i;
        int e;
        up.literal("dynamicinvoke \"" + this.methodRef.name() + "\" <" + SootMethod.getSubSignature("", this.methodRef.parameterTypes(), this.methodRef.returnType()) + ">(");
        if (this.argBoxes != null) {
            e = this.argBoxes.length;
            for (i = 0; i < e; ++i) {
                if (i != 0) {
                    up.literal(", ");
                }
                this.argBoxes[i].toString(up);
            }
        }
        up.literal(") ");
        up.methodRef(this.bsmRef);
        up.literal("(");
        e = this.bsmArgBoxes.length;
        for (i = 0; i < e; ++i) {
            if (i != 0) {
                up.literal(", ");
            }
            this.bsmArgBoxes[i].toString(up);
        }
        up.literal(")");
    }
}

