/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.List;
import soot.ArrayType;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.NewArrayInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.ExprSwitch;
import soot.jimple.JimpleToBafContext;
import soot.jimple.NewArrayExpr;
import soot.util.Switch;

public abstract class AbstractNewArrayExpr
implements NewArrayExpr,
ConvertToBaf {
    protected Type baseType;
    protected final ValueBox sizeBox;

    protected AbstractNewArrayExpr(Type type, ValueBox sizeBox) {
        this.baseType = type;
        this.sizeBox = sizeBox;
    }

    @Override
    public abstract Object clone();

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof AbstractNewArrayExpr) {
            AbstractNewArrayExpr ae = (AbstractNewArrayExpr)o;
            return this.sizeBox.getValue().equivTo(ae.sizeBox.getValue()) && this.baseType.equals(ae.baseType);
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.sizeBox.getValue().equivHashCode() * 101 + this.baseType.hashCode() * 17;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("newarray (");
        buf.append(this.getBaseTypeString()).append(")[").append(this.sizeBox.getValue().toString()).append(']');
        return buf.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("newarray (");
        up.type(this.baseType);
        up.literal(")[");
        this.sizeBox.toString(up);
        up.literal("]");
    }

    private String getBaseTypeString() {
        return this.baseType.toString();
    }

    @Override
    public Type getBaseType() {
        return this.baseType;
    }

    @Override
    public void setBaseType(Type type) {
        this.baseType = type;
    }

    @Override
    public ValueBox getSizeBox() {
        return this.sizeBox;
    }

    @Override
    public Value getSize() {
        return this.sizeBox.getValue();
    }

    @Override
    public void setSize(Value size) {
        this.sizeBox.setValue(size);
    }

    @Override
    public final List<ValueBox> getUseBoxes() {
        ArrayList<ValueBox> useBoxes = new ArrayList<ValueBox>(this.sizeBox.getValue().getUseBoxes());
        useBoxes.add(this.sizeBox);
        return useBoxes;
    }

    @Override
    public Type getType() {
        if (this.baseType instanceof ArrayType) {
            ArrayType base = (ArrayType)this.baseType;
            return ArrayType.v(base.baseType, base.numDimensions + 1);
        }
        return ArrayType.v(this.baseType, 1);
    }

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseNewArrayExpr(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        ((ConvertToBaf)((Object)this.getSize())).convertToBaf(context, out);
        NewArrayInst u = Baf.v().newNewArrayInst(this.getBaseType());
        out.add(u);
        u.addAllTagsOf(context.getCurrentUnit());
    }
}

