/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.Collections;
import java.util.List;
import soot.Local;
import soot.Scene;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.LoadInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.JimpleToBafContext;
import soot.jimple.JimpleValueSwitch;
import soot.util.IterableNumberer;
import soot.util.Switch;

public class JimpleLocal
implements Local,
ConvertToBaf {
    protected String name;
    protected Type type;
    private volatile int number = 0;

    public JimpleLocal(String name, Type type) {
        this.setName(name);
        this.setType(type);
        this.addToNumberer();
    }

    protected void addToNumberer() {
        IterableNumberer<Local> numberer = Scene.v().getLocalNumberer();
        if (numberer != null) {
            numberer.add(this);
        }
    }

    @Override
    public boolean equivTo(Object o) {
        return this.equals(o);
    }

    @Override
    public int equivHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public Object clone() {
        JimpleLocal local = new JimpleLocal(null, this.type);
        local.name = this.name;
        return local;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name == null ? null : name.intern();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void setType(Type t) {
        this.type = t;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.local(this);
    }

    @Override
    public final List<ValueBox> getUseBoxes() {
        return Collections.emptyList();
    }

    @Override
    public void apply(Switch sw) {
        ((JimpleValueSwitch)sw).caseLocal(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        LoadInst u = Baf.v().newLoadInst(this.getType(), context.getBafLocalOfJimpleLocal(this));
        u.addAllTagsOf(context.getCurrentUnit());
        out.add(u);
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public void setNumber(int number) {
        this.number = number;
    }

    @Override
    public boolean isStackLocal() {
        String n = this.getName();
        return n != null && n.charAt(0) == '$';
    }
}

