/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.util.IterableNumberer;
import soot.util.Numberable;

public class ZArrayNumberer<E extends Numberable>
implements IterableNumberer<E>,
Iterable<E> {
    final Map<E, E> objContainer;
    Numberable[] numberToObj;
    int lastNumber = 0;
    int filledCells = 0;

    public ZArrayNumberer() {
        this.numberToObj = new Numberable[1023];
        this.objContainer = new HashMap<E, E>(1023);
    }

    public ZArrayNumberer(int initSize) {
        this.numberToObj = new Numberable[initSize];
        this.objContainer = new HashMap<E, E>(initSize);
    }

    @Override
    public void add(E o) {
        if (o.getNumber() != -1 && this.numberToObj[o.getNumber()] == o) {
            return;
        }
        this.numberToObj[this.lastNumber] = o;
        o.setNumber(this.lastNumber);
        this.objContainer.put(o, o);
        ++this.lastNumber;
        ++this.filledCells;
        if (this.lastNumber >= this.numberToObj.length) {
            Numberable[] newnto = new Numberable[this.numberToObj.length * 2];
            System.arraycopy(this.numberToObj, 0, newnto, 0, this.numberToObj.length);
            this.numberToObj = newnto;
        }
    }

    public void clear() {
        for (int i = 0; i < this.lastNumber; ++i) {
            this.numberToObj[i] = null;
        }
        this.lastNumber = 0;
        this.filledCells = 0;
        this.objContainer.clear();
    }

    @Override
    public long get(E o) {
        if (o == null) {
            return -1L;
        }
        return o.getNumber();
    }

    @Override
    public E get(long number) {
        Numberable ret = this.numberToObj[(int)number];
        return (E)ret;
    }

    public E searchFor(E o) {
        return (E)((Numberable)this.objContainer.get(o));
    }

    @Override
    public boolean remove(E o) {
        int id = o.getNumber();
        if (id < 0) {
            return false;
        }
        if (this.numberToObj[id] != o) {
            return false;
        }
        this.numberToObj[id] = null;
        o.setNumber(-1);
        --this.filledCells;
        return true;
    }

    @Override
    public int size() {
        return this.filledCells;
    }

    public void reassign() {
        int i;
        int j = this.lastNumber - 1;
        for (i = 0; i < j; ++i) {
            if (this.numberToObj[i] != null) continue;
            while (j > i && this.numberToObj[j] == null) {
                --j;
            }
            if (i == j) break;
            this.numberToObj[i] = this.numberToObj[j];
            this.numberToObj[i].setNumber(i);
            this.numberToObj[j] = null;
        }
        this.lastNumber = i;
    }

    @Override
    public Iterator<E> iterator() {
        return new NumbererIterator();
    }

    final class NumbererIterator
    implements Iterator<E> {
        int cur = 0;
        E lastElement = null;

        NumbererIterator() {
        }

        @Override
        public final boolean hasNext() {
            while (this.cur < ZArrayNumberer.this.lastNumber && ZArrayNumberer.this.numberToObj[this.cur] == null) {
                ++this.cur;
            }
            return this.cur < ZArrayNumberer.this.lastNumber;
        }

        @Override
        public final E next() {
            Numberable temp = ZArrayNumberer.this.numberToObj[this.cur++];
            this.lastElement = temp;
            return temp;
        }

        @Override
        public final void remove() {
            ZArrayNumberer.this.remove(this.lastElement);
        }
    }
}

