/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.ide.libsumm;

import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.InvokeExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;

public class FixedMethods {
    public static final boolean ASSUME_PACKAGES_SEALED = false;

    public static boolean isFixed(InvokeExpr ie) {
        return ie instanceof StaticInvokeExpr || ie instanceof SpecialInvokeExpr || !FixedMethods.clientOverwriteableOverwrites(ie.getMethod());
    }

    private static boolean clientOverwriteableOverwrites(SootMethod m) {
        if (FixedMethods.clientOverwriteable(m)) {
            return true;
        }
        SootClass c = m.getDeclaringClass();
        for (SootClass cPrime : Scene.v().getFastHierarchy().getSubclassesOf(c)) {
            SootMethod mPrime = cPrime.getMethodUnsafe(m.getSubSignature());
            if (mPrime == null || !FixedMethods.clientOverwriteable(mPrime)) continue;
            return true;
        }
        return false;
    }

    private static boolean clientOverwriteable(SootMethod m) {
        SootClass c = m.getDeclaringClass();
        return !c.isFinal() && !m.isFinal() && FixedMethods.visible(m) && FixedMethods.clientCanInstantiate(c);
    }

    private static boolean clientCanInstantiate(SootClass cPrime) {
        if (cPrime.isInterface()) {
            return true;
        }
        for (SootMethod m : cPrime.getMethods()) {
            if (!m.getName().equals("<init>") || !FixedMethods.visible(m)) continue;
            return true;
        }
        return false;
    }

    private static boolean visible(SootMethod mPrime) {
        SootClass cPrime = mPrime.getDeclaringClass();
        return !(!cPrime.isPublic() && !cPrime.isProtected() && cPrime.isPrivate() || !mPrime.isPublic() && !mPrime.isProtected() && mPrime.isPrivate());
    }
}

