/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.reflection;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.Local;
import soot.LocalGenerator;
import soot.PhaseOptions;
import soot.PrimType;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.ClassConstant;
import soot.jimple.FieldRef;
import soot.jimple.GotoStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.toolkits.reflection.ReflectionTraceInfo;
import soot.jimple.toolkits.scalar.CopyPropagator;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.options.CGOptions;
import soot.options.Options;
import soot.rtlib.tamiflex.DefaultHandler;
import soot.rtlib.tamiflex.IUnexpectedReflectiveCallHandler;
import soot.rtlib.tamiflex.OpaquePredicate;
import soot.rtlib.tamiflex.ReflectiveCalls;
import soot.rtlib.tamiflex.SootSig;
import soot.rtlib.tamiflex.UnexpectedReflectiveCall;
import soot.toolkits.scalar.UnusedLocalEliminator;
import soot.util.Chain;
import soot.util.HashChain;

public class ReflectiveCallsInliner
extends SceneTransformer {
    private static final String ALREADY_CHECKED_FIELDNAME = "SOOT$Reflection$alreadyChecked";
    private static final List<String> fieldSets = Arrays.asList("set", "setBoolean", "setByte", "setChar", "setInt", "setLong", "setFloat", "setDouble", "setShort");
    private static final List<String> fieldGets = Arrays.asList("get", "getBoolean", "getByte", "getChar", "getInt", "getLong", "getFloat", "getDouble", "getShort");
    private static final boolean useCaching = false;
    private ReflectionTraceInfo RTI;
    private SootMethodRef UNINTERPRETED_METHOD;
    private boolean initialized = false;
    private int callSiteId;
    private int callNum;
    private SootClass reflectiveCallsClass;

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        if (!this.initialized) {
            CGOptions cgOptions = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"));
            this.RTI = new ReflectionTraceInfo(cgOptions.reflection_log());
            Scene scene = Scene.v();
            scene.getSootClass(SootSig.class.getName()).setApplicationClass();
            scene.getSootClass(UnexpectedReflectiveCall.class.getName()).setApplicationClass();
            scene.getSootClass(IUnexpectedReflectiveCallHandler.class.getName()).setApplicationClass();
            scene.getSootClass(DefaultHandler.class.getName()).setApplicationClass();
            scene.getSootClass(OpaquePredicate.class.getName()).setApplicationClass();
            scene.getSootClass(ReflectiveCalls.class.getName()).setApplicationClass();
            SootClass reflectiveCallsClass = new SootClass("soot.rtlib.tamiflex.ReflectiveCallsWrapper", 1);
            scene.addClass(reflectiveCallsClass);
            reflectiveCallsClass.setApplicationClass();
            this.reflectiveCallsClass = reflectiveCallsClass;
            this.UNINTERPRETED_METHOD = scene.makeMethodRef(scene.getSootClass("soot.rtlib.tamiflex.OpaquePredicate"), "getFalse", Collections.emptyList(), BooleanType.v(), true);
            this.initializeReflectiveCallsTable();
            this.callSiteId = 0;
            this.callNum = 0;
            this.initialized = true;
        }
        boolean validate = Options.v().validate();
        for (SootMethod m : this.RTI.methodsContainingReflectiveCalls()) {
            Set<String> fieldGetSignatures;
            Set<String> fieldSetSignatures;
            Set<String> methodInvokeSignatures;
            Set<String> constructorNewInstanceSignatures;
            Set<String> classNewInstanceClassNames;
            Body b = m.retrieveActiveBody();
            Set<String> classForNameClassNames = this.RTI.classForNameClassNames(m);
            if (!classForNameClassNames.isEmpty()) {
                this.inlineRelectiveCalls(m, classForNameClassNames, ReflectionTraceInfo.Kind.ClassForName);
                if (validate) {
                    b.validate();
                }
            }
            if (!(classNewInstanceClassNames = this.RTI.classNewInstanceClassNames(m)).isEmpty()) {
                this.inlineRelectiveCalls(m, classNewInstanceClassNames, ReflectionTraceInfo.Kind.ClassNewInstance);
                if (validate) {
                    b.validate();
                }
            }
            if (!(constructorNewInstanceSignatures = this.RTI.constructorNewInstanceSignatures(m)).isEmpty()) {
                this.inlineRelectiveCalls(m, constructorNewInstanceSignatures, ReflectionTraceInfo.Kind.ConstructorNewInstance);
                if (validate) {
                    b.validate();
                }
            }
            if (!(methodInvokeSignatures = this.RTI.methodInvokeSignatures(m)).isEmpty()) {
                this.inlineRelectiveCalls(m, methodInvokeSignatures, ReflectionTraceInfo.Kind.MethodInvoke);
                if (validate) {
                    b.validate();
                }
            }
            if (!(fieldSetSignatures = this.RTI.fieldSetSignatures(m)).isEmpty()) {
                this.inlineRelectiveCalls(m, fieldSetSignatures, ReflectionTraceInfo.Kind.FieldSet);
                if (validate) {
                    b.validate();
                }
            }
            if (!(fieldGetSignatures = this.RTI.fieldGetSignatures(m)).isEmpty()) {
                this.inlineRelectiveCalls(m, fieldGetSignatures, ReflectionTraceInfo.Kind.FieldGet);
                if (validate) {
                    b.validate();
                }
            }
            this.cleanup(b);
        }
    }

    private void cleanup(Body b) {
        CopyPropagator.v().transform(b);
        DeadAssignmentEliminator.v().transform(b);
        UnusedLocalEliminator.v().transform(b);
        NopEliminator.v().transform(b);
    }

    private void initializeReflectiveCallsTable() {
        Jimple jimp = Jimple.v();
        Scene scene = Scene.v();
        SootClass reflCallsClass = scene.getSootClass("soot.rtlib.tamiflex.ReflectiveCalls");
        Body body = reflCallsClass.getMethodByName("<clinit>").retrieveActiveBody();
        LocalGenerator localGen = scene.createLocalGenerator(body);
        HashChain<Stmt> newUnits = new HashChain<Stmt>();
        SootClass sootClassSet = scene.getSootClass("java.util.Set");
        RefType refTypeSet = sootClassSet.getType();
        SootMethodRef addMethodRef = sootClassSet.getMethodByName("add").makeRef();
        int callSiteId = 0;
        for (SootMethod m : this.RTI.methodsContainingReflectiveCalls()) {
            InterfaceInvokeExpr invokeExpr;
            Local setLocal;
            SootFieldRef fieldRef;
            if (!this.RTI.classForNameClassNames(m).isEmpty()) {
                fieldRef = scene.makeFieldRef(reflCallsClass, "classForName", refTypeSet, true);
                setLocal = localGen.generateLocal(refTypeSet);
                newUnits.add(jimp.newAssignStmt(setLocal, jimp.newStaticFieldRef(fieldRef)));
                for (String className : this.RTI.classForNameClassNames(m)) {
                    invokeExpr = jimp.newInterfaceInvokeExpr(setLocal, addMethodRef, (Value)StringConstant.v(callSiteId + className));
                    newUnits.add(jimp.newInvokeStmt(invokeExpr));
                }
                ++callSiteId;
            }
            if (!this.RTI.classNewInstanceClassNames(m).isEmpty()) {
                fieldRef = scene.makeFieldRef(reflCallsClass, "classNewInstance", refTypeSet, true);
                setLocal = localGen.generateLocal(refTypeSet);
                newUnits.add(jimp.newAssignStmt(setLocal, jimp.newStaticFieldRef(fieldRef)));
                for (String className : this.RTI.classNewInstanceClassNames(m)) {
                    invokeExpr = jimp.newInterfaceInvokeExpr(setLocal, addMethodRef, (Value)StringConstant.v(callSiteId + className));
                    newUnits.add(jimp.newInvokeStmt(invokeExpr));
                }
                ++callSiteId;
            }
            if (!this.RTI.constructorNewInstanceSignatures(m).isEmpty()) {
                fieldRef = scene.makeFieldRef(reflCallsClass, "constructorNewInstance", refTypeSet, true);
                setLocal = localGen.generateLocal(refTypeSet);
                newUnits.add(jimp.newAssignStmt(setLocal, jimp.newStaticFieldRef(fieldRef)));
                for (String constrSig : this.RTI.constructorNewInstanceSignatures(m)) {
                    invokeExpr = jimp.newInterfaceInvokeExpr(setLocal, addMethodRef, (Value)StringConstant.v(callSiteId + constrSig));
                    newUnits.add(jimp.newInvokeStmt(invokeExpr));
                }
                ++callSiteId;
            }
            if (this.RTI.methodInvokeSignatures(m).isEmpty()) continue;
            fieldRef = scene.makeFieldRef(reflCallsClass, "methodInvoke", refTypeSet, true);
            setLocal = localGen.generateLocal(refTypeSet);
            newUnits.add(jimp.newAssignStmt(setLocal, jimp.newStaticFieldRef(fieldRef)));
            for (String methodSig : this.RTI.methodInvokeSignatures(m)) {
                invokeExpr = jimp.newInterfaceInvokeExpr(setLocal, addMethodRef, (Value)StringConstant.v(callSiteId + methodSig));
                newUnits.add(jimp.newInvokeStmt(invokeExpr));
            }
            ++callSiteId;
        }
        UnitPatchingChain units = body.getUnits();
        units.insertAfter(newUnits, units.getPredOf(units.getLast()));
        if (Options.v().validate()) {
            body.validate();
        }
    }

    private void addCaching() {
        Scene scene = Scene.v();
        BooleanType bt = BooleanType.v();
        scene.getSootClass("java.lang.reflect.Method").addField(scene.makeSootField(ALREADY_CHECKED_FIELDNAME, bt));
        scene.getSootClass("java.lang.reflect.Constructor").addField(scene.makeSootField(ALREADY_CHECKED_FIELDNAME, bt));
        scene.getSootClass("java.lang.Class").addField(scene.makeSootField(ALREADY_CHECKED_FIELDNAME, bt));
        for (ReflectionTraceInfo.Kind k : ReflectionTraceInfo.Kind.values()) {
            this.addCaching(k);
        }
    }

    private void addCaching(ReflectionTraceInfo.Kind kind) {
        String methodName;
        SootClass c;
        Scene scene = Scene.v();
        switch (kind) {
            case ClassNewInstance: {
                c = scene.getSootClass("java.lang.Class");
                methodName = "knownClassNewInstance";
                break;
            }
            case ConstructorNewInstance: {
                c = scene.getSootClass("java.lang.reflect.Constructor");
                methodName = "knownConstructorNewInstance";
                break;
            }
            case MethodInvoke: {
                c = scene.getSootClass("java.lang.reflect.Method");
                methodName = "knownMethodInvoke";
                break;
            }
            case ClassForName: {
                return;
            }
            default: {
                throw new IllegalStateException("unknown kind: " + (Object)((Object)kind));
            }
        }
        SootMethod m = scene.getSootClass("soot.rtlib.tamiflex.ReflectiveCalls").getMethodByName(methodName);
        JimpleBody body = (JimpleBody)m.retrieveActiveBody();
        UnitPatchingChain units = body.getUnits();
        Unit firstStmt = units.getPredOf(body.getFirstNonIdentityStmt());
        HashChain<Stmt> newUnits = new HashChain<Stmt>();
        BooleanType bt = BooleanType.v();
        Jimple jimp = Jimple.v();
        InstanceFieldRef fieldRef = jimp.newInstanceFieldRef(body.getParameterLocal(m.getParameterCount() - 1), scene.makeFieldRef(c, ALREADY_CHECKED_FIELDNAME, bt, false));
        LocalGenerator localGen = scene.createLocalGenerator(body);
        Local alreadyCheckedLocal = localGen.generateLocal(bt);
        newUnits.add(jimp.newAssignStmt(alreadyCheckedLocal, fieldRef));
        NopStmt jumpTarget = jimp.newNopStmt();
        newUnits.add(jimp.newIfStmt((Value)jimp.newEqExpr(alreadyCheckedLocal, IntConstant.v(0)), jumpTarget));
        newUnits.add(jimp.newReturnVoidStmt());
        newUnits.add(jumpTarget);
        newUnits.add(jimp.newAssignStmt(jimp.newInstanceFieldRef(body.getParameterLocal(m.getParameterCount() - 1), scene.makeFieldRef(c, ALREADY_CHECKED_FIELDNAME, bt, false)), IntConstant.v(1)));
        units.insertAfter(newUnits, firstStmt);
        if (Options.v().validate()) {
            body.validate();
        }
    }

    private void inlineRelectiveCalls(SootMethod m, Set<String> targets, ReflectionTraceInfo.Kind callKind) {
        Body b = m.retrieveActiveBody();
        UnitPatchingChain units = b.getUnits();
        Scene scene = Scene.v();
        LocalGenerator localGen = scene.createLocalGenerator(b);
        Jimple jimp = Jimple.v();
        Iterator iter = units.snapshotIterator();
        while (iter.hasNext()) {
            Value field;
            SootMethod sootMethod;
            Object recv;
            Stmt s = (Stmt)iter.next();
            HashChain<Stmt> newUnits = new HashChain<Stmt>();
            if (!s.containsInvokeExpr()) continue;
            InvokeExpr ie = s.getInvokeExpr();
            boolean found = false;
            Type fieldSetGetType = null;
            if (callKind == ReflectionTraceInfo.Kind.ClassForName && ("<java.lang.Class: java.lang.Class forName(java.lang.String)>".equals(ie.getMethodRef().getSignature()) || "<java.lang.Class: java.lang.Class forName(java.lang.String,boolean,java.lang.ClassLoader)>".equals(ie.getMethodRef().getSignature()))) {
                found = true;
                Value classNameValue = ie.getArg(0);
                newUnits.add(jimp.newInvokeStmt(jimp.newStaticInvokeExpr(scene.getMethod("<soot.rtlib.tamiflex.ReflectiveCalls: void knownClassForName(int,java.lang.String)>").makeRef(), IntConstant.v(this.callSiteId), classNameValue)));
            } else if (callKind == ReflectionTraceInfo.Kind.ClassNewInstance && "<java.lang.Class: java.lang.Object newInstance()>".equals(ie.getMethodRef().getSignature())) {
                found = true;
                Local classLocal = (Local)((InstanceInvokeExpr)ie).getBase();
                newUnits.add(jimp.newInvokeStmt(jimp.newStaticInvokeExpr(scene.getMethod("<soot.rtlib.tamiflex.ReflectiveCalls: void knownClassNewInstance(int,java.lang.Class)>").makeRef(), IntConstant.v(this.callSiteId), classLocal)));
            } else if (callKind == ReflectionTraceInfo.Kind.ConstructorNewInstance && "<java.lang.reflect.Constructor: java.lang.Object newInstance(java.lang.Object[])>".equals(ie.getMethodRef().getSignature())) {
                found = true;
                Local constrLocal = (Local)((InstanceInvokeExpr)ie).getBase();
                newUnits.add(jimp.newInvokeStmt(jimp.newStaticInvokeExpr(scene.getMethod("<soot.rtlib.tamiflex.ReflectiveCalls: void knownConstructorNewInstance(int,java.lang.reflect.Constructor)>").makeRef(), IntConstant.v(this.callSiteId), constrLocal)));
            } else if (callKind == ReflectionTraceInfo.Kind.MethodInvoke && "<java.lang.reflect.Method: java.lang.Object invoke(java.lang.Object,java.lang.Object[])>".equals(ie.getMethodRef().getSignature())) {
                found = true;
                Local methodLocal = (Local)((InstanceInvokeExpr)ie).getBase();
                recv = ie.getArg(0);
                newUnits.add(jimp.newInvokeStmt(jimp.newStaticInvokeExpr(scene.getMethod("<soot.rtlib.tamiflex.ReflectiveCalls: void knownMethodInvoke(int,java.lang.Object,java.lang.reflect.Method)>").makeRef(), new Value[]{IntConstant.v(this.callSiteId), recv, methodLocal})));
            } else if (callKind == ReflectionTraceInfo.Kind.FieldSet) {
                sootMethod = ie.getMethodRef().resolve();
                if ("java.lang.reflect.Field".equals(sootMethod.getDeclaringClass().getName()) && fieldSets.contains(sootMethod.getName())) {
                    found = true;
                    fieldSetGetType = sootMethod.getParameterType(1);
                    recv = ie.getArg(0);
                    field = ((InstanceInvokeExpr)ie).getBase();
                    newUnits.add(jimp.newInvokeStmt(jimp.newStaticInvokeExpr(scene.getMethod("<soot.rtlib.tamiflex.ReflectiveCalls: void knownFieldSet(int,java.lang.Object,java.lang.reflect.Field)>").makeRef(), new Value[]{IntConstant.v(this.callSiteId), recv, field})));
                }
            } else if (callKind == ReflectionTraceInfo.Kind.FieldGet && "java.lang.reflect.Field".equals((sootMethod = ie.getMethodRef().resolve()).getDeclaringClass().getName()) && fieldGets.contains(sootMethod.getName())) {
                found = true;
                fieldSetGetType = sootMethod.getReturnType();
                recv = ie.getArg(0);
                field = ((InstanceInvokeExpr)ie).getBase();
                newUnits.add(jimp.newInvokeStmt(jimp.newStaticInvokeExpr(scene.getMethod("<soot.rtlib.tamiflex.ReflectiveCalls: void knownFieldSet(int,java.lang.Object,java.lang.reflect.Field)>").makeRef(), new Value[]{IntConstant.v(this.callSiteId), recv, field})));
            }
            if (!found) continue;
            NopStmt endLabel = jimp.newNopStmt();
            for (String target : targets) {
                NopStmt jumpTarget = jimp.newNopStmt();
                Local predLocal = localGen.generateLocal(BooleanType.v());
                newUnits.add(jimp.newAssignStmt(predLocal, jimp.newStaticInvokeExpr(this.UNINTERPRETED_METHOD)));
                newUnits.add(jimp.newIfStmt((Value)jimp.newEqExpr(IntConstant.v(0), predLocal), jumpTarget));
                SootMethod newMethod = this.createNewMethod(callKind, target, fieldSetGetType);
                LinkedList<Value> args = new LinkedList<Value>();
                switch (callKind) {
                    case ClassNewInstance: 
                    case ClassForName: {
                        break;
                    }
                    case ConstructorNewInstance: {
                        args.add(ie.getArgs().get(0));
                        break;
                    }
                    case MethodInvoke: {
                        args.add(ie.getArgs().get(0));
                        args.add(ie.getArgs().get(1));
                        break;
                    }
                    case FieldSet: {
                        args.add(ie.getArgs().get(0));
                        args.add(ie.getArgs().get(1));
                        break;
                    }
                    case FieldGet: {
                        args.add(ie.getArgs().get(0));
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                Local retLocal = localGen.generateLocal(newMethod.getReturnType());
                newUnits.add(jimp.newAssignStmt(retLocal, jimp.newStaticInvokeExpr(newMethod.makeRef(), args)));
                if (s instanceof AssignStmt) {
                    AssignStmt assignStmt = (AssignStmt)s;
                    newUnits.add(jimp.newAssignStmt(assignStmt.getLeftOp(), retLocal));
                }
                GotoStmt gotoStmt = jimp.newGotoStmt(endLabel);
                newUnits.add(gotoStmt);
                newUnits.add(jumpTarget);
            }
            Unit end = (Unit)newUnits.getLast();
            units.insertAfter(newUnits, s);
            units.remove(s);
            units.insertAfter(s, end);
            units.insertAfter(endLabel, s);
        }
        ++this.callSiteId;
    }

    private SootMethod createNewMethod(ReflectionTraceInfo.Kind callKind, String target, Type fieldSetGetType) {
        Local freshLocal;
        LinkedList<Type> parameterTypes = new LinkedList<Type>();
        Type returnType = null;
        switch (callKind) {
            case ClassForName: {
                returnType = RefType.v("java.lang.Class");
                break;
            }
            case ClassNewInstance: {
                returnType = RefType.v("java.lang.Object");
                break;
            }
            case ConstructorNewInstance: {
                returnType = RefType.v("java.lang.Object");
                parameterTypes.add(ArrayType.v(returnType, 1));
                break;
            }
            case MethodInvoke: {
                returnType = RefType.v("java.lang.Object");
                parameterTypes.add(returnType);
                parameterTypes.add(ArrayType.v(returnType, 1));
                break;
            }
            case FieldSet: {
                returnType = VoidType.v();
                parameterTypes.add(RefType.v("java.lang.Object"));
                parameterTypes.add(fieldSetGetType);
                break;
            }
            case FieldGet: {
                returnType = fieldSetGetType;
                parameterTypes.add(RefType.v("java.lang.Object"));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Jimple jimp = Jimple.v();
        Scene scene = Scene.v();
        SootMethod newMethod = scene.makeSootMethod("reflectiveCall" + this.callNum++, parameterTypes, returnType, 9);
        JimpleBody newBody = jimp.newBody(newMethod);
        newMethod.setActiveBody(newBody);
        this.reflectiveCallsClass.addMethod(newMethod);
        UnitPatchingChain newUnits = newBody.getUnits();
        LocalGenerator localGen = scene.createLocalGenerator(newBody);
        Value replacement = null;
        Local[] paramLocals = null;
        switch (callKind) {
            case ClassForName: {
                freshLocal = localGen.generateLocal(RefType.v("java.lang.Class"));
                replacement = ClassConstant.v(target.replace('.', '/'));
                break;
            }
            case ClassNewInstance: {
                RefType targetType = RefType.v(target);
                freshLocal = localGen.generateLocal(targetType);
                replacement = jimp.newNewExpr(targetType);
                break;
            }
            case ConstructorNewInstance: {
                SootMethod constructor = scene.getMethod(target);
                paramLocals = new Local[constructor.getParameterCount()];
                if (constructor.getParameterCount() > 0) {
                    ArrayType arrayType = ArrayType.v(RefType.v("java.lang.Object"), 1);
                    Local argArrayLocal = localGen.generateLocal(arrayType);
                    newUnits.add(jimp.newIdentityStmt(argArrayLocal, jimp.newParameterRef(arrayType, 0)));
                    int i = 0;
                    for (Type paramType : constructor.getParameterTypes()) {
                        paramLocals[i] = localGen.generateLocal(paramType);
                        this.unboxParameter(argArrayLocal, i, paramLocals, paramType, newUnits, localGen);
                        ++i;
                    }
                }
                RefType targetType = constructor.getDeclaringClass().getType();
                freshLocal = localGen.generateLocal(targetType);
                replacement = jimp.newNewExpr(targetType);
                break;
            }
            case MethodInvoke: {
                SootMethod method = scene.getMethod(target);
                RefType objectType = RefType.v("java.lang.Object");
                Local recvObject = localGen.generateLocal(objectType);
                newUnits.add(jimp.newIdentityStmt(recvObject, jimp.newParameterRef(objectType, 0)));
                paramLocals = new Local[method.getParameterCount()];
                if (method.getParameterCount() > 0) {
                    ArrayType arrayType = ArrayType.v(RefType.v("java.lang.Object"), 1);
                    Local argArrayLocal = localGen.generateLocal(arrayType);
                    newUnits.add(jimp.newIdentityStmt(argArrayLocal, jimp.newParameterRef(arrayType, 1)));
                    int i = 0;
                    for (Type paramType : method.getParameterTypes()) {
                        paramLocals[i] = localGen.generateLocal(paramType);
                        this.unboxParameter(argArrayLocal, i, paramLocals, paramType, newUnits, localGen);
                        ++i;
                    }
                }
                RefType targetType = method.getDeclaringClass().getType();
                freshLocal = localGen.generateLocal(targetType);
                replacement = jimp.newCastExpr(recvObject, method.getDeclaringClass().getType());
                break;
            }
            case FieldSet: 
            case FieldGet: {
                RefType objectType = RefType.v("java.lang.Object");
                Local recvObject = localGen.generateLocal(objectType);
                newUnits.add(jimp.newIdentityStmt(recvObject, jimp.newParameterRef(objectType, 0)));
                RefType fieldClassType = scene.getField(target).getDeclaringClass().getType();
                freshLocal = localGen.generateLocal(fieldClassType);
                replacement = jimp.newCastExpr(recvObject, fieldClassType);
                break;
            }
            default: {
                throw new InternalError("Unknown kind of reflective call " + (Object)((Object)callKind));
            }
        }
        AssignStmt replStmt = jimp.newAssignStmt(freshLocal, replacement);
        newUnits.add(replStmt);
        Local retLocal = localGen.generateLocal(returnType);
        switch (callKind) {
            case ClassForName: {
                newUnits.add(jimp.newAssignStmt(retLocal, freshLocal));
                break;
            }
            case ClassNewInstance: {
                newUnits.add(jimp.newInvokeStmt(jimp.newSpecialInvokeExpr(freshLocal, scene.makeMethodRef(scene.getSootClass(target), "<init>", Collections.emptyList(), VoidType.v(), false))));
                newUnits.add(jimp.newAssignStmt(retLocal, freshLocal));
                break;
            }
            case ConstructorNewInstance: {
                newUnits.add(jimp.newInvokeStmt(jimp.newSpecialInvokeExpr(freshLocal, scene.getMethod(target).makeRef(), Arrays.asList(paramLocals))));
                newUnits.add(jimp.newAssignStmt(retLocal, freshLocal));
                break;
            }
            case MethodInvoke: {
                SootMethod method = scene.getMethod(target);
                InvokeExpr invokeExpr = method.isStatic() ? jimp.newStaticInvokeExpr(method.makeRef(), Arrays.asList(paramLocals)) : jimp.newVirtualInvokeExpr(freshLocal, method.makeRef(), Arrays.asList(paramLocals));
                if (VoidType.v().equals(method.getReturnType())) {
                    newUnits.add(jimp.newInvokeStmt(invokeExpr));
                    newUnits.add(jimp.newAssignStmt(retLocal, NullConstant.v()));
                    break;
                }
                newUnits.add(jimp.newAssignStmt(retLocal, invokeExpr));
                break;
            }
            case FieldSet: {
                Local value = localGen.generateLocal(fieldSetGetType);
                newUnits.insertBeforeNoRedirect(jimp.newIdentityStmt(value, jimp.newParameterRef(fieldSetGetType, 1)), replStmt);
                SootField field = scene.getField(target);
                Local boxedOrCasted = localGen.generateLocal(field.getType());
                this.insertCastOrUnboxingCode(boxedOrCasted, value, newUnits);
                FieldRef fieldRef = field.isStatic() ? jimp.newStaticFieldRef(field.makeRef()) : jimp.newInstanceFieldRef(freshLocal, field.makeRef());
                newUnits.add(jimp.newAssignStmt(fieldRef, boxedOrCasted));
                break;
            }
            case FieldGet: {
                SootField field = scene.getField(target);
                Local value = localGen.generateLocal(field.getType());
                FieldRef fieldRef = field.isStatic() ? jimp.newStaticFieldRef(field.makeRef()) : jimp.newInstanceFieldRef(freshLocal, field.makeRef());
                newUnits.add(jimp.newAssignStmt(value, fieldRef));
                this.insertCastOrBoxingCode(retLocal, value, newUnits);
                break;
            }
        }
        if (!VoidType.v().equals(returnType)) {
            newUnits.add(jimp.newReturnStmt(retLocal));
        }
        if (Options.v().validate()) {
            ((Body)newBody).validate();
        }
        this.cleanup(newBody);
        return newMethod;
    }

    private void insertCastOrUnboxingCode(Local lhs, Local rhs, Chain<Unit> newUnits) {
        Type lhsType = lhs.getType();
        if (lhsType instanceof PrimType) {
            Type rhsType = rhs.getType();
            if (rhsType instanceof PrimType) {
                newUnits.add(Jimple.v().newAssignStmt(lhs, Jimple.v().newCastExpr(rhs, lhsType)));
            } else {
                RefType boxedType = (RefType)rhsType;
                SootMethodRef ref = Scene.v().makeMethodRef(boxedType.getSootClass(), lhsType.toString() + "Value", Collections.emptyList(), lhsType, false);
                newUnits.add(Jimple.v().newAssignStmt(lhs, Jimple.v().newVirtualInvokeExpr(rhs, ref)));
            }
        }
    }

    private void insertCastOrBoxingCode(Local lhs, Local rhs, Chain<Unit> newUnits) {
        Type lhsType = lhs.getType();
        if (lhsType instanceof RefLikeType) {
            Type rhsType = rhs.getType();
            if (rhsType instanceof RefLikeType) {
                newUnits.add(Jimple.v().newAssignStmt(lhs, Jimple.v().newCastExpr(rhs, lhsType)));
            } else {
                RefType boxedType = ((PrimType)rhsType).boxedType();
                SootMethodRef ref = Scene.v().makeMethodRef(boxedType.getSootClass(), "valueOf", Collections.singletonList(rhsType), boxedType, true);
                newUnits.add(Jimple.v().newAssignStmt(lhs, Jimple.v().newStaticInvokeExpr(ref, (Value)rhs)));
            }
        }
    }

    private void unboxParameter(Local argsArrayLocal, int paramIndex, Local[] paramLocals, Type paramType, Chain<Unit> newUnits, LocalGenerator localGen) {
        Jimple jimp = Jimple.v();
        if (paramType instanceof PrimType) {
            RefType boxedType = ((PrimType)paramType).boxedType();
            Local boxedLocal = localGen.generateLocal(RefType.v("java.lang.Object"));
            newUnits.add(jimp.newAssignStmt(boxedLocal, jimp.newArrayRef(argsArrayLocal, IntConstant.v(paramIndex))));
            Local castedLocal = localGen.generateLocal(boxedType);
            newUnits.add(jimp.newAssignStmt(castedLocal, jimp.newCastExpr(boxedLocal, boxedType)));
            newUnits.add(jimp.newAssignStmt(paramLocals[paramIndex], jimp.newVirtualInvokeExpr(castedLocal, Scene.v().makeMethodRef(boxedType.getSootClass(), paramType + "Value", Collections.emptyList(), paramType, false))));
        } else {
            Local boxedLocal = localGen.generateLocal(RefType.v("java.lang.Object"));
            newUnits.add(jimp.newAssignStmt(boxedLocal, jimp.newArrayRef(argsArrayLocal, IntConstant.v(paramIndex))));
            Local castedLocal = localGen.generateLocal(paramType);
            newUnits.add(jimp.newAssignStmt(castedLocal, jimp.newCastExpr(boxedLocal, paramType)));
            newUnits.add(jimp.newAssignStmt(paramLocals[paramIndex], castedLocal));
        }
    }
}

