/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.Iterator;
import java.util.List;
import soot.toolkits.scalar.AbstractFlowSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.FlowSet;

public class ToppedSet<T>
extends AbstractFlowSet<T> {
    protected final FlowSet<T> underlyingSet;
    protected boolean isTop;

    public ToppedSet(FlowSet<T> under) {
        this.underlyingSet = under;
    }

    @Override
    public ToppedSet<T> clone() {
        ToppedSet<T> newSet = new ToppedSet<T>(this.underlyingSet.clone());
        newSet.setTop(this.isTop());
        return newSet;
    }

    @Override
    public void copy(FlowSet<T> d) {
        if (this != d) {
            ToppedSet dest = (ToppedSet)d;
            dest.isTop = this.isTop;
            if (!this.isTop()) {
                this.underlyingSet.copy(dest.underlyingSet);
            }
        }
    }

    @Override
    public FlowSet<T> emptySet() {
        return new ToppedSet<T>(this.underlyingSet.emptySet());
    }

    @Override
    public void clear() {
        this.isTop = false;
        this.underlyingSet.clear();
    }

    @Override
    public void union(FlowSet<T> o, FlowSet<T> d) {
        if (o instanceof ToppedSet && d instanceof ToppedSet) {
            ToppedSet other = (ToppedSet)o;
            ToppedSet dest = (ToppedSet)d;
            if (this.isTop()) {
                this.copy(dest);
            } else if (other.isTop()) {
                other.copy(dest);
            } else {
                this.underlyingSet.union(other.underlyingSet, dest.underlyingSet);
                dest.setTop(false);
            }
        } else {
            super.union(o, d);
        }
    }

    @Override
    public void intersection(FlowSet<T> o, FlowSet<T> d) {
        if (this.isTop()) {
            o.copy(d);
            return;
        }
        ToppedSet other = (ToppedSet)o;
        ToppedSet dest = (ToppedSet)d;
        if (other.isTop()) {
            this.copy(dest);
        } else {
            this.underlyingSet.intersection(other.underlyingSet, dest.underlyingSet);
            dest.setTop(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void difference(FlowSet<T> o, FlowSet<T> d) {
        ToppedSet other = (ToppedSet)o;
        ToppedSet dest = (ToppedSet)d;
        if (this.isTop()) {
            if (other.isTop()) {
                dest.clear();
                return;
            } else {
                if (!(other.underlyingSet instanceof BoundedFlowSet)) throw new RuntimeException("can't take difference!");
                ((BoundedFlowSet)other.underlyingSet).complement(dest);
            }
            return;
        } else if (other.isTop()) {
            dest.clear();
            return;
        } else {
            this.underlyingSet.difference(other.underlyingSet, dest.underlyingSet);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.isTop() ? false : this.underlyingSet.isEmpty();
    }

    @Override
    public int size() {
        if (this.isTop()) {
            throw new UnsupportedOperationException();
        }
        return this.underlyingSet.size();
    }

    @Override
    public void add(T obj) {
        if (!this.isTop()) {
            this.underlyingSet.add(obj);
        }
    }

    @Override
    public void remove(T obj) {
        if (!this.isTop()) {
            this.underlyingSet.remove(obj);
        }
    }

    @Override
    public boolean contains(T obj) {
        return this.isTop() ? true : this.underlyingSet.contains(obj);
    }

    @Override
    public List<T> toList() {
        if (this.isTop()) {
            throw new UnsupportedOperationException();
        }
        return this.underlyingSet.toList();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + this.underlyingSet.hashCode();
        hash = 97 * hash + (this.isTop() ? 1 : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ToppedSet other = (ToppedSet)obj;
        return this.isTop() == other.isTop() && this.underlyingSet.equals(other.underlyingSet);
    }

    @Override
    public String toString() {
        return this.isTop() ? "{TOP}" : this.underlyingSet.toString();
    }

    @Override
    public Iterator<T> iterator() {
        if (this.isTop()) {
            throw new UnsupportedOperationException();
        }
        return this.underlyingSet.iterator();
    }

    public void setTop(boolean top) {
        this.isTop = top;
    }

    public boolean isTop() {
        return this.isTop;
    }
}

