/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.PatchingChain;
import soot.TrapManager;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPatchingChain;
import soot.options.Options;
import soot.shimple.PhiExpr;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.shimple.internal.SUnitBox;
import soot.util.Chain;
import soot.util.HashMultiMap;

public class SPatchingChain
extends UnitPatchingChain {
    private static final Logger logger = LoggerFactory.getLogger(SPatchingChain.class);
    protected final Body body;
    protected final boolean debug;
    protected Map<UnitBox, Unit> boxToPhiNode = new HashMap<UnitBox, Unit>();
    protected Set<Unit> phiNodeSet = new HashSet<Unit>();
    protected Map<SUnitBox, Boolean> boxToNeedsPatching = new HashMap<SUnitBox, Boolean>();

    public SPatchingChain(Body aBody, Chain<Unit> aChain) {
        super(aChain);
        this.body = aBody;
        boolean debug = Options.v().debug();
        if (aBody instanceof ShimpleBody) {
            debug |= ((ShimpleBody)aBody).getOptions().debug();
        }
        this.debug = debug;
    }

    @Override
    public boolean add(Unit o) {
        this.processPhiNode(o);
        return super.add(o);
    }

    @Override
    public void swapWith(Unit out, Unit in) {
        this.processPhiNode(in);
        Shimple.redirectPointers(out, in);
        super.insertBefore(in, out);
        this.remove(out);
    }

    @Override
    public void insertAfter(Unit toInsert, Unit point) {
        this.processPhiNode(toInsert);
        super.insertAfter(toInsert, point);
        if (!point.fallsThrough()) {
            return;
        }
        if (!(point.branches() || this.body != null && TrapManager.getTrappedUnitsOf(this.body).contains(point))) {
            Shimple.redirectPointers(point, toInsert);
            return;
        }
        for (UnitBox ub : new ArrayList<UnitBox>(point.getBoxesPointingToThis())) {
            if (ub.getUnit() != point) {
                throw new RuntimeException("Assertion failed.");
            }
            if (ub.isBranchTarget()) continue;
            SUnitBox box = this.getSBox(ub);
            Boolean needsPatching = this.boxToNeedsPatching.get(box);
            if (needsPatching == null || box.isUnitChanged()) {
                if (!this.boxToPhiNode.containsKey(box)) {
                    this.reprocessPhiNodes();
                    if (!this.boxToPhiNode.containsKey(box) && this.debug) {
                        throw new RuntimeException("SPatchingChain has pointers from a Phi node that has never been seen.");
                    }
                }
                this.computeNeedsPatching();
                needsPatching = this.boxToNeedsPatching.get(box);
                if (needsPatching == null) {
                    if (!this.debug) continue;
                    logger.warn("Orphaned UnitBox to " + point + "?  SPatchingChain will not move the pointer.");
                    continue;
                }
            }
            if (!needsPatching.booleanValue()) continue;
            box.setUnit(toInsert);
            box.setUnitChanged(false);
        }
    }

    @Override
    public void insertAfter(List<Unit> toInsert, Unit point) {
        for (Unit unit : toInsert) {
            this.processPhiNode(unit);
        }
        super.insertAfter(toInsert, point);
    }

    @Override
    public void insertAfter(Chain<Unit> toInsert, Unit point) {
        for (Unit unit : toInsert) {
            this.processPhiNode(unit);
        }
        super.insertAfter(toInsert, point);
    }

    @Override
    public void insertAfter(Collection<? extends Unit> toInsert, Unit point) {
        for (Unit unit : toInsert) {
            this.processPhiNode(unit);
        }
        super.insertAfter(toInsert, point);
    }

    @Override
    public void insertBefore(Unit toInsert, Unit point) {
        this.processPhiNode(toInsert);
        super.insertBefore(toInsert, point);
    }

    @Override
    public void insertBefore(List<Unit> toInsert, Unit point) {
        for (Unit unit : toInsert) {
            this.processPhiNode(unit);
        }
        super.insertBefore(toInsert, point);
    }

    @Override
    public void insertBefore(Chain<Unit> toInsert, Unit point) {
        for (Unit unit : toInsert) {
            this.processPhiNode(unit);
        }
        super.insertBefore(toInsert, point);
    }

    @Override
    public void insertBefore(Collection<? extends Unit> toInsert, Unit point) {
        for (Unit unit : toInsert) {
            this.processPhiNode(unit);
        }
        super.insertBefore(toInsert, point);
    }

    @Override
    public void addFirst(Unit u) {
        this.processPhiNode(u);
        super.addFirst(u);
    }

    @Override
    public void addLast(Unit u) {
        this.processPhiNode(u);
        super.addLast(u);
    }

    public boolean remove(Unit u) {
        if (this.contains(u)) {
            Shimple.redirectToPreds(this.body, u);
            boolean ret = super.remove(u);
            SPatchingChain.patchAfterRemoval(u);
            return ret;
        }
        return false;
    }

    @Override
    public boolean remove(Object obj) {
        return obj instanceof Unit ? this.remove((Unit)obj) : false;
    }

    protected static void patchAfterRemoval(Unit removing) {
        if (removing != null) {
            for (UnitBox ub : removing.getUnitBoxes()) {
                Unit u = ub.getUnit();
                if (u == null) continue;
                u.removeBoxPointingToThis(ub);
            }
        }
    }

    protected void processPhiNode(Unit phiNode) {
        PhiExpr phi = Shimple.getPhiExpr(phiNode);
        if (phi == null) {
            return;
        }
        if (this.phiNodeSet.contains(phiNode)) {
            return;
        }
        for (UnitBox box : phi.getUnitBoxes()) {
            this.boxToPhiNode.put(box, phiNode);
            this.phiNodeSet.add(phiNode);
        }
    }

    protected void reprocessPhiNodes() {
        HashSet<Unit> phiNodes = new HashSet<Unit>(this.boxToPhiNode.values());
        this.boxToPhiNode = new HashMap<UnitBox, Unit>();
        this.phiNodeSet = new HashSet<Unit>();
        this.boxToNeedsPatching = new HashMap<SUnitBox, Boolean>();
        for (Unit next : phiNodes) {
            this.processPhiNode(next);
        }
    }

    protected void computeNeedsPatching() {
        if (this.boxToPhiNode.isEmpty()) {
            return;
        }
        HashMultiMap<Unit, UnitBox> trackedPhiToBoxes = new HashMultiMap<Unit, UnitBox>();
        HashSet<Unit> trackedBranchTargets = new HashSet<Unit>();
        for (Unit u : this) {
            List<UnitBox> boxesToTrack = u.getBoxesPointingToThis();
            if (boxesToTrack != null) {
                for (UnitBox boxToTrack : boxesToTrack) {
                    if (boxToTrack.isBranchTarget()) continue;
                    trackedPhiToBoxes.put(this.boxToPhiNode.get(boxToTrack), boxToTrack);
                }
            }
            if (u.fallsThrough() && u.branches()) {
                for (UnitBox ub : u.getUnitBoxes()) {
                    trackedBranchTargets.add(ub.getUnit());
                }
            }
            if (!u.fallsThrough() || trackedBranchTargets.contains(u)) {
                for (UnitBox next : trackedPhiToBoxes.values()) {
                    SUnitBox box = this.getSBox(next);
                    this.boxToNeedsPatching.put(box, Boolean.FALSE);
                    box.setUnitChanged(false);
                }
                trackedPhiToBoxes.clear();
                continue;
            }
            Set boxes = trackedPhiToBoxes.get(u);
            if (boxes == null) continue;
            for (UnitBox ub : boxes) {
                SUnitBox box = this.getSBox(ub);
                this.boxToNeedsPatching.put(box, Boolean.TRUE);
                box.setUnitChanged(false);
            }
            trackedPhiToBoxes.remove(u);
        }
        for (UnitBox next : trackedPhiToBoxes.values()) {
            SUnitBox box = this.getSBox(next);
            this.boxToNeedsPatching.put(box, Boolean.FALSE);
            box.setUnitChanged(false);
        }
    }

    protected SUnitBox getSBox(UnitBox box) {
        if (box instanceof SUnitBox) {
            return (SUnitBox)box;
        }
        throw new RuntimeException("Shimple box not an SUnitBox?");
    }

    @Override
    public Iterator<Unit> iterator() {
        return new SPatchingIterator(this.innerChain);
    }

    @Override
    public Iterator<Unit> iterator(Unit u) {
        return new SPatchingIterator(this.innerChain, u);
    }

    @Override
    public Iterator<Unit> iterator(Unit head, Unit tail) {
        return new SPatchingIterator(this.innerChain, head, tail);
    }

    protected class SPatchingIterator
    extends PatchingChain.PatchingIterator {
        SPatchingIterator(Chain<Unit> innerChain) {
            super(innerChain);
        }

        SPatchingIterator(Chain<Unit> innerChain, Unit u) {
            super((PatchingChain)SPatchingChain.this, innerChain, u);
        }

        SPatchingIterator(Chain<Unit> innerChain, Unit head, Unit tail) {
            super((PatchingChain)SPatchingChain.this, innerChain, head, tail);
        }

        @Override
        public void remove() {
            if (!this.state) {
                throw new IllegalStateException("remove called before first next() call");
            }
            this.state = false;
            Unit victim = this.lastObject;
            Shimple.redirectToPreds(SPatchingChain.this.body, victim);
            SPatchingChain.patchBeforeRemoval(this.innerChain, victim);
            this.innerIterator.remove();
            SPatchingChain.patchAfterRemoval(victim);
        }
    }
}

