/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.internal.JimpleLocal;
import soot.jimple.toolkits.base.Aggregator;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.jimple.toolkits.scalar.UnconditionalBranchFolder;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.options.ShimpleOptions;
import soot.shimple.DefaultShimpleFactory;
import soot.shimple.PhiExpr;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.shimple.ShimpleFactory;
import soot.shimple.internal.PhiNodeManager;
import soot.shimple.internal.PiNodeManager;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.DominatorNode;
import soot.toolkits.graph.DominatorTree;
import soot.toolkits.scalar.UnusedLocalEliminator;
import soot.toolkits.scalar.ValueUnitPair;

public class ShimpleBodyBuilder {
    private static String freshSeparator = "_";
    protected final ShimpleBody body;
    protected final ShimpleOptions options;
    protected final ShimpleFactory sf;
    protected List<Local> origLocals;
    protected Map<String, Local> newLocals;
    protected Map<Local, Local> newLocalsToOldLocal;
    protected int[] assignmentCounters;
    protected Stack<Integer>[] namingStacks;
    public final PhiNodeManager phi;
    public final PiNodeManager pi;

    public ShimpleBodyBuilder(ShimpleBody body) {
        NopEliminator.v().transform(body);
        this.body = body;
        this.options = body.getOptions();
        this.sf = new DefaultShimpleFactory(body);
        this.sf.clearCache();
        this.phi = new PhiNodeManager(body, this.sf);
        this.pi = new PiNodeManager(body, false, this.sf);
        this.makeUniqueLocalNames();
    }

    public void update() {
        this.origLocals = Collections.unmodifiableList(new ArrayList<Local>(this.body.getLocals()));
    }

    public void transform() {
        this.sf.clearCache();
        this.update();
        this.phi.insertTrivialPhiNodes();
        if (this.options.extended()) {
            boolean change = this.pi.insertTrivialPiNodes();
            while (change && this.phi.insertTrivialPhiNodes()) {
                change = this.pi.insertTrivialPiNodes();
            }
        }
        this.renameLocals();
        this.phi.trimExceptionalPhiNodes();
        this.makeUniqueLocalNames();
    }

    public void preElimOpt() {
    }

    public void postElimOpt() {
        if (this.options.node_elim_opt()) {
            DeadAssignmentEliminator.v().transform(this.body);
            UnreachableCodeEliminator.v().transform(this.body);
            UnconditionalBranchFolder.v().transform(this.body);
            Aggregator.v().transform(this.body);
            UnusedLocalEliminator.v().transform(this.body);
        }
    }

    public void eliminatePhiNodes() {
        if (this.phi.doEliminatePhiNodes()) {
            this.makeUniqueLocalNames();
        }
    }

    public void eliminatePiNodes() {
        this.pi.eliminatePiNodes(this.options.node_elim_opt());
    }

    public void renameLocals() {
        this.update();
        this.newLocals = new HashMap<String, Local>();
        this.newLocalsToOldLocal = new HashMap<Local, Local>();
        int size = this.origLocals.size();
        this.assignmentCounters = new int[size];
        Stack[] temp = new Stack[size];
        for (int i = 0; i < size; ++i) {
            temp[i] = new Stack();
        }
        this.namingStacks = temp;
        List<Block> heads = this.sf.getBlockGraph().getHeads();
        switch (heads.size()) {
            case 0: {
                return;
            }
            case 1: {
                this.renameLocalsSearch(heads.get(0));
                return;
            }
        }
        throw new RuntimeException("Assertion failed: Only one head expected.");
    }

    public void renameLocalsSearch(Block block) {
        ArrayList<Local> lhsLocals = new ArrayList<Local>();
        for (Unit unit : block) {
            DefinitionStmt definitionStmt;
            ValueBox lhsLocalBox;
            Value lhsValue;
            Integer subscript;
            if (!Shimple.isPhiNode(unit)) {
                for (ValueBox useBox : unit.getUseBoxes()) {
                    Stack<Integer> namingStack;
                    Value use = useBox.getValue();
                    int localIndex = this.indexOfLocal(use);
                    if (localIndex == -1 || (namingStack = this.namingStacks[localIndex]).empty()) continue;
                    subscript = namingStack.peek();
                    Local renamedLocal = this.fetchNewLocal((Local)use, subscript);
                    useBox.setValue(renamedLocal);
                }
            }
            if (!(unit instanceof DefinitionStmt) || !this.origLocals.contains(lhsValue = (lhsLocalBox = (definitionStmt = (DefinitionStmt)unit).getLeftOpBox()).getValue())) continue;
            Local lhsLocal = (Local)lhsValue;
            lhsLocals.add(lhsLocal);
            int localIndex = this.indexOfLocal(lhsLocal);
            if (localIndex == -1) {
                throw new RuntimeException("Assertion failed.");
            }
            subscript = this.assignmentCounters[localIndex];
            Local newLhsLocal = this.fetchNewLocal(lhsLocal, subscript);
            lhsLocalBox.setValue(newLhsLocal);
            this.namingStacks[localIndex].push(subscript);
            int n = localIndex;
            this.assignmentCounters[n] = this.assignmentCounters[n] + 1;
        }
        for (Block block2 : this.sf.getBlockGraph().getSuccsOf(block)) {
            if (block.getHead() == null && block.getTail() == null) continue;
            for (Unit unit : block2) {
                PhiExpr phiExpr = Shimple.getPhiExpr(unit);
                if (phiExpr == null) continue;
                ValueUnitPair phiArgBox = phiExpr.getArgBox(block);
                if (phiArgBox == null) {
                    throw new RuntimeException("Assertion failed. Cannot find " + block + " in " + phiExpr);
                }
                Local phiArg = (Local)phiArgBox.getValue();
                int localIndex = this.indexOfLocal(phiArg);
                if (localIndex == -1) {
                    throw new RuntimeException("Assertion failed.");
                }
                Stack<Integer> namingStack = this.namingStacks[localIndex];
                if (namingStack.empty()) continue;
                Integer subscript = namingStack.peek();
                Local newPhiArg = this.fetchNewLocal(phiArg, subscript);
                phiArgBox.setValue(newPhiArg);
            }
        }
        DominatorTree<Block> dt = this.sf.getDominatorTree();
        for (DominatorNode<Block> dominatorNode : dt.getChildrenOf(dt.getDode(block))) {
            this.renameLocalsSearch(dominatorNode.getGode());
        }
        for (Local local : lhsLocals) {
            int n = this.indexOfLocal(local);
            if (n == -1) {
                throw new RuntimeException("Assertion failed.");
            }
            this.namingStacks[n].pop();
        }
    }

    protected Local fetchNewLocal(Local local, Integer subscript) {
        Local oldLocal;
        Local local2 = oldLocal = this.origLocals.contains(local) ? local : this.newLocalsToOldLocal.get(local);
        if (subscript == 0) {
            return oldLocal;
        }
        String name = oldLocal.getName() + freshSeparator + subscript;
        Local newLocal = this.newLocals.get(name);
        if (newLocal == null) {
            newLocal = new JimpleLocal(name, oldLocal.getType());
            this.newLocals.put(name, newLocal);
            this.newLocalsToOldLocal.put(newLocal, oldLocal);
            this.body.getLocals().add(newLocal);
        }
        return newLocal;
    }

    protected int indexOfLocal(Value local) {
        int localIndex = this.origLocals.indexOf(local);
        if (localIndex == -1) {
            Local oldLocal = this.newLocalsToOldLocal.get(local);
            localIndex = this.origLocals.indexOf(oldLocal);
        }
        return localIndex;
    }

    public void makeUniqueLocalNames() {
        if (this.options.standard_local_names()) {
            LocalNameStandardizer.v().transform(this.body);
            return;
        }
        HashSet<String> localNames = new HashSet<String>();
        for (Local local : this.body.getLocals()) {
            String localName = local.getName();
            if (localNames.contains(localName)) {
                String uniqueName = ShimpleBodyBuilder.makeUniqueLocalName(localName, localNames);
                local.setName(uniqueName);
                localNames.add(uniqueName);
                continue;
            }
            localNames.add(localName);
        }
    }

    public static String makeUniqueLocalName(String dupName, Set<String> localNames) {
        int counter = 1;
        String newName = dupName;
        while (localNames.contains(newName)) {
            newName = dupName + freshSeparator + counter++;
        }
        return newName;
    }

    public static void setSeparator(String sep) {
        freshSeparator = sep;
    }
}

