/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.reference.TypeReference;
import soot.ArrayType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.IntegerType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.PrimType;
import soot.RefType;
import soot.SootClass;
import soot.Type;
import soot.Value;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.CastExpr;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.DivExpr;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.EqExpr;
import soot.jimple.Expr;
import soot.jimple.ExprSwitch;
import soot.jimple.GeExpr;
import soot.jimple.GtExpr;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.RemExpr;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.SubExpr;
import soot.jimple.UshrExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.XorExpr;
import soot.toDex.ConstantVisitor;
import soot.toDex.DexPrinter;
import soot.toDex.PrimitiveType;
import soot.toDex.Register;
import soot.toDex.RegisterAllocator;
import soot.toDex.SootToDexUtils;
import soot.toDex.StmtVisitor;
import soot.toDex.instructions.AbstractInsn;
import soot.toDex.instructions.Insn;
import soot.toDex.instructions.Insn10x;
import soot.toDex.instructions.Insn11x;
import soot.toDex.instructions.Insn12x;
import soot.toDex.instructions.Insn21c;
import soot.toDex.instructions.Insn21t;
import soot.toDex.instructions.Insn22b;
import soot.toDex.instructions.Insn22c;
import soot.toDex.instructions.Insn22s;
import soot.toDex.instructions.Insn22t;
import soot.toDex.instructions.Insn23x;
import soot.toDex.instructions.Insn35c;
import soot.toDex.instructions.Insn3rc;
import soot.toDex.instructions.InsnWithOffset;

public class ExprVisitor
implements ExprSwitch {
    protected StmtVisitor stmtV;
    protected ConstantVisitor constantV;
    protected RegisterAllocator regAlloc;
    protected Register destinationReg;
    protected Stmt targetForOffset;
    protected Stmt origStmt;
    private int lastInvokeInstructionPosition;

    public ExprVisitor(StmtVisitor stmtV, ConstantVisitor constantV, RegisterAllocator regAlloc) {
        this.stmtV = stmtV;
        this.constantV = constantV;
        this.regAlloc = regAlloc;
    }

    public void setDestinationReg(Register destinationReg) {
        this.destinationReg = destinationReg;
    }

    public void setOrigStmt(Stmt stmt) {
        this.origStmt = stmt;
    }

    public void setTargetForOffset(Stmt targetForOffset) {
        this.targetForOffset = targetForOffset;
    }

    @Override
    public void defaultCase(Object o) {
        throw new Error("unknown Object (" + o.getClass() + ") as Expression: " + o);
    }

    @Override
    public void caseDynamicInvokeExpr(DynamicInvokeExpr v) {
        throw new Error("DynamicInvokeExpr not supported: " + v);
    }

    @Override
    public void caseSpecialInvokeExpr(SpecialInvokeExpr sie) {
        MethodReference method = DexPrinter.toMethodReference(sie.getMethodRef());
        List<Register> arguments = this.getInstanceInvokeArgumentRegs(sie);
        this.lastInvokeInstructionPosition = this.stmtV.getInstructionCount();
        if (this.isCallToConstructor(sie) || this.isCallToPrivate(sie)) {
            this.stmtV.addInsn(this.buildInvokeInsn("INVOKE_DIRECT", method, arguments), this.origStmt);
        } else if (this.isCallToSuper(sie)) {
            this.stmtV.addInsn(this.buildInvokeInsn("INVOKE_SUPER", method, arguments), this.origStmt);
        } else {
            this.stmtV.addInsn(this.buildInvokeInsn("INVOKE_VIRTUAL", method, arguments), this.origStmt);
        }
    }

    private Insn buildInvokeInsn(String invokeOpcode, MethodReference method, List<Register> argumentRegs) {
        AbstractInsn invokeInsn;
        int regCountForArguments = SootToDexUtils.getRealRegCount(argumentRegs);
        if (regCountForArguments <= 5) {
            Register[] paddedArray = this.pad35cRegs(argumentRegs);
            Opcode opc = Opcode.valueOf((String)invokeOpcode);
            invokeInsn = new Insn35c(opc, regCountForArguments, paddedArray[0], paddedArray[1], paddedArray[2], paddedArray[3], paddedArray[4], (Reference)method);
        } else if (regCountForArguments <= 255) {
            Opcode opc = Opcode.valueOf((String)(invokeOpcode + "_RANGE"));
            invokeInsn = new Insn3rc(opc, argumentRegs, (short)regCountForArguments, (Reference)method);
        } else {
            throw new Error("too many parameter registers for invoke-* (> 255): " + regCountForArguments + " or registers too big (> 4 bits)");
        }
        this.stmtV.setLastReturnTypeDescriptor(method.getReturnType());
        return invokeInsn;
    }

    private boolean isCallToPrivate(SpecialInvokeExpr sie) {
        return sie.getMethod().isPrivate();
    }

    private boolean isCallToConstructor(SpecialInvokeExpr sie) {
        return sie.getMethodRef().name().equals("<init>");
    }

    private boolean isCallToSuper(SpecialInvokeExpr sie) {
        SootClass classWithInvokation = sie.getMethod().getDeclaringClass();
        SootClass currentClass = this.stmtV.getBelongingClass();
        while (currentClass != null) {
            if ((currentClass = currentClass.getSuperclassUnsafe()) == null) continue;
            if (currentClass == classWithInvokation) {
                return true;
            }
            if (!currentClass.isPhantom() || currentClass.getName().equals("java.lang.Object")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void caseVirtualInvokeExpr(VirtualInvokeExpr vie) {
        MethodReference method = DexPrinter.toMethodReference(vie.getMethodRef());
        List<Register> argumentRegs = this.getInstanceInvokeArgumentRegs(vie);
        this.lastInvokeInstructionPosition = this.stmtV.getInstructionCount();
        this.stmtV.addInsn(this.buildInvokeInsn("INVOKE_VIRTUAL", method, argumentRegs), this.origStmt);
    }

    private List<Register> getInvokeArgumentRegs(InvokeExpr ie) {
        this.constantV.setOrigStmt(this.origStmt);
        ArrayList<Register> argumentRegs = new ArrayList<Register>();
        for (Value arg : ie.getArgs()) {
            Register currentReg = this.regAlloc.asImmediate(arg, this.constantV);
            argumentRegs.add(currentReg);
        }
        return argumentRegs;
    }

    private List<Register> getInstanceInvokeArgumentRegs(InstanceInvokeExpr iie) {
        this.constantV.setOrigStmt(this.origStmt);
        List<Register> argumentRegs = this.getInvokeArgumentRegs(iie);
        Local callee = (Local)iie.getBase();
        Register calleeRegister = this.regAlloc.asLocal(callee);
        argumentRegs.add(0, calleeRegister);
        return argumentRegs;
    }

    private Register[] pad35cRegs(List<Register> realRegs) {
        Register[] paddedArray = new Register[5];
        int nextReg = 0;
        Iterator<Register> iterator = realRegs.iterator();
        while (iterator.hasNext()) {
            Register realReg;
            paddedArray[nextReg] = realReg = iterator.next();
            if (realReg.isWide()) {
                paddedArray[++nextReg] = Register.EMPTY_REGISTER;
            }
            ++nextReg;
        }
        while (nextReg < 5) {
            paddedArray[nextReg] = Register.EMPTY_REGISTER;
            ++nextReg;
        }
        return paddedArray;
    }

    @Override
    public void caseInterfaceInvokeExpr(InterfaceInvokeExpr iie) {
        MethodReference method = DexPrinter.toMethodReference(iie.getMethodRef());
        List<Register> arguments = this.getInstanceInvokeArgumentRegs(iie);
        this.lastInvokeInstructionPosition = this.stmtV.getInstructionCount();
        this.stmtV.addInsn(this.buildInvokeInsn("INVOKE_INTERFACE", method, arguments), this.origStmt);
    }

    @Override
    public void caseStaticInvokeExpr(StaticInvokeExpr sie) {
        MethodReference method = DexPrinter.toMethodReference(sie.getMethodRef());
        List<Register> arguments = this.getInvokeArgumentRegs(sie);
        this.lastInvokeInstructionPosition = this.stmtV.getInstructionCount();
        this.stmtV.addInsn(this.buildInvokeInsn("INVOKE_STATIC", method, arguments), this.origStmt);
    }

    private void buildCalculatingBinaryInsn(String binaryOperation, Value firstOperand, Value secondOperand, Expr originalExpr) {
        this.constantV.setOrigStmt(this.origStmt);
        Register firstOpReg = this.regAlloc.asImmediate(firstOperand, this.constantV);
        if (this.destinationReg.getType() instanceof IntType && secondOperand instanceof IntConstant && !binaryOperation.equals("SUB")) {
            int secondOpConstant = ((IntConstant)secondOperand).value;
            if (SootToDexUtils.fitsSigned8(secondOpConstant)) {
                this.stmtV.addInsn(this.buildLit8BinaryInsn(binaryOperation, firstOpReg, (byte)secondOpConstant), this.origStmt);
                return;
            }
            if (SootToDexUtils.fitsSigned16(secondOpConstant) && !binaryOperation.equals("SHL") && !binaryOperation.equals("SHR") && !binaryOperation.equals("USHR")) {
                this.stmtV.addInsn(this.buildLit16BinaryInsn(binaryOperation, firstOpReg, (short)secondOpConstant), this.origStmt);
                return;
            }
        }
        if (!(secondOperand.getType() instanceof PrimType)) {
            throw new RuntimeException("Invalid value type for primitive operation");
        }
        PrimitiveType destRegType = PrimitiveType.getByName(this.destinationReg.getType().toString());
        Register secondOpReg = this.regAlloc.asImmediate(secondOperand, this.constantV);
        Register orgDestReg = this.destinationReg;
        if (this.isSmallerThan(destRegType, PrimitiveType.INT)) {
            this.destinationReg = this.regAlloc.asTmpReg(IntType.v());
        } else if (this.isBiggerThan(PrimitiveType.getByName(secondOpReg.getType().toString()), destRegType)) {
            this.destinationReg = this.regAlloc.asTmpReg(secondOpReg.getType());
        } else if (this.isBiggerThan(PrimitiveType.getByName(firstOpReg.getType().toString()), destRegType)) {
            this.destinationReg = this.regAlloc.asTmpReg(firstOpReg.getType());
        }
        if (this.destinationReg.getNumber() == firstOpReg.getNumber()) {
            this.stmtV.addInsn(this.build2AddrBinaryInsn(binaryOperation, secondOpReg), this.origStmt);
        } else {
            this.stmtV.addInsn(this.buildNormalBinaryInsn(binaryOperation, firstOpReg, secondOpReg), this.origStmt);
        }
        if (orgDestReg != this.destinationReg) {
            Register tempReg = this.destinationReg.clone();
            this.destinationReg = orgDestReg.clone();
            this.castPrimitive(tempReg, originalExpr, this.destinationReg.getType());
        }
    }

    private String fixIntTypeString(String typeString) {
        if (typeString.equals("boolean") || typeString.equals("byte") || typeString.equals("char") || typeString.equals("short")) {
            return "int";
        }
        return typeString;
    }

    private Insn build2AddrBinaryInsn(String binaryOperation, Register secondOpReg) {
        String localTypeString = this.destinationReg.getTypeString();
        localTypeString = this.fixIntTypeString(localTypeString);
        Opcode opc = Opcode.valueOf((String)(binaryOperation + "_" + localTypeString.toUpperCase() + "_2ADDR"));
        return new Insn12x(opc, this.destinationReg, secondOpReg);
    }

    private Insn buildNormalBinaryInsn(String binaryOperation, Register firstOpReg, Register secondOpReg) {
        String localTypeString = firstOpReg.getTypeString();
        localTypeString = this.fixIntTypeString(localTypeString);
        Opcode opc = Opcode.valueOf((String)(binaryOperation + "_" + localTypeString.toUpperCase()));
        return new Insn23x(opc, this.destinationReg, firstOpReg, secondOpReg);
    }

    private Insn buildLit16BinaryInsn(String binaryOperation, Register firstOpReg, short secondOpLieteral) {
        Opcode opc = Opcode.valueOf((String)(binaryOperation + "_INT_LIT16"));
        return new Insn22s(opc, this.destinationReg, firstOpReg, secondOpLieteral);
    }

    private Insn buildLit8BinaryInsn(String binaryOperation, Register firstOpReg, byte secondOpLiteral) {
        Opcode opc = Opcode.valueOf((String)(binaryOperation + "_INT_LIT8"));
        return new Insn22b(opc, this.destinationReg, firstOpReg, secondOpLiteral);
    }

    @Override
    public void caseAddExpr(AddExpr ae) {
        this.buildCalculatingBinaryInsn("ADD", ae.getOp1(), ae.getOp2(), ae);
    }

    @Override
    public void caseSubExpr(SubExpr se) {
        this.buildCalculatingBinaryInsn("SUB", se.getOp1(), se.getOp2(), se);
    }

    @Override
    public void caseMulExpr(MulExpr me) {
        this.buildCalculatingBinaryInsn("MUL", me.getOp1(), me.getOp2(), me);
    }

    @Override
    public void caseDivExpr(DivExpr de) {
        this.buildCalculatingBinaryInsn("DIV", de.getOp1(), de.getOp2(), de);
    }

    @Override
    public void caseRemExpr(RemExpr re) {
        this.buildCalculatingBinaryInsn("REM", re.getOp1(), re.getOp2(), re);
    }

    @Override
    public void caseAndExpr(AndExpr ae) {
        this.buildCalculatingBinaryInsn("AND", ae.getOp1(), ae.getOp2(), ae);
    }

    @Override
    public void caseOrExpr(OrExpr oe) {
        this.buildCalculatingBinaryInsn("OR", oe.getOp1(), oe.getOp2(), oe);
    }

    @Override
    public void caseXorExpr(XorExpr xe) {
        Value firstOperand = xe.getOp1();
        Value secondOperand = xe.getOp2();
        this.constantV.setOrigStmt(this.origStmt);
        if (secondOperand.equals(IntConstant.v(-1)) || secondOperand.equals(LongConstant.v(-1L))) {
            Register sourceReg;
            PrimitiveType destRegType = PrimitiveType.getByName(this.destinationReg.getType().toString());
            Register orgDestReg = this.destinationReg;
            if (this.isBiggerThan(PrimitiveType.getByName(secondOperand.getType().toString()), destRegType)) {
                this.destinationReg = this.regAlloc.asTmpReg(IntType.v());
            }
            if (secondOperand.equals(IntConstant.v(-1))) {
                sourceReg = this.regAlloc.asImmediate(firstOperand, this.constantV);
                this.stmtV.addInsn(new Insn12x(Opcode.NOT_INT, this.destinationReg, sourceReg), this.origStmt);
            } else if (secondOperand.equals(LongConstant.v(-1L))) {
                sourceReg = this.regAlloc.asImmediate(firstOperand, this.constantV);
                this.stmtV.addInsn(new Insn12x(Opcode.NOT_LONG, this.destinationReg, sourceReg), this.origStmt);
            }
            if (orgDestReg != this.destinationReg) {
                Register tempReg = this.destinationReg.clone();
                this.destinationReg = orgDestReg.clone();
                this.castPrimitive(tempReg, secondOperand, this.destinationReg.getType());
            }
        } else {
            this.buildCalculatingBinaryInsn("XOR", firstOperand, secondOperand, xe);
        }
    }

    @Override
    public void caseShlExpr(ShlExpr sle) {
        this.buildCalculatingBinaryInsn("SHL", sle.getOp1(), sle.getOp2(), sle);
    }

    @Override
    public void caseShrExpr(ShrExpr sre) {
        this.buildCalculatingBinaryInsn("SHR", sre.getOp1(), sre.getOp2(), sre);
    }

    @Override
    public void caseUshrExpr(UshrExpr usre) {
        this.buildCalculatingBinaryInsn("USHR", usre.getOp1(), usre.getOp2(), usre);
    }

    private Insn buildComparingBinaryInsn(String binaryOperation, Value firstOperand, Value secondOperand) {
        InsnWithOffset comparingBinaryInsn;
        boolean secondOpIsZero;
        this.constantV.setOrigStmt(this.origStmt);
        Value realFirstOperand = this.fixNullConstant(firstOperand);
        Value realSecondOperand = this.fixNullConstant(secondOperand);
        Register firstOpReg = this.regAlloc.asImmediate(realFirstOperand, this.constantV);
        String opcodeName = "IF_" + binaryOperation;
        boolean secondOpIsInt = realSecondOperand instanceof IntConstant;
        boolean bl = secondOpIsZero = secondOpIsInt && ((IntConstant)realSecondOperand).value == 0;
        if (secondOpIsZero) {
            Opcode opc = Opcode.valueOf((String)opcodeName.concat("Z"));
            comparingBinaryInsn = new Insn21t(opc, firstOpReg);
            comparingBinaryInsn.setTarget(this.targetForOffset);
        } else {
            Opcode opc = Opcode.valueOf((String)opcodeName);
            Register secondOpReg = this.regAlloc.asImmediate(realSecondOperand, this.constantV);
            comparingBinaryInsn = new Insn22t(opc, firstOpReg, secondOpReg);
            comparingBinaryInsn.setTarget(this.targetForOffset);
        }
        return comparingBinaryInsn;
    }

    private Value fixNullConstant(Value potentialNullConstant) {
        if (potentialNullConstant instanceof NullConstant) {
            return IntConstant.v(0);
        }
        return potentialNullConstant;
    }

    @Override
    public void caseEqExpr(EqExpr ee) {
        this.stmtV.addInsn(this.buildComparingBinaryInsn("EQ", ee.getOp1(), ee.getOp2()), this.origStmt);
    }

    @Override
    public void caseGeExpr(GeExpr ge) {
        this.stmtV.addInsn(this.buildComparingBinaryInsn("GE", ge.getOp1(), ge.getOp2()), this.origStmt);
    }

    @Override
    public void caseGtExpr(GtExpr ge) {
        this.stmtV.addInsn(this.buildComparingBinaryInsn("GT", ge.getOp1(), ge.getOp2()), this.origStmt);
    }

    @Override
    public void caseLeExpr(LeExpr le) {
        this.stmtV.addInsn(this.buildComparingBinaryInsn("LE", le.getOp1(), le.getOp2()), this.origStmt);
    }

    @Override
    public void caseLtExpr(LtExpr le) {
        this.stmtV.addInsn(this.buildComparingBinaryInsn("LT", le.getOp1(), le.getOp2()), this.origStmt);
    }

    @Override
    public void caseNeExpr(NeExpr ne) {
        this.stmtV.addInsn(this.buildComparingBinaryInsn("NE", ne.getOp1(), ne.getOp2()), this.origStmt);
    }

    @Override
    public void caseCmpExpr(CmpExpr v) {
        this.stmtV.addInsn(this.buildCmpInsn("CMP_LONG", v.getOp1(), v.getOp2()), this.origStmt);
    }

    @Override
    public void caseCmpgExpr(CmpgExpr v) {
        this.stmtV.addInsn(this.buildCmpInsn("CMPG", v.getOp1(), v.getOp2()), this.origStmt);
    }

    @Override
    public void caseCmplExpr(CmplExpr v) {
        this.stmtV.addInsn(this.buildCmpInsn("CMPL", v.getOp1(), v.getOp2()), this.origStmt);
    }

    private Insn buildCmpInsn(String opcodePrefix, Value firstOperand, Value secondOperand) {
        this.constantV.setOrigStmt(this.origStmt);
        Register firstReg = this.regAlloc.asImmediate(firstOperand, this.constantV);
        Register secondReg = this.regAlloc.asImmediate(secondOperand, this.constantV);
        Opcode opc = null;
        if (opcodePrefix.equals("CMP_LONG")) {
            opc = Opcode.CMP_LONG;
        } else if (firstReg.isFloat()) {
            opc = Opcode.valueOf((String)(opcodePrefix + "_FLOAT"));
        } else if (firstReg.isDouble()) {
            opc = Opcode.valueOf((String)(opcodePrefix + "_DOUBLE"));
        } else {
            throw new RuntimeException("unsupported type of operands for cmp* opcode: " + firstOperand.getType());
        }
        return new Insn23x(opc, this.destinationReg, firstReg, secondReg);
    }

    @Override
    public void caseLengthExpr(LengthExpr le) {
        Value array = le.getOp();
        this.constantV.setOrigStmt(this.origStmt);
        Register arrayReg = this.regAlloc.asImmediate(array, this.constantV);
        this.stmtV.addInsn(new Insn12x(Opcode.ARRAY_LENGTH, this.destinationReg, arrayReg), this.origStmt);
    }

    @Override
    public void caseNegExpr(NegExpr ne) {
        Opcode opc;
        Value source = ne.getOp();
        this.constantV.setOrigStmt(this.origStmt);
        Register sourceReg = this.regAlloc.asImmediate(source, this.constantV);
        Type type = source.getType();
        if (type instanceof IntegerType) {
            opc = Opcode.NEG_INT;
        } else if (type instanceof FloatType) {
            opc = Opcode.NEG_FLOAT;
        } else if (type instanceof DoubleType) {
            opc = Opcode.NEG_DOUBLE;
        } else if (type instanceof LongType) {
            opc = Opcode.NEG_LONG;
        } else {
            throw new RuntimeException("unsupported value type for neg-* opcode: " + type);
        }
        this.stmtV.addInsn(new Insn12x(opc, this.destinationReg, sourceReg), this.origStmt);
    }

    @Override
    public void caseInstanceOfExpr(InstanceOfExpr ioe) {
        Value referenceToCheck = ioe.getOp();
        this.constantV.setOrigStmt(this.origStmt);
        Register referenceToCheckReg = this.regAlloc.asImmediate(referenceToCheck, this.constantV);
        TypeReference checkType = DexPrinter.toTypeReference(ioe.getCheckType());
        this.stmtV.addInsn(new Insn22c(Opcode.INSTANCE_OF, this.destinationReg, referenceToCheckReg, (Reference)checkType), this.origStmt);
    }

    @Override
    public void caseCastExpr(CastExpr ce) {
        Type castType = ce.getCastType();
        Value source = ce.getOp();
        this.constantV.setOrigStmt(this.origStmt);
        Register sourceReg = this.regAlloc.asImmediate(source, this.constantV);
        if (SootToDexUtils.isObject(castType)) {
            this.castObject(sourceReg, castType);
        } else {
            this.castPrimitive(sourceReg, source, castType);
        }
    }

    protected void castObject(Register sourceReg, Type castType) {
        TypeReference castTypeItem = DexPrinter.toTypeReference(castType);
        if (sourceReg.getNumber() == this.destinationReg.getNumber()) {
            this.stmtV.addInsn(new Insn21c(Opcode.CHECK_CAST, this.destinationReg, (Reference)castTypeItem), this.origStmt);
        } else {
            Register tmp = this.regAlloc.asTmpReg(sourceReg.getType());
            this.stmtV.addInsn(StmtVisitor.buildMoveInsn(tmp, sourceReg), this.origStmt);
            this.stmtV.addInsn(new Insn21c(Opcode.CHECK_CAST, tmp.clone(), (Reference)castTypeItem), this.origStmt);
            this.stmtV.addInsn(StmtVisitor.buildMoveInsn(this.destinationReg, tmp.clone()), this.origStmt);
        }
    }

    private void castPrimitive(Register sourceReg, Value source, Type castSootType) {
        Type srcType;
        PrimitiveType castType = PrimitiveType.getByName(castSootType.toString());
        if (castType == PrimitiveType.INT && source.getType() instanceof NullType) {
            source = IntConstant.v(0);
        }
        if ((srcType = source.getType()) instanceof RefType) {
            throw new RuntimeException("Trying to cast reference type " + srcType + " to a primitive");
        }
        PrimitiveType sourceType = PrimitiveType.getByName(srcType.toString());
        if (castType == PrimitiveType.BOOLEAN) {
            castType = PrimitiveType.INT;
            sourceType = PrimitiveType.INT;
        }
        if (this.shouldCastFromInt(sourceType, castType)) {
            sourceType = PrimitiveType.INT;
            Opcode opc = this.getCastOpc(sourceType, castType);
            this.stmtV.addInsn(new Insn12x(opc, this.destinationReg, sourceReg), this.origStmt);
        } else if (this.isMoveCompatible(sourceType, castType)) {
            if (this.destinationReg.getNumber() != sourceReg.getNumber()) {
                this.stmtV.addInsn(StmtVisitor.buildMoveInsn(this.destinationReg, sourceReg), this.origStmt);
            } else if (!this.origStmt.getBoxesPointingToThis().isEmpty()) {
                this.stmtV.addInsn(new Insn10x(Opcode.NOP), this.origStmt);
            }
        } else if (this.needsCastThroughInt(sourceType, castType)) {
            Opcode castToIntOpc = this.getCastOpc(sourceType, PrimitiveType.INT);
            Opcode castFromIntOpc = this.getCastOpc(PrimitiveType.INT, castType);
            Register tmp = this.regAlloc.asTmpReg(IntType.v());
            this.stmtV.addInsn(new Insn12x(castToIntOpc, tmp, sourceReg), this.origStmt);
            this.stmtV.addInsn(new Insn12x(castFromIntOpc, this.destinationReg, tmp.clone()), this.origStmt);
        } else {
            Opcode opc = this.getCastOpc(sourceType, castType);
            this.stmtV.addInsn(new Insn12x(opc, this.destinationReg, sourceReg), this.origStmt);
        }
    }

    private boolean needsCastThroughInt(PrimitiveType sourceType, PrimitiveType castType) {
        return this.isEqualOrBigger(sourceType, PrimitiveType.LONG) && !this.isEqualOrBigger(castType, PrimitiveType.INT);
    }

    private boolean isMoveCompatible(PrimitiveType sourceType, PrimitiveType castType) {
        if (sourceType == castType) {
            return true;
        }
        return castType == PrimitiveType.INT && !this.isBiggerThan(sourceType, PrimitiveType.INT);
    }

    private boolean shouldCastFromInt(PrimitiveType sourceType, PrimitiveType castType) {
        if (this.isEqualOrBigger(sourceType, PrimitiveType.INT)) {
            return false;
        }
        return castType != PrimitiveType.INT;
    }

    private boolean isEqualOrBigger(PrimitiveType type, PrimitiveType relativeTo) {
        return type.compareTo(relativeTo) >= 0;
    }

    private boolean isBiggerThan(PrimitiveType type, PrimitiveType relativeTo) {
        return type.compareTo(relativeTo) > 0;
    }

    private boolean isSmallerThan(PrimitiveType type, PrimitiveType relativeTo) {
        return type.compareTo(relativeTo) < 0;
    }

    private Opcode getCastOpc(PrimitiveType sourceType, PrimitiveType castType) {
        Opcode opc = Opcode.valueOf((String)(sourceType.getName().toUpperCase() + "_TO_" + castType.getName().toUpperCase()));
        if (opc == null) {
            throw new RuntimeException("unsupported cast from " + (Object)((Object)sourceType) + " to " + (Object)((Object)castType));
        }
        return opc;
    }

    @Override
    public void caseNewArrayExpr(NewArrayExpr nae) {
        Value size = nae.getSize();
        this.constantV.setOrigStmt(this.origStmt);
        Register sizeReg = this.regAlloc.asImmediate(size, this.constantV);
        Type baseType = nae.getBaseType();
        int numDimensions = 1;
        while (baseType instanceof ArrayType) {
            ArrayType at = (ArrayType)baseType;
            baseType = at.getElementType();
            ++numDimensions;
        }
        ArrayType arrayType = ArrayType.v(baseType, numDimensions);
        TypeReference arrayTypeItem = DexPrinter.toTypeReference(arrayType);
        this.stmtV.addInsn(new Insn22c(Opcode.NEW_ARRAY, this.destinationReg, sizeReg, (Reference)arrayTypeItem), this.origStmt);
    }

    @Override
    public void caseNewMultiArrayExpr(NewMultiArrayExpr nmae) {
        this.constantV.setOrigStmt(this.origStmt);
        if (nmae.getSizeCount() > 255) {
            throw new RuntimeException("number of dimensions is too high (> 255) for the filled-new-array* opcodes: " + nmae.getSizeCount());
        }
        int dimensions = nmae.getSizeCount();
        ArrayType arrayType = ArrayType.v(nmae.getBaseType().baseType, dimensions);
        TypeReference arrayTypeItem = DexPrinter.toTypeReference(arrayType);
        ArrayList<Register> dimensionSizeRegs = new ArrayList<Register>();
        for (int i = 0; i < dimensions; ++i) {
            Value currentDimensionSize = nmae.getSize(i);
            Register currentReg = this.regAlloc.asImmediate(currentDimensionSize, this.constantV);
            dimensionSizeRegs.add(currentReg);
        }
        if (dimensions <= 5) {
            Register[] paddedRegs = this.pad35cRegs(dimensionSizeRegs);
            this.stmtV.addInsn(new Insn35c(Opcode.FILLED_NEW_ARRAY, dimensions, paddedRegs[0], paddedRegs[1], paddedRegs[2], paddedRegs[3], paddedRegs[4], (Reference)arrayTypeItem), null);
        } else {
            this.stmtV.addInsn(new Insn3rc(Opcode.FILLED_NEW_ARRAY_RANGE, dimensionSizeRegs, (short)dimensions, (Reference)arrayTypeItem), null);
        }
        this.stmtV.addInsn(new Insn11x(Opcode.MOVE_RESULT_OBJECT, this.destinationReg), this.origStmt);
    }

    @Override
    public void caseNewExpr(NewExpr ne) {
        TypeReference baseType = DexPrinter.toTypeReference(ne.getBaseType());
        this.stmtV.addInsn(new Insn21c(Opcode.NEW_INSTANCE, this.destinationReg, (Reference)baseType), this.origStmt);
    }

    public int getLastInvokeInstructionPosition() {
        return this.lastInvokeInstructionPosition;
    }
}

