/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex.instructions;

import java.util.BitSet;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.instruction.BuilderInstruction11n;
import soot.toDex.LabelAssigner;
import soot.toDex.Register;
import soot.toDex.instructions.AbstractInsn;
import soot.toDex.instructions.OneRegInsn;

public class Insn11n
extends AbstractInsn
implements OneRegInsn {
    private byte litB;

    public Insn11n(Opcode opc, Register regA, byte litB) {
        super(opc);
        this.regs.add(regA);
        this.litB = litB;
    }

    @Override
    public Register getRegA() {
        return (Register)this.regs.get(0);
    }

    public byte getLitB() {
        return this.litB;
    }

    @Override
    protected BuilderInstruction getRealInsn0(LabelAssigner assigner) {
        return new BuilderInstruction11n(this.opc, (int)((byte)this.getRegA().getNumber()), (int)this.getLitB());
    }

    @Override
    public BitSet getIncompatibleRegs() {
        BitSet incompatRegs = new BitSet(1);
        if (!this.getRegA().fitsByte()) {
            incompatRegs.set(0);
        }
        return incompatRegs;
    }

    @Override
    public String toString() {
        return super.toString() + " lit: " + this.getLitB();
    }
}

