/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.exceptions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import soot.BodyTransformer;
import soot.Unit;
import soot.Value;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.MonitorStmt;
import soot.toolkits.graph.UnitGraph;
import soot.util.HashMultiMap;

public abstract class TrapTransformer
extends BodyTransformer {
    public Set<Unit> getUnitsWithMonitor(UnitGraph ug) {
        HashMultiMap<Unit, Value> unitMonitors = new HashMultiMap<Unit, Value>();
        ArrayList<Unit> workList = new ArrayList<Unit>();
        HashSet<Unit> doneSet = new HashSet<Unit>();
        for (Unit head : ug.getHeads()) {
            workList.add(head);
        }
        while (!workList.isEmpty()) {
            MonitorStmt ems;
            Unit curUnit = (Unit)workList.remove(0);
            boolean hasChanged = false;
            Value exitValue = null;
            if (curUnit instanceof EnterMonitorStmt) {
                ems = (EnterMonitorStmt)curUnit;
                hasChanged = unitMonitors.put(curUnit, ems.getOp());
            } else if (curUnit instanceof ExitMonitorStmt) {
                ems = (ExitMonitorStmt)curUnit;
                exitValue = ems.getOp();
            }
            for (Unit pred : ug.getPredsOf(curUnit)) {
                for (Value v : unitMonitors.get(pred)) {
                    if (v == exitValue || !unitMonitors.put(curUnit, v)) continue;
                    hasChanged = true;
                }
            }
            if (!doneSet.add(curUnit) && !hasChanged) continue;
            workList.addAll(ug.getSuccsOf(curUnit));
        }
        return unitMonitors.keySet();
    }
}

