/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.CollectionFlowUniverse;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

class SimpleDominatorsAnalysis<N>
extends ForwardFlowAnalysis<N, FlowSet<N>> {
    private final BoundedFlowSet<N> emptySet;
    private final BoundedFlowSet<N> fullSet;

    SimpleDominatorsAnalysis(DirectedGraph<N> graph) {
        super(graph);
        ArrayList<N> nodes = new ArrayList<N>(graph.size());
        for (N n : graph) {
            nodes.add(n);
        }
        this.emptySet = new ArrayPackedSet(new CollectionFlowUniverse(nodes));
        this.fullSet = (BoundedFlowSet)this.emptySet.clone();
        this.fullSet.complement();
        this.doAnalysis();
    }

    @Override
    protected FlowSet<N> newInitialFlow() {
        return this.fullSet.clone();
    }

    @Override
    protected FlowSet<N> entryInitialFlow() {
        Object initSet = this.emptySet.clone();
        for (Object h : this.graph.getHeads()) {
            initSet.add(h);
        }
        return initSet;
    }

    @Override
    protected void flowThrough(FlowSet<N> in, N block, FlowSet<N> out) {
        in.copy(out);
        out.add(block);
    }

    @Override
    protected void merge(FlowSet<N> in1, FlowSet<N> in2, FlowSet<N> out) {
        in1.intersection(in2, out);
    }

    @Override
    protected void mergeInto(N block, FlowSet<N> inout, FlowSet<N> in) {
        inout.intersection(in);
    }

    @Override
    protected void copy(FlowSet<N> source, FlowSet<N> dest) {
        source.copy(dest);
    }
}

