/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.HashMap;
import java.util.Map;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.toolkits.graph.MHGDominatorsFinder;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

class GuaranteedDefsAnalysis
extends ForwardFlowAnalysis<Unit, FlowSet<Value>> {
    private static final FlowSet<Value> EMPTY_SET = new ArraySparseSet<Value>();
    private final Map<Unit, FlowSet<Value>> unitToGenerateSet;

    GuaranteedDefsAnalysis(UnitGraph graph) {
        super(graph);
        this.unitToGenerateSet = new HashMap<Unit, FlowSet<Value>>(graph.size() * 2 + 1, 0.7f);
        MHGDominatorsFinder<Unit> df = new MHGDominatorsFinder<Unit>(graph);
        for (Unit s : graph) {
            FlowSet<Value> genSet = EMPTY_SET.clone();
            for (Unit dom : df.getDominators(s)) {
                for (ValueBox box : dom.getDefBoxes()) {
                    Value val = box.getValue();
                    if (!(val instanceof Local)) continue;
                    genSet.add(val, genSet);
                }
            }
            this.unitToGenerateSet.put(s, genSet);
        }
        this.doAnalysis();
    }

    @Override
    protected FlowSet<Value> newInitialFlow() {
        return EMPTY_SET.clone();
    }

    @Override
    protected FlowSet<Value> entryInitialFlow() {
        return EMPTY_SET.clone();
    }

    @Override
    protected void flowThrough(FlowSet<Value> in, Unit unit, FlowSet<Value> out) {
        in.union(this.unitToGenerateSet.get(unit), out);
    }

    @Override
    protected void merge(FlowSet<Value> in1, FlowSet<Value> in2, FlowSet<Value> out) {
        in1.intersection(in2, out);
    }

    @Override
    protected void copy(FlowSet<Value> source, FlowSet<Value> dest) {
        source.copy(dest);
    }
}

