/*
 * Decompiled with CFR 0.152.
 */
package soot.util.dot;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import soot.util.dot.DotGraphAttribute;
import soot.util.dot.DotGraphUtility;

public abstract class AbstractDotGraphElement {
    private LinkedHashMap<String, DotGraphAttribute> attributes;

    public void setAttribute(String id, String value) {
        this.setAttribute(new DotGraphAttribute(id, value));
    }

    public void setAttribute(DotGraphAttribute attr) {
        LinkedHashMap<String, DotGraphAttribute> attrs = this.attributes;
        if (attrs == null) {
            this.attributes = attrs = new LinkedHashMap();
        }
        attrs.put(attr.getID(), attr);
    }

    public Collection<DotGraphAttribute> getAttributes() {
        LinkedHashMap<String, DotGraphAttribute> attrs = this.attributes;
        return attrs == null ? Collections.emptyList() : Collections.unmodifiableCollection(attrs.values());
    }

    public DotGraphAttribute getAttribute(String id) {
        LinkedHashMap<String, DotGraphAttribute> attrs = this.attributes;
        return attrs == null ? null : attrs.get(id);
    }

    public String getAttributeValue(String id) {
        DotGraphAttribute attr = this.getAttribute(id);
        return attr == null ? null : attr.getValue();
    }

    public void removeAttribute(String id) {
        LinkedHashMap<String, DotGraphAttribute> attrs = this.attributes;
        if (attrs != null) {
            attrs.remove(id);
        }
    }

    public void removeAttribute(DotGraphAttribute attr) {
        LinkedHashMap<String, DotGraphAttribute> attrs = this.attributes;
        if (attrs != null) {
            attrs.remove(attr.getID(), attr);
        }
    }

    public void removeAllAttributes() {
        this.attributes = null;
    }

    public void setLabel(String label) {
        label = DotGraphUtility.replaceQuotes(label);
        label = DotGraphUtility.replaceReturns(label);
        this.setAttribute("label", "\"" + label + "\"");
    }

    public String getLabel() {
        return this.getAttributeValue("label");
    }
}

