/*
 * Decompiled with CFR 0.152.
 */
package soot.validation;

import java.util.List;
import soot.Body;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum CheckEscapingValidator implements BodyValidator
{
    INSTANCE;


    public static CheckEscapingValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        for (Unit u : body.getUnits()) {
            Stmt stmt;
            if (!(u instanceof Stmt) || !(stmt = (Stmt)u).containsInvokeExpr()) continue;
            InvokeExpr iexpr = stmt.getInvokeExpr();
            SootMethodRef ref = iexpr.getMethodRef();
            if (ref.name().contains("'") || ref.declaringClass().getName().contains("'")) {
                exception.add(new ValidationException(stmt, "Escaped name found in signature"));
            }
            for (Type paramType : ref.parameterTypes()) {
                if (!paramType.toString().contains("'")) continue;
                exception.add(new ValidationException(stmt, "Escaped name found in signature"));
            }
        }
    }

    @Override
    public boolean isBasicValidator() {
        return false;
    }
}

