/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import soot.ArrayType;
import soot.UnitPrinter;
import soot.baf.InstSwitch;
import soot.baf.NewMultiArrayInst;
import soot.baf.internal.AbstractInst;
import soot.util.Switch;

public class BNewMultiArrayInst
extends AbstractInst
implements NewMultiArrayInst {
    int dimensionCount;
    ArrayType baseType;

    public BNewMultiArrayInst(ArrayType opType, int dimensionCount) {
        this.dimensionCount = dimensionCount;
        this.baseType = opType;
    }

    @Override
    public Object clone() {
        return new BNewMultiArrayInst(this.getBaseType(), this.getDimensionCount());
    }

    @Override
    public int getInCount() {
        return this.dimensionCount;
    }

    @Override
    public int getOutCount() {
        return 1;
    }

    @Override
    public int getInMachineCount() {
        return this.dimensionCount;
    }

    @Override
    public int getOutMachineCount() {
        return 1;
    }

    @Override
    public final String getName() {
        return "newmultiarray";
    }

    @Override
    final String getParameters() {
        return " " + this.dimensionCount;
    }

    @Override
    protected void getParameters(UnitPrinter up) {
        up.literal(" ");
        up.literal(Integer.toString(this.dimensionCount));
    }

    @Override
    public ArrayType getBaseType() {
        return this.baseType;
    }

    @Override
    public void setBaseType(ArrayType type) {
        this.baseType = type;
    }

    @Override
    public int getDimensionCount() {
        return this.dimensionCount;
    }

    @Override
    public void setDimensionCount(int x) {
        this.dimensionCount = x;
    }

    @Override
    public void apply(Switch sw) {
        ((InstSwitch)sw).caseNewMultiArrayInst(this);
    }

    @Override
    public boolean containsNewExpr() {
        return true;
    }
}

