/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import soot.Body;
import soot.Local;
import soot.Value;
import soot.dotnet.exceptions.NoStatementInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.dotnet.types.DotnetTypeFactory;
import soot.jimple.AssignStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;

public class CilIsInstInstruction
extends AbstractCilnstruction {
    public CilIsInstInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        throw new NoStatementInstructionException(this.instruction);
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        String type = this.instruction.getType().getFullname();
        CilInstruction cilExpr = CilInstructionFactory.fromInstructionMsg(this.instruction.getArgument(), this.dotnetBody, this.cilBlock);
        Value argument = cilExpr.jimplifyExpr(jb);
        return Jimple.v().newInstanceOfExpr(argument, DotnetTypeFactory.toSootType(type));
    }

    public void resolveRewritingIsInst(Body jb, Local variable, Value instanceOfExpr) {
        Local local = this.dotnetBody.variableManager.localGenerator.generateLocal(DotnetTypeFactory.toSootType("System.Boolean"));
        AssignStmt assignInstanceOfStmt = Jimple.v().newAssignStmt(local, instanceOfExpr);
        NopStmt nopStmt = Jimple.v().newNopStmt();
        AssignStmt assignIfTrueStmt = Jimple.v().newAssignStmt(variable, ((InstanceOfExpr)instanceOfExpr).getOp());
        AssignStmt assignIfFalseStmt = Jimple.v().newAssignStmt(variable, NullConstant.v());
        IfStmt ifStmt = Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr(local, IntConstant.v(1)), assignIfTrueStmt);
        GotoStmt gotoStmt = Jimple.v().newGotoStmt(nopStmt);
        jb.getUnits().add(assignInstanceOfStmt);
        jb.getUnits().add(ifStmt);
        jb.getUnits().add(assignIfFalseStmt);
        jb.getUnits().add(gotoStmt);
        jb.getUnits().add(assignIfTrueStmt);
        jb.getUnits().add(nopStmt);
        this.dotnetBody.variableManager.addLocalsToCast(variable.getName());
    }
}

