/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.bafTransformations;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.baf.Baf;
import soot.baf.TableSwitchInst;
import soot.baf.ThrowInst;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.bafTransformations.StackTypeHeightCalculator;
import soot.jbco.util.BodyBuilder;
import soot.jbco.util.Rand;
import soot.jbco.util.ThrowSet;
import soot.util.Chain;

public class WrapSwitchesInTrys
extends BodyTransformer
implements IJbcoTransform {
    int totaltraps = 0;
    public static String[] dependancies = new String[]{"bb.jbco_ptss", "bb.jbco_ful", "bb.lp"};
    public static String name = "bb.jbco_ptss";

    @Override
    public String[] getDependencies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void outputSummary() {
        out.println("Switches wrapped in Tries: " + this.totaltraps);
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        int weight = Main.getWeight(phaseName, b.getMethod().getSignature());
        if (weight == 0) {
            return;
        }
        int i = 0;
        Unit handler = null;
        Chain<Trap> traps = b.getTraps();
        UnitPatchingChain units = b.getUnits();
        Iterator it = units.snapshotIterator();
        while (it.hasNext()) {
            TableSwitchInst o;
            TableSwitchInst twi;
            Unit u = (Unit)it.next();
            if (!(u instanceof TableSwitchInst) || BodyBuilder.isExceptionCaughtAt(units, twi = (TableSwitchInst)u, traps.iterator()) || Rand.getInt(10) > weight) continue;
            if (handler == null) {
                Iterator uit = units.snapshotIterator();
                while (uit.hasNext()) {
                    Unit uthrow = (Unit)uit.next();
                    if (!(uthrow instanceof ThrowInst) || BodyBuilder.isExceptionCaughtAt(units, uthrow, traps.iterator())) continue;
                    handler = uthrow;
                    break;
                }
                if (handler == null) {
                    handler = Baf.v().newThrowInst();
                    units.add(handler);
                }
            }
            int size = 4;
            Unit succ = units.getSuccOf(twi);
            while (!BodyBuilder.isExceptionCaughtAt(units, succ, traps.iterator()) && size-- > 0 && (o = units.getSuccOf(succ)) != null) {
                succ = o;
            }
            traps.add(Baf.v().newTrap(ThrowSet.getRandomThrowable(), twi, succ, handler));
            ++i;
        }
        this.totaltraps += i;
        if (i > 0 && debug) {
            StackTypeHeightCalculator.calculateStackHeights(b);
        }
    }
}

