/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.DoubleType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.util.Rand;
import soot.jimple.AssignStmt;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.Expr;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;
import soot.jimple.MulExpr;
import soot.jimple.NumericConstant;
import soot.util.Chain;

public class ArithmeticTransformer
extends BodyTransformer
implements IJbcoTransform {
    private static int mulPerformed = 0;
    private static int divPerformed = 0;
    private static int total = 0;
    public static String[] dependancies = new String[]{"jtp.jbco_cae2bo"};
    public static String name = "jtp.jbco_cae2bo";

    @Override
    public String[] getDependencies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        int weight = Main.getWeight(phaseName, b.getMethod().getSignature());
        if (weight == 0) {
            return;
        }
        UnitPatchingChain units = b.getUnits();
        int localCount = 0;
        Chain<Local> locals = b.getLocals();
        if (output) {
            out.println("*** Performing Arithmetic Transformation on " + b.getMethod().getSignature());
        }
        Iterator it = units.snapshotIterator();
        while (it.hasNext()) {
            Object[] shft_rem;
            Unit u = (Unit)it.next();
            if (!(u instanceof AssignStmt)) continue;
            AssignStmt as = (AssignStmt)u;
            Value v = as.getRightOp();
            if (v instanceof MulExpr) {
                Expr e;
                Object[] shft_rem2;
                Type opType;
                int max;
                ++total;
                MulExpr me = (MulExpr)v;
                Value op1 = me.getOp1();
                Value op = null;
                Value op2 = me.getOp2();
                NumericConstant nc = null;
                if (op1 instanceof NumericConstant) {
                    nc = (NumericConstant)op1;
                    op = op2;
                } else if (op2 instanceof NumericConstant) {
                    nc = (NumericConstant)op2;
                    op = op1;
                }
                if (nc == null) continue;
                if (output) {
                    out.println("Considering: " + as + "\r");
                }
                if ((max = (opType = op.getType()) instanceof IntType ? 32 : (opType instanceof LongType ? 64 : 0)) == 0 || (shft_rem2 = this.checkNumericValue(nc))[0] == null || (Integer)shft_rem2[0] >= max || Rand.getInt(10) > weight) continue;
                ArrayList<Unit> unitsBuilt = new ArrayList<Unit>();
                int rand = Rand.getInt(16);
                int shift = (Integer)shft_rem2[0];
                boolean neg = (Boolean)shft_rem2[2];
                shift = rand % 2 == 0 ? (shift += rand * max) : (shift -= rand * max);
                if (shft_rem2[1] != null) {
                    Value tmp2 = null;
                    Local tmp1 = Jimple.v().newLocal("__tmp_shft_lcl" + localCount++, opType);
                    locals.add(tmp1);
                    AssignStmt newU = Jimple.v().newAssignStmt(tmp1, Jimple.v().newShlExpr(op, IntConstant.v(shift)));
                    unitsBuilt.add(newU);
                    units.insertBefore(newU, u);
                    double rem = (Double)shft_rem2[1];
                    if (rem != 1.0) {
                        nc = rem == (double)((int)rem) && opType instanceof IntType ? IntConstant.v((int)rem) : (rem == (double)((long)rem) && opType instanceof LongType ? LongConstant.v((long)rem) : DoubleConstant.v(rem));
                        if (nc instanceof DoubleConstant) {
                            tmp2 = Jimple.v().newLocal("__tmp_shft_lcl" + localCount++, DoubleType.v());
                            locals.add((Local)tmp2);
                            newU = Jimple.v().newAssignStmt(tmp2, Jimple.v().newCastExpr(op, DoubleType.v()));
                            unitsBuilt.add(newU);
                            units.insertBefore(newU, u);
                            newU = Jimple.v().newAssignStmt(tmp2, Jimple.v().newMulExpr(tmp2, nc));
                        } else {
                            tmp2 = Jimple.v().newLocal("__tmp_shft_lcl" + localCount++, nc.getType());
                            locals.add((Local)tmp2);
                            newU = Jimple.v().newAssignStmt(tmp2, Jimple.v().newMulExpr(op, nc));
                        }
                        unitsBuilt.add(newU);
                        units.insertBefore(newU, u);
                    }
                    if (tmp2 == null) {
                        e = Jimple.v().newAddExpr(tmp1, op);
                    } else if (tmp2.getType().getClass() != tmp1.getType().getClass()) {
                        Local tmp3 = Jimple.v().newLocal("__tmp_shft_lcl" + localCount++, tmp2.getType());
                        locals.add(tmp3);
                        newU = Jimple.v().newAssignStmt(tmp3, Jimple.v().newCastExpr(tmp1, tmp2.getType()));
                        unitsBuilt.add(newU);
                        units.insertBefore(newU, u);
                        e = Jimple.v().newAddExpr(tmp3, tmp2);
                    } else {
                        e = Jimple.v().newAddExpr(tmp1, tmp2);
                    }
                } else {
                    e = Jimple.v().newShlExpr(op, IntConstant.v(shift));
                }
                if (e.getType().getClass() != as.getLeftOp().getType().getClass()) {
                    Local tmp = Jimple.v().newLocal("__tmp_shft_lcl" + localCount++, e.getType());
                    locals.add(tmp);
                    AssignStmt newU = Jimple.v().newAssignStmt(tmp, e);
                    unitsBuilt.add(newU);
                    units.insertAfter(newU, u);
                    e = Jimple.v().newCastExpr(tmp, as.getLeftOp().getType());
                }
                as.setRightOp(e);
                unitsBuilt.add(as);
                if (neg) {
                    AssignStmt newU = Jimple.v().newAssignStmt(as.getLeftOp(), Jimple.v().newNegExpr(as.getLeftOp()));
                    unitsBuilt.add(newU);
                    units.insertAfter(newU, u);
                }
                ++mulPerformed;
                this.printOutput(unitsBuilt);
                continue;
            }
            if (!(v instanceof DivExpr)) continue;
            ++total;
            DivExpr de = (DivExpr)v;
            Value op2 = de.getOp2();
            if (!(op2 instanceof NumericConstant)) continue;
            NumericConstant nc = (NumericConstant)op2;
            Type opType = de.getOp1().getType();
            int max = opType instanceof IntType ? 32 : (opType instanceof LongType ? 64 : 0);
            if (max == 0 || (shft_rem = this.checkNumericValue(nc))[0] == null || shft_rem[1] != null && (Double)shft_rem[1] != 0.0 || (Integer)shft_rem[0] >= max || Rand.getInt(10) > weight) continue;
            ArrayList<Unit> unitsBuilt = new ArrayList<Unit>();
            int rand = Rand.getInt(16);
            int shift = (Integer)shft_rem[0];
            boolean neg = (Boolean)shft_rem[2];
            shift = Rand.getInt() % 2 == 0 ? (shift += rand * max) : (shift -= rand * max);
            Expr e = Jimple.v().newShrExpr(de.getOp1(), IntConstant.v(shift));
            if (e.getType().getClass() != as.getLeftOp().getType().getClass()) {
                Local tmp = Jimple.v().newLocal("__tmp_shft_lcl" + localCount++, e.getType());
                locals.add(tmp);
                AssignStmt newU = Jimple.v().newAssignStmt(tmp, e);
                unitsBuilt.add(newU);
                units.insertAfter(newU, u);
                e = Jimple.v().newCastExpr(tmp, as.getLeftOp().getType());
            }
            as.setRightOp(e);
            unitsBuilt.add(as);
            if (neg) {
                AssignStmt newU = Jimple.v().newAssignStmt(as.getLeftOp(), Jimple.v().newNegExpr(as.getLeftOp()));
                unitsBuilt.add(newU);
                units.insertAfter(newU, u);
            }
            ++divPerformed;
            this.printOutput(unitsBuilt);
        }
    }

    private void printOutput(List<Unit> unitsBuilt) {
        if (!output) {
            return;
        }
        out.println(" after as: ");
        for (Unit uu : unitsBuilt) {
            out.println("\t" + uu + "\ttype : " + (uu instanceof AssignStmt ? ((AssignStmt)uu).getLeftOp().getType().toString() : ""));
        }
    }

    @Override
    public void outputSummary() {
        if (!output) {
            return;
        }
        out.println("Replaced mul/div expressions: " + (divPerformed + mulPerformed));
        out.println("Total mul/div expressions: " + total);
    }

    private Object[] checkNumericValue(NumericConstant nc) {
        Double dnc = null;
        if (nc instanceof IntConstant) {
            dnc = ((IntConstant)nc).value;
        } else if (nc instanceof DoubleConstant) {
            dnc = ((DoubleConstant)nc).value;
        } else if (nc instanceof FloatConstant) {
            dnc = ((FloatConstant)nc).value;
        } else if (nc instanceof LongConstant) {
            dnc = ((LongConstant)nc).value;
        }
        Object[] shift = new Object[3];
        if (dnc != null) {
            shift[2] = dnc < 0.0;
            double[] tmp = this.checkShiftValue(dnc);
            if (tmp[0] != 0.0) {
                shift[0] = (int)tmp[0];
                shift[1] = tmp[1] != 0.0 ? Double.valueOf(tmp[1]) : null;
            } else {
                dnc = null;
            }
        }
        if (dnc == null) {
            shift[0] = null;
            shift[1] = null;
        }
        return shift;
    }

    private double[] checkShiftValue(double val) {
        double[] shift = new double[2];
        if (val == 0.0 || val == 1.0 || val == -1.0) {
            shift[0] = 0.0;
            shift[1] = 0.0;
        } else {
            double shift_int;
            double shift_dbl = Math.log(val) / Math.log(2.0);
            if (shift_dbl == (shift_int = Math.rint(shift_dbl))) {
                shift[1] = 0.0;
            } else {
                if (Math.pow(2.0, shift_int) > val) {
                    shift_int -= 1.0;
                }
                shift[1] = val - Math.pow(2.0, shift_int);
            }
            shift[0] = shift_int;
        }
        return shift;
    }
}

