/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Body;
import soot.FastHierarchy;
import soot.G;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.name.JunkNameGenerator;
import soot.jbco.name.NameGenerator;
import soot.jbco.util.BodyBuilder;
import soot.jimple.CastExpr;
import soot.jimple.ClassConstant;
import soot.jimple.Expr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.Ref;
import soot.tagkit.SourceFileTag;

public class ClassRenamer
extends SceneTransformer
implements IJbcoTransform {
    private static final Logger logger = LoggerFactory.getLogger(ClassRenamer.class);
    private boolean removePackages = false;
    private boolean renamePackages = false;
    public static final String name = "wjtp.jbco_cr";
    private final Map<String, String> oldToNewPackageNames = new HashMap<String, String>();
    private final Map<String, String> oldToNewClassNames = new HashMap<String, String>();
    private final Map<String, SootClass> newNameToClass = new HashMap<String, SootClass>();
    private final Object classNamesMapLock = new Object();
    private final Object packageNamesMapLock = new Object();
    private final NameGenerator nameGenerator;

    public ClassRenamer(Singletons.Global global) {
        if (global == null) {
            throw new NullPointerException("Cannot instantiate ClassRenamer with null Singletons.Global");
        }
        this.nameGenerator = new JunkNameGenerator();
    }

    public static ClassRenamer v() {
        return G.v().soot_jbco_jimpleTransformations_ClassRenamer();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String[] getDependencies() {
        return new String[]{name};
    }

    @Override
    public void outputSummary() {
        StringBuilder stringBuilder = new StringBuilder("ClassName mapping:").append(System.lineSeparator());
        this.oldToNewClassNames.forEach((oldName, newName) -> stringBuilder.append((String)oldName).append(" -> ").append((String)newName).append(System.lineSeparator()));
        logger.info(stringBuilder.toString());
    }

    public boolean isRemovePackages() {
        return this.removePackages;
    }

    public void setRemovePackages(boolean removePackages) {
        this.removePackages = removePackages;
    }

    public boolean isRenamePackages() {
        return this.renamePackages;
    }

    public void setRenamePackages(boolean renamePackages) {
        this.renamePackages = renamePackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassNameMapping(String classNameSource, String classNameTarget) {
        Object object = this.classNamesMapLock;
        synchronized (object) {
            if (!(this.oldToNewClassNames.containsKey(classNameSource) || this.oldToNewClassNames.containsValue(classNameTarget) || BodyBuilder.nameList.contains(classNameTarget))) {
                this.oldToNewClassNames.put(classNameSource, classNameTarget);
                BodyBuilder.nameList.add(classNameTarget);
                return;
            }
        }
        throw new IllegalStateException("Cannot generate unique name: too long for JVM.");
    }

    public Map<String, String> getClassNameMapping(BiPredicate<String, String> predicate) {
        if (predicate == null) {
            return new HashMap<String, String>(this.oldToNewClassNames);
        }
        return this.oldToNewClassNames.entrySet().stream().filter(entry -> predicate.test((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        if (this.isVerbose()) {
            logger.info("Transforming Class Names...");
        }
        BodyBuilder.retrieveAllBodies();
        BodyBuilder.retrieveAllNames();
        SootClass mainClass = ClassRenamer.getMainClassSafely();
        for (SootClass applicationClass : Scene.v().getApplicationClasses()) {
            String fullyQualifiedName = applicationClass.getName();
            if (applicationClass.equals(mainClass) || this.oldToNewClassNames.containsValue(fullyQualifiedName) || Main.getWeight(phaseName, fullyQualifiedName) == 0) continue;
            String newClassName = this.getOrAddNewName(ClassRenamer.getPackageName(fullyQualifiedName), ClassRenamer.getClassName(fullyQualifiedName));
            applicationClass.setName(newClassName);
            RefType crt = RefType.v(newClassName);
            crt.setSootClass(applicationClass);
            applicationClass.setRefType(crt);
            applicationClass.setResolvingLevel(3);
            SourceFileTag sourceFileTag = (SourceFileTag)applicationClass.getTag("SourceFileTag");
            if (sourceFileTag == null) {
                logger.info("Adding SourceFileTag for class {}", (Object)fullyQualifiedName);
                sourceFileTag = new SourceFileTag();
                applicationClass.addTag(sourceFileTag);
            }
            sourceFileTag.setSourceFile(newClassName);
            this.newNameToClass.put(newClassName, applicationClass);
            if (!this.isVerbose()) continue;
            logger.info("Renaming {} to {}", (Object)fullyQualifiedName, (Object)newClassName);
        }
        Scene.v().releaseActiveHierarchy();
        Scene.v().setFastHierarchy(new FastHierarchy());
        if (this.isVerbose()) {
            logger.info("Updating bytecode class references");
        }
        for (SootClass sootClass : Scene.v().getApplicationClasses()) {
            for (SootMethod sootMethod : sootClass.getMethods()) {
                Body aBody;
                if (!sootMethod.isConcrete()) continue;
                if (this.isVerbose()) {
                    logger.info(sootMethod.getSignature());
                }
                try {
                    aBody = sootMethod.getActiveBody();
                }
                catch (Exception e) {
                    continue;
                }
                for (Unit u : aBody.getUnits()) {
                    for (ValueBox vb : u.getUseAndDefBoxes()) {
                        Value v = vb.getValue();
                        if (v instanceof ClassConstant) {
                            ClassConstant constant = (ClassConstant)v;
                            RefType type = (RefType)constant.toSootType();
                            RefType updatedType = type.getSootClass().getType();
                            vb.setValue(ClassConstant.fromType(updatedType));
                            continue;
                        }
                        if (v instanceof Expr) {
                            if (v instanceof CastExpr) {
                                CastExpr castExpr = (CastExpr)v;
                                this.updateType(castExpr.getCastType());
                                continue;
                            }
                            if (!(v instanceof InstanceOfExpr)) continue;
                            InstanceOfExpr instanceOfExpr = (InstanceOfExpr)v;
                            this.updateType(instanceOfExpr.getCheckType());
                            continue;
                        }
                        if (!(v instanceof Ref)) continue;
                        this.updateType(v.getType());
                    }
                }
            }
        }
        Scene.v().releaseActiveHierarchy();
        Scene.v().setFastHierarchy(new FastHierarchy());
    }

    private void updateType(Type type) {
        if (type instanceof RefType) {
            RefType rt = (RefType)type;
            if (!rt.getSootClass().isLibraryClass() && this.oldToNewClassNames.containsKey(rt.getClassName())) {
                rt.setSootClass(this.newNameToClass.get(this.oldToNewClassNames.get(rt.getClassName())));
                rt.setClassName(this.oldToNewClassNames.get(rt.getClassName()));
            }
        } else if (type instanceof ArrayType) {
            RefType rt;
            ArrayType at = (ArrayType)type;
            if (at.baseType instanceof RefType && !(rt = (RefType)at.baseType).getSootClass().isLibraryClass() && this.oldToNewClassNames.containsKey(rt.getClassName())) {
                rt.setSootClass(this.newNameToClass.get(this.oldToNewClassNames.get(rt.getClassName())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOrAddNewName(String packageName, String className) {
        int size = 5;
        int tries = 0;
        String newFqn = "";
        if (className != null) {
            String string = this.removePackages ? className : (newFqn = packageName == null ? className : packageName + '.' + className);
            if (this.oldToNewClassNames.containsKey(newFqn)) {
                return this.oldToNewClassNames.get(newFqn);
            }
        }
        Object object = this.classNamesMapLock;
        synchronized (object) {
            if (this.oldToNewClassNames.containsKey(newFqn)) {
                return this.oldToNewClassNames.get(newFqn);
            }
            while (newFqn.length() < 21845) {
                String oldFqn;
                String name;
                newFqn = name = this.nameGenerator.generateName(size);
                if (!this.removePackages) {
                    String newPackage = this.renamePackages ? this.getOrAddNewPackageName(packageName) : packageName;
                    String string = newFqn = newPackage == null ? name : newPackage + '.' + name;
                }
                if (!(this.oldToNewClassNames.containsKey(oldFqn = className == null ? newFqn : (packageName == null ? "" : packageName + '.') + className) || this.oldToNewClassNames.containsValue(newFqn) || BodyBuilder.nameList.contains(newFqn))) {
                    this.addClassNameMapping(oldFqn, newFqn);
                    return newFqn;
                }
                if (tries++ <= size) continue;
                ++size;
                tries = 0;
            }
        }
        throw new IllegalStateException("Cannot generate unique package name part: too long for JVM.");
    }

    public static String getPackageName(String fullyQualifiedClassName) {
        if (fullyQualifiedClassName == null || fullyQualifiedClassName.isEmpty()) {
            return null;
        }
        int idx = fullyQualifiedClassName.lastIndexOf(46);
        return idx >= 1 ? fullyQualifiedClassName.substring(0, idx) : null;
    }

    public static String getClassName(String fullyQualifiedClassName) {
        if (fullyQualifiedClassName == null || fullyQualifiedClassName.isEmpty()) {
            return null;
        }
        int idx = fullyQualifiedClassName.lastIndexOf(46);
        if (idx < 0) {
            return fullyQualifiedClassName;
        }
        return idx < fullyQualifiedClassName.length() - 1 ? fullyQualifiedClassName.substring(idx + 1) : null;
    }

    private static SootClass getMainClassSafely() {
        if (Scene.v().hasMainClass()) {
            return Scene.v().getMainClass();
        }
        return null;
    }

    private String getOrAddNewPackageName(String packageName) {
        if (packageName == null || packageName.isEmpty()) {
            return this.getNewPackageNamePart("");
        }
        String[] packageNameParts = packageName.split("\\.");
        StringBuilder newPackageName = new StringBuilder((int)((double)(5 * (packageNameParts.length + 1)) * 1.5));
        for (int i = 0; i < packageNameParts.length; ++i) {
            newPackageName.append(this.getNewPackageNamePart(packageNameParts[i]));
            if (i >= packageNameParts.length - 1) continue;
            newPackageName.append('.');
        }
        return newPackageName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNewPackageNamePart(String oldPackageNamePart) {
        if (oldPackageNamePart != null && this.oldToNewPackageNames.containsKey(oldPackageNamePart)) {
            return this.oldToNewPackageNames.get(oldPackageNamePart);
        }
        int size = 5;
        int tries = 0;
        String newPackageNamePart = "";
        while (newPackageNamePart.length() < 21845) {
            Object object = this.packageNamesMapLock;
            synchronized (object) {
                if (this.oldToNewPackageNames.containsValue(newPackageNamePart)) {
                    return this.oldToNewPackageNames.get(newPackageNamePart);
                }
                newPackageNamePart = this.nameGenerator.generateName(size);
                if (!this.oldToNewPackageNames.containsValue(newPackageNamePart)) {
                    String key = oldPackageNamePart == null ? newPackageNamePart : oldPackageNamePart;
                    this.oldToNewPackageNames.put(key, newPackageNamePart);
                    return newPackageNamePart;
                }
            }
            if (tries++ <= size) continue;
            ++size;
            tries = 0;
        }
        throw new IllegalStateException("Cannot generate unique package name part: too long for JVM.");
    }
}

