/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.G;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.jimple.IdentityStmt;
import soot.tagkit.LineNumberTag;

public class LineNumberAdder
extends SceneTransformer {
    public LineNumberAdder(Singletons.Global g) {
    }

    public static LineNumberAdder v() {
        return G.v().soot_jimple_toolkits_annotation_LineNumberAdder();
    }

    @Override
    public void internalTransform(String phaseName, Map<String, String> opts) {
        Iterator<SootClass> it = Scene.v().getApplicationClasses().snapshotIterator();
        while (it.hasNext()) {
            LineNumberTag tag;
            Unit s;
            UnitPatchingChain units;
            SootClass sc = it.next();
            HashMap<Integer, SootMethod> lineToMeth = new HashMap<Integer, SootMethod>();
            for (SootMethod meth : new ArrayList<SootMethod>(sc.getMethods())) {
                if (!meth.isConcrete()) continue;
                units = meth.retrieveActiveBody().getUnits();
                s = (Unit)units.getFirst();
                while (s instanceof IdentityStmt) {
                    s = units.getSuccOf(s);
                }
                tag = (LineNumberTag)s.getTag("LineNumberTag");
                if (tag == null) continue;
                lineToMeth.put(tag.getLineNumber(), meth);
            }
            for (SootMethod meth : sc.getMethods()) {
                if (!meth.isConcrete()) continue;
                units = meth.retrieveActiveBody().getUnits();
                s = (Unit)units.getFirst();
                while (s instanceof IdentityStmt) {
                    s = units.getSuccOf(s);
                }
                tag = (LineNumberTag)s.getTag("LineNumberTag");
                if (tag == null) continue;
                int line_num = tag.getLineNumber() - 1;
                if (lineToMeth.containsKey(line_num)) {
                    meth.addTag(new LineNumberTag(line_num + 1));
                    continue;
                }
                meth.addTag(new LineNumberTag(line_num));
            }
        }
    }
}

