/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.ArrayType;
import soot.Body;
import soot.BodyTransformer;
import soot.FastHierarchy;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Trap;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.toolkits.base.ExceptionCheckerError;
import soot.jimple.toolkits.base.ExceptionCheckerErrorReporter;
import soot.tagkit.SourceLnPosTag;
import soot.util.NumberedString;

public class ExceptionChecker
extends BodyTransformer {
    protected final ExceptionCheckerErrorReporter reporter;
    protected FastHierarchy hierarchy;

    public ExceptionChecker(ExceptionCheckerErrorReporter r) {
        this.reporter = r;
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        for (Unit u : b.getUnits()) {
            Value rightOp;
            Stmt s = (Stmt)u;
            if (s instanceof ThrowStmt) {
                this.checkThrow(b, (ThrowStmt)s);
                continue;
            }
            if (s instanceof InvokeStmt) {
                this.checkInvoke(b, (InvokeStmt)s);
                continue;
            }
            if (!(s instanceof AssignStmt) || !((rightOp = ((AssignStmt)s).getRightOp()) instanceof InvokeExpr)) continue;
            this.checkInvokeExpr(b, (InvokeExpr)rightOp, s);
        }
    }

    protected void checkThrow(Body b, ThrowStmt ts) {
        RefType opType = (RefType)ts.getOp().getType();
        if (this.isThrowDeclared(b, opType.getSootClass()) || this.isThrowFromCompiler(ts) || this.isExceptionCaught(b, ts, opType)) {
            return;
        }
        if (this.reporter != null) {
            this.reporter.reportError(new ExceptionCheckerError(b.getMethod(), opType.getSootClass(), ts, (SourceLnPosTag)ts.getOpBox().getTag("SourceLnPosTag")));
        }
    }

    protected boolean isThrowDeclared(Body b, SootClass throwClass) {
        if (this.hierarchy == null) {
            this.hierarchy = new FastHierarchy();
        }
        SootClass sootClassRuntimeException = Scene.v().getSootClass("java.lang.RuntimeException");
        SootClass sootClassError = Scene.v().getSootClass("java.lang.Error");
        if (throwClass.equals(sootClassRuntimeException) || throwClass.equals(sootClassError) || this.hierarchy.isSubclass(throwClass, sootClassRuntimeException) || this.hierarchy.isSubclass(throwClass, sootClassError)) {
            return true;
        }
        if (b.getMethod().throwsException(throwClass)) {
            return true;
        }
        List<SootClass> exceptions = b.getMethod().getExceptionsUnsafe();
        if (exceptions != null) {
            for (SootClass nextEx : exceptions) {
                if (!this.hierarchy.isSubclass(throwClass, nextEx)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isThrowFromCompiler(ThrowStmt ts) {
        return ts.hasTag("ThrowCreatedByCompilerTag");
    }

    protected boolean isExceptionCaught(Body b, Stmt s, RefType throwType) {
        if (this.hierarchy == null) {
            this.hierarchy = new FastHierarchy();
        }
        for (Trap trap : b.getTraps()) {
            RefType type = trap.getException().getType();
            if (!type.equals(throwType) && !this.hierarchy.isSubclass(throwType.getSootClass(), type.getSootClass()) || !this.isThrowInStmtRange(b, (Stmt)trap.getBeginUnit(), (Stmt)trap.getEndUnit(), s)) continue;
            return true;
        }
        return false;
    }

    protected boolean isThrowInStmtRange(Body b, Stmt begin, Stmt end, Stmt s) {
        Iterator<Stmt> it = b.getUnits().iterator(begin, end);
        while (it.hasNext()) {
            Unit u = it.next();
            if (!u.equals(s)) continue;
            return true;
        }
        return false;
    }

    protected void checkInvoke(Body b, InvokeStmt is) {
        this.checkInvokeExpr(b, is.getInvokeExpr(), is);
    }

    private List<SootClass> getExceptionSpec(SootClass intrface, NumberedString sig) {
        SootMethod sm = intrface.getMethodUnsafe(sig);
        if (sm != null) {
            return sm.getExceptions();
        }
        sm = Scene.v().getSootClass(Scene.v().getObjectType().toString()).getMethodUnsafe(sig);
        if (sm != null && sm.getExceptionsUnsafe() == null) {
            return Collections.emptyList();
        }
        List<SootClass> result = sm == null ? null : new ArrayList<SootClass>(sm.getExceptions());
        for (SootClass suprintr : intrface.getInterfaces()) {
            List<SootClass> other = this.getExceptionSpec(suprintr, sig);
            if (other == null) continue;
            if (result == null) {
                result = other;
                continue;
            }
            result.retainAll(other);
        }
        return result;
    }

    protected void checkInvokeExpr(Body b, InvokeExpr ie, Stmt s) {
        List<SootClass> exceptions;
        SootMethodRef methodRef = ie.getMethodRef();
        if ("clone".equals(methodRef.name()) && methodRef.parameterTypes().isEmpty() && ie instanceof InstanceInvokeExpr && ((InstanceInvokeExpr)ie).getBase().getType() instanceof ArrayType) {
            return;
        }
        List<SootClass> list = exceptions = ie instanceof InterfaceInvokeExpr ? this.getExceptionSpec(methodRef.declaringClass(), methodRef.getSubSignature()) : ie.getMethod().getExceptionsUnsafe();
        if (exceptions != null) {
            for (SootClass sc : exceptions) {
                if (this.isThrowDeclared(b, sc) || this.isExceptionCaught(b, s, sc.getType()) || this.reporter == null) continue;
                if (s instanceof InvokeStmt) {
                    this.reporter.reportError(new ExceptionCheckerError(b.getMethod(), sc, s, (SourceLnPosTag)s.getTag("SourceLnPosTag")));
                    continue;
                }
                if (!(s instanceof AssignStmt)) continue;
                this.reporter.reportError(new ExceptionCheckerError(b.getMethod(), sc, s, (SourceLnPosTag)((AssignStmt)s).getRightOpBox().getTag("SourceLnPosTag")));
            }
        }
    }
}

