/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import soot.IdentityUnit;
import soot.Local;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.shimple.PhiExpr;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.shimple.ShimpleFactory;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BlockGraph;
import soot.toolkits.graph.DominanceFrontier;
import soot.toolkits.graph.DominatorNode;
import soot.toolkits.graph.DominatorTree;
import soot.toolkits.scalar.ValueUnitPair;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class PhiNodeManager {
    protected final ShimpleBody body;
    protected final ShimpleFactory sf;
    protected BlockGraph cfg;
    protected MultiMap<Local, Block> varToBlocks;
    protected Map<Unit, Block> unitToBlock;

    public PhiNodeManager(ShimpleBody body, ShimpleFactory sf) {
        this.body = body;
        this.sf = sf;
    }

    public void update() {
        BlockGraph oldCfg = this.cfg;
        this.cfg = this.sf.getBlockGraph();
        if (oldCfg != this.cfg) {
            this.unitToBlock = null;
            this.varToBlocks = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean insertTrivialPhiNodes() {
        this.update();
        this.varToBlocks = new HashMultiMap<Local, Block>();
        LinkedHashMap localsToDefPoints = new LinkedHashMap();
        for (Block block : this.cfg) {
            for (Unit unit : block) {
                for (ValueBox vb : unit.getDefBoxes()) {
                    void var10_12;
                    Value def = vb.getValue();
                    if (!(def instanceof Local)) continue;
                    Local local = (Local)def;
                    List list = (List)localsToDefPoints.get(local);
                    if (list == null) {
                        ArrayList arrayList = new ArrayList();
                        localsToDefPoints.put(local, arrayList);
                    }
                    var10_12.add(block);
                }
                if (!Shimple.isPhiNode(unit)) continue;
                this.varToBlocks.put(Shimple.getLhsLocal(unit), block);
            }
        }
        boolean change = false;
        DominatorTree<Block> dt = this.sf.getDominatorTree();
        DominanceFrontier<Block> df = this.sf.getDominanceFrontier();
        int iterCount = 0;
        int[] workFlags = new int[this.cfg.size()];
        Stack<Block> workList = new Stack<Block>();
        HashMap<Integer, Integer> has_already = new HashMap<Integer, Integer>();
        for (Block block : this.cfg) {
            has_already.put(block.getIndexInMethod(), 0);
        }
        for (Map.Entry entry : localsToDefPoints.entrySet()) {
            ++iterCount;
            assert (workList.isEmpty());
            List def_points = (List)entry.getValue();
            if (def_points.size() == 1) continue;
            for (Block block : def_points) {
                workFlags[block.getIndexInMethod()] = iterCount;
                workList.push(block);
            }
            Local local = (Local)entry.getKey();
            while (!workList.empty()) {
                Block block = (Block)workList.pop();
                for (DominatorNode<Block> dn : df.getDominanceFrontierOf(dt.getDode(block))) {
                    int fBIndex;
                    Block frontierBlock = dn.getGode();
                    if (!frontierBlock.iterator().hasNext() || (Integer)has_already.get(fBIndex = frontierBlock.getIndexInMethod()) >= iterCount) continue;
                    has_already.put(fBIndex, iterCount);
                    this.prependTrivialPhiNode(local, frontierBlock);
                    change = true;
                    if (workFlags[fBIndex] >= iterCount) continue;
                    workFlags[fBIndex] = iterCount;
                    workList.push(frontierBlock);
                }
            }
        }
        return change;
    }

    public void prependTrivialPhiNode(Local local, Block frontierBlock) {
        PhiExpr pe = Shimple.v().newPhiExpr(local, frontierBlock.getPreds());
        pe.setBlockId(frontierBlock.getIndexInMethod());
        AssignStmt trivialPhi = Jimple.v().newAssignStmt(local, pe);
        Unit head = frontierBlock.getHead();
        if (head instanceof IdentityUnit) {
            frontierBlock.insertAfter(trivialPhi, head);
        } else {
            frontierBlock.insertBefore(trivialPhi, head);
        }
        this.varToBlocks.put(local, frontierBlock);
    }

    public void trimExceptionalPhiNodes() {
        HashSet<Unit> handlerUnits = new HashSet<Unit>();
        for (Trap trap : this.body.getTraps()) {
            handlerUnits.add(trap.getHandlerUnit());
        }
        for (Block block : this.cfg) {
            if (!handlerUnits.contains(block.getHead())) continue;
            for (Unit unit : block) {
                PhiExpr phi = Shimple.getPhiExpr(unit);
                if (phi == null) continue;
                this.trimPhiNode(phi);
            }
        }
    }

    public void trimPhiNode(PhiExpr phiExpr) {
        HashMultiMap<Value, ValueUnitPair> valueToPairs = new HashMultiMap<Value, ValueUnitPair>();
        for (ValueUnitPair argPair : phiExpr.getArgs()) {
            valueToPairs.put(argPair.getValue(), argPair);
        }
        block1: for (Value value : valueToPairs.keySet()) {
            Set pairsSet = valueToPairs.get(value);
            LinkedList champs = new LinkedList(pairsSet);
            LinkedList challengers = new LinkedList(pairsSet);
            ValueUnitPair champ = (ValueUnitPair)champs.remove(0);
            Unit champU = champ.getUnit();
            boolean retry = true;
            while (retry) {
                retry = false;
                Iterator itr = challengers.iterator();
                while (itr.hasNext()) {
                    ValueUnitPair challenger = (ValueUnitPair)itr.next();
                    if (challenger.equals(champ)) continue;
                    Unit challengerU = challenger.getUnit();
                    if (this.dominates(champU, challengerU)) {
                        phiExpr.removeArg(challenger);
                        itr.remove();
                        continue;
                    }
                    if (this.dominates(challengerU, champU)) {
                        phiExpr.removeArg(champ);
                        champ = challenger;
                        champU = champ.getUnit();
                        continue;
                    }
                    retry = true;
                }
                if (!retry) continue;
                if (champs.isEmpty()) continue block1;
                champ = (ValueUnitPair)champs.remove(0);
                champU = champ.getUnit();
            }
        }
    }

    public boolean dominates(Unit champ, Unit challenger) {
        Block challengerBlock;
        Block champBlock;
        if (champ == null || challenger == null) {
            throw new RuntimeException("Assertion failed.");
        }
        if (champ.equals(challenger)) {
            return true;
        }
        Map<Unit, Block> unitToBlock = this.unitToBlock;
        if (unitToBlock == null) {
            this.unitToBlock = unitToBlock = PhiNodeManager.getUnitToBlockMap(this.cfg);
        }
        if ((champBlock = unitToBlock.get(champ)).equals(challengerBlock = unitToBlock.get(challenger))) {
            for (Unit unit : champBlock) {
                if (unit.equals(champ)) {
                    return true;
                }
                if (!unit.equals(challenger)) continue;
                return false;
            }
            throw new RuntimeException("Assertion failed.");
        }
        DominatorTree<Block> dt = this.sf.getDominatorTree();
        DominatorNode<Block> champNode = dt.getDode(champBlock);
        DominatorNode<Block> challengerNode = dt.getDode(challengerBlock);
        return dt.isDominatorOf(champNode, challengerNode);
    }

    public boolean doEliminatePhiNodes() {
        boolean addedNewLocals = false;
        ArrayList<Unit> phiNodes = new ArrayList<Unit>();
        ArrayList<AssignStmt> equivStmts = new ArrayList<AssignStmt>();
        ArrayList<ValueUnitPair> predBoxes = new ArrayList<ValueUnitPair>();
        Jimple jimp = Jimple.v();
        UnitPatchingChain units = this.body.getUnits();
        for (Unit unit : units) {
            PhiExpr phi = Shimple.getPhiExpr(unit);
            if (phi == null) continue;
            Local lhsLocal = Shimple.getLhsLocal(unit);
            for (ValueUnitPair vup : phi.getArgs()) {
                predBoxes.add(vup);
                equivStmts.add(jimp.newAssignStmt(lhsLocal, vup.getValue()));
            }
            phiNodes.add(unit);
        }
        if (equivStmts.size() != predBoxes.size()) {
            throw new RuntimeException("Assertion failed.");
        }
        ListIterator it = predBoxes.listIterator();
        while (it.hasNext()) {
            Unit pred = ((ValueUnitPair)it.next()).getUnit();
            if (pred == null) {
                throw new RuntimeException("Assertion failed.");
            }
            AssignStmt stmt = (AssignStmt)equivStmts.get(it.previousIndex());
            if (pred.branches()) {
                boolean needPriming = false;
                Local lhsLocal = (Local)stmt.getLeftOp();
                Local savedLocal = jimp.newLocal(lhsLocal.getName() + "_", lhsLocal.getType());
                for (ValueBox useBox : pred.getUseBoxes()) {
                    if (!lhsLocal.equals(useBox.getValue())) continue;
                    needPriming = true;
                    addedNewLocals = true;
                    useBox.setValue(savedLocal);
                }
                if (needPriming) {
                    this.body.getLocals().add(savedLocal);
                    units.insertBefore(jimp.newAssignStmt(savedLocal, lhsLocal), pred);
                }
                units.insertBefore(stmt, pred);
                continue;
            }
            units.insertAfter(stmt, pred);
        }
        for (Unit removeMe : phiNodes) {
            units.remove(removeMe);
            removeMe.clearUnitBoxes();
        }
        return addedNewLocals;
    }

    public static Map<Unit, Block> getUnitToBlockMap(BlockGraph blocks) {
        HashMap<Unit, Block> unitToBlock = new HashMap<Unit, Block>();
        for (Block block : blocks) {
            for (Unit unit : block) {
                unitToBlock.put(unit, block);
            }
        }
        return unitToBlock;
    }
}

