/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import soot.tagkit.AnnotationElem;
import soot.tagkit.Tag;

public class AnnotationTag
implements Tag {
    public static final String NAME = "AnnotationTag";
    private final String type;
    private List<AnnotationElem> elems;

    public AnnotationTag(String type) {
        this.type = type;
        this.elems = null;
    }

    public AnnotationTag(String type, Collection<AnnotationElem> elements) {
        this.type = type;
        this.elems = elements == null || elements.isEmpty() ? null : (elements instanceof List ? (List<Object>)elements : new ArrayList<AnnotationElem>(elements));
    }

    @Deprecated
    public AnnotationTag(String type, int numElem) {
        this.type = type;
        this.elems = new ArrayList<AnnotationElem>(numElem);
    }

    public String toString() {
        if (this.elems != null) {
            StringBuilder sb = new StringBuilder("Annotation: type: ");
            sb.append(this.type).append(" num elems: ").append(this.elems.size()).append(" elems: ");
            for (AnnotationElem next : this.elems) {
                sb.append('\n').append(next);
            }
            sb.append('\n');
            return sb.toString();
        }
        return "Annotation type: " + this.type + " without elements";
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getInfo() {
        return "Annotation";
    }

    public String getType() {
        return this.type;
    }

    @Override
    public byte[] getValue() {
        throw new RuntimeException("AnnotationTag has no value for bytecode");
    }

    public void addElem(AnnotationElem elem) {
        if (this.elems == null) {
            this.elems = new ArrayList<AnnotationElem>();
        }
        this.elems.add(elem);
    }

    public void setElems(List<AnnotationElem> list) {
        this.elems = list;
    }

    public Collection<AnnotationElem> getElems() {
        return this.elems == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.elems);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elems == null ? 0 : this.elems.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationTag other = (AnnotationTag)obj;
        if (this.elems == null ? other.elems != null : !this.elems.equals(other.elems)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

