/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import soot.coffi.CONSTANT_Utf8_info;
import soot.jimple.StringConstant;
import soot.tagkit.ConstantValueTag;

public class StringConstantValueTag
extends ConstantValueTag {
    public static final String NAME = "StringConstantValueTag";
    private final String value;

    public StringConstantValueTag(String value) {
        super(CONSTANT_Utf8_info.toUtf8(value));
        this.value = value;
    }

    public String getStringValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String toString() {
        return "ConstantValue: " + this.value;
    }

    @Override
    public StringConstant getConstant() {
        return StringConstant.v(this.value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        StringConstantValueTag other = (StringConstantValueTag)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

