/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.DominatorsFinder;
import soot.toolkits.graph.SimpleDominatorsAnalysis;
import soot.toolkits.scalar.FlowSet;

public class SimpleDominatorsFinder<N>
implements DominatorsFinder<N> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleDominatorsFinder.class);
    protected final DirectedGraph<N> graph;
    protected final Map<N, FlowSet<N>> nodeToDominators;

    public SimpleDominatorsFinder(DirectedGraph<N> graph) {
        this.graph = graph;
        this.nodeToDominators = new HashMap<N, FlowSet<N>>(graph.size() * 2 + 1, 0.7f);
        SimpleDominatorsAnalysis<N> analysis = new SimpleDominatorsAnalysis<N>(graph);
        for (N node : graph) {
            this.nodeToDominators.put(node, (FlowSet<N>)analysis.getFlowAfter(node));
        }
    }

    @Override
    public DirectedGraph<N> getGraph() {
        return this.graph;
    }

    @Override
    public List<N> getDominators(N node) {
        return this.nodeToDominators.get(node).toList();
    }

    @Override
    public N getImmediateDominator(N node) {
        if (this.getGraph().getHeads().contains(node)) {
            return null;
        }
        FlowSet<N> head = this.nodeToDominators.get(node).clone();
        head.remove(node);
        for (N dominator : head) {
            if (!this.nodeToDominators.get(dominator).isSubSet(head)) continue;
            return dominator;
        }
        return null;
    }

    @Override
    public boolean isDominatedBy(N node, N dominator) {
        return this.nodeToDominators.get(node).contains(dominator);
    }

    @Override
    public boolean isDominatedByAll(N node, Collection<N> dominators) {
        FlowSet<N> f = this.nodeToDominators.get(node);
        for (N n : dominators) {
            if (f.contains(n)) continue;
            return false;
        }
        return true;
    }
}

