/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.BackwardFlowAnalysis;
import soot.toolkits.scalar.CombinedAnalysis;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.UnitValueBoxPair;
import soot.util.Cons;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class CombinedDUAnalysis
extends BackwardFlowAnalysis<Unit, FlowSet<ValueBox>>
implements CombinedAnalysis {
    private static final Logger logger = LoggerFactory.getLogger(CombinedDUAnalysis.class);
    private final Map<Cons<Local, Unit>, List<Unit>> defsOfAt = new HashMap<Cons<Local, Unit>, List<Unit>>();
    private final Map<Unit, List<UnitValueBoxPair>> usesOf = new HashMap<Unit, List<UnitValueBoxPair>>();
    private final Map<Unit, List<Local>> liveLocalsBefore = new HashMap<Unit, List<Local>>();
    private final Map<Unit, List<Local>> liveLocalsAfter = new HashMap<Unit, List<Local>>();
    private final Map<ValueBox, Unit> useBoxToUnit = new HashMap<ValueBox, Unit>();
    private final Map<Unit, Local> unitToLocalDefed = new HashMap<Unit, Local>();
    private final Map<Unit, ArraySparseSet<ValueBox>> unitToLocalUseBoxes = new HashMap<Unit, ArraySparseSet<ValueBox>>();
    private final MultiMap<Value, ValueBox> localToUseBoxes = new HashMultiMap<Value, ValueBox>();

    @Override
    public List<Unit> getDefsOfAt(Local l, Unit s) {
        Cons<Local, Unit> cons = new Cons<Local, Unit>(l, s);
        List<Unit> ret = this.defsOfAt.get(cons);
        if (ret == null) {
            ret = new ArrayList<Unit>();
            this.defsOfAt.put(cons, ret);
        }
        return ret;
    }

    @Override
    public List<Unit> getDefsOf(Local l) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public List<UnitValueBoxPair> getUsesOf(Unit u) {
        List<UnitValueBoxPair> ret = this.usesOf.get(u);
        if (ret == null) {
            Local def = this.unitToLocalDefed.get(u);
            if (def == null) {
                ret = Collections.emptyList();
                this.usesOf.put(u, ret);
            } else {
                ret = new ArrayList<UnitValueBoxPair>();
                this.usesOf.put(u, ret);
                for (ValueBox vb : (FlowSet)this.getFlowAfter(u)) {
                    if (vb.getValue() != def) continue;
                    ret.add(new UnitValueBoxPair(this.useBoxToUnit.get(vb), vb));
                }
            }
        }
        return ret;
    }

    @Override
    public List<Local> getLiveLocalsBefore(Unit u) {
        List<Local> ret = this.liveLocalsBefore.get(u);
        if (ret == null) {
            HashSet<Local> hs = new HashSet<Local>();
            for (ValueBox vb : (FlowSet)this.getFlowBefore(u)) {
                hs.add((Local)vb.getValue());
            }
            ret = new ArrayList<Local>(hs);
            this.liveLocalsBefore.put(u, ret);
        }
        return ret;
    }

    @Override
    public List<Local> getLiveLocalsAfter(Unit u) {
        List<Local> ret = this.liveLocalsAfter.get(u);
        if (ret == null) {
            HashSet<Local> hs = new HashSet<Local>();
            for (ValueBox vb : (FlowSet)this.getFlowAfter(u)) {
                hs.add((Local)vb.getValue());
            }
            ret = new ArrayList<Local>(hs);
            this.liveLocalsAfter.put(u, ret);
        }
        return ret;
    }

    public CombinedDUAnalysis(UnitGraph graph) {
        super(graph);
        if (Options.v().verbose()) {
            logger.debug("[" + graph.getBody().getMethod().getName() + "]     Constructing CombinedDUAnalysis...");
        }
        for (Unit u : graph) {
            List<Value> defs = this.localsInBoxes(u.getDefBoxes());
            switch (defs.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.unitToLocalDefed.put(u, (Local)defs.get(0));
                    break;
                }
                default: {
                    throw new RuntimeException("Locals defed in " + u + ": " + defs.size());
                }
            }
            ArraySparseSet<ValueBox> localUseBoxes = new ArraySparseSet<ValueBox>();
            for (ValueBox vb : u.getUseBoxes()) {
                Value v = vb.getValue();
                if (!(v instanceof Local)) continue;
                localUseBoxes.add(vb);
                if (this.useBoxToUnit.containsKey(vb)) {
                    throw new RuntimeException("Aliased ValueBox " + vb + " in Unit " + u);
                }
                this.useBoxToUnit.put(vb, u);
                this.localToUseBoxes.put(v, vb);
            }
            this.unitToLocalUseBoxes.put(u, localUseBoxes);
        }
        this.doAnalysis();
        for (Unit defUnit : graph) {
            Local localDefed = this.unitToLocalDefed.get(defUnit);
            if (localDefed == null) continue;
            for (ValueBox vb : (FlowSet)this.getFlowAfter(defUnit)) {
                if (vb.getValue() != localDefed) continue;
                Unit useUnit = this.useBoxToUnit.get(vb);
                this.getDefsOfAt(localDefed, useUnit).add(defUnit);
            }
        }
        if (Options.v().verbose()) {
            logger.debug("[" + graph.getBody().getMethod().getName() + "]     Finished CombinedDUAnalysis...");
        }
    }

    private List<Value> localsInBoxes(List<ValueBox> boxes) {
        ArrayList<Value> ret = new ArrayList<Value>();
        for (ValueBox vb : boxes) {
            Value v = vb.getValue();
            if (!(v instanceof Local)) continue;
            ret.add(v);
        }
        return ret;
    }

    protected void merge(FlowSet<ValueBox> inout, FlowSet<ValueBox> in) {
        inout.union(in);
    }

    @Override
    protected void merge(FlowSet<ValueBox> in1, FlowSet<ValueBox> in2, FlowSet<ValueBox> out) {
        in1.union(in2, out);
    }

    @Override
    protected void flowThrough(FlowSet<ValueBox> out, Unit u, FlowSet<ValueBox> in) {
        Local def = this.unitToLocalDefed.get(u);
        out.copy(in);
        if (def != null) {
            Set<ValueBox> boxesDefed = this.localToUseBoxes.get(def);
            for (ValueBox vb : in) {
                if (!boxesDefed.contains(vb)) continue;
                in.remove(vb);
            }
        }
        in.union((FlowSet<ValueBox>)this.unitToLocalUseBoxes.get(u));
    }

    @Override
    protected FlowSet<ValueBox> entryInitialFlow() {
        return new ArraySparseSet<ValueBox>();
    }

    @Override
    protected FlowSet<ValueBox> newInitialFlow() {
        return new ArraySparseSet<ValueBox>();
    }

    @Override
    protected void copy(FlowSet<ValueBox> source, FlowSet<ValueBox> dest) {
        source.copy(dest);
    }
}

