/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import soot.baf.GotoInst;
import soot.jimple.GotoStmt;
import soot.options.Options;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.interaction.FlowInfo;
import soot.toolkits.graph.interaction.InteractionHandler;
import soot.toolkits.scalar.AbstractFlowAnalysis;
import soot.toolkits.scalar.FlowSet;
import soot.util.Numberable;
import soot.util.PriorityQueue;

public abstract class FlowAnalysis<N, A>
extends AbstractFlowAnalysis<N, A> {
    protected final Map<N, A> unitToAfterFlow;
    protected Map<N, A> filterUnitToAfterFlow;

    public FlowAnalysis(DirectedGraph<N> graph) {
        super(graph);
        this.unitToAfterFlow = new IdentityHashMap<N, A>(graph.size() * 2 + 1);
        this.filterUnitToAfterFlow = Collections.emptyMap();
    }

    protected abstract void flowThrough(A var1, N var2, A var3);

    public A getFlowAfter(N s) {
        A a = this.unitToAfterFlow.get(s);
        return a == null ? this.newInitialFlow() : a;
    }

    @Override
    public A getFlowBefore(N s) {
        Object a = this.unitToBeforeFlow.get(s);
        return (A)(a == null ? this.newInitialFlow() : a);
    }

    private void initFlow(Iterable<Entry<N, A>> universe, Map<N, A> in, Map<N, A> out) {
        assert (universe != null);
        assert (in != null);
        assert (out != null);
        for (Entry<N, A> n : universe) {
            boolean omit = true;
            if (n.in.length > 1) {
                n.inFlow = this.newInitialFlow();
                omit = !n.isRealStronglyConnected;
            } else {
                assert (n.in.length == 1) : "missing superhead";
                n.inFlow = this.getFlow(n.in[0], n);
                assert (n.inFlow != null) : "topological order is broken";
            }
            n.outFlow = omit && this.omissible(n.data) ? n.inFlow : this.newInitialFlow();
            in.put(n.data, n.inFlow);
            out.put(n.data, n.outFlow);
        }
    }

    protected boolean omissible(N n) {
        return false;
    }

    protected Flow getFlow(N from, N mergeNode) {
        return Flow.OUT;
    }

    private A getFlow(Entry<N, A> o, Entry<N, A> e) {
        return (A)(o.inFlow == o.outFlow ? o.outFlow : this.getFlow(o.data, e.data).getFlow(o));
    }

    private void meetFlows(Entry<N, A> e) {
        assert (e.in.length >= 1);
        if (e.in.length > 1) {
            boolean copy = true;
            for (Entry o : e.in) {
                Object flow = this.getFlow(o, e);
                if (copy) {
                    copy = false;
                    this.copy(flow, e.inFlow);
                    continue;
                }
                this.mergeInto(e.data, e.inFlow, flow);
            }
        }
    }

    final int doAnalysis(GraphView gv, InteractionFlowHandler ifh, Map<N, A> inFlow, Map<N, A> outFlow) {
        assert (gv != null);
        assert (ifh != null);
        ifh = Options.v().interactive_mode() ? ifh : InteractionFlowHandler.NONE;
        List<Entry<N, A>> universe = Orderer.INSTANCE.newUniverse(this.graph, gv, this.entryInitialFlow(), this.isForward());
        this.initFlow(universe, inFlow, outFlow);
        PriorityQueue<Entry<N, A>> q = PriorityQueue.of(universe, true);
        int numComputations = 0;
        Entry e;
        while ((e = (Entry)q.poll()) != null) {
            this.meetFlows(e);
            ifh.handleFlowIn(this, e.data);
            boolean hasChanged = this.flowThrough(e);
            ifh.handleFlowOut(this, e.data);
            if (hasChanged) {
                q.addAll(Arrays.asList(e.out));
            }
            ++numComputations;
        }
        return numComputations;
    }

    private boolean flowThrough(Entry<N, A> d) {
        if (d.inFlow == d.outFlow) {
            assert (!d.isRealStronglyConnected || d.in.length == 1);
            return true;
        }
        if (d.isRealStronglyConnected) {
            Object out = this.newInitialFlow();
            this.flowThrough(d.inFlow, d.data, out);
            if (out.equals(d.outFlow)) {
                return false;
            }
            this.copyFreshToExisting(out, d.outFlow);
            return true;
        }
        this.flowThrough(d.inFlow, d.data, d.outFlow);
        return true;
    }

    protected void copyFreshToExisting(A in, A dest) {
        if (in instanceof FlowSet && dest instanceof FlowSet) {
            FlowSet fin = (FlowSet)in;
            FlowSet fdest = (FlowSet)dest;
            fin.copyFreshToExisting(fdest);
        } else {
            this.copy(in, dest);
        }
    }

    static enum GraphView {
        BACKWARD{

            @Override
            <N> List<N> getEntries(DirectedGraph<N> g) {
                return g.getTails();
            }

            @Override
            <N> List<N> getOut(DirectedGraph<N> g, N s) {
                return g.getPredsOf(s);
            }
        }
        ,
        FORWARD{

            @Override
            <N> List<N> getEntries(DirectedGraph<N> g) {
                return g.getHeads();
            }

            @Override
            <N> List<N> getOut(DirectedGraph<N> g, N s) {
                return g.getSuccsOf(s);
            }
        };


        abstract <N> List<N> getEntries(DirectedGraph<N> var1);

        abstract <N> List<N> getOut(DirectedGraph<N> var1, N var2);
    }

    static enum InteractionFlowHandler {
        NONE,
        FORWARD{

            @Override
            public <A, N> void handleFlowIn(FlowAnalysis<N, A> a, N s) {
                this.beforeEvent(this.stop(s), a, s);
            }

            @Override
            public <A, N> void handleFlowOut(FlowAnalysis<N, A> a, N s) {
                this.afterEvent(InteractionHandler.v(), a, s);
            }
        }
        ,
        BACKWARD{

            @Override
            public <A, N> void handleFlowIn(FlowAnalysis<N, A> a, N s) {
                this.afterEvent(this.stop(s), a, s);
            }

            @Override
            public <A, N> void handleFlowOut(FlowAnalysis<N, A> a, N s) {
                this.beforeEvent(InteractionHandler.v(), a, s);
            }
        };


        <A, N> void beforeEvent(InteractionHandler i, FlowAnalysis<N, A> a, N s) {
            Object savedFlow = a.filterUnitToBeforeFlow.get(s);
            if (savedFlow == null) {
                savedFlow = a.newInitialFlow();
            }
            a.copy(a.unitToBeforeFlow.get(s), savedFlow);
            i.handleBeforeAnalysisEvent(new FlowInfo(savedFlow, s, true));
        }

        <A, N> void afterEvent(InteractionHandler i, FlowAnalysis<N, A> a, N s) {
            Object savedFlow = a.filterUnitToAfterFlow.get(s);
            if (savedFlow == null) {
                savedFlow = a.newInitialFlow();
            }
            a.copy(a.unitToAfterFlow.get(s), savedFlow);
            i.handleAfterAnalysisEvent(new FlowInfo(savedFlow, s, false));
        }

        InteractionHandler stop(Object s) {
            InteractionHandler h = InteractionHandler.v();
            ArrayList<Object> stopList = h.getStopUnitList();
            if (stopList != null && stopList.contains(s)) {
                h.handleStopAtNodeEvent(s);
            }
            return h;
        }

        public <A, N> void handleFlowIn(FlowAnalysis<N, A> a, N s) {
        }

        public <A, N> void handleFlowOut(FlowAnalysis<N, A> a, N s) {
        }
    }

    static final class Orderer
    extends Enum<Orderer> {
        public static final /* enum */ Orderer INSTANCE = new Orderer();
        private static final /* synthetic */ Orderer[] $VALUES;

        public static Orderer[] values() {
            return (Orderer[])$VALUES.clone();
        }

        public static Orderer valueOf(String name) {
            return Enum.valueOf(Orderer.class, name);
        }

        <D, F> List<Entry<D, F>> newUniverse(DirectedGraph<D> g, GraphView gv, F entryFlow, boolean isForward) {
            int n = g.size();
            ArrayDeque<Entry<D, F>> s = new ArrayDeque<Entry<D, F>>(n);
            ArrayList<Entry<D, F>> universe = new ArrayList<Entry<D, F>>(n);
            HashMap visited = new HashMap((n + 1) * 4 / 3);
            Entry superEntry = new Entry(null, null);
            List<D> entries = null;
            List<D> actualEntries = gv.getEntries(g);
            if (!actualEntries.isEmpty()) {
                entries = actualEntries;
            } else {
                if (isForward) {
                    throw new RuntimeException("error: no entry point for method in forward analysis");
                }
                entries = new ArrayList<D>();
                assert (g.getHeads().size() == 1);
                D head = g.getHeads().get(0);
                HashSet visitedNodes = new HashSet();
                ArrayList<D> workList = new ArrayList<D>();
                workList.add(head);
                while (!workList.isEmpty()) {
                    Object current = workList.remove(0);
                    visitedNodes.add(current);
                    if (current instanceof GotoInst || current instanceof GotoStmt) {
                        entries.add(current);
                    }
                    for (D next : g.getSuccsOf(current)) {
                        if (visitedNodes.contains(next)) continue;
                        workList.add(next);
                    }
                }
                if (entries.isEmpty()) {
                    throw new RuntimeException("error: backward analysis on an empty entry set.");
                }
            }
            this.visitEntry(visited, superEntry, entries);
            superEntry.inFlow = entryFlow;
            superEntry.outFlow = entryFlow;
            Entry[] sv = new Entry[g.size()];
            int[] si = new int[g.size()];
            int index = 0;
            int i = 0;
            Entry v = superEntry;
            while (true) {
                if (i < v.out.length) {
                    Entry w = v.out[i++];
                    if (w.number != Integer.MIN_VALUE) continue;
                    w.number = s.size();
                    s.add(w);
                    this.visitEntry(visited, w, gv.getOut(g, w.data));
                    si[index] = i;
                    sv[index] = v;
                    ++index;
                    i = 0;
                    v = w;
                    continue;
                }
                if (index == 0) {
                    assert (universe.size() <= g.size());
                    Collections.reverse(universe);
                    return universe;
                }
                universe.add(v);
                this.sccPop(s, v);
                v = sv[--index];
                i = si[index];
            }
        }

        private <D, F> Entry<D, F>[] visitEntry(Map<D, Entry<D, F>> visited, Entry<D, F> v, List<D> out) {
            int n = out.size();
            Entry[] a = new Entry[n];
            assert (out instanceof RandomAccess);
            for (int i = 0; i < n; ++i) {
                a[i] = this.getEntryOf(visited, out.get(i), v);
            }
            v.out = a;
            return a;
        }

        private <D, F> Entry<D, F> getEntryOf(Map<D, Entry<D, F>> visited, D d, Entry<D, F> v) {
            Entry<D, F> newEntry = new Entry<D, F>(d, v);
            Entry<D, F> oldEntry = visited.putIfAbsent(d, newEntry);
            if (oldEntry == null) {
                return newEntry;
            }
            if (oldEntry == v) {
                oldEntry.isRealStronglyConnected = true;
            }
            int l = oldEntry.in.length;
            oldEntry.in = Arrays.copyOf(oldEntry.in, l + 1);
            oldEntry.in[l] = v;
            return oldEntry;
        }

        private <D, F> void sccPop(Deque<Entry<D, F>> s, Entry<D, F> v) {
            int min = v.number;
            for (Entry e : v.out) {
                assert (e.number > Integer.MIN_VALUE);
                min = Math.min(min, e.number);
            }
            if (min != v.number) {
                v.number = min;
                return;
            }
            Entry<D, F> w = s.removeLast();
            w.number = Integer.MAX_VALUE;
            if (w == v) {
                return;
            }
            w.isRealStronglyConnected = true;
            do {
                w = s.removeLast();
                assert (w.number >= v.number);
                w.isRealStronglyConnected = true;
                w.number = Integer.MAX_VALUE;
            } while (w != v);
            assert (w.in.length >= 2);
        }

        static {
            $VALUES = new Orderer[]{INSTANCE};
        }
    }

    static class Entry<D, F>
    implements Numberable {
        final D data;
        int number;
        boolean isRealStronglyConnected;
        Entry<D, F>[] in;
        Entry<D, F>[] out;
        F inFlow;
        F outFlow;

        Entry(D u, Entry<D, F> pred) {
            this.in = new Entry[]{pred};
            this.data = u;
            this.number = Integer.MIN_VALUE;
            this.isRealStronglyConnected = false;
        }

        public String toString() {
            return this.data == null ? "" : this.data.toString();
        }

        @Override
        public void setNumber(int n) {
            this.number = n;
        }

        @Override
        public int getNumber() {
            return this.number;
        }
    }

    public static enum Flow {
        IN{

            @Override
            <F> F getFlow(Entry<?, F> e) {
                return e.inFlow;
            }
        }
        ,
        OUT{

            @Override
            <F> F getFlow(Entry<?, F> e) {
                return e.outFlow;
            }
        };


        abstract <F> F getFlow(Entry<?, F> var1);
    }
}

