/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Timers;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPatchingChain;
import soot.options.Options;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.graph.interaction.FlowInfo;
import soot.toolkits.graph.interaction.InteractionHandler;
import soot.toolkits.scalar.BranchedFlowAnalysis;

public abstract class ForwardBranchedFlowAnalysis<A>
extends BranchedFlowAnalysis<Unit, A> {
    private static final Logger logger = LoggerFactory.getLogger(ForwardBranchedFlowAnalysis.class);

    public ForwardBranchedFlowAnalysis(UnitGraph graph) {
        super(graph);
    }

    @Override
    protected boolean isForward() {
        return true;
    }

    private void accumulateAfterFlowSets(Unit s, A[] flowRepositories, List<A> previousAfterFlows) {
        int repCount = 0;
        previousAfterFlows.clear();
        if (s.fallsThrough()) {
            this.copy(((List)this.unitToAfterFallFlow.get(s)).get(0), flowRepositories[repCount]);
            previousAfterFlows.add(flowRepositories[repCount++]);
        }
        if (s.branches()) {
            for (Object fs : this.getBranchFlowAfter(s)) {
                this.copy(fs, flowRepositories[repCount]);
                previousAfterFlows.add(flowRepositories[repCount++]);
            }
        }
    }

    @Override
    protected void doAnalysis() {
        TreeSet<Unit> changedUnits = new TreeSet<Unit>(new Comparator<Unit>(){
            final Map<Unit, Integer> numbers = new HashMap<Unit, Integer>();
            {
                int i = 1;
                for (Unit u : new PseudoTopologicalOrderer().newList(ForwardBranchedFlowAnalysis.this.graph, false)) {
                    this.numbers.put(u, i);
                    ++i;
                }
            }

            @Override
            public int compare(Unit o1, Unit o2) {
                return this.numbers.get(o1) - this.numbers.get(o2);
            }
        });
        int numNodes = this.graph.size();
        HashMap unitToIncomingFlowSets = new HashMap(numNodes * 2 + 1, 0.7f);
        for (Unit s : this.graph) {
            unitToIncomingFlowSets.put(s, new ArrayList());
        }
        int numComputations = 0;
        int maxBranchSize = 0;
        UnitPatchingChain sl = ((UnitGraph)this.graph).getBody().getUnits();
        for (Unit s : this.graph) {
            changedUnits.add(s);
            this.unitToBeforeFlow.put(s, this.newInitialFlow());
            if (s.fallsThrough()) {
                ArrayList fl = new ArrayList();
                fl.add(this.newInitialFlow());
                this.unitToAfterFallFlow.put(s, fl);
                Unit succ = sl.getSuccOf(s);
                if (succ != null) {
                    ((ArrayList)unitToIncomingFlowSets.get(succ)).addAll(fl);
                }
            } else {
                this.unitToAfterFallFlow.put(s, new ArrayList());
            }
            List<UnitBox> unitBoxes = s.getUnitBoxes();
            ArrayList l = new ArrayList();
            if (s.branches()) {
                for (UnitBox ub : unitBoxes) {
                    Object f = this.newInitialFlow();
                    l.add(f);
                    ((ArrayList)unitToIncomingFlowSets.get(ub.getUnit())).add(f);
                }
            }
            this.unitToAfterBranchFlow.put(s, l);
            if (unitBoxes.size() <= maxBranchSize) continue;
            maxBranchSize = unitBoxes.size();
        }
        List heads = this.graph.getHeads();
        for (Unit s : heads) {
            this.unitToBeforeFlow.put(s, this.entryInitialFlow());
        }
        if (this.treatTrapHandlersAsEntries()) {
            for (Trap trap : ((UnitGraph)this.graph).getBody().getTraps()) {
                this.unitToBeforeFlow.put(trap.getHandlerUnit(), this.entryInitialFlow());
            }
        }
        Object[] flowRepositories = new Object[maxBranchSize + 1];
        Object[] previousFlowRepositories = new Object[maxBranchSize + 1];
        for (int i = 0; i < maxBranchSize + 1; ++i) {
            flowRepositories[i] = this.newInitialFlow();
            previousFlowRepositories[i] = this.newInitialFlow();
        }
        ArrayList previousAfterFlows = new ArrayList();
        ArrayList afterFlows = new ArrayList();
        while (!changedUnits.isEmpty()) {
            Unit s = changedUnits.first();
            changedUnits.remove(s);
            this.accumulateAfterFlowSets(s, previousFlowRepositories, previousAfterFlows);
            Object beforeFlow = this.getFlowBefore(s);
            Iterator preds = ((ArrayList)unitToIncomingFlowSets.get(s)).iterator();
            if (preds.hasNext()) {
                this.copy(preds.next(), beforeFlow);
                while (preds.hasNext()) {
                    Object otherBranchFlow = preds.next();
                    Object newBeforeFlow = this.newInitialFlow();
                    this.merge(s, beforeFlow, otherBranchFlow, newBeforeFlow);
                    this.copy(newBeforeFlow, beforeFlow);
                }
                if (heads.contains(s)) {
                    this.mergeInto(s, beforeFlow, this.entryInitialFlow());
                }
            }
            List afterFallFlow = (List)this.unitToAfterFallFlow.get(s);
            List afterBranchFlow = this.getBranchFlowAfter(s);
            if (Options.v().interactive_mode()) {
                InteractionHandler ih = InteractionHandler.v();
                Object savedFlow = this.newInitialFlow();
                this.copy(beforeFlow, savedFlow);
                FlowInfo fi = new FlowInfo(savedFlow, s, true);
                if (ih.getStopUnitList() != null && ih.getStopUnitList().contains(s)) {
                    ih.handleStopAtNodeEvent(s);
                }
                ih.handleBeforeAnalysisEvent(fi);
            }
            this.flowThrough(beforeFlow, s, afterFallFlow, afterBranchFlow);
            if (Options.v().interactive_mode()) {
                ArrayList l = new ArrayList();
                if (!afterFallFlow.isEmpty()) {
                    l.addAll(afterFallFlow);
                }
                if (!afterBranchFlow.isEmpty()) {
                    l.addAll(afterBranchFlow);
                }
                FlowInfo fi = new FlowInfo(l, s, false);
                InteractionHandler.v().handleAfterAnalysisEvent(fi);
            }
            ++numComputations;
            this.accumulateAfterFlowSets(s, flowRepositories, afterFlows);
            if (afterFlows.equals(previousAfterFlows)) continue;
            for (Unit succ : this.graph.getSuccsOf(s)) {
                changedUnits.add(succ);
            }
        }
        Timers.v().totalFlowNodes += numNodes;
        Timers.v().totalFlowComputations += numComputations;
    }
}

