/*
 * Decompiled with CFR 0.152.
 */
package soot.xml;

import soot.xml.XMLRoot;

public class XMLNode
extends XMLRoot {
    public static final int TAG_STRING_BUFFER = 4096;
    public XMLNode next = null;
    public XMLNode prev = null;
    public XMLNode parent = null;
    public XMLNode child = null;
    public XMLRoot root = null;

    public XMLNode(String in_name, String in_value, String[] in_attributes, String[] in_values) {
        this.name = in_name;
        this.value = in_value;
        this.attributes = in_attributes;
        this.values = in_values;
    }

    public XMLNode(XMLNode node) {
        if (node != null) {
            this.name = node.name;
            this.value = node.value;
            this.attributes = node.attributes;
            this.values = node.values;
            if (node.child != null) {
                this.child = (XMLNode)node.child.clone();
            }
            if (node.next != null) {
                this.next = (XMLNode)node.next.clone();
            }
        }
    }

    public Object clone() {
        return new XMLNode(this);
    }

    public String toPostString() {
        return this.toPostString("");
    }

    public String toPostString(String indent) {
        if (this.next != null) {
            return this.toString(indent) + this.next.toPostString(indent);
        }
        return this.toString(indent);
    }

    public int getNumberOfChildren() {
        int count = 0;
        XMLNode current = this.child;
        while (current != null) {
            ++count;
            current = current.next;
        }
        return count;
    }

    public XMLNode addAttribute(String attribute, String value) {
        String[] oldAttrs = this.attributes;
        int oldAttrsLen = oldAttrs.length;
        String[] newAttrs = new String[oldAttrsLen + 1];
        System.arraycopy(oldAttrs, 0, newAttrs, 0, oldAttrsLen);
        newAttrs[oldAttrsLen] = attribute.trim();
        this.attributes = newAttrs;
        String[] oldValues = this.values;
        int oldValuesLen = oldValues.length;
        String[] newValues = new String[oldValuesLen + 1];
        System.arraycopy(oldValues, 0, newValues, 0, oldValuesLen);
        newValues[oldValuesLen] = value.trim();
        this.values = newValues;
        return this;
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String endTag;
        String xmlName = this.eliminateSpaces(this.name);
        StringBuilder beginTag = new StringBuilder(4096);
        beginTag.append(indent);
        beginTag.append('<').append(xmlName);
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                if (this.attributes[i].length() <= 0) continue;
                String attributeName = this.eliminateSpaces(this.attributes[i].trim());
                beginTag.append(' ').append(attributeName).append("=\"");
                if (this.values == null) continue;
                if (i < this.values.length) {
                    beginTag.append(this.values[i].trim()).append('\"');
                    continue;
                }
                beginTag.append(attributeName.trim()).append('\"');
            }
        }
        if (this.child == null && this.value.isEmpty()) {
            beginTag.append(" />\n");
            endTag = null;
        } else {
            beginTag.append('>');
            endTag = "</" + xmlName + ">\n";
        }
        if (!this.value.isEmpty()) {
            beginTag.append(this.value);
        }
        if (this.child != null) {
            beginTag.append('\n');
            beginTag.append(this.child.toPostString(indent + "  "));
            beginTag.append(indent);
        }
        if (endTag != null) {
            beginTag.append(endTag);
        }
        return beginTag.toString();
    }

    public XMLNode insertElement(String name) {
        return this.insertElement(name, "", "", "");
    }

    public XMLNode insertElement(String name, String value) {
        return this.insertElement(name, value, "", "");
    }

    public XMLNode insertElement(String name, String value, String[] attributes) {
        return this.insertElement(name, value, attributes, null);
    }

    public XMLNode insertElement(String name, String[] attributes, String[] values) {
        return this.insertElement(name, "", attributes, values);
    }

    public XMLNode insertElement(String name, String value, String attribute, String attributeValue) {
        return this.insertElement(name, value, new String[]{attribute}, new String[]{attributeValue});
    }

    public XMLNode insertElement(String name, String value, String[] attributes, String[] values) {
        XMLNode newnode = new XMLNode(name, value, attributes, values);
        if (this.parent != null) {
            if (this.parent.child.equals(this)) {
                this.parent.child = newnode;
            }
        } else if (this.prev == null) {
            this.root.child = newnode;
        }
        newnode.child = null;
        newnode.parent = this.parent;
        newnode.prev = this.prev;
        if (newnode.prev != null) {
            newnode.prev.next = newnode;
        }
        this.prev = newnode;
        newnode.next = this;
        return newnode;
    }

    @Override
    public XMLNode addElement(String name) {
        return this.addElement(name, "", "", "");
    }

    @Override
    public XMLNode addElement(String name, String value) {
        return this.addElement(name, value, "", "");
    }

    @Override
    public XMLNode addElement(String name, String value, String[] attributes) {
        return this.addElement(name, value, attributes, null);
    }

    @Override
    public XMLNode addElement(String name, String[] attributes, String[] values) {
        return this.addElement(name, "", attributes, values);
    }

    @Override
    public XMLNode addElement(String name, String value, String attribute, String attributeValue) {
        return this.addElement(name, value, new String[]{attribute}, new String[]{attributeValue});
    }

    @Override
    public XMLNode addElement(String name, String value, String[] attributes, String[] values) {
        XMLNode newnode = new XMLNode(name, value, attributes, values);
        return this.addElement(newnode);
    }

    public XMLNode addElement(XMLNode node) {
        XMLNode current = this;
        while (current.next != null) {
            current = current.next;
        }
        current.next = node;
        node.prev = current;
        return node;
    }

    public XMLNode addChildren(XMLNode children) {
        XMLNode current = children;
        while (current != null) {
            current.parent = this;
            current = current.next;
        }
        if (this.child == null) {
            this.child = children;
        } else {
            current = this.child;
            while (current.next != null) {
                current = current.next;
            }
            current.next = children;
        }
        return this;
    }

    public XMLNode addChild(String name) {
        return this.addChild(name, "", "", "");
    }

    public XMLNode addChild(String name, String value) {
        return this.addChild(name, value, "", "");
    }

    public XMLNode addChild(String name, String value, String[] attributes) {
        return this.addChild(name, value, attributes, null);
    }

    public XMLNode addChild(String name, String[] attributes, String[] values) {
        return this.addChild(name, "", attributes, values);
    }

    public XMLNode addChild(String name, String value, String attribute, String attributeValue) {
        return this.addChild(name, value, new String[]{attribute}, new String[]{attributeValue});
    }

    public XMLNode addChild(String name, String value, String[] attributes, String[] values) {
        XMLNode newnode = new XMLNode(name, value, attributes, values);
        return this.addChild(newnode);
    }

    public XMLNode addChild(XMLNode node) {
        if (this.child == null) {
            this.child = node;
            node.parent = this;
        } else {
            XMLNode current = this.child;
            while (current.next != null) {
                current = current.next;
            }
            current.next = node;
            node.prev = current;
            node.parent = this;
        }
        return node;
    }

    private String eliminateSpaces(String str) {
        return str.trim().replace(' ', '_');
    }
}

