/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Body;
import soot.JastAddJ.Constant;
import soot.JastAddJ.Expr;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Unary;
import soot.Value;

public class PlusExpr
extends Unary
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public PlusExpr clone() throws CloneNotSupportedException {
        PlusExpr node = (PlusExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public PlusExpr copy() {
        try {
            PlusExpr node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public PlusExpr fullCopy() {
        PlusExpr tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public void typeCheck() {
        if (!this.getOperand().type().isNumericType()) {
            this.error("unary plus only operates on numeric types");
        }
    }

    @Override
    public Value eval(Body b) {
        return this.getOperand().eval(b);
    }

    public PlusExpr() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[1];
    }

    public PlusExpr(Expr p0) {
        this.setChild(p0, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setOperand(Expr node) {
        this.setChild(node, 0);
    }

    @Override
    public Expr getOperand() {
        return (Expr)this.getChild(0);
    }

    @Override
    public Expr getOperandNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public Constant constant() {
        ASTNode$State state = this.state();
        return this.type().plus(this.getOperand().constant());
    }

    @Override
    public boolean isConstant() {
        ASTNode$State state = this.state();
        return this.getOperand().isConstant();
    }

    @Override
    public String printPreOp() {
        ASTNode$State state = this.state();
        return "+";
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.getOperand().type().unaryNumericPromotion();
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

