/*
 * Decompiled with CFR 0.152.
 */
package soot;

import soot.ClassMember;
import soot.Modifier;
import soot.RefLikeType;
import soot.Scene;
import soot.SootClass;
import soot.SootFieldRef;
import soot.Type;
import soot.jimple.paddle.PaddleField;
import soot.jimple.spark.pag.SparkField;
import soot.options.Options;
import soot.tagkit.AbstractHost;
import soot.util.Numberable;

public class SootField
extends AbstractHost
implements ClassMember,
SparkField,
Numberable,
PaddleField {
    protected String name;
    protected Type type;
    protected int modifiers;
    protected boolean isDeclared = false;
    protected SootClass declaringClass;
    protected boolean isPhantom = false;
    protected volatile String sig;
    protected volatile String subSig;
    private int number = 0;

    public SootField(String name, Type type, int modifiers) {
        if (name == null || type == null) {
            throw new RuntimeException("A SootField cannot have a null name or type.");
        }
        this.name = name;
        this.type = type;
        this.modifiers = modifiers;
    }

    public SootField(String name, Type type) {
        this(name, type, 0);
    }

    public int equivHashCode() {
        return this.type.hashCode() * 101 + this.modifiers * 17 + this.name.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSignature() {
        if (this.sig == null) {
            SootField sootField = this;
            synchronized (sootField) {
                if (this.sig == null) {
                    this.sig = SootField.getSignature(this.getDeclaringClass(), this.getSubSignature());
                }
            }
        }
        return this.sig;
    }

    public static String getSignature(SootClass cl, String name, Type type) {
        return SootField.getSignature(cl, SootField.getSubSignature(name, type));
    }

    public static String getSignature(SootClass cl, String subSignature) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('<').append(Scene.v().quotedNameOf(cl.getName())).append(": ");
        buffer.append(subSignature).append('>');
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubSignature() {
        if (this.subSig == null) {
            SootField sootField = this;
            synchronized (sootField) {
                if (this.subSig == null) {
                    this.subSig = SootField.getSubSignature(this.getName(), this.getType());
                }
            }
        }
        return this.subSig;
    }

    protected static String getSubSignature(String name, Type type) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(type.toQuotedString()).append(' ').append(Scene.v().quotedNameOf(name));
        return buffer.toString();
    }

    @Override
    public SootClass getDeclaringClass() {
        if (!this.isDeclared) {
            throw new RuntimeException("not declared: " + this.getName() + " " + this.getType());
        }
        return this.declaringClass;
    }

    public synchronized void setDeclaringClass(SootClass sc) {
        if (sc != null && this.type instanceof RefLikeType) {
            Scene.v().getFieldNumberer().add(this);
        }
        this.declaringClass = sc;
        this.sig = null;
    }

    @Override
    public boolean isPhantom() {
        return this.isPhantom;
    }

    @Override
    public void setPhantom(boolean value) {
        if (value) {
            if (!Scene.v().allowsPhantomRefs()) {
                throw new RuntimeException("Phantom refs not allowed");
            }
            if (!Options.v().allow_phantom_elms() && this.declaringClass != null && !this.declaringClass.isPhantom()) {
                throw new RuntimeException("Declaring class would have to be phantom");
            }
        }
        this.isPhantom = value;
    }

    @Override
    public boolean isDeclared() {
        return this.isDeclared;
    }

    public void setDeclared(boolean isDeclared) {
        this.isDeclared = isDeclared;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        if (name != null) {
            this.name = name;
            this.sig = null;
            this.subSig = null;
        }
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public synchronized void setType(Type t) {
        if (t != null) {
            this.type = t;
            this.sig = null;
            this.subSig = null;
        }
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Override
    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public String toString() {
        return this.getSignature();
    }

    private String getOriginalStyleDeclaration() {
        String qualifiers = (Modifier.toString(this.modifiers) + ' ' + this.type.toQuotedString()).trim();
        if (qualifiers.isEmpty()) {
            return Scene.v().quotedNameOf(this.name);
        }
        return qualifiers + ' ' + Scene.v().quotedNameOf(this.name);
    }

    public String getDeclaration() {
        return this.getOriginalStyleDeclaration();
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public final void setNumber(int number) {
        this.number = number;
    }

    public SootFieldRef makeRef() {
        return Scene.v().makeFieldRef(this.declaringClass, this.name, this.type, this.isStatic());
    }
}

