/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.ForwardingLoadingCache;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jf.dexlib2.iface.DexFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ClassProvider;
import soot.ClassSource;
import soot.CoffiClassProvider;
import soot.CoffiClassSource;
import soot.CompilationDeathException;
import soot.DexClassProvider;
import soot.FoundFile;
import soot.G;
import soot.IFoundFile;
import soot.JavaClassProvider;
import soot.JimpleClassProvider;
import soot.ModulePathSourceLocator;
import soot.ModuleUtil;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.asm.AsmClassProvider;
import soot.asm.AsmJava9ClassProvider;
import soot.dexpler.DexFileProvider;
import soot.dotnet.AssemblyFile;
import soot.dotnet.DotnetClassProvider;
import soot.options.Options;
import soot.util.SharedCloseable;

public class SourceLocator {
    private static final Logger logger = LoggerFactory.getLogger(SourceLocator.class);
    protected final Set<ClassLoader> additionalClassLoaders = new HashSet<ClassLoader>();
    protected List<ClassProvider> classProviders;
    protected List<String> classPath;
    protected List<String> sourcePath;
    protected boolean java9Mode = false;
    private Set<String> dexClassPathExtensions;
    private Map<String, File> dexClassIndex;
    private static final int PATH_CACHE_CAPACITY = 100000;
    final SharedZipFileCacheWrapper archivePathToZip = new SharedZipFileCacheWrapper(5, 100000);
    protected final LoadingCache<String, ClassSourceType> pathToSourceType = CacheBuilder.newBuilder().initialCapacity(5).maximumSize(100000L).concurrencyLevel(Runtime.getRuntime().availableProcessors()).build((CacheLoader)new CacheLoader<String, ClassSourceType>(){

        public ClassSourceType load(String path) throws Exception {
            File f = new File(path);
            if (!f.exists() && !Options.v().ignore_classpath_errors()) {
                throw new Exception("Error: The path '" + path + "' does not exist.");
            }
            if (!f.canRead() && !Options.v().ignore_classpath_errors()) {
                throw new Exception("Error: The path '" + path + "' exists but is not readable.");
            }
            if (f.isFile()) {
                switch (path.substring(path.length() - 4)) {
                    case ".zip": {
                        return ClassSourceType.zip;
                    }
                    case ".jar": {
                        return ClassSourceType.jar;
                    }
                    case ".dex": {
                        return ClassSourceType.dex;
                    }
                    case ".exe": {
                        return ClassSourceType.exe;
                    }
                    case ".dll": {
                        return ClassSourceType.dll;
                    }
                }
                return Scene.isApk(new File(path)) ? ClassSourceType.apk : ClassSourceType.unknown;
            }
            if (f.isDirectory()) {
                return ClassSourceType.directory;
            }
            throw new Exception("Error: The path '" + path + "' is neither file nor directory.");
        }
    });
    protected final LoadingCache<String, Set<String>> archivePathToEntriesCache = CacheBuilder.newBuilder().initialCapacity(5).maximumSize(100000L).softValues().concurrencyLevel(Runtime.getRuntime().availableProcessors()).build((CacheLoader)new CacheLoader<String, Set<String>>(){

        public Set<String> load(String archivePath) throws Exception {
            try (SharedCloseable<ZipFile> archive = SourceLocator.this.archivePathToZip.getRef(archivePath);){
                HashSet<String> ret = new HashSet<String>();
                Enumeration<? extends ZipEntry> it = archive.get().entries();
                while (it.hasMoreElements()) {
                    ret.add(it.nextElement().getName());
                }
                Set<String> set = Collections.unmodifiableSet(ret);
                return set;
            }
        }
    });

    public SourceLocator(Singletons.Global g) {
    }

    public static SourceLocator v() {
        return ModuleUtil.module_mode() ? G.v().soot_ModulePathSourceLocator() : G.v().soot_SourceLocator();
    }

    public static void ensureDirectoryExists(File dir) {
        if (dir != null && !dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (SecurityException se) {
                logger.debug("Unable to create " + dir);
                throw new CompilationDeathException(0);
            }
        }
    }

    public static List<String> explodeClassPath(String classPath) {
        ArrayList<String> ret = new ArrayList<String>();
        String regex = "(?<!\\\\)" + Pattern.quote(File.pathSeparator);
        for (String originalDir : classPath.split(regex)) {
            if (originalDir.isEmpty()) continue;
            try {
                originalDir = originalDir.replaceAll("\\\\" + Pattern.quote(File.pathSeparator), File.pathSeparator);
                String canonicalDir = new File(originalDir).getCanonicalPath();
                if ("VIRTUAL_FS_FOR_JDK".equals(originalDir)) {
                    SourceLocator.v().java9Mode = true;
                    continue;
                }
                ret.add(canonicalDir);
            }
            catch (IOException e) {
                throw new CompilationDeathException("Couldn't resolve classpath entry " + originalDir + ": " + e);
            }
        }
        return Collections.unmodifiableList(ret);
    }

    public ClassSource getClassSource(String className) {
        String fileName;
        InputStream stream;
        ClassLoader cl;
        ClassSource ret;
        if (this.classPath == null) {
            this.classPath = SourceLocator.explodeClassPath(Scene.v().getSootClassPath());
        }
        if (this.classProviders == null) {
            this.setupClassProviders();
        }
        JavaClassProvider.JarException ex = null;
        for (ClassProvider cp : this.classProviders) {
            try {
                ret = cp.find(className);
                if (ret == null) continue;
                return ret;
            }
            catch (JavaClassProvider.JarException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        for (final ClassLoader cl2 : this.additionalClassLoaders) {
            try {
                ret = new ClassProvider(){

                    @Override
                    public ClassSource find(String className) {
                        String fileName = className.replace('.', '/') + ".class";
                        InputStream stream = cl2.getResourceAsStream(fileName);
                        return stream == null ? null : new CoffiClassSource(className, stream, fileName);
                    }
                }.find(className);
                if (ret == null) continue;
                return ret;
            }
            catch (JavaClassProvider.JarException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        if (className.startsWith("soot.rtlib.tamiflex.") && (cl = this.getClass().getClassLoader()) != null && (stream = cl.getResourceAsStream(fileName = className.replace('.', '/') + ".class")) != null) {
            return new CoffiClassSource(className, stream, fileName);
        }
        return null;
    }

    public void additionalClassLoader(ClassLoader c) {
        this.additionalClassLoaders.add(c);
    }

    protected void setupClassProviders() {
        LinkedList<ClassProvider> classProviders = new LinkedList<ClassProvider>();
        if (this.java9Mode) {
            classProviders.add(new AsmJava9ClassProvider());
        }
        ClassProvider classFileClassProvider = Options.v().coffi() ? new CoffiClassProvider() : new AsmClassProvider();
        switch (Options.v().src_prec()) {
            case 1: {
                classProviders.add(classFileClassProvider);
                classProviders.add(new JimpleClassProvider());
                classProviders.add(new JavaClassProvider());
                break;
            }
            case 2: {
                classProviders.add(classFileClassProvider);
                break;
            }
            case 4: {
                classProviders.add(new JavaClassProvider());
                classProviders.add(classFileClassProvider);
                classProviders.add(new JimpleClassProvider());
                break;
            }
            case 3: {
                classProviders.add(new JimpleClassProvider());
                classProviders.add(classFileClassProvider);
                classProviders.add(new JavaClassProvider());
                break;
            }
            case 5: {
                classProviders.add(new DexClassProvider());
                classProviders.add(classFileClassProvider);
                classProviders.add(new JavaClassProvider());
                classProviders.add(new JimpleClassProvider());
                break;
            }
            case 6: {
                classProviders.add(new DexClassProvider());
                classProviders.add(classFileClassProvider);
                classProviders.add(new JimpleClassProvider());
                break;
            }
            case 7: {
                classProviders.add(new DotnetClassProvider());
                classProviders.add(new JimpleClassProvider());
                break;
            }
            default: {
                throw new RuntimeException("Other source precedences are not currently supported.");
            }
        }
        this.classProviders = classProviders;
    }

    public void setClassProviders(List<ClassProvider> classProviders) {
        this.classProviders = classProviders;
    }

    public List<String> classPath() {
        return this.classPath;
    }

    public void invalidateClassPath() {
        this.classPath = null;
        this.dexClassIndex = null;
    }

    public List<String> sourcePath() {
        List<String> sourcePath = this.sourcePath;
        if (sourcePath == null) {
            sourcePath = new ArrayList<String>();
            for (String dir : this.classPath) {
                ClassSourceType cst = this.getClassSourceType(dir);
                if (cst == ClassSourceType.apk || cst == ClassSourceType.jar || cst == ClassSourceType.zip) continue;
                sourcePath.add(dir);
            }
            this.sourcePath = sourcePath;
        }
        return sourcePath;
    }

    protected ClassSourceType getClassSourceType(String path) {
        try {
            return (ClassSourceType)((Object)this.pathToSourceType.get((Object)path));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getClassesUnder(String aPath) {
        return this.getClassesUnder(aPath, "");
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getClassesUnder(String aPath, String prefix) {
        if ("VIRTUAL_FS_FOR_JDK".equals(aPath)) {
            ArrayList<String> foundClasses = new ArrayList<String>();
            for (List<String> classesInModule : ModulePathSourceLocator.v().getClassUnderModulePath("jrt:/").values()) {
                foundClasses.addAll(classesInModule);
            }
            return foundClasses;
        }
        ArrayList<String> classes = new ArrayList<String>();
        ClassSourceType cst = this.getClassSourceType(aPath);
        if (cst == ClassSourceType.apk || cst == ClassSourceType.dex) {
            try {
                for (DexFileProvider.DexContainer<? extends DexFile> dexContainer : DexFileProvider.v().getDexFromSource(new File(aPath))) {
                    classes.addAll(DexClassProvider.classesOfDex(dexContainer.getBase().getDexFile()));
                }
            }
            catch (IOException e) {
                throw new CompilationDeathException("Error reading dex source", e);
            }
        }
        if (cst == ClassSourceType.jar || cst == ClassSourceType.zip) {
            try {
                Throwable throwable = null;
                try (SharedCloseable<ZipFile> archive = this.archivePathToZip.getRef(aPath);){
                    Enumeration<? extends ZipEntry> entries = archive.get().entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        String entryName = entry.getName();
                        if (!entryName.endsWith(".class") && !entryName.endsWith(".jimple")) continue;
                        classes.add(prefix + entryName.substring(0, entryName.lastIndexOf(46)).replace('/', '.'));
                    }
                }
                catch (Throwable entries) {
                    Throwable throwable2 = entries;
                    throw entries;
                }
            }
            catch (Throwable e) {
                throw new CompilationDeathException("Error reading archive '" + aPath + "'", e);
            }
            try {
                for (DexFileProvider.DexContainer<? extends DexFile> dexContainer : DexFileProvider.v().getDexFromSource(new File(aPath))) {
                    classes.addAll(DexClassProvider.classesOfDex(dexContainer.getBase().getDexFile()));
                }
            }
            catch (CompilationDeathException e) {
            }
            catch (IOException e) {
                logger.debug(e.getMessage());
            }
        } else if (Options.v().src_prec() == 7 && cst == ClassSourceType.directory || cst == ClassSourceType.dll || cst == ClassSourceType.exe) {
            void var6_23;
            if (Strings.isNullOrEmpty((String)Options.v().dotnet_nativehost_path())) {
                throw new RuntimeException("Dotnet NativeHost Path is not set! Use -dotnet-nativehost-path Soot parameter!");
            }
            File file = new File(aPath);
            File[] fileArray = new File[1];
            if (cst == ClassSourceType.directory) {
                File[] fileList = file.listFiles();
                if (fileList == null) {
                    return classes;
                }
                File[] fileArray2 = fileList;
            } else {
                fileArray[0] = new File(aPath);
            }
            for (void element : var6_23) {
                if (element.isDirectory()) {
                    classes.addAll(this.getClassesUnder(aPath + File.separatorChar + element.getName()));
                    continue;
                }
                String fileName = element.getName();
                if (!fileName.endsWith(".dll") && !fileName.endsWith(".exe")) continue;
                try {
                    AssemblyFile assemblyFile;
                    Map<String, File> classContainerIndex = SourceLocator.v().dexClassIndex();
                    String canonicalPath = element.getCanonicalPath();
                    if (classContainerIndex.containsKey(canonicalPath)) {
                        assemblyFile = (AssemblyFile)classContainerIndex.get(canonicalPath);
                    } else {
                        assemblyFile = new AssemblyFile(canonicalPath);
                        if (!assemblyFile.isAssembly()) continue;
                    }
                    List<String> allClassNames = assemblyFile.getAllTypeNames();
                    if (allClassNames == null) continue;
                    classes.addAll(allClassNames);
                }
                catch (IOException e) {
                    logger.debug("" + e.getMessage());
                }
            }
        } else if (cst == ClassSourceType.directory) {
            void var6_26;
            File file = new File(aPath);
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                File[] fileArray3 = new File[]{file};
            }
            for (void element : var6_26) {
                if (element.isDirectory()) {
                    classes.addAll(this.getClassesUnder(aPath + File.separatorChar + element.getName(), prefix + element.getName() + '.'));
                    continue;
                }
                String fileName = element.getName();
                if (fileName.endsWith(".class")) {
                    classes.add(prefix + fileName.substring(0, fileName.lastIndexOf(".class")));
                    continue;
                }
                if (fileName.endsWith(".jimple")) {
                    classes.add(prefix + fileName.substring(0, fileName.lastIndexOf(".jimple")));
                    continue;
                }
                if (fileName.endsWith(".java")) {
                    classes.add(prefix + fileName.substring(0, fileName.lastIndexOf(".java")));
                    continue;
                }
                if (!fileName.endsWith(".dex")) continue;
                try {
                    for (DexFileProvider.DexContainer<? extends DexFile> dex : DexFileProvider.v().getDexFromSource((File)element)) {
                        classes.addAll(DexClassProvider.classesOfDex(dex.getBase().getDexFile()));
                    }
                }
                catch (IOException e) {
                    logger.debug(e.getMessage());
                }
            }
        } else {
            throw new RuntimeException("Invalid class source type " + (Object)((Object)cst) + " for " + aPath);
        }
        return classes;
    }

    public String getFileNameFor(SootClass c, int rep) {
        if (rep == 12) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        if (!Options.v().output_jar()) {
            b.append(this.getOutputDir());
        }
        if (b.length() > 0 && b.charAt(b.length() - 1) != File.separatorChar) {
            b.append(File.separatorChar);
        }
        switch (rep) {
            case 15: {
                return this.getDavaFilenameFor(c, b);
            }
            case 14: {
                b.append(c.getName().replace('.', File.separatorChar));
                break;
            }
            case 16: {
                b.append(c.getName().replace('.', '_'));
                b.append("_Maker");
                break;
            }
            default: {
                if ((rep == 1 || rep == 3) && Options.v().hierarchy_dirs()) {
                    b.append(c.getName().replace('.', File.separatorChar));
                    break;
                }
                b.append(c.getName());
            }
        }
        b.append(this.getExtensionFor(rep));
        return b.toString();
    }

    private String getDavaFilenameFor(SootClass c, StringBuilder b) {
        b.append("dava").append(File.separatorChar);
        SourceLocator.ensureDirectoryExists(new File(b.toString() + "classes"));
        b.append("src").append(File.separatorChar);
        String fixedPackageName = c.getJavaPackageName();
        if (!fixedPackageName.isEmpty()) {
            b.append(fixedPackageName.replace('.', File.separatorChar)).append(File.separatorChar);
        }
        SourceLocator.ensureDirectoryExists(new File(b.toString()));
        b.append(c.getShortJavaStyleName()).append(".java");
        return b.toString();
    }

    public Set<String> classesInDynamicPackage(String str) {
        HashSet<String> set = new HashSet<String>(0);
        StringTokenizer strtok = new StringTokenizer(Scene.v().getSootClassPath(), File.pathSeparator);
        while (strtok.hasMoreTokens()) {
            String path = strtok.nextToken();
            if (this.getClassSourceType(path) != ClassSourceType.directory) continue;
            for (String filename : this.getClassesUnder(path)) {
                if (!filename.startsWith(str)) continue;
                set.add(filename);
            }
            StringBuilder sb = new StringBuilder(path);
            sb.append(File.separatorChar);
            StringTokenizer tok = new StringTokenizer(str, ".");
            while (tok.hasMoreTokens()) {
                sb.append(tok.nextToken());
                if (!tok.hasMoreTokens()) continue;
                sb.append(File.separatorChar);
            }
            for (String string : this.getClassesUnder(sb.toString())) {
                set.add(str + '.' + string);
            }
        }
        return set;
    }

    public String getExtensionFor(int rep) {
        switch (rep) {
            case 5: {
                return ".baf";
            }
            case 6: {
                return ".b";
            }
            case 1: {
                return ".jimple";
            }
            case 2: {
                return ".jimp";
            }
            case 3: {
                return ".shimple";
            }
            case 4: {
                return ".shimp";
            }
            case 8: {
                return ".grimp";
            }
            case 7: {
                return ".grimple";
            }
            case 14: {
                return ".class";
            }
            case 15: {
                return ".java";
            }
            case 13: {
                return ".jasmin";
            }
            case 9: {
                return ".xml";
            }
            case 16: {
                return ".java";
            }
            case 17: {
                return ".asm";
            }
        }
        throw new RuntimeException();
    }

    public String getOutputDir() {
        File dir;
        String output_dir = Options.v().output_dir();
        if (output_dir.isEmpty()) {
            dir = new File("sootOutput");
        } else {
            dir = new File(output_dir);
            if (dir.getPath().endsWith(".jar") && (dir = dir.getParentFile()) == null) {
                dir = new File("");
            }
        }
        SourceLocator.ensureDirectoryExists(dir);
        return dir.getPath();
    }

    public String getOutputJarName() {
        File dir;
        if (!Options.v().output_jar()) {
            return "";
        }
        String output_dir = Options.v().output_dir();
        if (output_dir.isEmpty()) {
            dir = new File("sootOutput/out.jar");
        } else {
            dir = new File(output_dir);
            if (!dir.getPath().endsWith(".jar")) {
                dir = new File(dir.getPath(), "out.jar");
            }
        }
        SourceLocator.ensureDirectoryExists(dir.getParentFile());
        return dir.getPath();
    }

    public IFoundFile lookupInClassPath(String fileName) {
        for (String dir : this.classPath) {
            IFoundFile ret = null;
            ClassSourceType cst = this.getClassSourceType(dir);
            if (cst == ClassSourceType.zip || cst == ClassSourceType.jar) {
                ret = this.lookupInArchive(dir, fileName);
            } else if (cst == ClassSourceType.directory) {
                ret = this.lookupInDir(dir, fileName);
            }
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    protected IFoundFile lookupInDir(String dir, String fileName) {
        File f = new File(dir, fileName);
        return f.exists() && f.canRead() ? new FoundFile(f) : null;
    }

    protected IFoundFile lookupInArchive(String archivePath, String fileName) {
        Set entryNames = null;
        try {
            entryNames = (Set)this.archivePathToEntriesCache.get((Object)archivePath);
        }
        catch (Exception e) {
            throw new RuntimeException("Error: Failed to retrieve the archive entries list for the archive at path '" + archivePath + "'.", e);
        }
        return entryNames.contains(fileName) ? new FoundFile(archivePath, fileName) : null;
    }

    public String getSourceForClass(String className) {
        int i = className.indexOf(36);
        if (i > -1) {
            return className.substring(0, i);
        }
        return className;
    }

    public Map<String, File> dexClassIndex() {
        return this.dexClassIndex;
    }

    public void setDexClassIndex(Map<String, File> index) {
        this.dexClassIndex = index;
    }

    public void extendClassPath(String newPathElement) {
        this.classPath = null;
        if (newPathElement.endsWith(".dex") || newPathElement.endsWith(".apk") || newPathElement.endsWith(".exe") || newPathElement.endsWith(".dll")) {
            Set<String> dexClassPathExtensions = this.dexClassPathExtensions;
            if (dexClassPathExtensions == null) {
                this.dexClassPathExtensions = dexClassPathExtensions = new HashSet<String>();
            }
            this.dexClassPathExtensions.add(newPathElement);
        }
    }

    public Set<String> getDexClassPathExtensions() {
        return this.dexClassPathExtensions;
    }

    public void clearDexClassPathExtensions() {
        this.dexClassPathExtensions = null;
    }

    static class SharedZipFileCacheWrapper {
        private final SharedResourceCache<String, ZipFile> cache;

        public SharedZipFileCacheWrapper(int initSize, int maxSize) {
            this.cache = new SharedResourceCache<String, ZipFile>(initSize, maxSize, new CacheLoader<String, ZipFile>(){

                public ZipFile load(String archivePath) throws Exception {
                    return new ZipFile(archivePath);
                }
            });
        }

        public SharedCloseable<ZipFile> getRef(String archivePath) throws ExecutionException {
            return this.cache.get((Object)archivePath);
        }

        private static class SharedResourceCache<K, V extends Closeable>
        extends ForwardingLoadingCache<K, SharedCloseable<V>> {
            private final LoadingCache<K, SharedCloseable<V>> delegate;
            private final DelayedRemovalListener<K, SharedCloseable<V>> removalListener = new DelayedRemovalListener();

            public SharedResourceCache(int initSize, int maxSize, final CacheLoader<K, V> loader) {
                this.delegate = CacheBuilder.newBuilder().initialCapacity(initSize).maximumSize((long)maxSize).concurrencyLevel(Runtime.getRuntime().availableProcessors()).expireAfterAccess(15L, TimeUnit.SECONDS).removalListener(this.removalListener).build(new CacheLoader<K, SharedCloseable<V>>(){

                    public SharedCloseable<V> load(K key) throws Exception {
                        return new SharedCloseable<Closeable>((Closeable)loader.load(key));
                    }
                });
            }

            protected final LoadingCache<K, SharedCloseable<V>> delegate() {
                return this.delegate;
            }

            public final SharedCloseable<V> get(K key) throws ExecutionException {
                this.removalListener.delay(key);
                try {
                    SharedCloseable sharedCloseable = ((SharedCloseable)super.get(key)).acquire();
                    return sharedCloseable;
                }
                finally {
                    this.removalListener.release(key);
                }
            }

            private static class DelayedRemovalListener<K, V extends SharedCloseable<?>>
            implements RemovalListener<K, V> {
                private static final BiFunction<Object, Integer, Integer> INC = new BiFunction<Object, Integer, Integer>(){

                    @Override
                    public Integer apply(Object t, Integer u) {
                        return u == null ? 1 : u + 1;
                    }
                };
                private static final BiFunction<Object, Integer, Integer> DEC = new BiFunction<Object, Integer, Integer>(){

                    @Override
                    public Integer apply(Object t, Integer u) {
                        return u == 1 ? null : Integer.valueOf(u - 1);
                    }
                };
                private final ConcurrentHashMap<K, Integer> delayed = new ConcurrentHashMap();
                private final Queue<RemovalNotification<K, V>> delayQueue = new ConcurrentLinkedQueue<RemovalNotification<K, V>>();

                private DelayedRemovalListener() {
                }

                public void onRemoval(RemovalNotification<K, V> rn) {
                    this.process();
                    this.removeOrEnqueue(rn, this.delayQueue);
                }

                public void delay(K key) {
                    Integer val = this.delayed.compute(key, INC);
                    assert (val != null && val > 0);
                }

                public void release(K key) {
                    Integer val = this.delayed.compute(key, DEC);
                    assert (val == null || val > 0);
                    this.process();
                }

                private void process() {
                    RemovalNotification<K, V> rn;
                    LinkedList<RemovalNotification<K, V>> delayFurther = new LinkedList<RemovalNotification<K, V>>();
                    while ((rn = this.delayQueue.poll()) != null) {
                        this.removeOrEnqueue(rn, delayFurther);
                    }
                    this.delayQueue.addAll(delayFurther);
                }

                private void removeOrEnqueue(RemovalNotification<K, V> rn, Queue<RemovalNotification<K, V>> q) {
                    if (this.delayed.containsKey(rn.getKey())) {
                        q.offer(rn);
                    } else {
                        SharedCloseable val = (SharedCloseable)rn.getValue();
                        assert (val != null);
                        val.release();
                    }
                }
            }
        }
    }

    protected static enum ClassSourceType {
        jar,
        zip,
        apk,
        dex,
        directory,
        jrt,
        unknown,
        exe,
        dll;

    }
}

