/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import java.util.ArrayList;
import soot.Body;
import soot.Value;
import soot.dotnet.exceptions.NoExpressionInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.jimple.Jimple;
import soot.jimple.NopStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;

public class CilSwitchInstruction
extends AbstractCilnstruction {
    public CilSwitchInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        CilInstruction cilExpr = CilInstructionFactory.fromInstructionMsg(this.instruction.getKeyInstr(), this.dotnetBody, this.cilBlock);
        Value key = cilExpr.jimplifyExpr(jb);
        int lowIndex = (int)this.instruction.getSwitchSections(0).getLabel();
        int highIndex = (int)this.instruction.getSwitchSections(this.instruction.getSwitchSectionsCount() - 1).getLabel();
        Stmt defaultInstruct = Jimple.v().newNopStmt();
        switch (this.instruction.getDefaultInst().getOpCode()) {
            case BRANCH: {
                this.cilBlock.getDeclaredBlockContainer().blockEntryPointsManager.gotoTargetsInBody.put(defaultInstruct, this.instruction.getDefaultInst().getTargetLabel());
                break;
            }
            case LEAVE: {
                if (this.cilBlock.getDeclaredBlockContainer().isChildBlockContainer() && !this.instruction.getDefaultInst().getTargetLabel().equals("IL_0000")) {
                    defaultInstruct = this.cilBlock.getDeclaredBlockContainer().getSkipBlockContainerStmt();
                    break;
                }
                this.dotnetBody.blockEntryPointsManager.gotoTargetsInBody.put(defaultInstruct, "RETURNLEAVE");
                break;
            }
            default: {
                throw new RuntimeException("CilSwitchInstruction: Opcode " + this.instruction.getDefaultInst().getOpCode().name() + " not implemented!");
            }
        }
        ArrayList<Stmt> targets = new ArrayList<Stmt>();
        block8: for (ProtoIlInstructions.IlSwitchSectionMsg section : this.instruction.getSwitchSectionsList()) {
            NopStmt nopStmt = Jimple.v().newNopStmt();
            switch (section.getTargetInstr().getOpCode()) {
                case BRANCH: {
                    targets.add(nopStmt);
                    this.cilBlock.getDeclaredBlockContainer().blockEntryPointsManager.gotoTargetsInBody.put(nopStmt, section.getTargetInstr().getTargetLabel());
                    continue block8;
                }
                case LEAVE: {
                    if (this.cilBlock.getDeclaredBlockContainer().isChildBlockContainer() && !section.getTargetInstr().getTargetLabel().equals("IL_0000")) {
                        targets.add(this.cilBlock.getDeclaredBlockContainer().getSkipBlockContainerStmt());
                        continue block8;
                    }
                    targets.add(nopStmt);
                    this.dotnetBody.blockEntryPointsManager.gotoTargetsInBody.put(nopStmt, "RETURNLEAVE");
                    continue block8;
                }
            }
            throw new RuntimeException("CilSwitchInstruction: Opcode " + section.getTargetInstr().getOpCode().name() + " not implemented!");
        }
        TableSwitchStmt tableSwitchStmt = Jimple.v().newTableSwitchStmt(key, lowIndex, highIndex, targets, defaultInstruct);
        jb.getUnits().add(tableSwitchStmt);
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        throw new NoExpressionInstructionException(this.instruction);
    }
}

