/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.Trap;
import soot.Unit;
import soot.Value;
import soot.dotnet.exceptions.NoExpressionInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CatchFilterHandlerBody;
import soot.dotnet.instructions.CatchHandlerBody;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilBlockContainer;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.NopStmt;

public class CilTryCatchInstruction
extends AbstractCilnstruction {
    public CilTryCatchInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        ArrayList<Unit> nopsToReplaceWithGoto = new ArrayList<Unit>();
        SootClass exceptionClass = Scene.v().getSootClass("System.Exception");
        NopStmt gotoEndTryCatchBlockNop = Jimple.v().newNopStmt();
        CilBlockContainer tryContainer = new CilBlockContainer(this.instruction.getTryBlock(), this.dotnetBody, CilBlockContainer.BlockContainerKind.TRY);
        Body tryContainerBlock = tryContainer.jimplify();
        if (CilBlockContainer.LastStmtIsNotReturn(tryContainerBlock)) {
            NopStmt nopStmt = Jimple.v().newNopStmt();
            tryContainerBlock.getUnits().add(nopStmt);
            nopsToReplaceWithGoto.add(nopStmt);
        }
        jb.getLocals().addAll(tryContainerBlock.getLocals());
        jb.getUnits().addAll(tryContainerBlock.getUnits());
        jb.getTraps().addAll(tryContainerBlock.getTraps());
        Local uncaughtExceptionVar = this.dotnetBody.variableManager.localGenerator.generateLocal(exceptionClass.getType());
        IdentityStmt exceptionIdentityStmt = Jimple.v().newIdentityStmt(uncaughtExceptionVar, Jimple.v().newCaughtExceptionRef());
        List<ProtoIlInstructions.IlTryCatchHandlerMsg> protoHandlersList = this.instruction.getHandlersList();
        ArrayList<CatchFilterHandlerBody> handlersWithFilterList = new ArrayList<CatchFilterHandlerBody>();
        ArrayList<CatchHandlerBody> handlersList = new ArrayList<CatchHandlerBody>();
        CatchHandlerBody systemExceptionHandler = null;
        for (ProtoIlInstructions.IlTryCatchHandlerMsg handlerMsg : protoHandlersList) {
            Local exceptionVar = this.dotnetBody.variableManager.addOrGetVariable(handlerMsg.getVariable(), jb);
            if (handlerMsg.getHasFilter()) {
                CatchFilterHandlerBody filterHandler = new CatchFilterHandlerBody(this.dotnetBody, handlerMsg, exceptionVar, gotoEndTryCatchBlockNop);
                handlersWithFilterList.add(filterHandler);
                continue;
            }
            CatchHandlerBody handler = new CatchHandlerBody(exceptionVar, handlerMsg, this.dotnetBody, tryContainerBlock, exceptionIdentityStmt, nopsToReplaceWithGoto);
            handlersList.add(handler);
            if (!handlerMsg.getVariable().getType().getFullname().equals("System.Exception")) continue;
            systemExceptionHandler = handler;
        }
        for (CatchHandlerBody handlerBody : handlersList) {
            Body body = handlerBody.getBody();
            if (handlerBody == systemExceptionHandler) {
                HashMap<Trap, Unit> tmpTrapEnds = new HashMap<Trap, Unit>();
                for (Trap trap : body.getTraps()) {
                    tmpTrapEnds.put(trap, trap.getEndUnit());
                }
                for (CatchFilterHandlerBody catchFilterHandlerBody : handlersWithFilterList) {
                    Local eVar = systemExceptionHandler.getExceptionVariable();
                    Body filterHandlerBody = catchFilterHandlerBody.getFilterHandlerBody(eVar);
                    body.getUnits().insertAfter(filterHandlerBody.getUnits(), body.getUnits().getFirst());
                    body.getTraps().addAll(filterHandlerBody.getTraps());
                }
                for (Map.Entry entry : tmpTrapEnds.entrySet()) {
                    ((Trap)entry.getKey()).setEndUnit((Unit)entry.getValue());
                }
            }
            jb.getUnits().addAll(body.getUnits());
            jb.getTraps().addAll(body.getTraps());
        }
        if (systemExceptionHandler == null) {
            jb.getTraps().add(Jimple.v().newTrap(exceptionClass, (Unit)tryContainerBlock.getUnits().getFirst(), (Unit)tryContainerBlock.getUnits().getLast(), exceptionIdentityStmt));
        }
        jb.getUnits().add(exceptionIdentityStmt);
        if (systemExceptionHandler == null) {
            for (CatchFilterHandlerBody filterHandler : handlersWithFilterList) {
                Body filterHandlerBody = filterHandler.getFilterHandlerBody(uncaughtExceptionVar);
                jb.getUnits().addAll(filterHandlerBody.getUnits());
                jb.getTraps().addAll(filterHandlerBody.getTraps());
            }
        }
        jb.getUnits().add(Jimple.v().newThrowStmt(uncaughtExceptionVar));
        jb.getUnits().add(gotoEndTryCatchBlockNop);
        for (Unit nop : nopsToReplaceWithGoto) {
            GotoStmt gotoStmt = Jimple.v().newGotoStmt(gotoEndTryCatchBlockNop);
            jb.getUnits().swapWith(nop, gotoStmt);
        }
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        throw new NoExpressionInstructionException(this.instruction);
    }
}

