/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.infoflow;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.EquivalentValue;
import soot.Local;
import soot.RefLikeType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.jimple.FieldRef;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.ParameterRef;
import soot.jimple.Ref;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.toolkits.infoflow.InfoFlowAnalysis;
import soot.jimple.toolkits.infoflow.SmartMethodInfoFlowAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.graph.HashMutableDirectedGraph;
import soot.toolkits.graph.MemoryEfficientGraph;
import soot.toolkits.graph.MutableDirectedGraph;

public class ClassInfoFlowAnalysis {
    private static final Logger logger = LoggerFactory.getLogger(ClassInfoFlowAnalysis.class);
    SootClass sootClass;
    InfoFlowAnalysis dfa;
    Map<SootMethod, SmartMethodInfoFlowAnalysis> methodToInfoFlowAnalysis;
    Map<SootMethod, HashMutableDirectedGraph<EquivalentValue>> methodToInfoFlowSummary;
    public static int methodCount = 0;

    public ClassInfoFlowAnalysis(SootClass sootClass, InfoFlowAnalysis dfa) {
        this.sootClass = sootClass;
        this.dfa = dfa;
        this.methodToInfoFlowAnalysis = new HashMap<SootMethod, SmartMethodInfoFlowAnalysis>();
        this.methodToInfoFlowSummary = new HashMap<SootMethod, HashMutableDirectedGraph<EquivalentValue>>();
    }

    public SmartMethodInfoFlowAnalysis getMethodInfoFlowAnalysis(SootMethod method) {
        if (!this.methodToInfoFlowAnalysis.containsKey(method)) {
            ++methodCount;
            if (!this.methodToInfoFlowSummary.containsKey(method)) {
                HashMutableDirectedGraph<EquivalentValue> dataFlowGraph = this.simpleConservativeInfoFlowAnalysis(method);
                this.methodToInfoFlowSummary.put(method, dataFlowGraph);
            }
            if (method.isConcrete()) {
                Body b = method.retrieveActiveBody();
                ExceptionalUnitGraph g = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(b);
                SmartMethodInfoFlowAnalysis smdfa = new SmartMethodInfoFlowAnalysis(g, this.dfa);
                this.methodToInfoFlowAnalysis.put(method, smdfa);
                this.methodToInfoFlowSummary.remove(method);
                this.methodToInfoFlowSummary.put(method, smdfa.getMethodInfoFlowSummary());
                return smdfa;
            }
        }
        return this.methodToInfoFlowAnalysis.get(method);
    }

    public MutableDirectedGraph<EquivalentValue> getMethodInfoFlowSummary(SootMethod method) {
        return this.getMethodInfoFlowSummary(method, true);
    }

    public HashMutableDirectedGraph<EquivalentValue> getMethodInfoFlowSummary(SootMethod method, boolean doFullAnalysis) {
        if (!this.methodToInfoFlowSummary.containsKey(method)) {
            ++methodCount;
            HashMutableDirectedGraph<EquivalentValue> dataFlowGraph = this.simpleConservativeInfoFlowAnalysis(method);
            this.methodToInfoFlowSummary.put(method, dataFlowGraph);
            if (method.isConcrete() && doFullAnalysis) {
                Body b = method.retrieveActiveBody();
                ExceptionalUnitGraph g = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(b);
                SmartMethodInfoFlowAnalysis smdfa = new SmartMethodInfoFlowAnalysis(g, this.dfa);
                this.methodToInfoFlowAnalysis.put(method, smdfa);
                this.methodToInfoFlowSummary.remove(method);
                this.methodToInfoFlowSummary.put(method, smdfa.getMethodInfoFlowSummary());
            }
        }
        return this.methodToInfoFlowSummary.get(method);
    }

    /*
     * WARNING - void declaration
     */
    private HashMutableDirectedGraph<EquivalentValue> simpleConservativeInfoFlowAnalysis(SootMethod sm) {
        if (!sm.isConcrete()) {
            return this.triviallyConservativeInfoFlowAnalysis(sm);
        }
        Body b = sm.retrieveActiveBody();
        ExceptionalUnitGraph g = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(b);
        HashSet<EquivalentValue> fieldsStaticsParamsAccessed = new HashSet<EquivalentValue>();
        for (Unit u : g) {
            InstanceFieldRef ifr;
            Value base;
            IdentityStmt identityStmt;
            IdentityRef ir;
            Stmt s = (Stmt)u;
            if (s instanceof IdentityStmt && (ir = (IdentityRef)(identityStmt = (IdentityStmt)s).getRightOp()) instanceof ParameterRef) {
                ParameterRef pr = (ParameterRef)ir;
                fieldsStaticsParamsAccessed.add(InfoFlowAnalysis.getNodeForParameterRef(sm, pr.getIndex()));
            }
            if (!s.containsFieldRef()) continue;
            FieldRef fieldRef = s.getFieldRef();
            if (fieldRef instanceof StaticFieldRef) {
                StaticFieldRef sfr = (StaticFieldRef)fieldRef;
                fieldsStaticsParamsAccessed.add(InfoFlowAnalysis.getNodeForFieldRef(sm, sfr.getField()));
                continue;
            }
            if (!(fieldRef instanceof InstanceFieldRef) || !((base = (ifr = (InstanceFieldRef)fieldRef).getBase()) instanceof Local) || !this.dfa.includesInnerFields() && (sm.isStatic() || !base.equivTo(b.getThisLocal()))) continue;
            fieldsStaticsParamsAccessed.add(InfoFlowAnalysis.getNodeForFieldRef(sm, ifr.getField()));
        }
        MemoryEfficientGraph<EquivalentValue> dataFlowGraph = new MemoryEfficientGraph<EquivalentValue>();
        for (EquivalentValue o : fieldsStaticsParamsAccessed) {
            ((HashMutableDirectedGraph)dataFlowGraph).addNode(o);
        }
        for (int i = 0; i < sm.getParameterCount(); ++i) {
            EquivalentValue equivalentValue = InfoFlowAnalysis.getNodeForParameterRef(sm, i);
            if (dataFlowGraph.containsNode(equivalentValue)) continue;
            ((HashMutableDirectedGraph)dataFlowGraph).addNode(equivalentValue);
        }
        for (SootField sootField : sm.getDeclaringClass().getFields()) {
            EquivalentValue fieldRefEqVal;
            if (!sootField.isStatic() && sm.isStatic() || dataFlowGraph.containsNode(fieldRefEqVal = InfoFlowAnalysis.getNodeForFieldRef(sm, sootField))) continue;
            ((HashMutableDirectedGraph)dataFlowGraph).addNode(fieldRefEqVal);
        }
        SootClass superclass = sm.getDeclaringClass();
        if (superclass.hasSuperclass()) {
            superclass = sm.getDeclaringClass().getSuperclass();
        }
        while (superclass.hasSuperclass()) {
            for (SootField scField : superclass.getFields()) {
                EquivalentValue fieldRefEqVal;
                if (!scField.isStatic() && sm.isStatic() || dataFlowGraph.containsNode(fieldRefEqVal = InfoFlowAnalysis.getNodeForFieldRef(sm, scField))) continue;
                ((HashMutableDirectedGraph)dataFlowGraph).addNode(fieldRefEqVal);
            }
            superclass = superclass.getSuperclass();
        }
        Object var8_19 = null;
        if (sm.getReturnType() != VoidType.v()) {
            ParameterRef parameterRef = new ParameterRef(sm.getReturnType(), -1);
            ((HashMutableDirectedGraph)dataFlowGraph).addNode(InfoFlowAnalysis.getNodeForReturnRef(sm));
        }
        if (!sm.isStatic()) {
            ((HashMutableDirectedGraph)dataFlowGraph).addNode(InfoFlowAnalysis.getNodeForThisRef(sm));
            fieldsStaticsParamsAccessed.add(InfoFlowAnalysis.getNodeForThisRef(sm));
        }
        for (EquivalentValue r : fieldsStaticsParamsAccessed) {
            void var8_21;
            Ref rRef = (Ref)r.getValue();
            if (!(rRef.getType() instanceof RefLikeType) && !this.dfa.includesPrimitiveInfoFlow()) continue;
            for (EquivalentValue s : fieldsStaticsParamsAccessed) {
                Ref sRef = (Ref)s.getValue();
                if (rRef instanceof ThisRef && sRef instanceof InstanceFieldRef || sRef instanceof ThisRef && rRef instanceof InstanceFieldRef || sRef instanceof ParameterRef && this.dfa.includesInnerFields() || !(sRef.getType() instanceof RefLikeType)) continue;
                ((HashMutableDirectedGraph)dataFlowGraph).addEdge(r, s);
            }
            if (var8_21 == null || !(var8_21.getType() instanceof RefLikeType) && !this.dfa.includesPrimitiveInfoFlow()) continue;
            ((HashMutableDirectedGraph)dataFlowGraph).addEdge(r, InfoFlowAnalysis.getNodeForReturnRef(sm));
        }
        return dataFlowGraph;
    }

    public HashMutableDirectedGraph<EquivalentValue> triviallyConservativeInfoFlowAnalysis(SootMethod sm) {
        HashSet<EquivalentValue> fieldsStaticsParamsAccessed = new HashSet<EquivalentValue>();
        for (int i = 0; i < sm.getParameterCount(); ++i) {
            EquivalentValue parameterRefEqVal = InfoFlowAnalysis.getNodeForParameterRef(sm, i);
            fieldsStaticsParamsAccessed.add(parameterRefEqVal);
        }
        for (SootField sf : sm.getDeclaringClass().getFields()) {
            if (!sf.isStatic() && sm.isStatic()) continue;
            EquivalentValue fieldRefEqVal = InfoFlowAnalysis.getNodeForFieldRef(sm, sf);
            fieldsStaticsParamsAccessed.add(fieldRefEqVal);
        }
        SootClass superclass = sm.getDeclaringClass();
        if (superclass.hasSuperclass()) {
            superclass = sm.getDeclaringClass().getSuperclass();
        }
        while (superclass.hasSuperclass()) {
            for (SootField scField : superclass.getFields()) {
                if (!scField.isStatic() && sm.isStatic()) continue;
                EquivalentValue fieldRefEqVal = InfoFlowAnalysis.getNodeForFieldRef(sm, scField);
                fieldsStaticsParamsAccessed.add(fieldRefEqVal);
            }
            superclass = superclass.getSuperclass();
        }
        MemoryEfficientGraph<EquivalentValue> dataFlowGraph = new MemoryEfficientGraph<EquivalentValue>();
        for (EquivalentValue o : fieldsStaticsParamsAccessed) {
            ((HashMutableDirectedGraph)dataFlowGraph).addNode(o);
        }
        ParameterRef returnValueRef = null;
        if (sm.getReturnType() != VoidType.v()) {
            returnValueRef = new ParameterRef(sm.getReturnType(), -1);
            ((HashMutableDirectedGraph)dataFlowGraph).addNode(InfoFlowAnalysis.getNodeForReturnRef(sm));
        }
        if (!sm.isStatic()) {
            ((HashMutableDirectedGraph)dataFlowGraph).addNode(InfoFlowAnalysis.getNodeForThisRef(sm));
            fieldsStaticsParamsAccessed.add(InfoFlowAnalysis.getNodeForThisRef(sm));
        }
        for (EquivalentValue r : fieldsStaticsParamsAccessed) {
            Ref rRef = (Ref)r.getValue();
            if (!(rRef.getType() instanceof RefLikeType) && !this.dfa.includesPrimitiveInfoFlow()) continue;
            for (EquivalentValue s : fieldsStaticsParamsAccessed) {
                Ref sRef = (Ref)s.getValue();
                if (rRef instanceof ThisRef && sRef instanceof InstanceFieldRef || sRef instanceof ThisRef && rRef instanceof InstanceFieldRef || !(sRef.getType() instanceof RefLikeType)) continue;
                ((HashMutableDirectedGraph)dataFlowGraph).addEdge(r, s);
            }
            if (returnValueRef == null || !(returnValueRef.getType() instanceof RefLikeType) && !this.dfa.includesPrimitiveInfoFlow()) continue;
            ((HashMutableDirectedGraph)dataFlowGraph).addEdge(r, InfoFlowAnalysis.getNodeForReturnRef(sm));
        }
        return dataFlowGraph;
    }
}

