/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.synchronization;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Filter;
import soot.jimple.toolkits.callgraph.TransitiveTargets;
import soot.jimple.toolkits.pointer.CodeBlockRWSet;
import soot.jimple.toolkits.pointer.FullObjectSet;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.pointer.SideEffectAnalysis;
import soot.jimple.toolkits.pointer.StmtRWSet;
import soot.jimple.toolkits.thread.EncapsulatedObjectAnalysis;
import soot.jimple.toolkits.thread.ThreadLocalObjectsAnalysis;
import soot.jimple.toolkits.thread.synchronization.CriticalSection;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionVisibleEdgesPred;

public class CriticalSectionAwareSideEffectAnalysis {
    PointsToAnalysis pa;
    CallGraph cg;
    Map<SootMethod, CodeBlockRWSet> methodToNTReadSet = new HashMap<SootMethod, CodeBlockRWSet>();
    Map<SootMethod, CodeBlockRWSet> methodToNTWriteSet = new HashMap<SootMethod, CodeBlockRWSet>();
    int rwsetcount = 0;
    CriticalSectionVisibleEdgesPred tve;
    TransitiveTargets tt;
    TransitiveTargets normaltt;
    SideEffectAnalysis normalsea;
    Collection<CriticalSection> criticalSections;
    EncapsulatedObjectAnalysis eoa;
    ThreadLocalObjectsAnalysis tlo;
    public Vector sigBlacklist;
    public Vector sigReadGraylist;
    public Vector sigWriteGraylist;
    public Vector subSigBlacklist;
    private HashMap<Stmt, RWSet> RCache = new HashMap();
    private HashMap<Stmt, RWSet> WCache = new HashMap();

    public void findNTRWSets(SootMethod method) {
        if (this.methodToNTReadSet.containsKey(method) && this.methodToNTWriteSet.containsKey(method)) {
            return;
        }
        CodeBlockRWSet read = null;
        CodeBlockRWSet write = null;
        for (Stmt s : method.retrieveActiveBody().getUnits()) {
            InvokeExpr ie;
            SootMethod calledMethod;
            RWSet ntw;
            boolean ignore = false;
            if (this.criticalSections != null) {
                for (CriticalSection tn : this.criticalSections) {
                    if (!tn.units.contains(s) && tn.prepStmt != s) continue;
                    ignore = true;
                    break;
                }
            }
            if (ignore) continue;
            RWSet ntr = this.ntReadSet(method, s);
            if (ntr != null) {
                if (read == null) {
                    read = new CodeBlockRWSet();
                }
                read.union(ntr);
            }
            if ((ntw = this.ntWriteSet(method, s)) != null) {
                if (write == null) {
                    write = new CodeBlockRWSet();
                }
                write.union(ntw);
            }
            if (!s.containsInvokeExpr() || !(calledMethod = (ie = s.getInvokeExpr()).getMethod()).getDeclaringClass().toString().startsWith("java.util") && !calledMethod.getDeclaringClass().toString().startsWith("java.lang")) continue;
            Local base = null;
            if (ie instanceof InstanceInvokeExpr) {
                base = (Local)((InstanceInvokeExpr)ie).getBase();
            }
            if (this.tlo != null && base != null && this.tlo.isObjectThreadLocal(base, method)) continue;
            RWSet r = this.approximatedReadSet(method, s, base, true);
            if (read == null) {
                read = new CodeBlockRWSet();
            }
            if (r != null) {
                read.union(r);
            }
            RWSet w = this.approximatedWriteSet(method, s, base, true);
            if (write == null) {
                write = new CodeBlockRWSet();
            }
            if (w == null) continue;
            write.union(w);
        }
        this.methodToNTReadSet.put(method, read);
        this.methodToNTWriteSet.put(method, write);
    }

    public void setExemptTransaction(CriticalSection tn) {
        this.tve.setExemptTransaction(tn);
    }

    public RWSet nonTransitiveReadSet(SootMethod method) {
        this.findNTRWSets(method);
        return this.methodToNTReadSet.get(method);
    }

    public RWSet nonTransitiveWriteSet(SootMethod method) {
        this.findNTRWSets(method);
        return this.methodToNTWriteSet.get(method);
    }

    public CriticalSectionAwareSideEffectAnalysis(PointsToAnalysis pa, CallGraph cg, Collection<CriticalSection> criticalSections, ThreadLocalObjectsAnalysis tlo) {
        this.pa = pa;
        this.cg = cg;
        this.tve = new CriticalSectionVisibleEdgesPred(criticalSections);
        this.tt = new TransitiveTargets(cg, new Filter(this.tve));
        this.normaltt = new TransitiveTargets(cg, null);
        this.normalsea = new SideEffectAnalysis(pa, cg);
        this.criticalSections = criticalSections;
        this.eoa = new EncapsulatedObjectAnalysis();
        this.tlo = tlo;
        this.sigBlacklist = new Vector();
        this.sigReadGraylist = new Vector();
        this.sigWriteGraylist = new Vector();
        this.subSigBlacklist = new Vector();
    }

    private RWSet ntReadSet(SootMethod method, Stmt stmt) {
        if (stmt instanceof AssignStmt) {
            AssignStmt a = (AssignStmt)stmt;
            Value r = a.getRightOp();
            if (r instanceof NewExpr) {
                return null;
            }
            return this.addValue(r, method, stmt);
        }
        return null;
    }

    public RWSet approximatedReadSet(SootMethod method, Stmt stmt, Value specialRead, boolean allFields) {
        CodeBlockRWSet ret = new CodeBlockRWSet();
        if (specialRead != null) {
            if (specialRead instanceof Local) {
                List<SootClass> baseClasses;
                SootClass baseTypeClass;
                Local vLocal = (Local)specialRead;
                PointsToSet base = this.pa.reachingObjects(vLocal);
                Type pType = vLocal.getType();
                if (pType instanceof RefType && !(baseTypeClass = ((RefType)pType).getSootClass()).isInterface() && !(baseClasses = Scene.v().getActiveHierarchy().getSuperclassesOfIncluding(baseTypeClass)).contains(RefType.v("java.lang.Exception").getSootClass())) {
                    for (SootClass baseClass : baseClasses) {
                        for (SootField baseField : baseClass.getFields()) {
                            if (baseField.isStatic()) continue;
                            ret.addFieldRef(base, baseField);
                        }
                    }
                }
                if (!allFields) {
                    RWSet normalRW;
                    CodeBlockRWSet allRW = ret;
                    ret = new CodeBlockRWSet();
                    if (this.RCache.containsKey(stmt)) {
                        normalRW = this.RCache.get(stmt);
                    } else {
                        normalRW = this.normalsea.readSet(method, stmt);
                        this.RCache.put(stmt, normalRW);
                    }
                    if (normalRW != null) {
                        for (Object field : normalRW.getFields()) {
                            if (!allRW.containsField(field)) continue;
                            PointsToSet otherBase = normalRW.getBaseForField(field);
                            if (otherBase instanceof FullObjectSet) {
                                ret.addFieldRef(otherBase, field);
                                continue;
                            }
                            if (!base.hasNonEmptyIntersection(otherBase)) continue;
                            ret.addFieldRef(base, field);
                        }
                    }
                }
            } else if (specialRead instanceof FieldRef) {
                ret.union(this.addValue(specialRead, method, stmt));
            }
        }
        if (stmt.containsInvokeExpr()) {
            int argCount = stmt.getInvokeExpr().getArgCount();
            for (int i = 0; i < argCount; ++i) {
                ret.union(this.addValue(stmt.getInvokeExpr().getArg(i), method, stmt));
            }
        }
        if (stmt instanceof AssignStmt) {
            AssignStmt a = (AssignStmt)stmt;
            Value r = a.getRightOp();
            ret.union(this.addValue(r, method, stmt));
        }
        return ret;
    }

    public RWSet readSet(SootMethod method, Stmt stmt, CriticalSection tn, Set uses) {
        InvokeExpr ie;
        SootMethod calledMethod;
        boolean ignore = false;
        if (stmt.containsInvokeExpr()) {
            InvokeExpr ie2 = stmt.getInvokeExpr();
            SootMethod calledMethod2 = ie2.getMethod();
            if (!(ie2 instanceof StaticInvokeExpr) && ie2 instanceof InstanceInvokeExpr) {
                if (calledMethod2.getSubSignature().startsWith("void <init>") && this.eoa.isInitMethodPureOnObject(calledMethod2)) {
                    ignore = true;
                } else if (this.tlo != null && !this.tlo.hasNonThreadLocalEffects(method, ie2)) {
                    ignore = true;
                }
            }
        }
        boolean inaccessibleUses = false;
        CodeBlockRWSet ret = new CodeBlockRWSet();
        this.tve.setExemptTransaction(tn);
        Iterator<MethodOrMethodContext> targets = this.tt.iterator(stmt);
        while (!ignore && targets.hasNext()) {
            RWSet ntr;
            SootMethod target = (SootMethod)targets.next();
            if (!target.isConcrete() || target.getDeclaringClass().toString().startsWith("java.util") || target.getDeclaringClass().toString().startsWith("java.lang") || (ntr = this.nonTransitiveReadSet(target)) == null) continue;
            ((RWSet)ret).union(ntr);
        }
        RWSet ntr = this.ntReadSet(method, stmt);
        if (!inaccessibleUses && ntr != null && stmt instanceof AssignStmt) {
            AssignStmt a = (AssignStmt)stmt;
            Value r = a.getRightOp();
            if (r instanceof InstanceFieldRef) {
                uses.add(((InstanceFieldRef)r).getBase());
            } else if (r instanceof StaticFieldRef) {
                uses.add(r);
            } else if (r instanceof ArrayRef) {
                uses.add(((ArrayRef)r).getBase());
            }
        }
        ((RWSet)ret).union(ntr);
        if (stmt.containsInvokeExpr() && ((calledMethod = (ie = stmt.getInvokeExpr()).getMethod()).getDeclaringClass().toString().startsWith("java.util") || calledMethod.getDeclaringClass().toString().startsWith("java.lang"))) {
            Local base = null;
            if (ie instanceof InstanceInvokeExpr) {
                base = (Local)((InstanceInvokeExpr)ie).getBase();
            }
            if (this.tlo == null || base == null || !this.tlo.isObjectThreadLocal(base, method)) {
                RWSet r = this.approximatedReadSet(method, stmt, base, true);
                if (r != null) {
                    ((RWSet)ret).union(r);
                }
                int argCount = stmt.getInvokeExpr().getArgCount();
                for (int i = 0; i < argCount; ++i) {
                    uses.add(ie.getArg(i));
                }
                if (base != null) {
                    uses.add(base);
                }
            }
        }
        return ret;
    }

    private RWSet ntWriteSet(SootMethod method, Stmt stmt) {
        if (stmt instanceof AssignStmt) {
            AssignStmt a = (AssignStmt)stmt;
            Value l = a.getLeftOp();
            return this.addValue(l, method, stmt);
        }
        return null;
    }

    public RWSet approximatedWriteSet(SootMethod method, Stmt stmt, Value v, boolean allFields) {
        CodeBlockRWSet ret = new CodeBlockRWSet();
        if (v != null) {
            if (v instanceof Local) {
                List<SootClass> baseClasses;
                SootClass baseTypeClass;
                Local vLocal = (Local)v;
                PointsToSet base = this.pa.reachingObjects(vLocal);
                Type pType = vLocal.getType();
                if (pType instanceof RefType && !(baseTypeClass = ((RefType)pType).getSootClass()).isInterface() && !(baseClasses = Scene.v().getActiveHierarchy().getSuperclassesOfIncluding(baseTypeClass)).contains(RefType.v("java.lang.Exception").getSootClass())) {
                    for (SootClass baseClass : baseClasses) {
                        for (SootField baseField : baseClass.getFields()) {
                            if (baseField.isStatic()) continue;
                            ret.addFieldRef(base, baseField);
                        }
                    }
                }
                if (!allFields) {
                    RWSet normalRW;
                    CodeBlockRWSet allRW = ret;
                    ret = new CodeBlockRWSet();
                    if (this.WCache.containsKey(stmt)) {
                        normalRW = this.WCache.get(stmt);
                    } else {
                        normalRW = this.normalsea.writeSet(method, stmt);
                        this.WCache.put(stmt, normalRW);
                    }
                    if (normalRW != null) {
                        for (Object field : normalRW.getFields()) {
                            if (!allRW.containsField(field)) continue;
                            PointsToSet otherBase = normalRW.getBaseForField(field);
                            if (otherBase instanceof FullObjectSet) {
                                ret.addFieldRef(otherBase, field);
                                continue;
                            }
                            if (!base.hasNonEmptyIntersection(otherBase)) continue;
                            ret.addFieldRef(base, field);
                        }
                    }
                }
            } else if (v instanceof FieldRef) {
                ret.union(this.addValue(v, method, stmt));
            }
        }
        if (stmt instanceof AssignStmt) {
            AssignStmt a = (AssignStmt)stmt;
            Value l = a.getLeftOp();
            ret.union(this.addValue(l, method, stmt));
        }
        return ret;
    }

    public RWSet writeSet(SootMethod method, Stmt stmt, CriticalSection tn, Set uses) {
        InvokeExpr ie;
        SootMethod calledMethod;
        boolean ignore = false;
        if (stmt.containsInvokeExpr()) {
            InvokeExpr ie2 = stmt.getInvokeExpr();
            SootMethod calledMethod2 = ie2.getMethod();
            if (!(ie2 instanceof StaticInvokeExpr) && ie2 instanceof InstanceInvokeExpr) {
                if (calledMethod2.getSubSignature().startsWith("void <init>") && this.eoa.isInitMethodPureOnObject(calledMethod2)) {
                    ignore = true;
                } else if (this.tlo != null && !this.tlo.hasNonThreadLocalEffects(method, ie2)) {
                    ignore = true;
                }
            }
        }
        boolean inaccessibleUses = false;
        CodeBlockRWSet ret = new CodeBlockRWSet();
        this.tve.setExemptTransaction(tn);
        Iterator<MethodOrMethodContext> targets = this.tt.iterator(stmt);
        while (!ignore && targets.hasNext()) {
            RWSet ntw;
            SootMethod target = (SootMethod)targets.next();
            if (!target.isConcrete() || target.getDeclaringClass().toString().startsWith("java.util") || target.getDeclaringClass().toString().startsWith("java.lang") || (ntw = this.nonTransitiveWriteSet(target)) == null) continue;
            ((RWSet)ret).union(ntw);
        }
        RWSet ntw = this.ntWriteSet(method, stmt);
        if (!inaccessibleUses && ntw != null && stmt instanceof AssignStmt) {
            AssignStmt a = (AssignStmt)stmt;
            Value l = a.getLeftOp();
            if (l instanceof InstanceFieldRef) {
                uses.add(((InstanceFieldRef)l).getBase());
            } else if (l instanceof StaticFieldRef) {
                uses.add(l);
            } else if (l instanceof ArrayRef) {
                uses.add(((ArrayRef)l).getBase());
            }
        }
        ((RWSet)ret).union(ntw);
        if (stmt.containsInvokeExpr() && ((calledMethod = (ie = stmt.getInvokeExpr()).getMethod()).getDeclaringClass().toString().startsWith("java.util") || calledMethod.getDeclaringClass().toString().startsWith("java.lang"))) {
            Local base = null;
            if (ie instanceof InstanceInvokeExpr) {
                base = (Local)((InstanceInvokeExpr)ie).getBase();
            }
            if (this.tlo == null || base == null || !this.tlo.isObjectThreadLocal(base, method)) {
                RWSet w = this.approximatedWriteSet(method, stmt, base, true);
                if (w != null) {
                    ((RWSet)ret).union(w);
                }
                if (base != null) {
                    uses.add(base);
                }
            }
        }
        return ret;
    }

    public RWSet valueRWSet(Value v, SootMethod m, Stmt s, CriticalSection tn) {
        InstanceFieldRef ifr;
        RWSet ret = null;
        if (this.tlo != null) {
            if (v instanceof InstanceFieldRef) {
                ifr = (InstanceFieldRef)v;
                if (m.isConcrete() && !m.isStatic() && m.retrieveActiveBody().getThisLocal().equivTo(ifr.getBase()) && this.tlo.isObjectThreadLocal(ifr, m)) {
                    return null;
                }
                if (this.tlo.isObjectThreadLocal(ifr.getBase(), m)) {
                    return null;
                }
            } else if (v instanceof ArrayRef && this.tlo.isObjectThreadLocal(((ArrayRef)v).getBase(), m)) {
                return null;
            }
        }
        if (v instanceof InstanceFieldRef) {
            ifr = (InstanceFieldRef)v;
            PointsToSet base = this.pa.reachingObjects((Local)ifr.getBase());
            ret = new StmtRWSet();
            ret.addFieldRef(base, ifr.getField());
        } else if (v instanceof StaticFieldRef) {
            StaticFieldRef sfr = (StaticFieldRef)v;
            ret = new StmtRWSet();
            ret.addGlobal(sfr.getField());
        } else if (v instanceof ArrayRef) {
            ArrayRef ar = (ArrayRef)v;
            PointsToSet base = this.pa.reachingObjects((Local)ar.getBase());
            ret = new StmtRWSet();
            ret.addFieldRef(base, "ARRAY_ELEMENTS_NODE");
        } else if (v instanceof Local) {
            RWSet wSet;
            Local vLocal = (Local)v;
            PointsToSet base = this.pa.reachingObjects(vLocal);
            ret = new CodeBlockRWSet();
            CodeBlockRWSet stmtRW = new CodeBlockRWSet();
            RWSet rSet = this.readSet(m, s, tn, new HashSet());
            if (rSet != null) {
                stmtRW.union(rSet);
            }
            if ((wSet = this.writeSet(m, s, tn, new HashSet())) != null) {
                stmtRW.union(wSet);
            }
            for (Object field : stmtRW.getFields()) {
                PointsToSet fieldBase = stmtRW.getBaseForField(field);
                if (!base.hasNonEmptyIntersection(fieldBase)) continue;
                ret.addFieldRef(base, field);
            }
        } else {
            return null;
        }
        return ret;
    }

    protected RWSet addValue(Value v, SootMethod m, Stmt s) {
        InstanceFieldRef ifr;
        StmtRWSet ret = null;
        if (this.tlo != null) {
            if (v instanceof InstanceFieldRef) {
                ifr = (InstanceFieldRef)v;
                if (m.isConcrete() && !m.isStatic() && m.retrieveActiveBody().getThisLocal().equivTo(ifr.getBase()) && this.tlo.isObjectThreadLocal(ifr, m)) {
                    return null;
                }
                if (this.tlo.isObjectThreadLocal(ifr.getBase(), m)) {
                    return null;
                }
            } else if (v instanceof ArrayRef && this.tlo.isObjectThreadLocal(((ArrayRef)v).getBase(), m)) {
                return null;
            }
        }
        if (v instanceof InstanceFieldRef) {
            ifr = (InstanceFieldRef)v;
            Local baseLocal = (Local)ifr.getBase();
            PointsToSet base = this.pa.reachingObjects(baseLocal);
            if (baseLocal.getType() instanceof RefType) {
                SootClass baseClass = ((RefType)baseLocal.getType()).getSootClass();
                if (Scene.v().getActiveHierarchy().isClassSubclassOfIncluding(baseClass, RefType.v("java.lang.Exception").getSootClass())) {
                    return null;
                }
            }
            ret = new StmtRWSet();
            ((RWSet)ret).addFieldRef(base, ifr.getField());
        } else if (v instanceof StaticFieldRef) {
            StaticFieldRef sfr = (StaticFieldRef)v;
            ret = new StmtRWSet();
            ((RWSet)ret).addGlobal(sfr.getField());
        } else if (v instanceof ArrayRef) {
            ArrayRef ar = (ArrayRef)v;
            PointsToSet base = this.pa.reachingObjects((Local)ar.getBase());
            ret = new StmtRWSet();
            ((RWSet)ret).addFieldRef(base, "ARRAY_ELEMENTS_NODE");
        }
        return ret;
    }

    public String toString() {
        return "TransactionAwareSideEffectAnalysis: PA=" + this.pa + " CG=" + this.cg;
    }
}

