/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.fast;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.G;
import soot.IntegerType;
import soot.Local;
import soot.LocalGenerator;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NegExpr;
import soot.jimple.NewExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.typing.Util;
import soot.jimple.toolkits.typing.fast.AugEvalFunction;
import soot.jimple.toolkits.typing.fast.AugHierarchy;
import soot.jimple.toolkits.typing.fast.BottomType;
import soot.jimple.toolkits.typing.fast.BytecodeHierarchy;
import soot.jimple.toolkits.typing.fast.DefaultTypingStrategy;
import soot.jimple.toolkits.typing.fast.IEvalFunction;
import soot.jimple.toolkits.typing.fast.IHierarchy;
import soot.jimple.toolkits.typing.fast.ITypingStrategy;
import soot.jimple.toolkits.typing.fast.IUseVisitor;
import soot.jimple.toolkits.typing.fast.Integer127Type;
import soot.jimple.toolkits.typing.fast.Integer1Type;
import soot.jimple.toolkits.typing.fast.Integer32767Type;
import soot.jimple.toolkits.typing.fast.TypePromotionUseVisitor;
import soot.jimple.toolkits.typing.fast.Typing;
import soot.jimple.toolkits.typing.fast.UseChecker;
import soot.jimple.toolkits.typing.fast.WeakObjectType;
import soot.toolkits.scalar.LocalDefs;

public class TypeResolver {
    protected final JimpleBody jb;
    private final List<DefinitionStmt> assignments;
    private final HashMap<Local, BitSet> depends;
    private final LocalGenerator localGenerator;
    final BooleanType booleanType = BooleanType.v();
    final ByteType byteType = ByteType.v();
    final ShortType shortType = ShortType.v();

    public TypeResolver(JimpleBody jb) {
        this.jb = jb;
        this.assignments = new ArrayList<DefinitionStmt>();
        this.depends = new HashMap(jb.getLocalCount());
        this.localGenerator = Scene.v().createLocalGenerator(jb);
        this.initAssignments();
    }

    private void initAssignments() {
        for (Unit stmt : this.jb.getUnits()) {
            if (!(stmt instanceof DefinitionStmt)) continue;
            this.initAssignment((DefinitionStmt)stmt);
        }
    }

    private void initAssignment(DefinitionStmt ds) {
        Value lhs = ds.getLeftOp();
        if (lhs instanceof Local || lhs instanceof ArrayRef) {
            int assignmentIdx = this.assignments.size();
            this.assignments.add(ds);
            Value rhs = ds.getRightOp();
            if (rhs instanceof Local) {
                this.addDepend((Local)rhs, assignmentIdx);
            } else if (rhs instanceof BinopExpr) {
                BinopExpr be = (BinopExpr)rhs;
                Value lop = be.getOp1();
                Value rop = be.getOp2();
                if (lop instanceof Local) {
                    this.addDepend((Local)lop, assignmentIdx);
                }
                if (rop instanceof Local) {
                    this.addDepend((Local)rop, assignmentIdx);
                }
            } else if (rhs instanceof NegExpr) {
                Value op = ((NegExpr)rhs).getOp();
                if (op instanceof Local) {
                    this.addDepend((Local)op, assignmentIdx);
                }
            } else if (rhs instanceof CastExpr) {
                Value op = ((CastExpr)rhs).getOp();
                if (op instanceof Local) {
                    this.addDepend((Local)op, assignmentIdx);
                }
            } else if (rhs instanceof ArrayRef) {
                this.addDepend((Local)((ArrayRef)rhs).getBase(), assignmentIdx);
            }
        }
    }

    private void addDepend(Local v, int stmtIndex) {
        BitSet d = this.depends.get(v);
        if (d == null) {
            d = new BitSet();
            this.depends.put(v, d);
        }
        d.set(stmtIndex);
    }

    public void inferTypes() {
        ITypingStrategy typingStrategy = this.getTypingStrategy();
        AugEvalFunction ef = new AugEvalFunction(this.jb);
        BytecodeHierarchy bh = new BytecodeHierarchy();
        Collection<Typing> sigma = this.applyAssignmentConstraints(typingStrategy.createTyping(this.jb.getLocals()), ef, bh);
        if (sigma.isEmpty()) {
            return;
        }
        int[] castCount = new int[1];
        Typing tg = this.minCasts(sigma, bh, castCount);
        if (castCount[0] != 0) {
            this.split_new();
            sigma = this.applyAssignmentConstraints(typingStrategy.createTyping(this.jb.getLocals()), ef, bh);
            tg = this.minCasts(sigma, bh, castCount);
        }
        this.insertCasts(tg, bh, false);
        BottomType bottom = BottomType.v();
        for (Local v : this.jb.getLocals()) {
            Type t = tg.get(v);
            if (t instanceof IntegerType) {
                tg.set(v, bottom);
            }
            v.setType(t);
        }
        if ((tg = this.typePromotion(tg)) == null) {
            soot.jimple.toolkits.typing.integer.TypeResolver.resolve(this.jb);
        } else {
            for (Local v : this.jb.getLocals()) {
                Type type = tg.get(v);
                v.setType(type);
            }
        }
    }

    protected ITypingStrategy getTypingStrategy() {
        return DefaultTypingStrategy.INSTANCE;
    }

    private Typing typePromotion(Typing tg) {
        boolean conversionsPending;
        do {
            AugEvalFunction ef = new AugEvalFunction(this.jb);
            AugHierarchy h = new AugHierarchy();
            UseChecker uc = new UseChecker(this.jb);
            TypePromotionUseVisitor uv = new TypePromotionUseVisitor(this.jb, tg);
            do {
                Collection<Typing> sigma;
                if ((sigma = this.applyAssignmentConstraints(tg, ef, h)).isEmpty()) {
                    return null;
                }
                tg = sigma.iterator().next();
                uv.typingChanged = false;
                uc.check(tg, uv);
                if (!uv.fail) continue;
                return null;
            } while (uv.typingChanged);
            conversionsPending = false;
            for (Local v : this.jb.getLocals()) {
                Type t = tg.get(v);
                Type r = this.convert(t);
                if (r == null) continue;
                tg.set(v, r);
                conversionsPending = true;
            }
        } while (conversionsPending);
        return tg;
    }

    protected Type convert(Type t) {
        ArrayType r;
        Type cv;
        if (t instanceof Integer1Type) {
            return this.booleanType;
        }
        if (t instanceof Integer127Type) {
            return this.byteType;
        }
        if (t instanceof Integer32767Type) {
            return this.shortType;
        }
        if (t instanceof WeakObjectType) {
            return RefType.v(((WeakObjectType)t).getClassName());
        }
        if (t instanceof ArrayType && (cv = this.convert((r = (ArrayType)t).getElementType())) != null) {
            return ArrayType.v(cv, r.numDimensions);
        }
        return null;
    }

    private int insertCasts(Typing tg, IHierarchy h, boolean countOnly) {
        UseChecker uc = new UseChecker(this.jb);
        CastInsertionUseVisitor uv = this.createCastInsertionUseVisitor(tg, h, countOnly);
        uc.check(tg, uv);
        return uv.getCount();
    }

    protected CastInsertionUseVisitor createCastInsertionUseVisitor(Typing tg, IHierarchy h, boolean countOnly) {
        return new CastInsertionUseVisitor(countOnly, this.jb, tg, h);
    }

    private Typing minCasts(Collection<Typing> sigma, IHierarchy h, int[] count) {
        count[0] = -1;
        Typing r = null;
        for (Typing tg : sigma) {
            int n = this.insertCasts(tg, h, true);
            if (count[0] != -1 && n >= count[0]) continue;
            count[0] = n;
            r = tg;
        }
        return r;
    }

    protected Collection<Typing> applyAssignmentConstraints(Typing tg, IEvalFunction ef, IHierarchy h) {
        int numAssignments = this.assignments.size();
        if (numAssignments == 0) {
            return Collections.emptyList();
        }
        ArrayDeque<WorklistElement> sigma = this.createSigmaQueue();
        List<Typing> r = this.createResultList();
        ITypingStrategy typingStrategy = this.getTypingStrategy();
        BitSet wl = new BitSet(numAssignments);
        wl.set(0, numAssignments);
        sigma.add(new WorklistElement(tg, wl));
        Set<RefType> throwable = null;
        while (!sigma.isEmpty()) {
            WorklistElement element = sigma.element();
            tg = element.typing;
            wl = element.worklist;
            int defIdx = wl.nextSetBit(0);
            if (defIdx == -1) {
                r.add(tg);
                sigma.remove();
                continue;
            }
            wl.clear(defIdx);
            DefinitionStmt stmt = this.assignments.get(defIdx);
            Value lhs = stmt.getLeftOp();
            Local v = lhs instanceof Local ? (Local)lhs : (Local)((ArrayRef)lhs).getBase();
            Type told = tg.get(v);
            boolean isFirstType = true;
            for (Type t_ : ef.eval(tg, stmt.getRightOp(), stmt)) {
                Collection<Type> lcas;
                if (lhs instanceof ArrayRef) {
                    if (!(t_ instanceof RefType) && !(t_ instanceof ArrayType) && !(t_ instanceof WeakObjectType)) continue;
                    t_ = t_.makeArrayType();
                }
                if (!TypeResolver.typesEqual(told, t_) && told instanceof RefType && t_ instanceof RefType && (((RefType)told).getSootClass().isPhantom() || ((RefType)t_).getSootClass().isPhantom()) && stmt.getRightOp() instanceof CaughtExceptionRef) {
                    if (throwable == null) {
                        throwable = Collections.singleton(Scene.v().getBaseExceptionType());
                    }
                    lcas = throwable;
                } else {
                    lcas = h.lcas(told, t_, true);
                }
                for (Type t : lcas) {
                    if (!TypeResolver.typesEqual(t, told)) {
                        BitSet wl_;
                        Typing tg_;
                        BitSet dependsV = this.depends.get(v);
                        if (isFirstType) {
                            tg_ = tg;
                            wl_ = wl;
                        } else {
                            tg_ = typingStrategy.createTyping(tg);
                            wl_ = (BitSet)wl.clone();
                            WorklistElement e = new WorklistElement(tg_, wl_);
                            sigma.add(e);
                        }
                        tg_.set(v, t);
                        if (dependsV != null) {
                            wl_.or(dependsV);
                        }
                    }
                    isFirstType = false;
                }
            }
        }
        typingStrategy.minimize(r, h);
        return r;
    }

    protected ArrayDeque<WorklistElement> createSigmaQueue() {
        return new ArrayDeque<WorklistElement>();
    }

    protected List<Typing> createResultList() {
        return new ArrayList<Typing>();
    }

    public static boolean typesEqual(Type a, Type b) {
        if (a instanceof ArrayType && b instanceof ArrayType) {
            ArrayType a_ = (ArrayType)a;
            ArrayType b_ = (ArrayType)b;
            return a_.numDimensions == b_.numDimensions && a_.baseType.equals(b_.baseType);
        }
        return a.equals(b);
    }

    private void split_new() {
        Jimple jimp = Jimple.v();
        JimpleBody body = this.jb;
        LocalDefs defs = G.v().soot_toolkits_scalar_LocalDefsFactory().newLocalDefs(body);
        UnitPatchingChain units = body.getUnits();
        Iterator it = units.snapshotIterator();
        block0: while (it.hasNext()) {
            Stmt stmt2;
            InvokeExpr invokeExpr;
            Unit stmt = (Unit)it.next();
            if (!(stmt instanceof InvokeStmt) || !((invokeExpr = ((InvokeStmt)stmt).getInvokeExpr()) instanceof SpecialInvokeExpr) || !"<init>".equals(invokeExpr.getMethodRef().getName())) continue;
            SpecialInvokeExpr special = (SpecialInvokeExpr)invokeExpr;
            List<Unit> deflist = defs.getDefsOfAt((Local)special.getBase(), stmt);
            while (deflist.size() == 1 && (stmt2 = (Stmt)deflist.get(0)) instanceof AssignStmt) {
                AssignStmt assign = (AssignStmt)stmt2;
                Value rightOp = assign.getRightOp();
                if (rightOp instanceof Local) {
                    deflist = defs.getDefsOfAt((Local)rightOp, assign);
                    continue;
                }
                if (!(rightOp instanceof NewExpr)) continue block0;
                Local newlocal = this.localGenerator.generateLocal(assign.getLeftOp().getType());
                special.setBase(newlocal);
                AssignStmt assignStmt = jimp.newAssignStmt(assign.getLeftOp(), newlocal);
                units.insertAfter(assignStmt, Util.findLastIdentityUnit(body, assign));
                assign.setLeftOp(newlocal);
                this.initAssignment(assignStmt);
                continue block0;
            }
        }
    }

    static class WorklistElement {
        Typing typing;
        BitSet worklist;

        public WorklistElement(Typing tg, BitSet wl) {
            this.typing = tg;
            this.worklist = wl;
        }

        public String toString() {
            return "Left in worklist: " + this.worklist.size() + ", typing: " + this.typing;
        }
    }

    public class CastInsertionUseVisitor
    implements IUseVisitor {
        protected JimpleBody jb;
        protected Typing tg;
        protected IHierarchy h;
        private final boolean countOnly;
        private int count;

        public CastInsertionUseVisitor(boolean countOnly, JimpleBody jb, Typing tg, IHierarchy h) {
            this.jb = jb;
            this.tg = tg;
            this.h = h;
            this.countOnly = countOnly;
            this.count = 0;
        }

        @Override
        public Value visit(Value op, Type useType, Stmt stmt, boolean checkOnly) {
            Local vold;
            Type baseType;
            Value leftOp;
            Type t = AugEvalFunction.eval_(this.tg, op, stmt, this.jb);
            if (useType == t) {
                return op;
            }
            boolean needCast = false;
            if (useType instanceof PrimType && t instanceof PrimType && t.isAllowedInFinalCode() && useType.isAllowedInFinalCode()) {
                needCast = true;
            }
            if (!needCast && this.h.ancestor(useType, t)) {
                return op;
            }
            ++this.count;
            if (this.countOnly) {
                return op;
            }
            if (stmt.containsArrayRef() && stmt.getArrayRef().getBase() == op && stmt instanceof DefinitionStmt && (leftOp = ((DefinitionStmt)stmt).getLeftOp()) instanceof Local && (baseType = this.tg.get((Local)op)) instanceof RefType && this.isObjectLikeType((RefType)baseType)) {
                this.tg.set((Local)leftOp, ((ArrayType)useType).getElementType());
            }
            if (op instanceof Local) {
                vold = (Local)op;
            } else {
                vold = TypeResolver.this.localGenerator.generateLocal(t);
                this.tg.set(vold, t);
                this.jb.getUnits().insertBefore(Jimple.v().newAssignStmt(vold, op), Util.findFirstNonIdentityUnit(this.jb, stmt));
            }
            return this.createCast(useType, stmt, vold, false);
        }

        private boolean isObjectLikeType(RefType rt) {
            if (rt instanceof WeakObjectType) {
                return true;
            }
            String name = rt.getSootClass().getName();
            return "java.lang.Object".equals(name) || "java.io.Serializable".equals(name) || "java.lang.Cloneable".equals(name);
        }

        protected Local createCast(Type useType, Stmt stmt, Local old, boolean after) {
            Local vnew = TypeResolver.this.localGenerator.generateLocal(useType);
            this.tg.set(vnew, useType);
            Jimple jimple = Jimple.v();
            AssignStmt newStmt = jimple.newAssignStmt(vnew, jimple.newCastExpr(old, useType));
            Unit u = Util.findFirstNonIdentityUnit(this.jb, stmt);
            if (after) {
                this.jb.getUnits().insertAfter(newStmt, u);
            } else {
                this.jb.getUnits().insertBefore(newStmt, u);
            }
            return vnew;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public boolean finish() {
            return false;
        }
    }
}

