/*
 * Decompiled with CFR 0.152.
 */
package soot.util.cfgcmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import soot.Body;
import soot.BriefUnitPrinter;
import soot.Unit;
import soot.toolkits.exceptions.ThrowableSet;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.DominatorNode;
import soot.toolkits.graph.ExceptionalGraph;
import soot.util.dot.DotGraph;
import soot.util.dot.DotGraphAttribute;
import soot.util.dot.DotGraphEdge;
import soot.util.dot.DotGraphNode;

public class CFGToDotGraph {
    private boolean onePage;
    private boolean isBrief;
    private boolean showExceptions;
    private DotGraphAttribute unexceptionalControlFlowAttr;
    private DotGraphAttribute exceptionalControlFlowAttr;
    private DotGraphAttribute exceptionEdgeAttr;
    private DotGraphAttribute headAttr;
    private DotGraphAttribute tailAttr;

    public CFGToDotGraph() {
        this.setOnePage(true);
        this.setBriefLabels(false);
        this.setShowExceptions(true);
        this.setUnexceptionalControlFlowAttr("color", "black");
        this.setExceptionalControlFlowAttr("color", "red");
        this.setExceptionEdgeAttr("color", "lightgray");
        this.setHeadAttr("fillcolor", "gray");
        this.setTailAttr("fillcolor", "lightgray");
    }

    public void setOnePage(boolean onePage) {
        this.onePage = onePage;
    }

    public void setBriefLabels(boolean useBrief) {
        this.isBrief = useBrief;
    }

    public void setShowExceptions(boolean showExceptions) {
        this.showExceptions = showExceptions;
    }

    public void setUnexceptionalControlFlowAttr(String id, String value) {
        this.unexceptionalControlFlowAttr = new DotGraphAttribute(id, value);
    }

    public void setExceptionalControlFlowAttr(String id, String value) {
        this.exceptionalControlFlowAttr = new DotGraphAttribute(id, value);
    }

    public void setExceptionEdgeAttr(String id, String value) {
        this.exceptionEdgeAttr = new DotGraphAttribute(id, value);
    }

    public void setHeadAttr(String id, String value) {
        this.headAttr = new DotGraphAttribute(id, value);
    }

    public void setTailAttr(String id, String value) {
        this.tailAttr = new DotGraphAttribute(id, value);
    }

    private static <T> Iterator<T> sortedIterator(Collection<T> coll, Comparator<? super T> comp) {
        if (coll.size() <= 1) {
            return coll.iterator();
        }
        ArrayList<T> list = new ArrayList<T>(coll);
        Collections.sort(list, comp);
        return list.iterator();
    }

    public <N> DotGraph drawCFG(DirectedGraph<N> graph, Body body) {
        DotGraph canvas = this.initDotGraph(body);
        DotNamer<N> namer = new DotNamer<N>((int)((float)graph.size() / 0.7f), 0.7f);
        NodeComparator comparator = new NodeComparator(namer);
        for (N node : graph) {
            namer.getName(node);
        }
        for (N node : graph) {
            canvas.drawNode(namer.getName(node));
            Iterator<N> succsIt = CFGToDotGraph.sortedIterator(graph.getSuccsOf(node), comparator);
            while (succsIt.hasNext()) {
                N succ = succsIt.next();
                canvas.drawEdge(namer.getName(node), namer.getName(succ));
            }
        }
        this.setStyle(graph.getHeads(), canvas, namer, "filled", this.headAttr);
        this.setStyle(graph.getTails(), canvas, namer, "filled", this.tailAttr);
        if (!this.isBrief) {
            this.formatNodeText(body, canvas, namer);
        }
        return canvas;
    }

    public <N> DotGraph drawCFG(ExceptionalGraph<N> graph) {
        Body body = graph.getBody();
        DotGraph canvas = this.initDotGraph(body);
        DotNamer<N> namer = new DotNamer<N>((int)((float)graph.size() / 0.7f), 0.7f);
        NodeComparator nodeComparator = new NodeComparator(namer);
        for (Object node : graph) {
            namer.getName(node);
        }
        for (Object node : graph) {
            Collection<ExceptionalGraph.ExceptionDest<N>> exDests;
            DotGraphEdge edge;
            N succ;
            canvas.drawNode(namer.getName(node));
            Iterator<N> succsIt = CFGToDotGraph.sortedIterator(graph.getUnexceptionalSuccsOf(node), nodeComparator);
            while (succsIt.hasNext()) {
                succ = succsIt.next();
                edge = canvas.drawEdge(namer.getName(node), namer.getName(succ));
                edge.setAttribute(this.unexceptionalControlFlowAttr);
            }
            succsIt = CFGToDotGraph.sortedIterator(graph.getExceptionalSuccsOf(node), nodeComparator);
            while (succsIt.hasNext()) {
                succ = succsIt.next();
                edge = canvas.drawEdge(namer.getName(node), namer.getName(succ));
                edge.setAttribute(this.exceptionalControlFlowAttr);
            }
            if (!this.showExceptions || (exDests = graph.getExceptionDests(node)) == null) continue;
            ExceptionDestComparator comp = new ExceptionDestComparator(namer);
            Iterator<ExceptionalGraph.ExceptionDest<N>> destsIt = CFGToDotGraph.sortedIterator(exDests, comp);
            while (destsIt.hasNext()) {
                ExceptionalGraph.ExceptionDest<N> dest = destsIt.next();
                Object handlerStart = dest.getHandlerNode();
                if (handlerStart == null) {
                    handlerStart = new Object(){

                        public String toString() {
                            return "Esc";
                        }
                    };
                    DotGraphNode escapeNode = canvas.drawNode(namer.getName(handlerStart));
                    escapeNode.setStyle("invis");
                }
                DotGraphEdge edge2 = canvas.drawEdge(namer.getName(node), namer.getName(handlerStart));
                edge2.setAttribute(this.exceptionEdgeAttr);
                edge2.setLabel(this.formatThrowableSet(dest.getThrowables()));
            }
        }
        this.setStyle(graph.getHeads(), canvas, namer, "filled", this.headAttr);
        this.setStyle(graph.getTails(), canvas, namer, "filled", this.tailAttr);
        if (!this.isBrief) {
            this.formatNodeText(graph.getBody(), canvas, namer);
        }
        return canvas;
    }

    private DotGraph initDotGraph(Body body) {
        String graphname = "cfg";
        if (body != null) {
            graphname = body.getMethod().getSubSignature();
        }
        DotGraph canvas = new DotGraph(graphname);
        canvas.setGraphLabel(graphname);
        if (!this.onePage) {
            canvas.setPageSize(8.5, 11.0);
        }
        if (this.isBrief) {
            canvas.setNodeShape("circle");
        } else {
            canvas.setNodeShape("box");
        }
        return canvas;
    }

    private <N> void formatNodeText(Body body, DotGraph canvas, DotNamer<N> namer) {
        BriefUnitPrinter printer = null;
        if (body != null) {
            printer = new BriefUnitPrinter(body);
            printer.noIndent();
        }
        for (Object node : namer.keySet()) {
            String nodeLabel;
            DotGraphNode dotnode = canvas.getNode(namer.getName(node));
            if (node instanceof DominatorNode) {
                DominatorNode n = (DominatorNode)node;
                node = n.getGode();
            }
            if (printer == null) {
                nodeLabel = node.toString();
            } else if (node instanceof Unit) {
                Unit nodeUnit = (Unit)node;
                nodeUnit.toString(printer);
                String targetLabel = printer.labels().get(nodeUnit);
                nodeLabel = targetLabel == null ? printer.toString() : targetLabel + ": " + printer.toString();
            } else if (node instanceof Block) {
                Block block = (Block)node;
                StringBuilder buffer = new StringBuilder();
                buffer.append(block.toShortString()).append("\\n");
                for (Unit unit : block) {
                    String targetLabel = printer.labels().get(unit);
                    if (targetLabel != null) {
                        buffer.append(targetLabel).append(":\\n");
                    }
                    unit.toString(printer);
                    buffer.append(printer.toString()).append("\\l");
                }
                nodeLabel = buffer.toString();
            } else {
                nodeLabel = node.toString();
            }
            dotnode.setLabel(nodeLabel);
        }
    }

    private <N> void setStyle(Collection<? extends N> objects, DotGraph canvas, DotNamer<N> namer, String style, DotGraphAttribute attrib) {
        for (N object : objects) {
            DotGraphNode objectNode = canvas.getNode(namer.getName(object));
            objectNode.setStyle(style);
            objectNode.setAttribute(attrib);
        }
    }

    private String formatThrowableSet(ThrowableSet set) {
        String input = set.toAbbreviatedString();
        int inputLength = input.length();
        StringBuilder result = new StringBuilder(inputLength + 5);
        for (int i = 0; i < inputLength; ++i) {
            char c = input.charAt(i);
            if (c == '+' || c == '-') {
                result.append("\\l");
            }
            result.append(c);
        }
        return result.toString();
    }

    private static class DotNamer<N>
    extends HashMap<N, Integer> {
        private int nodecount = 0;

        DotNamer(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        String getName(N node) {
            Integer index = (Integer)this.get(node);
            if (index == null) {
                index = this.nodecount++;
                this.put(node, index);
            }
            return index.toString();
        }

        int getNumber(N node) {
            Integer index = (Integer)this.get(node);
            if (index == null) {
                index = this.nodecount++;
                this.put(node, index);
            }
            return index;
        }
    }

    private static class ExceptionDestComparator<T>
    implements Comparator<ExceptionalGraph.ExceptionDest<T>> {
        private final DotNamer<T> namer;

        ExceptionDestComparator(DotNamer<T> namer) {
            this.namer = namer;
        }

        private int getValue(ExceptionalGraph.ExceptionDest<T> o) {
            T handler = o.getHandlerNode();
            if (handler == null) {
                return Integer.MAX_VALUE;
            }
            return this.namer.getNumber(handler);
        }

        @Override
        public int compare(ExceptionalGraph.ExceptionDest<T> o1, ExceptionalGraph.ExceptionDest<T> o2) {
            return this.getValue(o1) - this.getValue(o2);
        }

        public boolean equal(ExceptionalGraph.ExceptionDest<T> o1, ExceptionalGraph.ExceptionDest<T> o2) {
            return this.getValue(o1) == this.getValue(o2);
        }
    }

    private static class NodeComparator<T>
    implements Comparator<T> {
        private final DotNamer<T> namer;

        NodeComparator(DotNamer<T> namer) {
            this.namer = namer;
        }

        @Override
        public int compare(T o1, T o2) {
            return this.namer.getNumber(o1) - this.namer.getNumber(o2);
        }

        public boolean equal(T o1, T o2) {
            return this.namer.getNumber(o1) == this.namer.getNumber(o2);
        }
    }
}

