/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ConflictingFieldRefException;
import soot.ResolutionFailedException;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.Type;
import soot.options.Options;

public class AbstractSootFieldRef
implements SootFieldRef {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSootFieldRef.class);
    private final SootClass declaringClass;
    private final String name;
    private final Type type;
    private final boolean isStatic;

    public AbstractSootFieldRef(SootClass declaringClass, String name, Type type, boolean isStatic) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.type = type;
        this.isStatic = isStatic;
        if (declaringClass == null) {
            throw new RuntimeException("Attempt to create SootFieldRef with null class");
        }
        if (name == null) {
            throw new RuntimeException("Attempt to create SootFieldRef with null name");
        }
        if (type == null) {
            throw new RuntimeException("Attempt to create SootFieldRef with null type");
        }
    }

    @Override
    public SootClass declaringClass() {
        return this.declaringClass;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public String getSignature() {
        return SootField.getSignature(this.declaringClass, this.name, this.type);
    }

    @Override
    public SootField resolve() {
        return this.resolve(null);
    }

    private SootField checkStatic(SootField ret) {
        if (!(Options.v().wrong_staticness() != 1 && Options.v().wrong_staticness() != 4 || ret.isStatic() == this.isStatic() || ret.isPhantom())) {
            throw new ResolutionFailedException("Resolved " + this + " to " + ret + " which has wrong static-ness");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SootField resolve(StringBuffer trace) {
        SootClass sootClass;
        SootClass cl = this.declaringClass;
        while (true) {
            SootClass iface;
            SootField clField;
            if (trace != null) {
                trace.append("Looking in " + cl + " which has fields " + cl.getFields() + "\n");
            }
            if ((clField = cl.getFieldUnsafe(this.name, this.type)) != null) {
                return this.checkStatic(clField);
            }
            if (Scene.v().allowsPhantomRefs() && cl.isPhantom()) {
                sootClass = cl;
                synchronized (sootClass) {
                    clField = cl.getFieldUnsafe(this.name, this.type);
                    if (clField != null) {
                        return this.checkStatic(clField);
                    }
                    SootField existingField = cl.getFieldByNameUnsafe(this.name);
                    if (existingField != null) {
                        return this.handleFieldTypeMismatch(clField);
                    }
                    SootField f = Scene.v().makeSootField(this.name, this.type, this.isStatic() ? 8 : 0);
                    f.setPhantom(true);
                    cl.addField(f);
                    return f;
                }
            }
            ArrayDeque<SootClass> queue = new ArrayDeque<SootClass>();
            queue.addAll(cl.getInterfaces());
            while ((iface = (SootClass)queue.poll()) != null) {
                SootField ifaceField;
                if (trace != null) {
                    trace.append("Looking in " + iface + " which has fields " + iface.getFields() + "\n");
                }
                if ((ifaceField = iface.getFieldUnsafe(this.name, this.type)) != null) {
                    return this.checkStatic(ifaceField);
                }
                queue.addAll(iface.getInterfaces());
            }
            if (!cl.hasSuperclass()) break;
            cl = cl.getSuperclass();
        }
        if (Options.v().allow_phantom_refs()) {
            SootField sf = Scene.v().makeSootField(this.name, this.type, this.isStatic ? 8 : 0);
            sf.setPhantom(true);
            sootClass = this.declaringClass;
            synchronized (sootClass) {
                SootField clField = this.declaringClass.getFieldByNameUnsafe(this.name);
                if (clField != null) {
                    if (clField.getType().equals(this.type)) {
                        return this.checkStatic(clField);
                    }
                    return this.handleFieldTypeMismatch(clField);
                }
                this.declaringClass.addField(sf);
                return sf;
            }
        }
        if (trace == null) {
            FieldResolutionFailedException e = new FieldResolutionFailedException();
            if (Options.v().ignore_resolution_errors()) {
                logger.debug("" + e.getMessage());
            } else {
                throw e;
            }
        }
        return null;
    }

    protected SootField handleFieldTypeMismatch(SootField clField) {
        switch (Options.v().field_type_mismatches()) {
            case 1: {
                throw new ConflictingFieldRefException(clField, this.type);
            }
            case 2: {
                return this.checkStatic(clField);
            }
            case 3: {
                return null;
            }
        }
        throw new RuntimeException(String.format("Unsupported option for handling field type mismatches: %d", Options.v().field_type_mismatches()));
    }

    public String toString() {
        return this.getSignature();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
        result = 31 * result + (this.isStatic ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSootFieldRef other = (AbstractSootFieldRef)obj;
        if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        if (this.isStatic != other.isStatic) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public class FieldResolutionFailedException
    extends ResolutionFailedException {
        private static final long serialVersionUID = -4657113720516199499L;

        public FieldResolutionFailedException() {
            super("Class " + AbstractSootFieldRef.this.declaringClass + " doesn't have field " + AbstractSootFieldRef.this.name + " : " + AbstractSootFieldRef.this.type + "; failed to resolve in superclasses and interfaces");
        }

        @Override
        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append(super.toString());
            AbstractSootFieldRef.this.resolve(ret);
            return ret.toString();
        }
    }
}

