/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.MagicNumberFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pxb.android.axml.AxmlReader;
import pxb.android.axml.AxmlVisitor;
import pxb.android.axml.NodeVisitor;
import soot.AbstractSootFieldRef;
import soot.AndroidPlatformException;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.ClassSource;
import soot.DoubleType;
import soot.EntryPoints;
import soot.FastHierarchy;
import soot.FloatType;
import soot.G;
import soot.Hierarchy;
import soot.IntType;
import soot.Local;
import soot.LocalGenerator;
import soot.LongType;
import soot.PhaseOptions;
import soot.PointsToAnalysis;
import soot.PolymorphicMethodRef;
import soot.RefType;
import soot.ShortType;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.SootMethodRefImpl;
import soot.SootResolver;
import soot.SourceLocator;
import soot.Type;
import soot.VoidType;
import soot.dexpler.DalvikThrowAnalysis;
import soot.dotnet.exceptiontoolkits.DotnetThrowAnalysis;
import soot.javaToJimple.DefaultLocalGenerator;
import soot.jimple.spark.internal.ClientAccessibilityOracle;
import soot.jimple.spark.internal.PublicAndProtectedAccessibility;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.ContextSensitiveCallGraph;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.pointer.DumbPointerAnalysis;
import soot.jimple.toolkits.pointer.SideEffectAnalysis;
import soot.jimple.toolkits.scalar.DefaultLocalCreation;
import soot.jimple.toolkits.scalar.LocalCreation;
import soot.options.CGOptions;
import soot.options.Options;
import soot.toolkits.exceptions.PedanticThrowAnalysis;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.exceptions.UnitThrowAnalysis;
import soot.util.ArrayNumberer;
import soot.util.Chain;
import soot.util.HashChain;
import soot.util.IterableNumberer;
import soot.util.StringNumberer;

public class Scene {
    private static final Logger logger = LoggerFactory.getLogger(Scene.class);
    private static final int defaultSdkVersion = 15;
    private static final Pattern arrayPattern = Pattern.compile("([^\\[\\]]*)(.*)");
    protected final Map<String, RefType> nameToClass = new ConcurrentHashMap<String, RefType>();
    protected final Set<String> reservedNames = new HashSet<String>();
    protected final Set<String>[] basicclasses = new Set[4];
    protected Chain<SootClass> classes = new HashChain<SootClass>();
    protected Chain<SootClass> applicationClasses = new HashChain<SootClass>();
    protected Chain<SootClass> libraryClasses = new HashChain<SootClass>();
    protected Chain<SootClass> phantomClasses = new HashChain<SootClass>();
    protected IterableNumberer<Type> typeNumberer = new ArrayNumberer<Type>();
    protected StringNumberer subSigNumberer = new StringNumberer();
    protected Hierarchy activeHierarchy;
    protected FastHierarchy activeFastHierarchy;
    protected SideEffectAnalysis activeSideEffectAnalysis;
    protected PointsToAnalysis activePointsToAnalysis;
    protected CallGraph activeCallGraph;
    protected ReachableMethods reachableMethods;
    protected List<SootMethod> entryPoints;
    protected ContextSensitiveCallGraph cscg;
    protected ClientAccessibilityOracle accessibilityOracle;
    protected String sootClassPath;
    protected List<SootClass> dynamicClasses;
    protected LinkedList<String> excludedPackages;
    protected boolean allowsPhantomRefs = false;
    protected SootClass mainClass;
    protected boolean incrementalBuild = false;
    protected boolean doneResolving = false;
    private ThrowAnalysis defaultThrowAnalysis;
    private List<String> pkgList;
    private int stateCount = 0;
    private final Map<String, Integer> maxAPIs = new HashMap<String, Integer>();
    private AndroidVersionInfo androidSDKVersionInfo;
    private int androidAPIVersion = -1;

    public Scene(Singletons.Global g) {
        this.setReservedNames();
        String scp = System.getProperty("soot.class.path");
        if (scp != null) {
            this.setSootClassPath(scp);
        }
        if (Options.v().src_prec() == 7) {
            this.addSootBasicDotnetClasses();
        } else {
            this.addSootBasicClasses();
            this.determineExcludedPackages();
        }
    }

    public static Scene v() {
        G g = G.v();
        if (g.soot_ModuleUtil().isInModuleMode()) {
            return g.soot_ModuleScene();
        }
        return g.soot_Scene();
    }

    private void determineExcludedPackages() {
        int fmt;
        Options options = Options.v();
        List<String> exclude = options.exclude();
        LinkedList<Object> excludedPackages = exclude == null ? new LinkedList() : new LinkedList<String>(exclude);
        if (!options.include_all() && (fmt = options.output_format()) != 10 && fmt != 11) {
            excludedPackages.add("java.*");
            excludedPackages.add("sun.*");
            excludedPackages.add("javax.*");
            excludedPackages.add("com.sun.*");
            excludedPackages.add("com.ibm.*");
            excludedPackages.add("org.xml.*");
            excludedPackages.add("org.w3c.*");
            excludedPackages.add("apple.awt.*");
            excludedPackages.add("com.apple.*");
        }
        this.excludedPackages = excludedPackages;
    }

    public void setMainClass(SootClass m) {
        this.mainClass = m;
        if (!m.declaresMethod(this.getSubSigNumberer().findOrAdd("void main(java.lang.String[])")) && !m.declaresMethod(this.getSubSigNumberer().findOrAdd("void Main(System.String[])"))) {
            throw new RuntimeException("Main-class has no main method!");
        }
    }

    public Set<String> getReservedNames() {
        return this.reservedNames;
    }

    public String quotedNameOf(String s) {
        boolean found;
        boolean bl = found = s.indexOf(45) > -1;
        if (!found) {
            for (String token : this.reservedNames) {
                if (!s.contains(token)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            return s;
        }
        StringBuilder res = new StringBuilder(s.length());
        for (String part : s.split("\\.")) {
            if (res.length() > 0) {
                res.append('.');
            }
            if (!part.isEmpty() && part.charAt(0) == '-' || this.reservedNames.contains(part)) {
                res.append('\'').append(part).append('\'');
                continue;
            }
            res.append(part);
        }
        return res.toString();
    }

    public static String unescapeName(String s) {
        if (s.indexOf(39) < 0) {
            return s;
        }
        StringBuilder res = new StringBuilder(s.length());
        for (String part : s.split("\\.")) {
            int len;
            if (res.length() > 0) {
                res.append('.');
            }
            if ((len = part.length()) > 1 && part.charAt(0) == '\'' && part.charAt(len - 1) == '\'') {
                res.append(part.substring(1, len - 1));
                continue;
            }
            res.append(part);
        }
        return res.toString();
    }

    public boolean hasMainClass() {
        if (this.mainClass == null) {
            this.setMainClassFromOptions();
        }
        return this.mainClass != null;
    }

    public SootClass getMainClass() {
        if (!this.hasMainClass()) {
            throw new RuntimeException("There is no main class set!");
        }
        return this.mainClass;
    }

    public SootMethod getMainMethod() {
        SootMethod mainMethod;
        if (!this.hasMainClass()) {
            throw new RuntimeException("There is no main class set!");
        }
        SootMethod sootMethod = mainMethod = Options.v().src_prec() != 7 ? this.mainClass.getMethodUnsafe("main", Collections.singletonList(ArrayType.v(RefType.v("java.lang.String"), 1)), VoidType.v()) : this.mainClass.getMethodUnsafe("Main", Collections.singletonList(ArrayType.v(RefType.v("System.String"), 1)), VoidType.v());
        if (mainMethod == null) {
            throw new RuntimeException("Main class declares no main method!");
        }
        return mainMethod;
    }

    public void setSootClassPath(String p) {
        this.sootClassPath = p;
        SourceLocator.v().invalidateClassPath();
    }

    public void extendSootClassPath(String newPathElement) {
        this.sootClassPath = this.sootClassPath == null ? newPathElement : this.sootClassPath + File.pathSeparatorChar + newPathElement;
        SourceLocator.v().extendClassPath(newPathElement);
    }

    public void reset() {
        this.sootClassPath = null;
    }

    public String getSootClassPath() {
        if (this.sootClassPath == null) {
            String cp = Options.v().soot_classpath();
            if (cp == null || cp.isEmpty()) {
                cp = this.defaultClassPath();
            } else if (Options.v().prepend_classpath()) {
                cp = cp + File.pathSeparatorChar + this.defaultClassPath();
            }
            LinkedList<String> dirs = new LinkedList<String>();
            dirs.addAll(Options.v().process_dir());
            List<String> jarDirs = Options.v().process_jar_dir();
            if (!jarDirs.isEmpty()) {
                for (String jarDirName : jarDirs) {
                    File[] contents;
                    File jarDir = new File(jarDirName);
                    for (File f : contents = jarDir.listFiles()) {
                        if (!f.getAbsolutePath().endsWith(".jar")) continue;
                        dirs.add(f.getAbsolutePath());
                    }
                }
            }
            if (!dirs.isEmpty()) {
                StringBuilder pds = new StringBuilder();
                for (String path : dirs) {
                    if (cp.contains(path)) continue;
                    path = path.replaceAll("(?<!\\\\)" + Pattern.quote(File.pathSeparator), "\\\\" + File.pathSeparator);
                    pds.append(path).append(File.pathSeparatorChar);
                }
                cp = pds.append(cp).toString();
            }
            this.sootClassPath = cp;
        }
        return this.sootClassPath;
    }

    private int getMaxAPIAvailable(String dir) {
        Integer mapi = this.maxAPIs.get(dir);
        if (mapi != null) {
            return mapi;
        }
        File d = new File(dir);
        if (!d.exists()) {
            throw new AndroidPlatformException(String.format("The Android platform directory you have specified (%s) does not exist. Please check.", dir));
        }
        File[] files = d.listFiles();
        if (files == null) {
            return -1;
        }
        int maxApi = -1;
        for (File f : files) {
            String name = f.getName();
            if (!f.isDirectory() || !name.startsWith("android-")) continue;
            try {
                int v = Integer.decode(name.split("android-")[1]);
                if (v <= maxApi) continue;
                maxApi = v;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.maxAPIs.put(dir, maxApi);
        return maxApi;
    }

    public String getAndroidJarPath(String jars, String apk) {
        int APIVersion = this.getAndroidAPIVersion(jars, apk);
        String jarPath = jars + File.separatorChar + "android-" + APIVersion + File.separatorChar + "android.jar";
        File f = new File(jarPath);
        if (!f.isFile()) {
            throw new AndroidPlatformException(String.format("error: target android.jar %s does not exist.", jarPath));
        }
        return jarPath;
    }

    public int getAndroidAPIVersion() {
        return this.androidAPIVersion > 0 ? this.androidAPIVersion : (Options.v().android_api_version() > 0 ? Options.v().android_api_version() : 15);
    }

    private int getAndroidAPIVersion(String jars, String apk) {
        String jarPath;
        if (this.androidAPIVersion > 0) {
            return this.androidAPIVersion;
        }
        File jarsF = new File(jars);
        if (!jarsF.exists()) {
            throw new AndroidPlatformException(String.format("Android platform directory '%s' does not exist!", jarsF.getAbsolutePath()));
        }
        if (apk != null && !new File(apk).exists()) {
            throw new RuntimeException("file '" + apk + "' does not exist!");
        }
        this.androidAPIVersion = 15;
        if (Options.v().android_api_version() > 0) {
            this.androidAPIVersion = Options.v().android_api_version();
        } else if (apk != null && apk.toLowerCase().endsWith(".apk")) {
            this.androidAPIVersion = this.getTargetSDKVersion(apk, jars);
        }
        int maxAPI = this.getMaxAPIAvailable(jars);
        if (maxAPI > 0 && this.androidAPIVersion > maxAPI) {
            this.androidAPIVersion = maxAPI;
        }
        while (this.androidAPIVersion < maxAPI && !new File(jarPath = jars + File.separatorChar + "android-" + this.androidAPIVersion + File.separatorChar + "android.jar").exists()) {
            ++this.androidAPIVersion;
        }
        return this.androidAPIVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTargetSDKVersion(String apkFile, String platformJARs) {
        ZipFile archive = null;
        try {
            InputStream manifestIS = null;
            try {
                archive = new ZipFile(apkFile);
                Enumeration<? extends ZipEntry> entries = archive.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!"AndroidManifest.xml".equals(entry.getName())) continue;
                    manifestIS = archive.getInputStream(entry);
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error when looking for manifest in apk: " + e);
            }
            if (manifestIS == null) {
                logger.debug("Could not find sdk version in Android manifest! Using default: 15");
                int e = 15;
                return e;
            }
            this.androidSDKVersionInfo = AndroidVersionInfo.get(manifestIS);
        }
        finally {
            if (archive != null) {
                try {
                    archive.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error when looking for manifest in apk: " + e);
                }
            }
        }
        int maxAPI = this.getMaxAPIAvailable(platformJARs);
        int APIVersion = -1;
        if (this.androidSDKVersionInfo.sdkTargetVersion != -1) {
            if (this.androidSDKVersionInfo.sdkTargetVersion > maxAPI && this.androidSDKVersionInfo.minSdkVersion != -1 && this.androidSDKVersionInfo.minSdkVersion <= maxAPI) {
                logger.warn("Android API version '" + this.androidSDKVersionInfo.sdkTargetVersion + "' not available, using minApkVersion '" + this.androidSDKVersionInfo.minSdkVersion + "' instead");
                APIVersion = this.androidSDKVersionInfo.minSdkVersion;
            } else {
                APIVersion = this.androidSDKVersionInfo.sdkTargetVersion;
            }
        } else if (this.androidSDKVersionInfo.platformBuildVersionCode != -1) {
            if (this.androidSDKVersionInfo.platformBuildVersionCode > maxAPI && this.androidSDKVersionInfo.minSdkVersion != -1 && this.androidSDKVersionInfo.minSdkVersion <= maxAPI) {
                logger.warn("Android API version '" + this.androidSDKVersionInfo.platformBuildVersionCode + "' not available, using minApkVersion '" + this.androidSDKVersionInfo.minSdkVersion + "' instead");
                APIVersion = this.androidSDKVersionInfo.minSdkVersion;
            } else {
                APIVersion = this.androidSDKVersionInfo.platformBuildVersionCode;
            }
        } else if (this.androidSDKVersionInfo.minSdkVersion != -1) {
            APIVersion = this.androidSDKVersionInfo.minSdkVersion;
        } else {
            logger.debug("Could not find sdk version in Android manifest! Using default: 15");
            APIVersion = 15;
        }
        if (APIVersion <= 2) {
            APIVersion = 3;
        }
        return APIVersion;
    }

    public AndroidVersionInfo getAndroidSDKVersionInfo() {
        return this.androidSDKVersionInfo;
    }

    public String defaultClassPath() {
        if (Options.v().src_prec() != 5) {
            String path;
            for (String entry : Options.v().process_dir()) {
                if (!entry.toLowerCase().endsWith(".apk")) continue;
                System.err.println("APK file on process dir, but chosen src-prec does not support loading APKs");
                break;
            }
            if ((path = Scene.defaultJavaClassPath()) == null) {
                throw new RuntimeException("Error: cannot find rt.jar.");
            }
            return path;
        }
        return this.defaultAndroidClassPath();
    }

    private String defaultAndroidClassPath() {
        String androidJars = Options.v().android_jars();
        String forceAndroidJar = Options.v().force_android_jar();
        if ((androidJars == null || androidJars.isEmpty()) && (forceAndroidJar == null || forceAndroidJar.isEmpty())) {
            throw new RuntimeException("You are analyzing an Android application but did not define android.jar. Options -android-jars or -force-android-jar should be used.");
        }
        String jarPath = "";
        if (forceAndroidJar != null && !forceAndroidJar.isEmpty()) {
            jarPath = forceAndroidJar;
            if (Options.v().android_api_version() > 0) {
                this.androidAPIVersion = Options.v().android_api_version();
            } else if (forceAndroidJar.contains("android-")) {
                Pattern pt = Pattern.compile("\\" + File.separatorChar + "android-(\\d+)\\" + File.separatorChar);
                Matcher m = pt.matcher(forceAndroidJar);
                if (m.find()) {
                    this.androidAPIVersion = Integer.valueOf(m.group(1));
                }
            } else {
                this.androidAPIVersion = 15;
            }
        } else if (androidJars != null && !androidJars.isEmpty()) {
            ArrayList<String> classPathEntries = new ArrayList<String>(Arrays.asList(Options.v().soot_classpath().split(File.pathSeparator)));
            classPathEntries.addAll(Options.v().process_dir());
            String targetApk = "";
            HashSet<String> targetDexs = new HashSet<String>();
            for (String entry : classPathEntries) {
                if (Scene.isApk(new File(entry))) {
                    if (targetApk != null && !targetApk.isEmpty()) {
                        throw new RuntimeException("only one Android application can be analyzed when using option -android-jars.");
                    }
                    targetApk = entry;
                }
                if (!entry.toLowerCase().endsWith(".dex")) continue;
                targetDexs.add(entry);
            }
            if (targetApk == null || targetApk.isEmpty()) {
                if (targetDexs.isEmpty()) {
                    throw new RuntimeException("no apk file given");
                }
                jarPath = this.getAndroidJarPath(androidJars, null);
            } else {
                jarPath = this.getAndroidJarPath(androidJars, targetApk);
            }
        }
        if (jarPath.isEmpty()) {
            throw new RuntimeException("android.jar not found.");
        }
        File f = new File(jarPath);
        if (!f.exists()) {
            throw new RuntimeException("file '" + jarPath + "' does not exist!");
        }
        logger.debug("Using '" + jarPath + "' as android.jar");
        return jarPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isApk(File apk) {
        MagicNumberFileFilter apkFilter = new MagicNumberFileFilter(new byte[]{80, 75});
        if (!apkFilter.accept(apk)) {
            return false;
        }
        try (ZipFile zf = new ZipFile(apk);){
            ZipEntry z;
            Enumeration<? extends ZipEntry> en = zf.entries();
            do {
                if (!en.hasMoreElements()) return false;
            } while (!"classes.dex".equals((z = en.nextElement()).getName()));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean isJavaGEQ9(String version) {
        try {
            String[] elements;
            Integer firstVersionDigest;
            int idx = version.indexOf(45);
            if (idx > 0) {
                version = version.substring(0, idx);
            }
            if ((firstVersionDigest = Integer.valueOf((elements = version.split("\\."))[0])) >= 9) {
                return true;
            }
            if (firstVersionDigest == 1 && elements.length > 1) {
                return Integer.valueOf(elements[1]) >= 9;
            }
            throw new IllegalArgumentException(String.format("Unknown Version number schema %s", version));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("Unknown Version number schema %s", version), ex);
        }
    }

    public static String defaultJavaClassPath() {
        boolean javaGEQ9;
        String javaHome = System.getProperty("java.home");
        StringBuilder sb = new StringBuilder();
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            File uiJar;
            String prefix = javaHome + File.separatorChar + ".." + File.separatorChar + "Classes" + File.separatorChar;
            File classesJar = new File(prefix + "classes.jar");
            if (classesJar.exists()) {
                sb.append(classesJar.getAbsolutePath()).append(File.pathSeparatorChar);
            }
            if ((uiJar = new File(prefix + "ui.jar")).exists()) {
                sb.append(uiJar.getAbsolutePath()).append(File.pathSeparatorChar);
            }
        }
        if (javaGEQ9 = Scene.isJavaGEQ9(System.getProperty("java.version"))) {
            sb.append("VIRTUAL_FS_FOR_JDK");
            Scene.v().addBasicClass("java.lang.invoke.StringConcatFactory");
        } else {
            File rtJar = new File(javaHome + File.separatorChar + "lib" + File.separatorChar + "rt.jar");
            if (rtJar.exists() && rtJar.isFile()) {
                sb.append(rtJar.getAbsolutePath());
            } else {
                rtJar = new File(javaHome + File.separatorChar + "jre" + File.separatorChar + "lib" + File.separatorChar + "rt.jar");
                if (rtJar.exists() && rtJar.isFile()) {
                    sb.append(rtJar.getAbsolutePath());
                } else {
                    return null;
                }
            }
        }
        if (!javaGEQ9 && (Options.v().whole_program() || Options.v().whole_shimple() || Options.v().output_format() == 15)) {
            sb.append(File.pathSeparatorChar).append(javaHome).append(File.separatorChar).append("lib").append(File.separatorChar).append("jce.jar");
        }
        return sb.toString();
    }

    public int getState() {
        return this.stateCount;
    }

    protected synchronized void modifyHierarchy() {
        ++this.stateCount;
        this.activeHierarchy = null;
        this.activeFastHierarchy = null;
        this.activeSideEffectAnalysis = null;
        this.activePointsToAnalysis = null;
    }

    public void addClass(SootClass c) {
        this.addClassSilent(c);
        c.setLibraryClass();
        this.modifyHierarchy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addClassSilent(SootClass c) {
        SootClass sootClass = c;
        synchronized (sootClass) {
            if (c.isInScene()) {
                throw new RuntimeException("already managed: " + c.getName());
            }
            if (this.containsClass(c.getName())) {
                throw new RuntimeException("duplicate class: " + c.getName());
            }
            this.classes.add(c);
            c.getType().setSootClass(c);
            c.setInScene(true);
            if (!c.isPhantom) {
                this.modifyHierarchy();
            }
            this.nameToClass.computeIfAbsent(c.getName(), k -> c.getType());
        }
    }

    public void removeClass(SootClass c) {
        if (!c.isInScene()) {
            throw new RuntimeException();
        }
        this.classes.remove(c);
        if (c.isLibraryClass()) {
            this.libraryClasses.remove(c);
        } else if (c.isPhantomClass()) {
            this.phantomClasses.remove(c);
        } else if (c.isApplicationClass()) {
            this.applicationClasses.remove(c);
        }
        c.getType().setSootClass(null);
        c.setInScene(false);
        this.modifyHierarchy();
    }

    public boolean containsClass(String className) {
        RefType type = this.nameToClass.get(className);
        return type != null && type.hasSootClass() && type.getSootClass().isInScene();
    }

    public boolean containsType(String className) {
        return this.nameToClass.containsKey(className);
    }

    private static int signatureSeparatorIndex(String sig) {
        int len = sig.length();
        if (len < 3 || sig.charAt(0) != '<' || sig.charAt(len - 1) != '>') {
            throw new RuntimeException("oops " + sig);
        }
        int index = sig.indexOf(58);
        if (index < 0) {
            throw new RuntimeException("oops " + sig);
        }
        return index;
    }

    private static String sepIndexToClass(String sig, int index) {
        return Scene.unescapeName(sig.substring(1, index));
    }

    private static String sepIndexToSubsignature(String sig, int index) {
        return sig.substring(index + 2, sig.length() - 1);
    }

    public static String signatureToClass(String sig) {
        return Scene.sepIndexToClass(sig, Scene.signatureSeparatorIndex(sig));
    }

    public static String signatureToSubsignature(String sig) {
        return Scene.sepIndexToSubsignature(sig, Scene.signatureSeparatorIndex(sig));
    }

    public SootField grabField(String fieldSignature) {
        int index = Scene.signatureSeparatorIndex(fieldSignature);
        String cname = Scene.sepIndexToClass(fieldSignature, index);
        if (!this.containsClass(cname)) {
            return null;
        }
        String fname = Scene.sepIndexToSubsignature(fieldSignature, index);
        return this.getSootClass(cname).getFieldUnsafe(fname);
    }

    public boolean containsField(String fieldSignature) {
        return this.grabField(fieldSignature) != null;
    }

    public SootMethod grabMethod(String methodSignature) {
        int index = Scene.signatureSeparatorIndex(methodSignature);
        String cname = Scene.sepIndexToClass(methodSignature, index);
        if (!this.containsClass(cname)) {
            return null;
        }
        String mname = Scene.sepIndexToSubsignature(methodSignature, index);
        return this.getSootClass(cname).getMethodUnsafe(mname);
    }

    public boolean containsMethod(String methodSignature) {
        return this.grabMethod(methodSignature) != null;
    }

    public SootField getField(String fieldSignature) {
        SootField f = this.grabField(fieldSignature);
        if (f != null) {
            return f;
        }
        throw new RuntimeException("tried to get nonexistent field " + fieldSignature);
    }

    public SootMethod getMethod(String methodSignature) {
        SootMethod m = this.grabMethod(methodSignature);
        if (m != null) {
            return m;
        }
        throw new RuntimeException("tried to get nonexistent method " + methodSignature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SootClass tryLoadClass(String className, int desiredLevel) {
        this.setPhantomRefs(true);
        try (ClassSource source = SourceLocator.v().getClassSource(className);){
            if (!this.getPhantomRefs() && source == null) {
                this.setPhantomRefs(false);
                SootClass sootClass = null;
                return sootClass;
            }
        }
        SootClass toReturn = SootResolver.v().resolveClass(className, desiredLevel);
        this.setPhantomRefs(false);
        return toReturn;
    }

    public SootClass loadClassAndSupport(String className) {
        SootClass ret = this.loadClass(className, 2);
        if (!ret.isPhantom()) {
            ret = this.loadClass(className, 3);
        }
        return ret;
    }

    public SootClass loadClass(String className, int desiredLevel) {
        this.setPhantomRefs(true);
        SootClass toReturn = SootResolver.v().resolveClass(className, desiredLevel);
        this.setPhantomRefs(false);
        return toReturn;
    }

    public Type getType(String arg) {
        Type t = this.getTypeUnsafe(arg, false);
        if (t == null) {
            throw new RuntimeException("Unknown Type: '" + t + "'");
        }
        return t;
    }

    public Type getTypeUnsafe(String arg) {
        return this.getTypeUnsafe(arg, true);
    }

    public Type getTypeUnsafe(String arg, boolean phantomNonExist) {
        Type result;
        Matcher m;
        String type = arg;
        int arrayCount = -1;
        if (arg.contains("[") && (m = arrayPattern.matcher(arg)).matches()) {
            type = m.group(1);
            arrayCount = m.group(2).length() / 2;
        }
        if ((result = this.getRefTypeUnsafe(type)) == null) {
            switch (type) {
                case "long": {
                    result = LongType.v();
                    break;
                }
                case "short": {
                    result = ShortType.v();
                    break;
                }
                case "double": {
                    result = DoubleType.v();
                    break;
                }
                case "int": {
                    result = IntType.v();
                    break;
                }
                case "float": {
                    result = FloatType.v();
                    break;
                }
                case "byte": {
                    result = ByteType.v();
                    break;
                }
                case "char": {
                    result = CharType.v();
                    break;
                }
                case "void": {
                    result = VoidType.v();
                    break;
                }
                case "boolean": {
                    result = BooleanType.v();
                    break;
                }
                default: {
                    if (!phantomNonExist || !this.allowsPhantomRefs()) break;
                    this.getSootClassUnsafe(type, phantomNonExist);
                    result = this.getRefTypeUnsafe(type);
                }
            }
        }
        if (result != null && arrayCount > 0) {
            result = ArrayType.v(result, arrayCount);
        }
        return result;
    }

    public RefType getRefType(String className) {
        RefType refType = this.getRefTypeUnsafe(className);
        if (refType == null) {
            throw new IllegalStateException("RefType " + className + " not loaded. If you tried to get the RefType of a library class, did you call loadNecessaryClasses()? Otherwise please check Soot's classpath.");
        }
        return refType;
    }

    public RefType getRefTypeUnsafe(String className) {
        return this.nameToClass.get(className);
    }

    public RefType getObjectType() {
        if (Options.v().src_prec() == 7) {
            return this.getRefType("System.Object");
        }
        return this.getRefType("java.lang.Object");
    }

    public RefType getBaseExceptionType() {
        if (Options.v().src_prec() == 7) {
            return this.getRefType("System.Exception");
        }
        return this.getRefType("java.lang.Throwable");
    }

    public SootClass getSootClassUnsafe(String className) {
        return this.getSootClassUnsafe(className, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SootClass getSootClassUnsafe(String className, boolean phantomNonExist) {
        RefType refType;
        RefType type = this.nameToClass.get(className);
        if (type != null) {
            refType = type;
            synchronized (refType) {
                SootClass tsc;
                if (type.hasSootClass() && (tsc = type.getSootClass()) != null) {
                    return tsc;
                }
            }
        }
        if (phantomNonExist && this.allowsPhantomRefs() || "soot.dummy.InvokeDynamic".equals(className)) {
            refType = type = this.getOrAddRefType(className);
            synchronized (refType) {
                if (type.hasSootClass()) {
                    return type.getSootClass();
                }
                SootClass c = new SootClass(className);
                c.isPhantom = true;
                this.addClassSilent(c);
                c.setPhantomClass();
                return c;
            }
        }
        return null;
    }

    public SootClass getSootClass(String className) {
        SootClass sc = this.getSootClassUnsafe(className);
        if (sc != null) {
            return sc;
        }
        throw new RuntimeException(System.lineSeparator() + "Aborting: can't find classfile " + className);
    }

    public Chain<SootClass> getClasses() {
        return this.classes;
    }

    public Chain<SootClass> getApplicationClasses() {
        return this.applicationClasses;
    }

    public Chain<SootClass> getLibraryClasses() {
        return this.libraryClasses;
    }

    public Chain<SootClass> getPhantomClasses() {
        return this.phantomClasses;
    }

    Chain<SootClass> getContainingChain(SootClass c) {
        if (c.isApplicationClass()) {
            return this.getApplicationClasses();
        }
        if (c.isLibraryClass()) {
            return this.getLibraryClasses();
        }
        if (c.isPhantomClass()) {
            return this.getPhantomClasses();
        }
        return null;
    }

    public SideEffectAnalysis getSideEffectAnalysis() {
        SideEffectAnalysis temp = this.activeSideEffectAnalysis;
        if (temp == null) {
            this.activeSideEffectAnalysis = temp = new SideEffectAnalysis(this.getPointsToAnalysis(), this.getCallGraph());
        }
        return temp;
    }

    public void setSideEffectAnalysis(SideEffectAnalysis sea) {
        this.activeSideEffectAnalysis = sea;
    }

    public boolean hasSideEffectAnalysis() {
        return this.activeSideEffectAnalysis != null;
    }

    public void releaseSideEffectAnalysis() {
        this.activeSideEffectAnalysis = null;
    }

    public PointsToAnalysis getPointsToAnalysis() {
        PointsToAnalysis temp = this.activePointsToAnalysis;
        if (temp == null) {
            return DumbPointerAnalysis.v();
        }
        return temp;
    }

    public void setPointsToAnalysis(PointsToAnalysis pa) {
        this.activePointsToAnalysis = pa;
    }

    public boolean hasPointsToAnalysis() {
        return this.activePointsToAnalysis != null;
    }

    public void releasePointsToAnalysis() {
        this.activePointsToAnalysis = null;
    }

    public ClientAccessibilityOracle getClientAccessibilityOracle() {
        ClientAccessibilityOracle temp = this.accessibilityOracle;
        if (temp == null) {
            return PublicAndProtectedAccessibility.v();
        }
        return temp;
    }

    public boolean hasClientAccessibilityOracle() {
        return this.accessibilityOracle != null;
    }

    public void setClientAccessibilityOracle(ClientAccessibilityOracle oracle) {
        this.accessibilityOracle = oracle;
    }

    public void releaseClientAccessibilityOracle() {
        this.accessibilityOracle = null;
    }

    public synchronized FastHierarchy getOrMakeFastHierarchy() {
        FastHierarchy temp = this.activeFastHierarchy;
        if (temp == null) {
            this.activeFastHierarchy = temp = new FastHierarchy();
        }
        return temp;
    }

    public synchronized FastHierarchy getFastHierarchy() {
        FastHierarchy temp = this.activeFastHierarchy;
        if (temp == null) {
            throw new RuntimeException("no active FastHierarchy present for scene");
        }
        return temp;
    }

    public synchronized void setFastHierarchy(FastHierarchy hierarchy) {
        this.activeFastHierarchy = hierarchy;
    }

    public synchronized boolean hasFastHierarchy() {
        return this.activeFastHierarchy != null;
    }

    public synchronized void releaseFastHierarchy() {
        this.activeFastHierarchy = null;
    }

    public synchronized Hierarchy getActiveHierarchy() {
        Hierarchy temp = this.activeHierarchy;
        if (temp == null) {
            this.activeHierarchy = temp = new Hierarchy();
        }
        return temp;
    }

    public synchronized void setActiveHierarchy(Hierarchy hierarchy) {
        this.activeHierarchy = hierarchy;
    }

    public synchronized boolean hasActiveHierarchy() {
        return this.activeHierarchy != null;
    }

    public synchronized void releaseActiveHierarchy() {
        this.activeHierarchy = null;
    }

    public boolean hasCustomEntryPoints() {
        return this.entryPoints != null;
    }

    public List<SootMethod> getEntryPoints() {
        List<SootMethod> temp = this.entryPoints;
        if (temp == null) {
            this.entryPoints = temp = EntryPoints.v().all();
        }
        return temp;
    }

    public void setEntryPoints(List<SootMethod> entryPoints) {
        this.entryPoints = entryPoints;
    }

    public ContextSensitiveCallGraph getContextSensitiveCallGraph() {
        ContextSensitiveCallGraph temp = this.cscg;
        if (temp == null) {
            throw new RuntimeException("No context-sensitive call graph present in Scene. You can bulid one with Paddle.");
        }
        return temp;
    }

    public void setContextSensitiveCallGraph(ContextSensitiveCallGraph cscg) {
        this.cscg = cscg;
    }

    public CallGraph getCallGraph() {
        CallGraph temp = this.activeCallGraph;
        if (temp == null) {
            throw new RuntimeException("No call graph present in Scene. Maybe you want Whole Program mode (-w).");
        }
        return temp;
    }

    public void setCallGraph(CallGraph cg) {
        this.reachableMethods = null;
        this.activeCallGraph = cg;
    }

    public boolean hasCallGraph() {
        return this.activeCallGraph != null;
    }

    public void releaseCallGraph() {
        this.activeCallGraph = null;
        this.reachableMethods = null;
    }

    public ReachableMethods getReachableMethods() {
        ReachableMethods temp = this.reachableMethods;
        if (temp == null) {
            this.reachableMethods = temp = new ReachableMethods(this.getCallGraph(), new ArrayList<SootMethod>(this.getEntryPoints()));
        }
        temp.update();
        return temp;
    }

    public void setReachableMethods(ReachableMethods rm) {
        this.reachableMethods = rm;
    }

    public boolean hasReachableMethods() {
        return this.reachableMethods != null;
    }

    public void releaseReachableMethods() {
        this.reachableMethods = null;
    }

    public boolean getPhantomRefs() {
        return Options.v().allow_phantom_refs();
    }

    public void setPhantomRefs(boolean value) {
        this.allowsPhantomRefs = value;
    }

    public boolean allowsPhantomRefs() {
        return this.getPhantomRefs();
    }

    public IterableNumberer<Type> getTypeNumberer() {
        return this.typeNumberer;
    }

    public StringNumberer getSubSigNumberer() {
        return this.subSigNumberer;
    }

    public ThrowAnalysis getDefaultThrowAnalysis() {
        if (this.defaultThrowAnalysis == null) {
            switch (Options.v().throw_analysis()) {
                case 1: {
                    this.defaultThrowAnalysis = PedanticThrowAnalysis.v();
                    break;
                }
                case 2: {
                    this.defaultThrowAnalysis = UnitThrowAnalysis.v();
                    break;
                }
                case 3: {
                    this.defaultThrowAnalysis = DalvikThrowAnalysis.v();
                    break;
                }
                case 4: {
                    this.defaultThrowAnalysis = DotnetThrowAnalysis.v();
                    break;
                }
                case 5: {
                    if (Options.v().src_prec() == 5) {
                        this.defaultThrowAnalysis = DalvikThrowAnalysis.v();
                        break;
                    }
                    if (Options.v().src_prec() == 7) {
                        this.defaultThrowAnalysis = DotnetThrowAnalysis.v();
                        break;
                    }
                    this.defaultThrowAnalysis = UnitThrowAnalysis.v();
                    break;
                }
                default: {
                    throw new IllegalStateException("Options.v().throw_analysis() == " + Options.v().throw_analysis());
                }
            }
        }
        return this.defaultThrowAnalysis;
    }

    public void setDefaultThrowAnalysis(ThrowAnalysis ta) {
        this.defaultThrowAnalysis = ta;
    }

    private void setReservedNames() {
        Set<String> rn = this.reservedNames;
        rn.add("newarray");
        rn.add("newmultiarray");
        rn.add("nop");
        rn.add("ret");
        rn.add("specialinvoke");
        rn.add("staticinvoke");
        rn.add("tableswitch");
        rn.add("virtualinvoke");
        rn.add("null_type");
        rn.add("unknown");
        rn.add("cmp");
        rn.add("cmpg");
        rn.add("cmpl");
        rn.add("entermonitor");
        rn.add("exitmonitor");
        rn.add("interfaceinvoke");
        rn.add("lengthof");
        rn.add("lookupswitch");
        rn.add("neg");
        rn.add("if");
        rn.add("abstract");
        rn.add("annotation");
        rn.add("boolean");
        rn.add("break");
        rn.add("byte");
        rn.add("case");
        rn.add("catch");
        rn.add("char");
        rn.add("class");
        rn.add("enum");
        rn.add("final");
        rn.add("native");
        rn.add("public");
        rn.add("protected");
        rn.add("private");
        rn.add("static");
        rn.add("synchronized");
        rn.add("transient");
        rn.add("volatile");
        rn.add("interface");
        rn.add("void");
        rn.add("short");
        rn.add("int");
        rn.add("long");
        rn.add("float");
        rn.add("double");
        rn.add("extends");
        rn.add("implements");
        rn.add("breakpoint");
        rn.add("default");
        rn.add("goto");
        rn.add("instanceof");
        rn.add("new");
        rn.add("return");
        rn.add("throw");
        rn.add("throws");
        rn.add("null");
        rn.add("from");
        rn.add("to");
        rn.add("with");
        rn.add("cls");
        rn.add("dynamicinvoke");
        rn.add("strictfp");
    }

    private void addSootBasicClasses() {
        this.basicclasses[1] = new HashSet<String>();
        this.basicclasses[2] = new HashSet<String>();
        this.basicclasses[3] = new HashSet<String>();
        this.addBasicClass("java.lang.Object");
        this.addBasicClass("java.lang.Class", 2);
        this.addBasicClass("java.lang.Void", 2);
        this.addBasicClass("java.lang.Boolean", 2);
        this.addBasicClass("java.lang.Byte", 2);
        this.addBasicClass("java.lang.Character", 2);
        this.addBasicClass("java.lang.Short", 2);
        this.addBasicClass("java.lang.Integer", 2);
        this.addBasicClass("java.lang.Long", 2);
        this.addBasicClass("java.lang.Float", 2);
        this.addBasicClass("java.lang.Double", 2);
        this.addBasicClass("java.lang.Number", 2);
        this.addBasicClass("java.lang.String");
        this.addBasicClass("java.lang.StringBuffer", 2);
        this.addBasicClass("java.lang.Enum", 2);
        this.addBasicClass("java.lang.Error");
        this.addBasicClass("java.lang.AssertionError", 2);
        this.addBasicClass("java.lang.Throwable", 2);
        this.addBasicClass("java.lang.Exception", 2);
        this.addBasicClass("java.lang.NoClassDefFoundError", 2);
        this.addBasicClass("java.lang.ReflectiveOperationException", 2);
        this.addBasicClass("java.lang.ExceptionInInitializerError");
        this.addBasicClass("java.lang.RuntimeException");
        this.addBasicClass("java.lang.ClassNotFoundException");
        this.addBasicClass("java.lang.ArithmeticException");
        this.addBasicClass("java.lang.ArrayStoreException");
        this.addBasicClass("java.lang.ClassCastException");
        this.addBasicClass("java.lang.IllegalMonitorStateException");
        this.addBasicClass("java.lang.IndexOutOfBoundsException");
        this.addBasicClass("java.lang.ArrayIndexOutOfBoundsException");
        this.addBasicClass("java.lang.NegativeArraySizeException");
        this.addBasicClass("java.lang.NullPointerException", 2);
        this.addBasicClass("java.lang.InstantiationError");
        this.addBasicClass("java.lang.InternalError");
        this.addBasicClass("java.lang.OutOfMemoryError");
        this.addBasicClass("java.lang.StackOverflowError");
        this.addBasicClass("java.lang.UnknownError");
        this.addBasicClass("java.lang.ThreadDeath");
        this.addBasicClass("java.lang.ClassCircularityError");
        this.addBasicClass("java.lang.ClassFormatError");
        this.addBasicClass("java.lang.IllegalAccessError");
        this.addBasicClass("java.lang.IncompatibleClassChangeError");
        this.addBasicClass("java.lang.LinkageError");
        this.addBasicClass("java.lang.VerifyError");
        this.addBasicClass("java.lang.NoSuchFieldError");
        this.addBasicClass("java.lang.AbstractMethodError");
        this.addBasicClass("java.lang.NoSuchMethodError");
        this.addBasicClass("java.lang.UnsatisfiedLinkError");
        this.addBasicClass("java.lang.Thread");
        this.addBasicClass("java.lang.Runnable");
        this.addBasicClass("java.lang.Cloneable");
        this.addBasicClass("java.io.Serializable");
        this.addBasicClass("java.lang.ref.Finalizer");
        this.addBasicClass("java.lang.invoke.LambdaMetafactory");
    }

    private void addSootBasicDotnetClasses() {
        this.basicclasses[1] = new HashSet<String>();
        this.basicclasses[2] = new HashSet<String>();
        this.basicclasses[3] = new HashSet<String>();
        this.addBasicClass("System.Object", 2);
        this.addBasicClass("System.Void", 2);
        this.addBasicClass("System.Boolean", 2);
        this.addBasicClass("System.Byte", 2);
        this.addBasicClass("System.Char", 2);
        this.addBasicClass("System.Int16", 2);
        this.addBasicClass("System.Int32", 2);
        this.addBasicClass("System.Int64", 2);
        this.addBasicClass("System.Single", 2);
        this.addBasicClass("System.Double", 2);
        this.addBasicClass("System.String", 2);
        this.addBasicClass("System.Enum", 2);
        this.addBasicClass("System.Type", 2);
        this.addBasicClass("System.SByte", 2);
        this.addBasicClass("System.Decimal", 2);
        this.addBasicClass("System.IntPtr", 2);
        this.addBasicClass("System.UIntPtr", 2);
        this.addBasicClass("System.UIntPtr", 2);
        this.addBasicClass("System.UInt16", 2);
        this.addBasicClass("System.UInt32", 2);
        this.addBasicClass("System.UInt64", 2);
        this.addBasicClass("System.Exception", 2);
        this.addBasicClass("System.AccessViolationException", 2);
        this.addBasicClass("System.AggregateException", 2);
        this.addBasicClass("System.AppDomainUnloadedException", 2);
        this.addBasicClass("System.ApplicationException", 2);
        this.addBasicClass("System.ArgumentException", 2);
        this.addBasicClass("System.ArgumentNullException", 2);
        this.addBasicClass("System.ArgumentOutOfRangeException", 2);
        this.addBasicClass("System.ArithmeticException", 2);
        this.addBasicClass("System.ArrayTypeMismatchException", 2);
        this.addBasicClass("System.BadImageFormatException", 2);
        this.addBasicClass("System.CannotUnloadAppDomainException", 2);
        this.addBasicClass("System.ContextMarshalException", 2);
        this.addBasicClass("System.DataMisalignedException", 2);
        this.addBasicClass("System.DivideByZeroException", 2);
        this.addBasicClass("System.DllNotFoundException", 2);
        this.addBasicClass("System.DuplicateWaitObjectException", 2);
        this.addBasicClass("System.EntryPointNotFoundException", 2);
        this.addBasicClass("System.ExecutionEngineException", 2);
        this.addBasicClass("System.FieldAccessException", 2);
        this.addBasicClass("System.FormatException", 2);
        this.addBasicClass("System.IndexOutOfRangeException", 2);
        this.addBasicClass("System.InsufficientExecutionStackException", 2);
        this.addBasicClass("System.InsufficientMemoryException", 2);
        this.addBasicClass("System.InvalidCastException", 2);
        this.addBasicClass("System.InvalidOperationException", 2);
        this.addBasicClass("System.InvalidProgramException", 2);
        this.addBasicClass("System.InvalidTimeZoneException", 2);
        this.addBasicClass("System.MissingFieldException", 2);
        this.addBasicClass("System.MissingMethodException", 2);
        this.addBasicClass("System.NullReferenceException", 2);
        this.addBasicClass("System.OutOfMemoryException", 2);
        this.addBasicClass("System.OverflowException", 2);
        this.addBasicClass("System.SystemException", 2);
        this.addBasicClass("System.TypeAccessException", 2);
        this.addBasicClass("System.TypeInitializationException", 2);
        this.addBasicClass("System.TypeLoadException", 2);
        this.addBasicClass("System.TypeUnloadedException", 2);
        this.addBasicClass("System.UnauthorizedAccessException", 2);
        this.addBasicClass("System.UriFormatException", 2);
        this.addBasicClass("System.SecurityException", 2);
        this.addBasicClass("System.MethodAccessException", 2);
        this.addBasicClass("System.VerificationException", 2);
        this.addBasicClass("System.StackOverflowException", 2);
        this.addBasicClass("System.Threading", 2);
        this.addBasicClass("System.SerializableAttribute", 2);
        this.addBasicClass("System.Console", 2);
        this.addBasicClass("System.RuntimeFieldHandle", 2);
        this.addBasicClass("System.RuntimeMethodHandle", 2);
        this.addBasicClass("System.RuntimeTypeHandle", 2);
        this.addBasicClass("Fake.LdFtn", 2);
    }

    public void addBasicClass(String name) {
        this.addBasicClass(name, 1);
    }

    public void addBasicClass(String name, int level) {
        this.basicclasses[level].add(name);
    }

    public void loadBasicClasses() {
        this.addReflectionTraceClasses();
        int loadedClasses = 0;
        for (int i = 3; i >= 1; --i) {
            for (String name : this.basicclasses[i]) {
                SootClass basicClass = this.tryLoadClass(name, i);
                if (basicClass == null || basicClass.isPhantom()) continue;
                ++loadedClasses;
            }
        }
        if (loadedClasses == 0) {
            throw new RuntimeException("None of the basic classes could be loaded! Check your Soot class path!");
        }
    }

    public Set<String> getBasicClasses() {
        HashSet<String> all = new HashSet<String>();
        for (int i = 3; i >= 1; --i) {
            all.addAll(this.basicclasses[i]);
        }
        return all;
    }

    public boolean isBasicClass(String className) {
        for (int i = 3; i >= 1; --i) {
            if (!this.basicclasses[i].contains(className)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addReflectionTraceClasses() {
        HashSet<String> classNames = new HashSet<String>();
        CGOptions options = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"));
        String log = options.reflection_log();
        if (log != null && !log.isEmpty()) {
            String line = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(log)));){
                block47: while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    String[] portions = line.split(";", -1);
                    String kind = portions[0];
                    String target = portions[1];
                    String source = portions[2];
                    classNames.add(source.substring(0, source.lastIndexOf(46)));
                    switch (kind) {
                        case "Class.forName": 
                        case "Class.getFields": 
                        case "Class.getMethods": {
                            classNames.add(target);
                            continue block47;
                        }
                        case "Class.newInstance": {
                            classNames.add(target);
                            continue block47;
                        }
                        case "Method.invoke": 
                        case "Constructor.newInstance": 
                        case "Method.toString": 
                        case "Class.getDeclaredField": 
                        case "Class.getDeclaredMethod": 
                        case "Class.getMethod": 
                        case "Class.getField": 
                        case "Constructor.getModifiers": 
                        case "Field.getModifiers": 
                        case "Method.getModifiers": 
                        case "Method.getName": 
                        case "Method.getDeclaringClass": 
                        case "Constructor.toString": 
                        case "Method.toGenericString": {
                            classNames.add(Scene.signatureToClass(target));
                            continue block47;
                        }
                        case "Class.getDeclaredFields": 
                        case "Class.getDeclaredMethods": {
                            if (target.startsWith("[")) continue block47;
                            classNames.add(target);
                            continue block47;
                        }
                        case "Field.set*": 
                        case "Field.get*": 
                        case "Field.toString": 
                        case "Field.getName": 
                        case "Field.getDeclaringClass": {
                            classNames.add(Scene.signatureToClass(target));
                            continue block47;
                        }
                        case "Array.newInstance": {
                            continue block47;
                        }
                    }
                    throw new RuntimeException("Unknown entry kind: " + kind);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Line: '" + line + "'", e);
            }
        }
        Iterator iterator = classNames.iterator();
        while (iterator.hasNext()) {
            String c = (String)iterator.next();
            this.addBasicClass(c, 3);
        }
        return;
    }

    public Collection<SootClass> dynamicClasses() {
        List<SootClass> temp = this.dynamicClasses;
        if (temp == null) {
            throw new IllegalStateException("Have to call loadDynamicClasses() first!");
        }
        return temp;
    }

    protected void loadNecessaryClass(String name) {
        this.loadClassAndSupport(name).setApplicationClass();
    }

    public void loadNecessaryClasses() {
        this.loadBasicClasses();
        Options opts = Options.v();
        for (String name : opts.classes()) {
            this.loadNecessaryClass(name);
        }
        this.loadDynamicClasses();
        if (opts.oaat()) {
            if (opts.process_dir().isEmpty()) {
                throw new IllegalArgumentException("If switch -oaat is used, then also -process-dir must be given.");
            }
        } else {
            for (String path : opts.process_dir()) {
                for (String cl : SourceLocator.v().getClassesUnder(path)) {
                    SootClass theClass = this.loadClassAndSupport(cl);
                    if (theClass.isPhantom) continue;
                    theClass.setApplicationClass();
                }
            }
        }
        this.prepareClasses();
        this.setDoneResolving();
    }

    public void loadDynamicClasses() {
        ArrayList<SootClass> dynamicClasses = new ArrayList<SootClass>();
        Options opts = Options.v();
        HashSet<String> temp = new HashSet<String>(opts.dynamic_class());
        SourceLocator sloc = SourceLocator.v();
        for (String path : opts.dynamic_dir()) {
            temp.addAll(sloc.getClassesUnder(path));
        }
        for (String pkg : opts.dynamic_package()) {
            temp.addAll(sloc.classesInDynamicPackage(pkg));
        }
        for (String className : temp) {
            dynamicClasses.add(this.loadClassAndSupport(className));
        }
        Iterator iterator = dynamicClasses.iterator();
        while (iterator.hasNext()) {
            SootClass c = (SootClass)iterator.next();
            if (c.isConcrete()) continue;
            if (opts.verbose()) {
                logger.warn("dynamic class " + c.getName() + " is abstract or an interface, and it will not be considered.");
            }
            iterator.remove();
        }
        this.dynamicClasses = dynamicClasses;
    }

    protected void prepareClasses() {
        LinkedList optionsClasses = Options.v().classes();
        HashChain<SootClass> processedClasses = new HashChain<SootClass>();
        block0: while (true) {
            HashChain<SootClass> unprocessedClasses = new HashChain<SootClass>(this.getClasses());
            unprocessedClasses.removeAll(processedClasses);
            if (unprocessedClasses.isEmpty()) break;
            processedClasses.addAll(unprocessedClasses);
            Iterator iterator = unprocessedClasses.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                SootClass s = (SootClass)iterator.next();
                if (s.isPhantom()) continue;
                if (Options.v().app()) {
                    s.setApplicationClass();
                }
                if (optionsClasses.contains(s.getName())) {
                    s.setApplicationClass();
                    continue;
                }
                if (s.isApplicationClass() && this.isExcluded(s)) {
                    s.setLibraryClass();
                }
                if (this.isIncluded(s)) {
                    s.setApplicationClass();
                }
                if (!s.isApplicationClass()) continue;
                this.loadClassAndSupport(s.getName());
            }
            break;
        }
    }

    public boolean isExcluded(SootClass sc) {
        return this.isExcluded(sc.getName());
    }

    public boolean isExcluded(String className) {
        if (this.excludedPackages == null) {
            return false;
        }
        for (String pkg : this.excludedPackages) {
            if (!className.equals(pkg) && (!pkg.endsWith(".*") && !pkg.endsWith("$*") || !className.startsWith(pkg.substring(0, pkg.length() - 1)))) continue;
            return !this.isIncluded(className);
        }
        return false;
    }

    public boolean isIncluded(SootClass sc) {
        return this.isIncluded(sc.getName());
    }

    public boolean isIncluded(String className) {
        for (String pkg : Options.v().include()) {
            if (!className.equals(pkg) && (!pkg.endsWith(".*") && !pkg.endsWith("$*") || !className.startsWith(pkg.substring(0, pkg.length() - 1)))) continue;
            return true;
        }
        return false;
    }

    public void setPkgList(List<String> list) {
        this.pkgList = list;
    }

    public List<String> getPkgList() {
        return this.pkgList;
    }

    public SootMethodRef makeMethodRef(SootClass declaringClass, String name, List<Type> parameterTypes, Type returnType, boolean isStatic) {
        if (PolymorphicMethodRef.handlesClass(declaringClass)) {
            return new PolymorphicMethodRef(declaringClass, name, parameterTypes, returnType, isStatic);
        }
        return new SootMethodRefImpl(declaringClass, name, parameterTypes, returnType, isStatic);
    }

    public SootMethodRef makeConstructorRef(SootClass declaringClass, List<Type> parameterTypes) {
        return this.makeMethodRef(declaringClass, "<init>", parameterTypes, VoidType.v(), false);
    }

    public SootFieldRef makeFieldRef(SootClass declaringClass, String name, Type type, boolean isStatic) {
        return new AbstractSootFieldRef(declaringClass, name, type, isStatic);
    }

    public List<SootClass> getClasses(int desiredLevel) {
        ArrayList<SootClass> ret = new ArrayList<SootClass>();
        for (SootClass cl : this.getClasses()) {
            if (cl.resolvingLevel() < desiredLevel) continue;
            ret.add(cl);
        }
        return ret;
    }

    public boolean doneResolving() {
        return this.doneResolving;
    }

    public void setDoneResolving() {
        this.doneResolving = true;
    }

    public void setResolving(boolean value) {
        this.doneResolving = value;
    }

    public void setMainClassFromOptions() {
        if (this.mainClass == null) {
            String optsMain = Options.v().main_class();
            if (optsMain != null && !optsMain.isEmpty()) {
                this.setMainClass(this.getSootClass(optsMain));
            } else {
                List<Type> mainArgs = Collections.singletonList(ArrayType.v(Options.v().src_prec() == 7 ? RefType.v("System.String") : RefType.v("java.lang.String"), 1));
                for (String next : Options.v().classes()) {
                    SootClass c = this.getSootClass(next);
                    boolean declaresMethod = Options.v().src_prec() != 7 ? c.declaresMethod("main", mainArgs, VoidType.v()) : c.declaresMethod("Main", mainArgs, VoidType.v());
                    if (!declaresMethod) continue;
                    logger.debug("No main class given. Inferred '" + c.getName() + "' as main class.");
                    this.setMainClass(c);
                    return;
                }
                for (SootClass c : this.getApplicationClasses()) {
                    boolean declaresMethod = Options.v().src_prec() != 7 ? c.declaresMethod("main", mainArgs, VoidType.v()) : c.declaresMethod("Main", mainArgs, VoidType.v());
                    if (!declaresMethod) continue;
                    logger.debug("No main class given. Inferred '" + c.getName() + "' as main class.");
                    this.setMainClass(c);
                    return;
                }
            }
        }
    }

    public boolean isIncrementalBuild() {
        return this.incrementalBuild;
    }

    public void initiateIncrementalBuild() {
        this.incrementalBuild = true;
    }

    public void incrementalBuildFinished() {
        this.incrementalBuild = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SootClass forceResolve(String className, int level) {
        SootClass c;
        boolean tmp = this.doneResolving;
        this.doneResolving = false;
        try {
            c = SootResolver.v().resolveClass(className, level);
        }
        finally {
            this.doneResolving = tmp;
        }
        return c;
    }

    public SootClass makeSootClass(String name) {
        return new SootClass(name);
    }

    public SootClass makeSootClass(String name, int modifiers) {
        return new SootClass(name, modifiers);
    }

    public SootMethod makeSootMethod(String name, List<Type> parameterTypes, Type returnType) {
        return new SootMethod(name, parameterTypes, returnType);
    }

    public SootMethod makeSootMethod(String name, List<Type> parameterTypes, Type returnType, int modifiers) {
        return new SootMethod(name, parameterTypes, returnType, modifiers);
    }

    public SootMethod makeSootMethod(String name, List<Type> parameterTypes, Type returnType, int modifiers, List<SootClass> thrownExceptions) {
        return new SootMethod(name, parameterTypes, returnType, modifiers, thrownExceptions);
    }

    public SootField makeSootField(String name, Type type, int modifiers) {
        return new SootField(name, type, modifiers);
    }

    public SootField makeSootField(String name, Type type) {
        return new SootField(name, type);
    }

    public RefType getOrAddRefType(String refTypeName) {
        return this.nameToClass.computeIfAbsent(refTypeName, k -> new RefType((String)k));
    }

    public CallGraph internalMakeCallGraph() {
        return new CallGraph();
    }

    public LocalGenerator createLocalGenerator(Body stmtBody) {
        return new DefaultLocalGenerator(stmtBody);
    }

    public LocalCreation createLocalCreation(Chain<Local> locals) {
        return new DefaultLocalCreation(locals);
    }

    public LocalCreation createLocalCreation(Chain<Local> locals, String prefix) {
        return new DefaultLocalCreation(locals, prefix);
    }

    public void resetSootClassPathCache() {
        this.sootClassPath = null;
    }

    public static class AndroidVersionInfo {
        public int sdkTargetVersion = -1;
        public int minSdkVersion = -1;
        public int platformBuildVersionCode = -1;

        private static AndroidVersionInfo get(InputStream manifestIS) {
            final AndroidVersionInfo versionInfo = new AndroidVersionInfo();
            AxmlVisitor axmlVisitor = new AxmlVisitor(){
                private String nodeName = null;

                public void attr(String ns, String name, int resourceId, int type, Object obj) {
                    super.attr(ns, name, resourceId, type, obj);
                    if (this.nodeName != null && name != null) {
                        if (this.nodeName.equals("manifest")) {
                            if (name.equals("platformBuildVersionCode")) {
                                versionInfo.platformBuildVersionCode = Integer.valueOf("" + obj);
                            }
                        } else if (this.nodeName.equals("uses-sdk")) {
                            if (name.equals("targetSdkVersion") || name.isEmpty() && resourceId == 16843376) {
                                versionInfo.sdkTargetVersion = Integer.valueOf(String.valueOf(obj));
                            } else if (name.equals("minSdkVersion") || name.isEmpty() && resourceId == 16843276) {
                                versionInfo.minSdkVersion = Integer.valueOf(String.valueOf(obj));
                            }
                        }
                    }
                }

                public NodeVisitor child(String ns, String name) {
                    this.nodeName = name;
                    return this;
                }
            };
            try {
                AxmlReader xmlReader = new AxmlReader(IOUtils.toByteArray((InputStream)manifestIS));
                xmlReader.accept(axmlVisitor);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return versionInfo;
        }
    }
}

