/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.AbstractJasminClass;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.ClassMember;
import soot.Context;
import soot.DoubleType;
import soot.ErroneousType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.MethodOrMethodContext;
import soot.MethodSource;
import soot.Modifier;
import soot.NullType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethodInterface;
import soot.SootMethodRef;
import soot.StmtAddressType;
import soot.Type;
import soot.Unit;
import soot.dava.DavaBody;
import soot.dava.toolkits.base.renamer.RemoveFullyQualifiedName;
import soot.jbco.Main;
import soot.options.Options;
import soot.tagkit.AbstractHost;
import soot.util.IterableSet;
import soot.util.NumberedString;

public class SootMethod
extends AbstractHost
implements ClassMember,
MethodOrMethodContext,
SootMethodInterface {
    private static final Logger logger = LoggerFactory.getLogger(SootMethod.class);
    public static final String constructorName = "<init>";
    public static final String staticInitializerName = "<clinit>";
    protected String name;
    protected Type[] parameterTypes;
    protected Type returnType;
    protected boolean isDeclared;
    protected SootClass declaringClass;
    protected int modifiers;
    protected boolean isPhantom = false;
    protected List<SootClass> exceptions;
    protected volatile Body activeBody;
    protected volatile MethodSource ms;
    protected volatile String sig;
    protected volatile String subSig;
    protected NumberedString subsignature;

    public SootMethod(String name, List<Type> parameterTypes, Type returnType) {
        this(name, parameterTypes, returnType, 0, Collections.emptyList());
    }

    public SootMethod(String name, List<Type> parameterTypes, Type returnType, int modifiers) {
        this(name, parameterTypes, returnType, modifiers, Collections.emptyList());
    }

    public SootMethod(String name, List<Type> parameterTypes, Type returnType, int modifiers, List<SootClass> thrownExceptions) {
        this.name = name;
        if (parameterTypes != null && !parameterTypes.isEmpty()) {
            this.parameterTypes = parameterTypes.toArray(new Type[parameterTypes.size()]);
        }
        this.returnType = returnType;
        this.modifiers = modifiers;
        if (thrownExceptions != null && !thrownExceptions.isEmpty()) {
            this.exceptions = new ArrayList<SootClass>(thrownExceptions);
        }
        this.subsignature = Scene.v().getSubSigNumberer().findOrAdd(this.getSubSignature());
    }

    public int equivHashCode() {
        return this.returnType.hashCode() * 101 + this.modifiers * 17 + this.name.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        boolean wasDeclared = this.isDeclared;
        SootClass oldDeclaringClass = this.declaringClass;
        if (wasDeclared) {
            oldDeclaringClass.removeMethod(this);
        }
        this.name = name;
        this.sig = null;
        this.subSig = null;
        this.subsignature = Scene.v().getSubSigNumberer().findOrAdd(this.getSubSignature());
        if (wasDeclared) {
            oldDeclaringClass.addMethod(this);
        }
    }

    public synchronized void setDeclaringClass(SootClass declClass) {
        this.declaringClass = declClass;
        this.sig = null;
    }

    @Override
    public SootClass getDeclaringClass() {
        if (!this.isDeclared) {
            throw new RuntimeException("not declared: " + this.getName());
        }
        return this.declaringClass;
    }

    public void setDeclared(boolean isDeclared) {
        this.isDeclared = isDeclared;
    }

    @Override
    public boolean isDeclared() {
        return this.isDeclared;
    }

    @Override
    public boolean isPhantom() {
        return this.isPhantom;
    }

    public boolean isConcrete() {
        return !this.isPhantom() && !this.isAbstract() && (!this.isNative() || Options.v().native_code());
    }

    @Override
    public void setPhantom(boolean value) {
        if (value) {
            if (!Scene.v().allowsPhantomRefs()) {
                throw new RuntimeException("Phantom refs not allowed");
            }
            if (!Options.v().allow_phantom_elms() && this.declaringClass != null && !this.declaringClass.isPhantom()) {
                throw new RuntimeException("Declaring class would have to be phantom");
            }
        }
        this.isPhantom = value;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    public synchronized void setReturnType(Type t) {
        boolean wasDeclared = this.isDeclared;
        SootClass oldDeclaringClass = this.declaringClass;
        if (wasDeclared) {
            oldDeclaringClass.removeMethod(this);
        }
        this.returnType = t;
        this.sig = null;
        this.subSig = null;
        this.subsignature = Scene.v().getSubSigNumberer().findOrAdd(this.getSubSignature());
        if (wasDeclared) {
            oldDeclaringClass.addMethod(this);
        }
    }

    public int getParameterCount() {
        return this.parameterTypes == null ? 0 : this.parameterTypes.length;
    }

    @Override
    public Type getParameterType(int n) {
        return this.parameterTypes[n];
    }

    @Override
    public List<Type> getParameterTypes() {
        return this.parameterTypes == null ? Collections.emptyList() : Arrays.asList(this.parameterTypes);
    }

    public synchronized void setParameterTypes(List<Type> l) {
        boolean wasDeclared = this.isDeclared;
        SootClass oldDeclaringClass = this.declaringClass;
        if (wasDeclared) {
            oldDeclaringClass.removeMethod(this);
        }
        this.parameterTypes = l.toArray(new Type[l.size()]);
        this.sig = null;
        this.subSig = null;
        this.subsignature = Scene.v().getSubSigNumberer().findOrAdd(this.getSubSignature());
        if (wasDeclared) {
            oldDeclaringClass.addMethod(this);
        }
    }

    public MethodSource getSource() {
        return this.ms;
    }

    public synchronized void setSource(MethodSource ms) {
        this.ms = ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Body getActiveBody() {
        Body activeBody = this.activeBody;
        if (activeBody != null) {
            return activeBody;
        }
        SootMethod sootMethod = this;
        synchronized (sootMethod) {
            activeBody = this.activeBody;
            if (activeBody != null) {
                return activeBody;
            }
            if (this.declaringClass != null) {
                this.declaringClass.checkLevel(3);
            }
            if (this.declaringClass != null && this.declaringClass.isPhantomClass() || this.isPhantom()) {
                throw new RuntimeException("cannot get active body for phantom method: " + this.getSignature());
            }
            if (!Main.metrics) {
                throw new RuntimeException("no active body present for method " + this.getSignature());
            }
            return null;
        }
    }

    public synchronized void setActiveBody(Body body) {
        if (this.declaringClass != null && this.declaringClass.isPhantomClass()) {
            throw new RuntimeException("cannot set active body for phantom class! " + this);
        }
        this.setPhantom(false);
        if (!this.isConcrete()) {
            throw new RuntimeException("cannot set body for non-concrete method! " + this);
        }
        if (body != null) {
            body.setMethod(this);
        }
        this.activeBody = body;
    }

    public Body retrieveActiveBody() {
        return this.retrieveActiveBody(b -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Body retrieveActiveBody(Consumer<Body> consumer) {
        Body activeBody = this.activeBody;
        if (activeBody != null) {
            return activeBody;
        }
        SootMethod sootMethod = this;
        synchronized (sootMethod) {
            activeBody = this.activeBody;
            if (activeBody != null) {
                return activeBody;
            }
            if (this.declaringClass != null) {
                this.declaringClass.checkLevel(3);
            }
            if (this.declaringClass != null && this.declaringClass.isPhantomClass() || this.isPhantom()) {
                throw new RuntimeException("cannot get resident body for phantom method : " + this);
            }
            if (this.ms == null) {
                throw new RuntimeException("No method source set for method " + this);
            }
            activeBody = this.ms.getBody(this, "jb");
            consumer.accept(activeBody);
            this.setActiveBody(activeBody);
            if (Options.v().drop_bodies_after_load()) {
                this.ms = null;
            }
            return activeBody;
        }
    }

    public boolean hasActiveBody() {
        return this.activeBody != null;
    }

    public synchronized void releaseActiveBody() {
        this.activeBody = null;
    }

    public void addExceptionIfAbsent(SootClass e) {
        if (!this.throwsException(e)) {
            this.addException(e);
        }
    }

    public void addException(SootClass e) {
        logger.trace("Adding exception {}", (Object)e);
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<SootClass>();
        } else if (this.exceptions.contains(e)) {
            throw new RuntimeException("already throws exception " + e.getName());
        }
        this.exceptions.add(e);
    }

    public void removeException(SootClass e) {
        logger.trace("Removing exception {}", (Object)e);
        if (this.exceptions == null || !this.exceptions.contains(e)) {
            throw new RuntimeException("does not throw exception " + e.getName());
        }
        this.exceptions.remove(e);
    }

    public boolean throwsException(SootClass e) {
        return this.exceptions != null && this.exceptions.contains(e);
    }

    public void setExceptions(List<SootClass> exceptions) {
        this.exceptions = exceptions == null || exceptions.isEmpty() ? null : new ArrayList<SootClass>(exceptions);
    }

    public List<SootClass> getExceptions() {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<SootClass>();
        }
        return this.exceptions;
    }

    public List<SootClass> getExceptionsUnsafe() {
        return this.exceptions;
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isNative() {
        return Modifier.isNative(this.getModifiers());
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.getModifiers());
    }

    public boolean isMain() {
        return this.isPublic() && this.isStatic() && Scene.v().getSubSigNumberer().findOrAdd(Options.v().src_prec() != 7 ? "void main(java.lang.String[])" : "void Main(System.String[])").equals(this.subsignature);
    }

    public boolean isConstructor() {
        return constructorName.equals(this.name);
    }

    public boolean isStaticInitializer() {
        return staticInitializerName.equals(this.name);
    }

    public boolean isEntryMethod() {
        if (this.isStatic() && staticInitializerName.equals(this.subsignature.getString())) {
            return true;
        }
        return this.isMain();
    }

    public boolean isJavaLibraryMethod() {
        return this.getDeclaringClass().isJavaLibraryClass();
    }

    public String getBytecodeParms() {
        StringBuilder buffer = new StringBuilder();
        for (Type type : this.getParameterTypes()) {
            buffer.append(AbstractJasminClass.jasminDescriptorOf(type));
        }
        return buffer.toString().intern();
    }

    public String getBytecodeSignature() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('<');
        buffer.append(Scene.v().quotedNameOf(this.getDeclaringClass().getName()));
        buffer.append(": ");
        buffer.append(this.getName());
        buffer.append(AbstractJasminClass.jasminDescriptorOf(this.makeRef()));
        buffer.append('>');
        return buffer.toString().intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSignature() {
        String sig = this.sig;
        if (sig == null) {
            SootMethod sootMethod = this;
            synchronized (sootMethod) {
                sig = this.sig;
                if (sig == null) {
                    this.sig = sig = SootMethod.getSignature(this.getDeclaringClass(), this.getSubSignature());
                }
            }
        }
        return sig;
    }

    public static String getSignature(SootClass cl, String name, List<Type> params, Type returnType) {
        return SootMethod.getSignature(cl, SootMethod.getSubSignatureImpl(name, params, returnType));
    }

    public static String getSignature(SootClass cl, String subSignature) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('<');
        buffer.append(Scene.v().quotedNameOf(cl.getName()));
        buffer.append(": ");
        buffer.append(subSignature);
        buffer.append('>');
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubSignature() {
        String subSig = this.subSig;
        if (subSig == null) {
            SootMethod sootMethod = this;
            synchronized (sootMethod) {
                subSig = this.subSig;
                if (subSig == null) {
                    this.subSig = subSig = SootMethod.getSubSignatureImpl(this.getName(), this.getParameterTypes(), this.getReturnType());
                }
            }
        }
        return subSig;
    }

    public static String getSubSignature(String name, List<Type> params, Type returnType) {
        return SootMethod.getSubSignatureImpl(name, params, returnType);
    }

    private static String getSubSignatureImpl(String name, List<Type> params, Type returnType) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(returnType.toQuotedString());
        buffer.append(' ');
        buffer.append(Scene.v().quotedNameOf(name));
        buffer.append('(');
        if (params != null) {
            int e = params.size();
            for (int i = 0; i < e; ++i) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(params.get(i).toQuotedString());
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    public NumberedString getNumberedSubSignature() {
        return this.subsignature;
    }

    public String toString() {
        return this.getSignature();
    }

    public String getDavaDeclaration() {
        Iterator<SootClass> exceptionIt;
        if (staticInitializerName.equals(this.getName())) {
            return "static";
        }
        StringBuilder buffer = new StringBuilder();
        StringTokenizer st = new StringTokenizer(Modifier.toString(this.getModifiers()));
        if (st.hasMoreTokens()) {
            buffer.append(st.nextToken());
            while (st.hasMoreTokens()) {
                buffer.append(' ').append(st.nextToken());
            }
        }
        if (buffer.length() != 0) {
            buffer.append(' ');
        }
        if (constructorName.equals(this.getName())) {
            buffer.append(this.getDeclaringClass().getShortJavaStyleName());
        } else {
            Type t = this.getReturnType();
            String tempString = t.toString();
            if (this.hasActiveBody()) {
                DavaBody body = (DavaBody)this.getActiveBody();
                IterableSet<String> importSet = body.getImportList();
                if (!importSet.contains(tempString)) {
                    body.addToImportList(tempString);
                }
                tempString = RemoveFullyQualifiedName.getReducedName(importSet, tempString, t);
            }
            buffer.append(tempString).append(' ');
            buffer.append(Scene.v().quotedNameOf(this.getName()));
        }
        int count = 0;
        buffer.append('(');
        Iterator<Type> typeIt = this.getParameterTypes().iterator();
        while (typeIt.hasNext()) {
            Type t = typeIt.next();
            String tempString = t.toString();
            if (this.hasActiveBody()) {
                DavaBody body = (DavaBody)this.getActiveBody();
                IterableSet<String> importSet = body.getImportList();
                if (!importSet.contains(tempString)) {
                    body.addToImportList(tempString);
                }
                tempString = RemoveFullyQualifiedName.getReducedName(importSet, tempString, t);
            }
            buffer.append(tempString).append(' ');
            buffer.append(' ');
            if (this.hasActiveBody()) {
                buffer.append(((DavaBody)this.getActiveBody()).get_ParamMap().get(count++));
            } else if (t == BooleanType.v()) {
                buffer.append('z').append(count++);
            } else if (t == ByteType.v()) {
                buffer.append('b').append(count++);
            } else if (t == ShortType.v()) {
                buffer.append('s').append(count++);
            } else if (t == CharType.v()) {
                buffer.append('c').append(count++);
            } else if (t == IntType.v()) {
                buffer.append('i').append(count++);
            } else if (t == LongType.v()) {
                buffer.append('l').append(count++);
            } else if (t == DoubleType.v()) {
                buffer.append('d').append(count++);
            } else if (t == FloatType.v()) {
                buffer.append('f').append(count++);
            } else if (t == StmtAddressType.v()) {
                buffer.append('a').append(count++);
            } else if (t == ErroneousType.v()) {
                buffer.append('e').append(count++);
            } else if (t == NullType.v()) {
                buffer.append('n').append(count++);
            } else {
                buffer.append('r').append(count++);
            }
            if (!typeIt.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(')');
        if (this.exceptions != null && (exceptionIt = this.getExceptions().iterator()).hasNext()) {
            buffer.append(" throws ").append(exceptionIt.next().getName());
            while (exceptionIt.hasNext()) {
                buffer.append(", ").append(exceptionIt.next().getName());
            }
        }
        return buffer.toString().intern();
    }

    public String getDeclaration() {
        Iterator<SootClass> exceptionIt;
        StringBuilder buffer = new StringBuilder();
        StringTokenizer st = new StringTokenizer(Modifier.toString(this.getModifiers()));
        if (st.hasMoreTokens()) {
            buffer.append(st.nextToken());
            while (st.hasMoreTokens()) {
                buffer.append(' ').append(st.nextToken());
            }
        }
        if (buffer.length() != 0) {
            buffer.append(' ');
        }
        buffer.append(this.getReturnType().toQuotedString()).append(' ');
        buffer.append(Scene.v().quotedNameOf(this.getName()));
        buffer.append('(');
        Iterator<Type> typeIt = this.getParameterTypes().iterator();
        while (typeIt.hasNext()) {
            Type t = typeIt.next();
            buffer.append(t.toQuotedString());
            if (!typeIt.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(')');
        if (this.exceptions != null && (exceptionIt = this.getExceptions().iterator()).hasNext()) {
            buffer.append(" throws ").append(Scene.v().quotedNameOf(exceptionIt.next().getName()));
            while (exceptionIt.hasNext()) {
                buffer.append(", ").append(Scene.v().quotedNameOf(exceptionIt.next().getName()));
            }
        }
        return buffer.toString().intern();
    }

    @Override
    public SootMethod method() {
        return this;
    }

    @Override
    public Context context() {
        return null;
    }

    public SootMethodRef makeRef() {
        return Scene.v().makeMethodRef(this.declaringClass, this.name, this.parameterTypes == null ? null : Arrays.asList(this.parameterTypes), this.returnType, this.isStatic());
    }

    public boolean isValidResolve(SootMethodRef ref) {
        return this.isStatic() == ref.isStatic() && Objects.equals(this.getDeclaringClass(), ref.getDeclaringClass()) && Objects.equals(this.getName(), ref.getName()) && Objects.equals(this.getReturnType(), ref.getReturnType()) && Objects.equals(this.getParameterTypes(), ref.getParameterTypes());
    }

    @Override
    public int getJavaSourceStartLineNumber() {
        super.getJavaSourceStartLineNumber();
        if (this.line == -1 && this.hasActiveBody()) {
            for (Unit u : this.getActiveBody().getUnits()) {
                int l = u.getJavaSourceStartLineNumber();
                if (l <= -1) continue;
                this.line = l - 1;
                break;
            }
        }
        return this.line;
    }
}

