/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.LocalGenerator;
import soot.RefType;
import soot.ResolutionFailedException;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StringConstant;
import soot.options.Options;
import soot.util.NumberedString;

public class SootMethodRefImpl
implements SootMethodRef {
    private static final Logger logger = LoggerFactory.getLogger(SootMethodRefImpl.class);
    private final SootClass declaringClass;
    private final String name;
    private final List<Type> parameterTypes;
    private final Type returnType;
    private final boolean isStatic;
    private SootMethod resolveCache = null;
    private NumberedString subsig;

    public SootMethodRefImpl(SootClass declaringClass, String name, List<Type> parameterTypes, Type returnType, boolean isStatic) {
        if (declaringClass == null) {
            throw new IllegalArgumentException("Attempt to create SootMethodRef with null class");
        }
        if (name == null) {
            throw new IllegalArgumentException("Attempt to create SootMethodRef with null name");
        }
        if (returnType == null) {
            throw new IllegalArgumentException("Attempt to create SootMethodRef with null returnType (Method: " + name + " at declaring class: " + declaringClass.getName() + ")");
        }
        this.declaringClass = declaringClass;
        this.name = name;
        this.parameterTypes = this.createParameterTypeList(parameterTypes);
        this.returnType = returnType;
        this.isStatic = isStatic;
    }

    protected List<Type> createParameterTypeList(List<Type> parameterTypes) {
        if (parameterTypes == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<Type>(parameterTypes));
    }

    @Override
    public SootClass declaringClass() {
        return this.getDeclaringClass();
    }

    @Override
    public SootClass getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String name() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Type> parameterTypes() {
        return this.getParameterTypes();
    }

    @Override
    public List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Type returnType() {
        return this.getReturnType();
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public NumberedString getSubSignature() {
        if (this.subsig != null) {
            return this.subsig;
        }
        if (this.resolveCache != null) {
            this.subsig = this.resolveCache.getNumberedSubSignature();
            return this.subsig;
        }
        this.subsig = Scene.v().getSubSigNumberer().findOrAdd(SootMethod.getSubSignature(this.name, this.parameterTypes, this.returnType));
        return this.subsig;
    }

    @Override
    public String getSignature() {
        return SootMethod.getSignature(this.declaringClass, this.name, this.parameterTypes, this.returnType);
    }

    @Override
    public Type parameterType(int i) {
        return this.getParameterType(i);
    }

    @Override
    public Type getParameterType(int i) {
        return this.parameterTypes.get(i);
    }

    @Override
    public SootMethod resolve() {
        SootMethod cached = this.resolveCache;
        if (cached == null || !cached.isValidResolve(this)) {
            this.resolveCache = cached = this.resolve(null);
        }
        return cached;
    }

    @Override
    public SootMethod tryResolve() {
        return this.tryResolve(null);
    }

    private void checkStatic(SootMethod method) {
        int opt = Options.v().wrong_staticness();
        if (!(opt != 1 && opt != 4 || method.isStatic() == this.isStatic() || method.isPhantom())) {
            throw new ResolutionFailedException("Resolved " + this + " to " + method + " which has wrong static-ness");
        }
    }

    protected SootMethod tryResolve(StringBuilder trace) {
        SootMethod resolved = Scene.v().getOrMakeFastHierarchy().resolveMethod(this.declaringClass, this.declaringClass, this.name, this.parameterTypes, this.returnType, true, this.getSubSignature());
        if (resolved != null) {
            this.checkStatic(resolved);
            return resolved;
        }
        if (Scene.v().allowsPhantomRefs()) {
            for (SootClass selectedClass = this.declaringClass; selectedClass != null; selectedClass = selectedClass.getSuperclassUnsafe()) {
                if (!selectedClass.isPhantom()) continue;
                SootMethod phantomMethod = Scene.v().makeSootMethod(this.name, this.parameterTypes, this.returnType, this.isStatic() ? 8 : 0);
                phantomMethod.setPhantom(true);
                phantomMethod = selectedClass.getOrAddMethod(phantomMethod);
                this.checkStatic(phantomMethod);
                return phantomMethod;
            }
        }
        if (Scene.v().allowsPhantomRefs() && Options.v().ignore_resolution_errors()) {
            SootClass classToAddTo;
            for (classToAddTo = this.declaringClass; classToAddTo != null && !classToAddTo.isPhantom(); classToAddTo = classToAddTo.getSuperclassUnsafe()) {
            }
            if (classToAddTo == null) {
                classToAddTo = this.declaringClass;
            }
            SootMethod method = Scene.v().makeSootMethod(this.name, this.parameterTypes, this.returnType, this.isStatic() ? 8 : 0);
            method.setPhantom(true);
            method = classToAddTo.getOrAddMethod(method);
            this.checkStatic(method);
            return method;
        }
        return null;
    }

    private SootMethod resolve(StringBuilder trace) {
        SootMethod resolved = this.tryResolve(trace);
        if (resolved != null) {
            return resolved;
        }
        if (Options.v().allow_phantom_refs() || "soot.dummy.InvokeDynamic".equals(this.declaringClass.getName())) {
            return this.createUnresolvedErrorMethod(this.declaringClass);
        }
        if (trace == null) {
            ClassResolutionFailedException e = new ClassResolutionFailedException();
            if (Options.v().ignore_resolution_errors()) {
                logger.debug(e.getMessage());
            } else {
                throw e;
            }
        }
        return null;
    }

    private SootMethod createUnresolvedErrorMethod(SootClass declaringClass) {
        Jimple jimp = Jimple.v();
        SootMethod m = Scene.v().makeSootMethod(this.name, this.parameterTypes, this.returnType, this.isStatic() ? 8 : 0);
        int modifiers = 1;
        if (this.isStatic()) {
            modifiers |= 8;
        }
        m.setModifiers(modifiers);
        JimpleBody body = jimp.newBody(m);
        m.setActiveBody(body);
        LocalGenerator lg = Scene.v().createLocalGenerator(body);
        body.insertIdentityStmts(declaringClass);
        RefType runtimeExceptionType = RefType.v("java.lang.Error");
        if (Options.v().src_prec() == 7) {
            runtimeExceptionType = RefType.v("System.Exception");
        }
        Local exceptionLocal = lg.generateLocal(runtimeExceptionType);
        AssignStmt assignStmt = jimp.newAssignStmt(exceptionLocal, jimp.newNewExpr(runtimeExceptionType));
        body.getUnits().add(assignStmt);
        SootMethodRef cref = Scene.v().makeConstructorRef(runtimeExceptionType.getSootClass(), Collections.singletonList(RefType.v("java.lang.String")));
        if (Options.v().src_prec() == 7) {
            cref = Scene.v().makeConstructorRef(runtimeExceptionType.getSootClass(), Collections.singletonList(RefType.v("System.String")));
        }
        SpecialInvokeExpr constructorInvokeExpr = jimp.newSpecialInvokeExpr(exceptionLocal, cref, (Value)StringConstant.v("Unresolved compilation error: Method " + this.getSignature() + " does not exist!"));
        InvokeStmt initStmt = jimp.newInvokeStmt(constructorInvokeExpr);
        body.getUnits().insertAfter(initStmt, assignStmt);
        body.getUnits().insertAfter(jimp.newThrowStmt(exceptionLocal), initStmt);
        return declaringClass.getOrAddMethod(m);
    }

    public String toString() {
        return this.getSignature();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
        result = 31 * result + (this.isStatic ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameterTypes == null ? 0 : this.parameterTypes.hashCode());
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SootMethodRefImpl other = (SootMethodRefImpl)obj;
        if (this.isStatic != other.isStatic) {
            return false;
        }
        if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parameterTypes == null ? other.parameterTypes != null : !this.parameterTypes.equals(other.parameterTypes)) {
            return false;
        }
        return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
    }

    public class ClassResolutionFailedException
    extends ResolutionFailedException {
        private static final long serialVersionUID = 5430199603403917938L;

        public ClassResolutionFailedException() {
            super("Class " + SootMethodRefImpl.this.declaringClass + " doesn't have method " + SootMethodRefImpl.this.name + "(" + (SootMethodRefImpl.this.parameterTypes == null ? "" : SootMethodRefImpl.this.parameterTypes) + ") : " + SootMethodRefImpl.this.returnType + "; failed to resolve in superclasses and interfaces");
        }

        @Override
        public String toString() {
            StringBuilder ret = new StringBuilder(super.toString());
            SootMethodRefImpl.this.resolve(ret);
            return ret.toString();
        }
    }
}

