/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import java.util.ArrayList;
import java.util.List;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.reference.CallSiteReference;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodHandleReference;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodHandleEncodedValue;
import org.jf.dexlib2.iface.value.MethodTypeEncodedValue;
import org.jf.dexlib2.iface.value.NullEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootMethodRef;
import soot.Value;
import soot.dexpler.DexBody;
import soot.dexpler.DexType;
import soot.dexpler.instructions.MethodInvocationInstruction;
import soot.jimple.ClassConstant;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;
import soot.jimple.MethodHandle;
import soot.jimple.MethodType;
import soot.jimple.NullConstant;
import soot.jimple.StringConstant;

public class InvokeCustomInstruction
extends MethodInvocationInstruction {
    public InvokeCustomInstruction(Instruction instruction, int codeAddress) {
        super(instruction, codeAddress);
    }

    @Override
    public void jimplify(DexBody body) {
        CallSiteReference callSiteReference = (CallSiteReference)((ReferenceInstruction)this.instruction).getReference();
        Reference bootstrapRef = callSiteReference.getMethodHandle().getMemberReference();
        if (!(bootstrapRef instanceof MethodReference)) {
            if (bootstrapRef instanceof FieldReference) {
                throw new RuntimeException("Error: Unexpected FieldReference type for boot strap method.");
            }
            throw new RuntimeException("Error: Unhandled MethodHandleReference of type '" + callSiteReference.getMethodHandle().getMethodHandleType() + "'");
        }
        SootMethodRef bootstrapMethodRef = this.getBootStrapSootMethodRef();
        MethodHandle.Kind bootStrapKind = this.dexToSootMethodHandleKind(callSiteReference.getMethodHandle().getMethodHandleType());
        List<Value> bootstrapValues = this.constantEncodedValuesToValues(callSiteReference.getExtraArguments());
        SootMethodRef methodRef = this.getCustomSootMethodRef();
        List<Local> methodArgs = this.buildParameters(body, callSiteReference.getMethodProto().getParameterTypes(), true);
        this.invocation = Jimple.v().newDynamicInvokeExpr(bootstrapMethodRef, bootstrapValues, methodRef, bootStrapKind.getValue(), methodArgs);
        body.setDanglingInstruction(this);
    }

    private List<Value> constantEncodedValuesToValues(List<? extends EncodedValue> in) {
        ArrayList<Value> out = new ArrayList<Value>();
        for (EncodedValue encodedValue : in) {
            if (encodedValue instanceof BooleanEncodedValue) {
                out.add(IntConstant.v(((BooleanEncodedValue)encodedValue).getValue() ? 1 : 0));
                continue;
            }
            if (encodedValue instanceof ByteEncodedValue) {
                out.add(IntConstant.v(((ByteEncodedValue)encodedValue).getValue()));
                continue;
            }
            if (encodedValue instanceof CharEncodedValue) {
                out.add(IntConstant.v(((CharEncodedValue)encodedValue).getValue()));
                continue;
            }
            if (encodedValue instanceof DoubleEncodedValue) {
                out.add(DoubleConstant.v(((DoubleEncodedValue)encodedValue).getValue()));
                continue;
            }
            if (encodedValue instanceof FloatEncodedValue) {
                out.add(FloatConstant.v(((FloatEncodedValue)encodedValue).getValue()));
                continue;
            }
            if (encodedValue instanceof IntEncodedValue) {
                out.add(IntConstant.v(((IntEncodedValue)encodedValue).getValue()));
                continue;
            }
            if (encodedValue instanceof LongEncodedValue) {
                out.add(LongConstant.v(((LongEncodedValue)encodedValue).getValue()));
                continue;
            }
            if (encodedValue instanceof ShortEncodedValue) {
                out.add(IntConstant.v(((ShortEncodedValue)encodedValue).getValue()));
                continue;
            }
            if (encodedValue instanceof StringEncodedValue) {
                out.add(StringConstant.v(((StringEncodedValue)encodedValue).getValue()));
                continue;
            }
            if (encodedValue instanceof NullEncodedValue) {
                out.add(NullConstant.v());
                continue;
            }
            if (encodedValue instanceof MethodTypeEncodedValue) {
                MethodProtoReference protRef = ((MethodTypeEncodedValue)encodedValue).getValue();
                out.add(MethodType.v(this.convertParameterTypes(protRef.getParameterTypes()), DexType.toSoot(protRef.getReturnType())));
                continue;
            }
            if (encodedValue instanceof TypeEncodedValue) {
                out.add(ClassConstant.v(((TypeEncodedValue)encodedValue).getValue()));
                continue;
            }
            if (encodedValue instanceof MethodHandleEncodedValue) {
                MethodHandle handle;
                MethodHandleReference mh = ((MethodHandleEncodedValue)encodedValue).getValue();
                Reference ref = mh.getMemberReference();
                MethodHandle.Kind kind = this.dexToSootMethodHandleKind(mh.getMethodHandleType());
                if (ref instanceof MethodReference) {
                    handle = MethodHandle.v(this.getSootMethodRef((MethodReference)ref, kind), kind.getValue());
                } else if (ref instanceof FieldReference) {
                    handle = MethodHandle.v(this.getSootFieldRef((FieldReference)ref, kind), kind.getValue());
                } else {
                    throw new RuntimeException("Error: Unhandled method reference type " + ref.getClass().toString() + ".");
                }
                out.add(handle);
                continue;
            }
            throw new RuntimeException("Error: Unhandled constant type '" + encodedValue.getClass().toString() + "' when parsing bootstrap arguments in the call site reference.");
        }
        return out;
    }

    private MethodHandle.Kind dexToSootMethodHandleKind(int kind) {
        switch (kind) {
            case 3: {
                return MethodHandle.Kind.REF_GET_FIELD;
            }
            case 1: {
                return MethodHandle.Kind.REF_GET_FIELD_STATIC;
            }
            case 2: {
                return MethodHandle.Kind.REF_PUT_FIELD;
            }
            case 0: {
                return MethodHandle.Kind.REF_PUT_FIELD_STATIC;
            }
            case 5: {
                return MethodHandle.Kind.REF_INVOKE_VIRTUAL;
            }
            case 4: {
                return MethodHandle.Kind.REF_INVOKE_STATIC;
            }
            case 7: {
                return MethodHandle.Kind.REF_INVOKE_SPECIAL;
            }
            case 6: {
                return MethodHandle.Kind.REF_INVOKE_CONSTRUCTOR;
            }
            case 8: {
                return MethodHandle.Kind.REF_INVOKE_INTERFACE;
            }
        }
        throw new RuntimeException("Error: Unknown kind '" + kind + "' for method handle");
    }

    protected SootMethodRef getCustomSootMethodRef() {
        CallSiteReference callSiteReference = (CallSiteReference)((ReferenceInstruction)this.instruction).getReference();
        SootClass dummyclass = Scene.v().getSootClass("soot.dummy.InvokeDynamic");
        String methodName = callSiteReference.getMethodName();
        MethodProtoReference methodRef = callSiteReference.getMethodProto();
        return this.getSootMethodRef(dummyclass, methodName, methodRef.getReturnType(), methodRef.getParameterTypes(), MethodHandle.Kind.REF_INVOKE_STATIC);
    }

    protected SootMethodRef getBootStrapSootMethodRef() {
        MethodHandleReference mh = ((CallSiteReference)((ReferenceInstruction)this.instruction).getReference()).getMethodHandle();
        return this.getSootMethodRef((MethodReference)mh.getMemberReference(), this.dexToSootMethodHandleKind(mh.getMethodHandleType()));
    }
}

