/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import soot.Body;
import soot.Local;
import soot.Value;
import soot.dotnet.exceptions.NoExpressionInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.AbstractNewObjInstanceInstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.Jimple;

public class CilStObjInstruction
extends AbstractCilnstruction {
    public CilStObjInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        CilInstruction cilTargetExpr = CilInstructionFactory.fromInstructionMsg(this.instruction.getTarget(), this.dotnetBody, this.cilBlock);
        Value target = cilTargetExpr.jimplifyExpr(jb);
        CilInstruction cilExpr = CilInstructionFactory.fromInstructionMsg(this.instruction.getValueInstruction(), this.dotnetBody, this.cilBlock);
        Value value = cilExpr.jimplifyExpr(jb);
        if (value instanceof Local && !target.getType().toString().equals(value.getType().toString()) && value.getType().toString().equals("System.Object") && !target.getType().toString().equals("System.Object")) {
            value = Jimple.v().newCastExpr(value, target.getType());
        }
        if (value instanceof CastExpr && !(target instanceof Local)) {
            Local generatedLocal = this.dotnetBody.variableManager.localGenerator.generateLocal(target.getType());
            AssignStmt assignStmt = Jimple.v().newAssignStmt(generatedLocal, value);
            jb.getUnits().add(assignStmt);
            value = generatedLocal;
        }
        AssignStmt astm = Jimple.v().newAssignStmt(target, value);
        jb.getUnits().add(astm);
        if (cilExpr instanceof AbstractNewObjInstanceInstruction) {
            if (!(target instanceof Local)) {
                throw new RuntimeException("STOBJ: The given target is not a local! The value is: " + target.toString() + " of type " + target.getType() + "! The resolving method body is: " + this.dotnetBody.getDotnetMethodSig().getSootMethodSignature().getSignature());
            }
            ((AbstractNewObjInstanceInstruction)cilExpr).resolveCallConstructorBody(jb, (Local)target);
        }
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        throw new NoExpressionInstructionException(this.instruction);
    }
}

