/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.members.method;

import soot.Body;
import soot.Immediate;
import soot.Local;
import soot.LocalGenerator;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.VoidType;
import soot.dotnet.instructions.CilBlockContainer;
import soot.dotnet.members.DotnetMethod;
import soot.dotnet.members.method.BlockEntryPointsManager;
import soot.dotnet.members.method.DotnetBodyVariableManager;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.dotnet.types.DotnetTypeFactory;
import soot.jimple.CastExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NullConstant;

public class DotnetBody {
    private final ProtoIlInstructions.IlFunctionMsg ilFunctionMsg;
    private JimpleBody jb;
    public BlockEntryPointsManager blockEntryPointsManager;
    public DotnetBodyVariableManager variableManager;
    private final DotnetMethod dotnetMethodSig;

    public DotnetMethod getDotnetMethodSig() {
        return this.dotnetMethodSig;
    }

    public DotnetBody(DotnetMethod methodSignature, ProtoIlInstructions.IlFunctionMsg ilFunctionMsg) {
        this.dotnetMethodSig = methodSignature;
        this.ilFunctionMsg = ilFunctionMsg;
        this.blockEntryPointsManager = new BlockEntryPointsManager();
    }

    public void jimplify(JimpleBody jb) {
        this.jb = jb;
        this.variableManager = new DotnetBodyVariableManager(this, this.jb);
        this.addThisStmt();
        this.variableManager.fillMethodParameter();
        this.variableManager.addInitLocalVariables(this.ilFunctionMsg.getVariablesList());
        CilBlockContainer blockContainer = new CilBlockContainer(this.ilFunctionMsg.getBody(), this);
        Body b = blockContainer.jimplify();
        this.jb.getUnits().addAll(b.getUnits());
        this.jb.getTraps().addAll(b.getTraps());
        this.blockEntryPointsManager.swapGotoEntriesInJBody(this.jb);
    }

    private void addThisStmt() {
        if (this.dotnetMethodSig.isStatic()) {
            return;
        }
        RefType thisType = this.dotnetMethodSig.getDeclaringClass().getType();
        Local l = Jimple.v().newLocal("this", thisType);
        IdentityStmt identityStmt = Jimple.v().newIdentityStmt(l, Jimple.v().newThisRef(thisType));
        this.jb.getLocals().add(l);
        this.jb.getUnits().add(identityStmt);
    }

    public static Value inlineCastExpr(Value v) {
        if (v instanceof Immediate) {
            return v;
        }
        if (v instanceof CastExpr) {
            return DotnetBody.inlineCastExpr(((CastExpr)v).getOp());
        }
        return v;
    }

    public static JimpleBody getEmptyJimpleBody(SootMethod m) {
        JimpleBody b = Jimple.v().newBody(m);
        DotnetBody.resolveEmptyJimpleBody(b, m);
        return b;
    }

    public static void resolveEmptyJimpleBody(JimpleBody b, SootMethod m) {
        if (!m.isStatic()) {
            RefType thisType = m.getDeclaringClass().getType();
            Local l = Jimple.v().newLocal("this", thisType);
            IdentityStmt identityStmt = Jimple.v().newIdentityStmt(l, Jimple.v().newThisRef(thisType));
            b.getLocals().add(l);
            b.getUnits().add(identityStmt);
        }
        for (int i = 0; i < m.getParameterCount(); ++i) {
            Type parameterType = m.getParameterType(i);
            Local paramLocal = Jimple.v().newLocal("arg" + i, parameterType);
            b.getLocals().add(paramLocal);
            b.getUnits().add(Jimple.v().newIdentityStmt(paramLocal, Jimple.v().newParameterRef(parameterType, i)));
        }
        LocalGenerator lg = Scene.v().createLocalGenerator(b);
        b.getUnits().add(Jimple.v().newThrowStmt(lg.generateLocal(RefType.v("java.lang.Throwable"))));
        if (m.getReturnType() instanceof VoidType) {
            b.getUnits().add(Jimple.v().newReturnVoidStmt());
        } else if (m.getReturnType() instanceof PrimType) {
            b.getUnits().add(Jimple.v().newReturnStmt(DotnetTypeFactory.initType(m.getReturnType())));
        } else {
            b.getUnits().add(Jimple.v().newReturnStmt(NullConstant.v()));
        }
    }
}

